/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.security;

import java.security.SecureRandom;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.dbtools.security.PasswordValidator;
import oracle.dbtools.security.PasswordValidatorException;

public class PasswordGenerator {
    public static final String DEFAULT_SPECIAL = "!#$@";
    private static final String DEFAULT_CHARACTER_LIST;
    private static final int UPPER_START;
    private static final int LOWER_START;
    private static final int DIGIT_START;
    private static final int SPECIAL_START;
    public static PasswordGenerator ADWC_GENERATOR;
    private final String specials;
    private final String source;
    private final int len;
    private final int minUpper;
    private final int minLower;
    private final int minLetter;
    private final int minDigit;
    private final int minSpecial;
    private final SecureRandom random;

    private static char[] init(char start, char end) {
        char[] chars = new char[end - start + 1];
        int idx = 0;
        for (char i = start; i <= end; i = (char)(i + '\u0001')) {
            chars[idx++] = i;
        }
        return chars;
    }

    public static char[] generatePassword(int upper, int lower, int letters, int digits, int minSpecials, String specials, int length, List<String> restricted) {
        PasswordGenerator generator = new Builder().length(length).minUpperCase(upper).minLowerCase(lower).minLetters(letters).minDigits(digits).minSpecials(minSpecials).specials(specials).build();
        return generator.generate(restricted);
    }

    public static char[] generateADWCPassword(String username) {
        return ADWC_GENERATOR.generate(Collections.singleton(username));
    }

    private PasswordGenerator(int len, int minUpper, int minLower, int minLetter, int minDigit, int minSpecial, String specials) {
        this.len = len;
        this.minUpper = minUpper;
        this.minLower = minLower;
        this.minLetter = minLetter;
        this.minDigit = minDigit;
        this.minSpecial = minSpecial;
        this.specials = specials != null ? specials : "";
        this.source = DEFAULT_CHARACTER_LIST + this.specials;
        this.random = new SecureRandom();
    }

    public char[] generate() {
        char[] pwd = new char[this.len];
        this.fill(pwd);
        return pwd;
    }

    public char[] generate(Collection<String> restricted) {
        char[] pwd = new char[this.len];
        boolean invalid = true;
        while (invalid) {
            this.fill(pwd);
            try {
                invalid = false;
                PasswordValidator.validateAgainstChecklist(pwd, restricted);
            }
            catch (PasswordValidatorException e) {
                invalid = true;
            }
        }
        return pwd;
    }

    private int fill(char[] pwd, int startPos, int selectionStart, int selectionSize, int count) {
        int pos = startPos;
        if (selectionStart < this.source.length()) {
            for (int i = 0; i < count; ++i) {
                int r = this.random.nextInt(selectionSize);
                pwd[pos++] = this.source.charAt(selectionStart + r);
            }
        }
        return pos;
    }

    private void fill(char[] pwd) {
        int count = 0;
        int letters = 0;
        count = this.fill(pwd, count, UPPER_START, LOWER_START - UPPER_START, this.minUpper);
        letters += this.minUpper;
        count = this.fill(pwd, count, LOWER_START, DIGIT_START - LOWER_START, this.minLower);
        count = this.fill(pwd, count, UPPER_START, DIGIT_START - UPPER_START, this.minLetter - (letters += this.minLower));
        count = this.fill(pwd, count, DIGIT_START, SPECIAL_START - DIGIT_START, this.minDigit);
        count = this.fill(pwd, count, SPECIAL_START, this.specials.length(), this.minSpecial);
        count = this.fill(pwd, count, UPPER_START, this.source.length(), this.len - count);
        this.shuffle(pwd);
    }

    private void shuffle(char[] pwd) {
        for (int i = pwd.length - 1; i > 0; --i) {
            int r = this.random.nextInt(i + 1);
            char c = pwd[i];
            pwd[i] = pwd[r];
            pwd[r] = c;
        }
    }

    static {
        String upper = new String(PasswordGenerator.init('A', 'Z'));
        String lower = upper.toLowerCase();
        String digits = new String(PasswordGenerator.init('0', '9'));
        DEFAULT_CHARACTER_LIST = upper + lower + digits;
        UPPER_START = 0;
        LOWER_START = UPPER_START + upper.length();
        DIGIT_START = LOWER_START + lower.length();
        SPECIAL_START = DIGIT_START + digits.length();
        ADWC_GENERATOR = new Builder().length(Math.max(16, PasswordValidator.ADWC_VALIDATOR.getMinimumLength())).minUpperCase(PasswordValidator.ADWC_VALIDATOR.getMinimumUpperCaseCount()).minLowerCase(PasswordValidator.ADWC_VALIDATOR.getMinimumLowerCaseCount()).minDigits(PasswordValidator.ADWC_VALIDATOR.getMinimumDigitCount()).minSpecials(PasswordValidator.ADWC_VALIDATOR.getMinimumSpecialCount()).specials(DEFAULT_SPECIAL).build();
    }

    public static class Builder {
        private int len;
        private int minUpper;
        private int minLower;
        private int minLetter;
        private int minDigit;
        private int minSpecial;
        private String specials = "!#$@";

        public Builder length(int len) {
            this.len = len;
            return this;
        }

        public Builder minUpperCase(int min) {
            this.minUpper = min;
            return this;
        }

        public Builder minLowerCase(int min) {
            this.minLower = min;
            return this;
        }

        public Builder minLetters(int min) {
            this.minLetter = min;
            return this;
        }

        public Builder minDigits(int min) {
            this.minDigit = min;
            return this;
        }

        public Builder minSpecials(int min) {
            this.minSpecial = min;
            return this;
        }

        public Builder specials(String specials) {
            this.specials = specials;
            return this;
        }

        public PasswordGenerator build() {
            return new PasswordGenerator(this.len, this.minUpper, this.minLower, this.minLetter, this.minDigit, this.minSpecial, this.specials);
        }
    }
}

