/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ProviderForSQLPATH;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.nls.DefaultNLSProvider;
import oracle.dbtools.raptor.nls.OracleNLSProvider;

public class SQLPLUSUtil {
    private static String productName = "SQL Developer";
    private static ProviderForSQLPATH sqlpathProvider = null;

    public static String getProductName() {
        return productName;
    }

    public static void setProductName(String newName) {
        productName = newName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean haveIBytes(URL tryNextURL) {
        if (tryNextURL != null) {
            InputStream is = null;
            URLConnection c = null;
            try {
                c = tryNextURL.openConnection();
                is = c.getInputStream();
                if (is.read() != -1) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (MalformedURLException e1) {
                boolean bl = false;
                return bl;
            }
            catch (IOException e1) {
                boolean bl = false;
                return bl;
            }
            catch (Exception e2) {
                boolean bl = false;
                return bl;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return false;
        }
        return false;
    }

    public static void setExecutorPath(ScriptExecutor runner, String inputFileOrUrl, ScriptRunnerContext ctx) throws IOException {
        String inputFile = inputFileOrUrl;
        if (new File(inputFile).exists()) {
            String pathval = new File(inputFile).getCanonicalPath();
            int ii = pathval.lastIndexOf("/");
            int iislash = pathval.lastIndexOf("\\");
            if (iislash > ii) {
                ii = iislash;
            }
            runner.getScriptRunnerContext().setSourceRef(pathval);
            pathval = pathval.substring(0, ii);
            runner.setDirectory(pathval);
        } else if (FileUtils.startsWithHttpOrFtp(inputFile) && FileUtils.haveIBytes(inputFile, ctx)) {
            String localInputFile = inputFile.replace("\\", "/");
            runner.getScriptRunnerContext().setSourceRef(localInputFile);
            int ii = localInputFile.lastIndexOf("/");
            int iib = localInputFile.lastIndexOf("\\");
            if (iib > ii) {
                ii = iib;
            }
            localInputFile = localInputFile.substring(0, ii);
            runner.setDirectory(localInputFile);
        } else if (FileUtils.startsWithHttpOrFtp(inputFile) && FileUtils.haveIBytesRaw(inputFile)) {
            String localInputFile = inputFile.replace("/", "\\");
            runner.getScriptRunnerContext().setSourceRef(localInputFile);
            int ii = localInputFile.lastIndexOf("/");
            int iib = localInputFile.lastIndexOf("\\");
            if (iib > ii) {
                ii = iib;
            }
            localInputFile = localInputFile.substring(0, ii);
            runner.setDirectory(localInputFile);
        } else {
            runner.getScriptRunnerContext().setSourceRef("");
            runner.setDirectory("");
        }
    }

    public static Connection prelimAuthTryReopen(Connection preconn, ScriptRunnerContext ctx) {
        block8: {
            try {
                String password;
                Boolean prelim = (Boolean)ctx.getProperty("script.runner.PRELIM_AUTH");
                Integer prelimError = (Integer)ctx.getProperty("script.runner.PRELIM_AUTHPREERROR");
                if (preconn == null || !preconn.isClosed() || prelim == null || !prelim.equals(Boolean.TRUE) || prelimError == null) break block8;
                Properties duplicateProperties = new Properties();
                Properties props = (Properties)ctx.getProperty("cli.conn.props");
                String internalLogin = props.getProperty("internal_logon");
                String userName = props.getProperty("user");
                if (userName != null) {
                    duplicateProperties.setProperty("user", userName);
                }
                if ((password = props.getProperty("password")) != null) {
                    duplicateProperties.setProperty("password", password);
                }
                duplicateProperties.setProperty("prelim_auth", "true");
                duplicateProperties.setProperty("internal_logon", internalLogin);
                try {
                    Connection conn = DriverManager.getConnection((String)ctx.getProperty("cli.conn.url"), duplicateProperties);
                    try {
                        Logger.getLogger("SQLPLUS").log(Level.INFO, "(prelim auth) conn.isClosed()=" + conn.isClosed());
                    }
                    catch (SQLException ee) {
                        Logger.getLogger("SQLPLUS").log(Level.INFO, "(prelim auth) conn.isClosed()_exception", ee);
                    }
                    return conn;
                }
                catch (Throwable t2) {
                    ctx.write(t2.getLocalizedMessage() + "\n");
                }
            }
            catch (Exception e) {
                ctx.write(e.getLocalizedMessage() + "\n");
            }
        }
        return null;
    }

    public static void disconnectMessage(Connection conn, ScriptRunnerContext ctx, BufferedOutputStream out) {
        if (conn != null && !SQLPLUSUtil.isConnectionClosed(conn)) {
            String localOVersion = ctx.doPromptReplaceSqlplusVar(ScriptRunnerContext.SqlplusVariable._O_VERSION.toString(), ScriptRunnerContext.SqlplusVariable._O_VERSION);
            if (ctx.getProperty("script.runner.sqlplus.silent") == null ^ ctx.getProperty("script.runner.sqlcl.optionx") != null) {
                ctx.write(ScriptRunnerDbArb.format("DISCONNECTED_FROM", localOVersion) + "\n");
                try {
                    ctx.getOutputStream().flush();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void disconnect(Connection conn, ScriptRunnerContext ctx, BufferedOutputStream out) {
        if (conn != null && !SQLPLUSUtil.isConnectionClosed(conn)) {
            if (ctx.getProperty("script.runner.PRELIM_AUTH") == null || ((Boolean)ctx.getProperty("script.runner.PRELIM_AUTH")).equals(Boolean.FALSE)) {
                SQLPLUSUtil.disconnectMessage(conn, ctx, ctx.getOutputStream());
                SQLPLUSUtil.commitConnection(conn);
            }
            SQLPLUSUtil.configureOldConnections(conn, ctx);
        }
        conn = null;
        ctx.getMap().put(ScriptRunnerContext.SqlplusVariable._CONNECT_IDENTIFIER.toString(), "");
        ctx.getMap().put(ScriptRunnerContext.SqlplusVariable._USER.toString(), "");
        ctx.getMap().put(ScriptRunnerContext.SqlplusVariable._SQL_ID.toString(), "");
        ctx.setCurrentConnection(conn);
        ctx.putProperty("script.runner.sqlplus.nolog", true);
    }

    public static void configureOldConnections(Connection conn, ScriptRunnerContext ctx) {
        Object jline = ctx.getProperty("script.runner.jline");
        if (jline == null) {
            if (!SQLPLUSUtil.isConnectionClosed(conn)) {
                SQLPLUSUtil.closeOldConnection(conn, ctx);
            }
            ctx.setCloseConnection(true);
        } else {
            Boolean doNullBase = ctx.getBaseConnection() != null && conn != null && ctx.getBaseConnection().equals(conn);
            ctx.setCloseConnection(true);
            if (!SQLPLUSUtil.isConnectionClosed(conn)) {
                SQLPLUSUtil.closeOldConnection(conn, ctx);
            }
            if (doNullBase.booleanValue()) {
                ctx.setBaseConnection(null);
            }
            ctx.setCloseConnection(false);
        }
    }

    public static void closeOldConnection(Connection conn, ScriptRunnerContext ctx) {
        if (ctx.getCloseConnection()) {
            try {
                conn.close();
            }
            catch (Exception e) {
                Logger.getLogger(SQLPLUSUtil.class.getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
        }
    }

    public static void commitConnection(Connection conn) {
        block5: {
            try {
                if (conn == null || SQLPLUSUtil.isConnectionClosed(conn) || !LockManager.lock(conn)) break block5;
                try {
                    conn.commit();
                }
                finally {
                    LockManager.unlock(conn);
                }
            }
            catch (SQLException e) {
                Logger.getLogger(SQLPLUSUtil.class.getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
        }
    }

    public static boolean isConnectionClosed(Connection conn) {
        boolean closed;
        block5: {
            closed = false;
            try {
                if (conn == null || !LockManager.lock(conn)) break block5;
                try {
                    closed = conn.isClosed();
                }
                finally {
                    LockManager.unlock(conn);
                }
            }
            catch (SQLException e) {
                Logger.getLogger(SQLPLUSUtil.class.getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
        }
        return closed;
    }

    public static String resolveConnectionName(ScriptRunnerContext ctx) {
        return ConnectionResolver.getConnectionName(ctx.getBaseConnection());
    }

    public static boolean hasUrlStub(String url) {
        return SQLPLUSUtil.hasOracleDBStub(url) || SQLPLUSUtil.hasOracleRestStub(url);
    }

    public static boolean hasAnyStub(String url) {
        return url.startsWith("jdbc:") || url.startsWith("http:") || url.startsWith("https:");
    }

    public static boolean hasOracleDBStub(String url) {
        if (url != null) {
            for (String prefix : new String[]{"jdbc:oracle:thin", "jdbc:oracle:oci", "jdbc:oracle:kprb", "jdbc:default:connection", "jdbc:timesten:direct", "jdbc:timesten:client"}) {
                if (!url.startsWith(prefix)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasOracleRestStub(String url) {
        if (url != null) {
            for (String prefix : new String[]{"jdbc:oracle:orest", "http:", "https:"}) {
                if (!url.startsWith(prefix)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasNonOracleStub(String url) {
        return url != null && url.startsWith("jdbc:") && !SQLPLUSUtil.hasOracleDBStub(url) && !SQLPLUSUtil.hasOracleRestStub(url);
    }

    public static void forceEcho(ScriptRunnerContext ctx, boolean newValue, boolean isReset) {
        if (!isReset) {
            ctx.putProperty("script.setecho", Boolean.FALSE);
        } else {
            Boolean prop = (Boolean)ctx.getProperty("script.setecho");
            if (prop != null && prop.equals(Boolean.TRUE)) {
                return;
            }
        }
        ctx.setEcho(newValue);
    }

    public static String[] nextWordAndRest(String in) {
        return SQLPLUSUtil.nextWordAndRestOrString(in, null);
    }

    public static String[] nextWordAndRestOrString(String in, String extraOne) {
        String firstWord;
        int i;
        if ((in = in.trim()).length() == 0) {
            return null;
        }
        boolean inQuote = false;
        boolean found = false;
        String rest = "";
        for (i = 0; i < in.length(); ++i) {
            if (in.charAt(i) == '\"') {
                inQuote = !inQuote;
            }
            if (!Character.isWhitespace(in.charAt(i)) && (extraOne == null || extraOne.indexOf(in.charAt(i)) == -1) || inQuote) continue;
            found = true;
            break;
        }
        if (found) {
            rest = in.substring(i).trim();
            firstWord = in.substring(0, i);
        } else {
            firstWord = in;
        }
        String[] stringArray = new String[]{firstWord, rest};
        return stringArray;
    }

    public static void report(ScriptRunnerContext ctx, String s) {
        ScriptUtils.report(ctx, s);
    }

    public static void doWhenever(ScriptRunnerContext ctx, ISQLCommand cmd, Connection conn, boolean SqlError) {
        ScriptUtils.doWhenever(ctx, cmd, conn, SqlError);
    }

    public static void classicUrlMessageAdd(List<String> urlMessage, String user, String URLString, String feedback) {
        String urlLower;
        if (urlMessage.isEmpty()) {
            urlMessage.add("");
            urlMessage.add("");
            urlMessage.add("");
            urlMessage.set(2, ScriptRunnerDbArb.format("URL_MESSAGE_CLASSIC", feedback));
        }
        if (urlMessage.get(1).equals("") && URLString.startsWith("jdbc:oracle:thin")) {
            urlMessage.set(1, ScriptRunnerDbArb.format("URL_MESSAGE_CLASSIC", feedback));
        }
        if ((urlLower = URLString.toLowerCase(Locale.US).replaceAll("\\s+", "")).startsWith("jdbc:oracle:oci") && urlLower.endsWith("@") || urlLower.contains("protocol=ipc")) {
            urlMessage.set(0, ScriptRunnerDbArb.format("URL_MESSAGE_CLASSIC", feedback));
        }
        urlMessage.add(ScriptRunnerDbArb.format("URL_MESSAGE_CLASSIC", feedback));
    }

    public static void setupNLS(Connection myconn, ScriptRunnerContext src) {
        Map<String, String> nlsMap = src.getNLSMap();
        if (myconn != null && nlsMap != null && !nlsMap.isEmpty()) {
            OracleNLSProvider provider = null;
            provider = new OracleNLSProvider(myconn);
            ((DefaultNLSProvider)provider).initConnection();
            ((DefaultNLSProvider)provider).updateDefaults(nlsMap);
        }
    }

    public static ISQLCommand cleanCommand(ISQLCommand cmd) {
        String sql = cmd.getSql().trim();
        if (sql.endsWith(";") && sql.length() > 1) {
            sql = sql.substring(0, sql.length() - 1);
        }
        cmd.setSql(ScriptUtils.checkforContinuationChars(sql));
        return cmd;
    }

    public static String removeDashNewline(ISQLCommand cmd, String in) {
        if (cmd.getProperty("STRIPPED_CONTINUATION") != null) {
            return in;
        }
        return SQLPLUSUtil.removeDashNewline(in);
    }

    public static String removeDashNewline(String in) {
        int eatWhite;
        StringBuffer op = new StringBuffer();
        int currentlyAt = 0;
        int lastnewlineMatch = -1;
        int newlineMatch = -1;
        do {
            int match;
            if ((match = in.indexOf("-", currentlyAt)) == -1) {
                if (currentlyAt == 0) {
                    return in;
                }
                op.append(in.substring(currentlyAt));
                break;
            }
            eatWhite = match + 1;
            for (eatWhite = match + 1; eatWhite < in.length() && (in.substring(eatWhite, eatWhite + 1).equals(" ") || in.substring(eatWhite, eatWhite + 1).equals("\t")); ++eatWhite) {
            }
            if (eatWhite == in.length() && !SQLPLUSUtil.specialNoContinuation(in, match)) {
                op.append(in.substring(currentlyAt, match));
                break;
            }
            if (eatWhite < in.length() && (in.substring(eatWhite, eatWhite + 1).equals("\r") || in.substring(eatWhite, eatWhite + 1).equals("\n")) && !SQLPLUSUtil.specialNoContinuation(in, match)) {
                op.append(in.substring(currentlyAt, match));
                if (++eatWhite >= in.length() || in.substring(eatWhite, eatWhite + 1).equals("\r") || in.substring(eatWhite, eatWhite + 1).equals("\n")) {
                    // empty if block
                }
                currentlyAt = ++eatWhite;
                continue;
            }
            op.append(in.substring(currentlyAt, eatWhite));
            currentlyAt = eatWhite;
        } while (eatWhite != in.length());
        return op.toString();
    }

    public static boolean specialNoContinuation(String s, int match) {
        int index = s.lastIndexOf(10, match);
        if (index != -1) {
            return s.substring(index + 1, match + 1).matches("^\\s*--");
        }
        return false;
    }

    public static ProviderForSQLPATH getSqlpathProvider() {
        return sqlpathProvider;
    }

    public static void setSqlpathProvider(ProviderForSQLPATH sqlpathProvder) {
        sqlpathProvider = sqlpathProvder;
    }

    private SQLPLUSUtil() {
    }
}

