/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.proxy;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.dbtools.raptor.proxy.ProxyAutoConfig;
import oracle.dbtools.raptor.proxy.ProxyConfig;
import oracle.dbtools.raptor.proxy.SystemProxyType;
import oracle.dbtools.util.Logger;

public final class ProxySelectorImpl
extends ProxySelector {
    private static final List<Proxy> NO_PROXY_LIST = Collections.singletonList(Proxy.NO_PROXY);
    private static ProxySelector original = null;

    public static void installProxySelector() {
        ProxySelector originalProxySelector = ProxySelector.getDefault();
        if (originalProxySelector instanceof ProxySelectorImpl) {
            return;
        }
        ProxyConfig config = ProxyConfig.getProxyConfiguration();
        ProxySelectorImpl impl = new ProxySelectorImpl(originalProxySelector);
        ProxySelector.setDefault(impl);
    }

    public ProxySelectorImpl(ProxySelector originalProxySelector) {
        original = originalProxySelector;
    }

    @Override
    public List<Proxy> select(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("URI must not be null.");
        }
        List<Proxy> result = NO_PROXY_LIST;
        ProxyConfig config = ProxyConfig.getProxyConfiguration();
        String scheme = uri.getScheme();
        if ("http".equals(scheme) || "https".equals(scheme)) {
            try {
                SystemProxyType systemProxyType = config.getProxyType();
                if (SystemProxyType.PAC.equals((Object)systemProxyType)) {
                    result = ProxySelectorImpl.resolveProxyListFromPAC(uri, config.getPACFile());
                } else if (SystemProxyType.MANUAL_PROXY.equals((Object)systemProxyType)) {
                    result = ProxySelectorImpl.resolveProxyList(uri, config.getHttpProxyHost(), config.getHttpProxyPort(), null, null, config.getHttpProxyExceptions());
                }
            }
            catch (Exception e) {
                Logger.fine(ProxySelectorImpl.class, "Failed to resolve a proxy for " + uri + ": exception = " + e.getMessage());
            }
        }
        return result;
    }

    static List<Proxy> resolveProxyListFromPAC(URI uri, String pacFile) {
        ProxyAutoConfig pac = null;
        try {
            pac = ProxyAutoConfig.get(pacFile);
        }
        catch (Throwable t) {
            Logger.finest(ProxySelectorImpl.class, "Error retrieving Proxy Auto Config file " + pacFile + ": exception = " + t.getMessage());
        }
        if (pac == null) {
            Logger.finest(ProxySelectorImpl.class, "No instance of ProxyAutoConfig(" + pacFile + ") for URI " + uri);
            return NO_PROXY_LIST;
        }
        if (pac.getPacURI().getHost() == null || pac.getPacURI().getHost().equals(uri.getHost())) {
            Logger.finest(ProxySelectorImpl.class, "Malformed PAC URI " + pac.getPacURI() + " for URI " + uri);
            return NO_PROXY_LIST;
        }
        List<Proxy> proxies = pac.findProxyForURL(uri);
        return proxies;
    }

    private static List<Proxy> resolveProxyList(URI uri, String httpHost, String httpPort, String socksHost, String socksPort, String proxyExceptions) throws Exception {
        InetSocketAddress addr;
        if (!(httpHost != null && httpHost.trim().length() != 0 || socksHost != null && socksHost.trim().length() != 0)) {
            return NO_PROXY_LIST;
        }
        String[] exceptions = ProxyConfig.splitExceptionsIntoArray(proxyExceptions);
        if (exceptions != null) {
            for (String exception : exceptions) {
                if (!exception.equalsIgnoreCase(uri.getHost())) continue;
                return NO_PROXY_LIST;
            }
        }
        ArrayList<Proxy> res = new ArrayList<Proxy>(2);
        if (httpHost != null && httpHost.trim().length() > 0) {
            int httpPortParsed = 80;
            if (httpPort != null && httpPort.trim().length() > 0) {
                httpPortParsed = Integer.parseInt(httpPort);
            }
            addr = new InetSocketAddress(httpHost, httpPortParsed);
            Proxy proxy = new Proxy(Proxy.Type.HTTP, addr);
            res.add(proxy);
        }
        if (socksHost != null && socksHost.trim().length() > 0) {
            int socksPortParsed = 80;
            if (socksPort != null && socksPort.trim().length() > 0) {
                socksPortParsed = Integer.parseInt(socksPort);
            }
            addr = new InetSocketAddress(socksHost, socksPortParsed);
            Proxy proxy = new Proxy(Proxy.Type.SOCKS, addr);
            res.add(proxy);
        }
        if (res.size() > 0) {
            return res;
        }
        return NO_PROXY_LIST;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        Logger.fine(ProxySelectorImpl.class, "Connection failed: URI + " + uri + ", exception: " + ioe.getMessage());
    }

    public ProxySelector getOriginalProxySelector() {
        return original;
    }
}

