/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.tokenizer;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.raptor.newscriptrunner.util.tokenizer.AbstractTokenizer;

public class CStyleTokenizer
extends AbstractTokenizer {
    private static final Pattern LINE_PATTERN = Pattern.compile("(?:(?<=\\s|^)(?:'(?:\\\\(?:\\\\\\\\)*'|\\\\\\\\|[^'\\\\])*'|\"(?:\\\\(?:\\\\\\\\)*\"|\\\\\\\\|[^\"\\\\])*\")(?=\\s|$))|(?:[^\\s'\"\\\\]+)");
    private static final Pattern ESCAPES_PATTERN = Pattern.compile("(\\\\'|\\\\\"|\\\\\\\\)");

    @Override
    protected void findMatches(String line, AbstractTokenizer.MatchRegistry registry) {
        Matcher lineMatcher = LINE_PATTERN.matcher(line);
        while (lineMatcher.find()) {
            String wordMatch = lineMatcher.group(0);
            int start = lineMatcher.start(0);
            int end = lineMatcher.end(0);
            Matcher escapesMatcher = ESCAPES_PATTERN.matcher(wordMatch);
            StringBuilder sbuf = new StringBuilder();
            int charNo = 0;
            while (escapesMatcher.find()) {
                String escapesMatch = escapesMatcher.group();
                int escapesStart = escapesMatcher.start();
                int escapesEnd = escapesMatcher.end();
                switch (escapesMatch) {
                    case "\\'": {
                        sbuf.append(wordMatch.substring(charNo, escapesStart));
                        sbuf.append("'");
                        break;
                    }
                    case "\\\"": {
                        sbuf.append(wordMatch.substring(charNo, escapesStart));
                        sbuf.append("\"");
                        break;
                    }
                    case "\\\\": {
                        sbuf.append(wordMatch.substring(charNo, escapesStart));
                        sbuf.append("\\");
                    }
                }
                charNo = escapesEnd;
            }
            sbuf.append(wordMatch.substring(charNo));
            registry.addMatch(sbuf.toString(), wordMatch, start, end);
        }
    }
}

