/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.parser;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import oracle.dbtools.raptor.newscriptrunner.util.parser.AbbreviatedItem;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Messages;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Option;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Parameter;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;
import oracle.dbtools.raptor.newscriptrunner.util.tokenizer.SQLPLUSTokenizer;
import oracle.dbtools.raptor.newscriptrunner.util.tokenizer.Token;
import oracle.dbtools.raptor.newscriptrunner.util.tokenizer.Tokenizer;

public class Parser {
    private final TypeContainer rootContainer;
    private Tokenizer tokenizer;

    public Parser(Type type) {
        this(type, new SQLPLUSTokenizer());
    }

    public Parser(Type type, Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
        StringBuilder errorBuff = new StringBuilder();
        this.rootContainer = new TypeContainer("<root>", Collections.singletonList(type), errorBuff);
        if (errorBuff.length() > 0) {
            throw new IllegalArgumentException(errorBuff.toString());
        }
    }

    public Optional<ParsedCommand> parse(String command, Consumer<String> errorConsumer) {
        ParsedCommandImpl parsedCommand;
        if (command == null) {
            throw new IllegalArgumentException("command may not be null or empty");
        }
        if (errorConsumer == null) {
            throw new IllegalArgumentException("errorConsumer may not be null");
        }
        if (!command.isEmpty() && (parsedCommand = new ParsedCommandImpl(command, errorConsumer)).parse()) {
            return Optional.of(parsedCommand);
        }
        return Optional.empty();
    }

    private Set<String> getSynonyns(AbbreviatedItem item, StringBuilder errorBuff) {
        HashSet<String> synonyms = new HashSet<String>();
        String itemName = item.getName().toUpperCase();
        synonyms.add(itemName);
        Optional<String> truncationsOpt = item.getTruncations();
        if (truncationsOpt.isPresent()) {
            String truncations = truncationsOpt.get().toUpperCase();
            if (!itemName.startsWith(truncations)) {
                this.addDefinitionError(errorBuff, "invalid truncation, must be a root of ''{0}'': ''{1}''", itemName, truncations);
            } else {
                for (int c = truncations.length(); c < itemName.length(); ++c) {
                    synonyms.add(itemName.substring(0, c));
                }
            }
        }
        for (String abbreviation : item.getAbbreviations()) {
            synonyms.add(abbreviation.toUpperCase());
        }
        return synonyms;
    }

    private String nameMapToString(Map<String, ?> nameMap) {
        TreeMap sortedNameMap = new TreeMap(nameMap);
        StringBuilder sb = new StringBuilder();
        sb.append(" [\n");
        for (String name : sortedNameMap.keySet()) {
            Object value = sortedNameMap.get(name);
            sb.append("    ").append(name).append(" -> ").append(value != null ? value.toString() : "").append("\n");
        }
        sb.append("  ]");
        return sb.toString();
    }

    private void addDefinitionError(StringBuilder errorBuff, String message, Object ... args) {
        errorBuff.append(MessageFormat.format(message, args)).append("\n");
    }

    private class TypeNode
    extends TypeContainer {
        Type type;
        Map<String, Option> optionMap;
        List<Option> options;
        List<Parameter> parameters;

        TypeNode(Type type, StringBuilder errorBuff) {
            super(type.getName(), type.getNestedTypes(), errorBuff);
            this.optionMap = new HashMap<String, Option>();
            this.options = new ArrayList<Option>();
            this.parameters = new ArrayList<Parameter>();
            this.type = type;
            if (type.isBase()) {
                if (type.getNestedTypes().isEmpty()) {
                    Parser.this.addDefinitionError(errorBuff, "leaf type may not be base: {0}", type.getName());
                }
                if (!type.getOptions().isEmpty() || !type.getParameters().isEmpty()) {
                    Parser.this.addDefinitionError(errorBuff, "base type may not contain either options or attributes: {0}", type.getName());
                }
            }
            HashSet<String> attributeSynonymSet = new HashSet<String>();
            for (Option option : type.getOptions()) {
                if (option.isRequired() && option.getDefaultValue() != null) {
                    Parser.this.addDefinitionError(errorBuff, "required option may not have a default value: {0}", option.getName());
                }
                for (String synonym : Parser.this.getSynonyns(option, errorBuff)) {
                    if (!attributeSynonymSet.add(synonym)) {
                        Parser.this.addDefinitionError(errorBuff, "duplicate attribute synonym ''{0}'' in type ''{1}''", synonym, type.getName());
                    }
                    this.optionMap.put(synonym, option);
                }
                this.options.add(option);
            }
            int paramCount = type.getParameters().size();
            boolean optionalParam = false;
            for (int p = 0; p < paramCount; ++p) {
                String parameterName;
                Parameter parameter = type.getParameters().get(p);
                if (parameter.isRequired() && parameter.getDefaultValue() != null) {
                    Parser.this.addDefinitionError(errorBuff, "required parameter may not have a default value: {0}", parameter.getName());
                }
                if (!attributeSynonymSet.add(parameterName = parameter.getName().toUpperCase())) {
                    Parser.this.addDefinitionError(errorBuff, "duplicate attribute synonym ''{0}'' in type ''{1}''", parameterName, type.getName());
                }
                if (parameter.isRemainder() && p != paramCount - 1) {
                    Parser.this.addDefinitionError(errorBuff, "remainder parameters must be the last parameter: ''{0}'' in type ''{1}''", parameter.getName(), type.getName());
                }
                if (optionalParam) {
                    if (parameter.isRequired()) {
                        Parser.this.addDefinitionError(errorBuff, "parameters following an optional parameter must also be optional: ''{0}'' in type ''{1}''", parameter.getName(), type.getName());
                    }
                } else if (!parameter.isRequired()) {
                    optionalParam = true;
                }
                this.parameters.add(parameter);
            }
        }
    }

    private class TypeContainer {
        String containerName;
        Map<String, TypeNode> typeMap = new HashMap<String, TypeNode>();

        TypeContainer(String containerName, List<Type> types, StringBuilder errorBuff) {
            this.containerName = containerName.toUpperCase();
            for (Type type : types) {
                TypeNode nestedTypeNode = new TypeNode(type, errorBuff);
                for (String synonym : Parser.this.getSynonyns(type, errorBuff)) {
                    if (this.typeMap.put(synonym, nestedTypeNode) == null) continue;
                    Parser.this.addDefinitionError(errorBuff, "duplicate type synonym for {0}: {1}", containerName, synonym);
                }
            }
        }
    }

    private class ParsedCommandImpl
    implements ParsedCommand {
        private final String command;
        private final Consumer<String> errorConsumer;
        private final Map<String, Object> optionValuesMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        private final Map<String, Object> parameterValuesMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        private String path;
        private TypeNode typeNode;
        private boolean hasErrors;

        ParsedCommandImpl(String command, Consumer<String> errorConsumer) {
            this.command = command;
            this.errorConsumer = errorConsumer;
        }

        @Override
        public String getCommand() {
            return this.command;
        }

        @Override
        public Type getType() {
            return this.typeNode.type;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public boolean isFlagSet(String flagName) {
            Option flag = this.typeNode.optionMap.get(flagName);
            if (flag != null && flag.isFlag()) {
                Boolean value = (Boolean)this.getOptionValue(flagName);
                return value != null ? value : false;
            }
            throw new IllegalArgumentException("no such flag: " + flagName);
        }

        @Override
        public <T> T getOptionValue(String optionName) {
            if (this.optionValuesMap.containsKey(optionName)) {
                return (T)this.optionValuesMap.get(optionName);
            }
            throw new IllegalArgumentException("no such option: " + optionName);
        }

        @Override
        public <T> T getParameterValue(String parameterName) {
            if (this.parameterValuesMap.containsKey(parameterName)) {
                return (T)this.parameterValuesMap.get(parameterName);
            }
            throw new IllegalArgumentException("no such parameter: " + parameterName);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.path);
            sb.append("\nOptions:").append(Parser.this.nameMapToString(this.optionValuesMap));
            sb.append("\nParameters:").append(Parser.this.nameMapToString(this.parameterValuesMap));
            return sb.toString();
        }

        private boolean parse() {
            Object value;
            String rawValue;
            List<Token> tokens = Parser.this.tokenizer.tokenize(this.command, this.errorConsumer);
            int tokenNo = 0;
            if (tokens.isEmpty()) {
                return false;
            }
            StringBuilder pathBuf = new StringBuilder();
            TypeContainer container = Parser.this.rootContainer;
            boolean foundCommand = false;
            while (!foundCommand) {
                Token token = tokens.get(tokenNo);
                if (token.getType() == Token.Type.SYMBOL) {
                    TypeNode nestedTypeNode = container.typeMap.get(token.getValue().toUpperCase());
                    if (nestedTypeNode != null) {
                        pathBuf.append(nestedTypeNode.containerName).append('/');
                        this.typeNode = nestedTypeNode;
                        container = this.typeNode;
                        foundCommand = ++tokenNo >= tokens.size();
                        continue;
                    }
                    foundCommand = true;
                    continue;
                }
                foundCommand = true;
            }
            if (this.typeNode == null) {
                this.report(Messages.Key.UNRECOGNIZED_COMMAND, tokens.get(tokenNo).getRawValue());
            } else if (this.typeNode.type.isBase()) {
                this.report(Messages.Key.BASE_COMMAND, this.typeNode.type.getName());
            }
            if (this.hasErrors) {
                return false;
            }
            this.path = pathBuf.toString();
            HashMap<String, String> rawOptionsMap = new HashMap<String, String>();
            HashMap<String, String> rawParametersMap = new HashMap<String, String>();
            int paramCount = 0;
            while (tokenNo < tokens.size()) {
                Token token = tokens.get(tokenNo++);
                String value2 = token.getValue();
                if (token.getType() == Token.Type.SYMBOL && value2.startsWith("-")) {
                    if (value2.length() < 2) {
                        this.report(Messages.Key.ZERO_LENGTH_OPTION, new Object[0]);
                        continue;
                    }
                    String[] valueFields = value2.substring(1).split("[:=]");
                    String rawItemName = valueFields[0];
                    Option option = this.typeNode.optionMap.get(rawItemName.toUpperCase());
                    if (option != null) {
                        String itemName = option.getName();
                        if (option.isFlag()) {
                            rawOptionsMap.put(itemName, "true");
                            if (valueFields.length <= 1) continue;
                            this.report(Messages.Key.INVALID_FLAG_SYNTAX, itemName);
                            continue;
                        }
                        if (valueFields.length == 1) {
                            if (tokenNo < tokens.size()) {
                                Token optionValueToken;
                                if ((optionValueToken = tokens.get(tokenNo++)).getType() == Token.Type.LITERAL || !optionValueToken.getValue().startsWith("-")) {
                                    String optionValue = optionValueToken.getValue();
                                    rawOptionsMap.put(itemName, optionValue);
                                    continue;
                                }
                                rawOptionsMap.put(itemName, "");
                                this.report(Messages.Key.MISSING_OPTION_VALUE, itemName);
                                continue;
                            }
                            rawOptionsMap.put(itemName, "");
                            this.report(Messages.Key.MISSING_OPTION_VALUE, itemName);
                            continue;
                        }
                        rawOptionsMap.put(itemName, valueFields[1]);
                        if (valueFields.length <= 2) continue;
                        this.report(Messages.Key.INVALID_OPTION_SYNTAX, value2);
                        continue;
                    }
                    this.report(Messages.Key.UNRECOGNIZED_OPTION, value2);
                    continue;
                }
                if (this.typeNode.parameters.size() > paramCount) {
                    Parameter parameter;
                    if ((parameter = this.typeNode.parameters.get(paramCount++)).isRemainder()) {
                        StringBuilder buff = new StringBuilder(token.getRawValue());
                        for (int t = tokenNo; t < tokens.size(); ++t) {
                            Token remainderToken = tokens.get(t);
                            String dividerToken = this.command.substring(tokens.get(t - 1).getEnd(), remainderToken.getStart());
                            buff.append(dividerToken).append(remainderToken.getRawValue());
                        }
                        rawParametersMap.put(parameter.getName(), buff.toString());
                        tokenNo = tokens.size();
                        continue;
                    }
                    rawParametersMap.put(parameter.getName(), token.getValue());
                    continue;
                }
                this.report(Messages.Key.UNEXPECTED_TOKEN, token.getRawValue());
            }
            for (Option option : this.typeNode.options) {
                String optionName = option.getName();
                rawValue = (String)rawOptionsMap.get(optionName);
                if (rawValue != null) {
                    value = option.transform(rawValue, this.errorConsumer);
                } else {
                    value = option.getDefaultValue();
                    if (option.isRequired()) {
                        this.report(Messages.Key.REQUIRED_OPTION, optionName);
                    }
                }
                if (value == null && rawValue != null) {
                    this.report(Messages.Key.TRANSFORM_ERROR, rawValue, optionName);
                }
                if (value != null && !option.getType().isAssignableFrom(value.getClass())) {
                    throw new IllegalArgumentException("transformed value has type that is inconsistent with the type of option with name " + optionName);
                }
                this.optionValuesMap.put(optionName, value);
            }
            for (Parameter parameter : this.typeNode.parameters) {
                String parameterName = parameter.getName();
                rawValue = (String)rawParametersMap.get(parameterName);
                if (rawValue != null) {
                    value = parameter.transform(rawValue, this.errorConsumer);
                } else {
                    value = parameter.getDefaultValue();
                    if (parameter.isRequired()) {
                        this.report(Messages.Key.REQUIRED_PARAMETER, parameterName);
                    }
                }
                if (value == null && rawValue != null) {
                    this.report(Messages.Key.TRANSFORM_ERROR, rawValue, parameterName);
                }
                if (value != null && !parameter.getType().isAssignableFrom(value.getClass())) {
                    throw new IllegalArgumentException("transformed value has type that is inconsistent with the type of parameter with name " + parameterName);
                }
                this.parameterValuesMap.put(parameterName, value);
            }
            return !this.hasErrors;
        }

        private void report(Messages.Key key, Object ... args) {
            this.errorConsumer.accept(MessageFormat.format(Messages.getString(key), args));
            this.hasErrors = true;
        }
    }
}

