/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.parameterparser.validators;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.ParmResources;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.ParameterFailedValidationException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.validators.AbstractValidatorService;

public class DateValidator
extends AbstractValidatorService<Date> {
    @Override
    public Date getParameter(String parm) throws ParameterFailedValidationException {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(this.dateFmtStr);
            String dateStr = parm.trim().replaceAll("^\"|\"$", "");
            return dateFormat.parse(dateStr);
        }
        catch (Exception e) {
            throw new ParameterFailedValidationException(ParmResources.format("BAD_PARM_VALUE", parm, this.pName, "Bad date format " + this.dateFmtStr));
        }
    }

    @Override
    public String parmToString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.dateFmtStr);
        return dateFormat.format((Date)this.parmValue);
    }

    @Override
    public List<Date> StringToTypeList(String stringList) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.dateFmtStr);
        try {
            String[] tempArray;
            for (String date : tempArray = stringList.split(",")) {
                this.allowedValues.add(dateFormat.parse(date.trim()));
            }
            return this.allowedValues;
        }
        catch (Exception e) {
            return null;
        }
    }
}

