/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.parameterparser.parser;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.CommandParserConstants;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.Help.AbstractCommandConstants;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.ParmResources;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.CommandOptionsClassException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.ConnectionNotValidException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.ExtraParameterException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.InvalidCommandException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.MissingRequiredParameterException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.ParameterFailedValidationException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.parameter.StandardParameter;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.parser.ArgumentTokenizer;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.parser.Pair;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.validators.AbstractValidatorService;

public class CommandParser {
    private static boolean adjustCase(String value) {
        if (value.trim().startsWith("\"") && value.trim().endsWith("\"")) {
            return false;
        }
        return !value.trim().startsWith("'") || !value.trim().endsWith("'");
    }

    public static String expandCommand(String command, Map<String, String> aliases) {
        if (command.equals(CommandParserConstants.HELP_S)) {
            command = CommandParserConstants.HELP;
        }
        return aliases.containsKey(command) ? aliases.get(command) : command;
    }

    public static String expandParameter(String parm, Map<String, String> aliases) {
        while (parm.startsWith("-")) {
            parm = parm.substring(1).toLowerCase();
        }
        if (parm.equals("ex")) {
            return "example";
        }
        if (parm.equals("sy")) {
            return "syntax";
        }
        return aliases.containsKey(parm) ? aliases.get(parm) : parm;
    }

    public static void loadParams(String setName, String parmString, ScriptRunnerContext ctx, AbstractCommandConstants constants, boolean populateBaseCommand, boolean escapeBackSlashes) throws InvalidCommandException, ParameterFailedValidationException, MissingRequiredParameterException, ConnectionNotValidException, ExtraParameterException {
        CommandParser.loadParams(setName, parmString, ctx, constants, populateBaseCommand, escapeBackSlashes, true);
    }

    public static void loadParams(String setName, String parmString, ScriptRunnerContext ctx, AbstractCommandConstants constants, boolean populateBaseCommand, boolean escapeBackSlashes, boolean resetParameters) throws InvalidCommandException, ParameterFailedValidationException, MissingRequiredParameterException, ConnectionNotValidException, ExtraParameterException {
        String value;
        int i;
        LinkedList<String> invalidCommands = new LinkedList<String>();
        if (resetParameters) {
            ctx.getParameterInstance().resetParameters(setName);
        } else if (!ctx.getParameterInstance().parametersContains(setName)) {
            ctx.getParameterInstance().resetParameters(setName);
        } else {
            ctx.getParameterInstance().getParameters(setName).remove(CommandParserConstants.COMMAND);
            ctx.getParameterInstance().getParameters(setName).remove(CommandParserConstants.BASE_COMMAND);
            ctx.getParameterInstance().getParameters(setName).remove(CommandParserConstants.HELP);
            ctx.getParameterInstance().getParameters(setName).remove(CommandParserConstants.SYNTAX);
            ctx.getParameterInstance().getParameters(setName).remove(CommandParserConstants.EXAMPLE);
        }
        HashMap<String, Object> params = ctx.getParameterInstance().getParameters(setName);
        List<String> rawArgs = ArgumentTokenizer.tokenize(parmString, false, escapeBackSlashes);
        String[] _args = rawArgs.toArray(new String[0]);
        if (_args.length == 1 && (populateBaseCommand || !constants.getCommandModel().containsKey(_args[0]) && !constants.getCommandAliases().containsKey(_args[0]))) {
            params.put(CommandParserConstants.HELP, "true");
            params.put(CommandParserConstants.COMMAND, CommandParserConstants.HELP);
            if (populateBaseCommand) {
                params.put(CommandParserConstants.BASE_COMMAND, _args[0]);
            } else {
                params.put(CommandParserConstants.BASE_COMMAND, CommandParserConstants.NO_BASE_COMMAND_NAME);
            }
            return;
        }
        if (populateBaseCommand) {
            params.put(CommandParserConstants.BASE_COMMAND, _args[0].toLowerCase());
        } else {
            params.put(CommandParserConstants.BASE_COMMAND, CommandParserConstants.NO_BASE_COMMAND_NAME);
        }
        int n = i = populateBaseCommand ? 1 : 0;
        while (i < _args.length) {
            block52: {
                if (!_args[i].startsWith("-")) {
                    String command = _args[i].toLowerCase();
                    command = CommandParser.expandCommand(command, constants.getCommandAliases());
                    if (constants.hasHelpSubCommand() && command.equalsIgnoreCase(CommandParserConstants.HELP)) {
                        params.put(CommandParserConstants.HELP, "true");
                    }
                    try {
                        CommandParser.validateCommand(params.get(CommandParserConstants.BASE_COMMAND).toString(), command, new ArrayList<String>(constants.getCommandModel().keySet()), constants);
                        if (params.get(CommandParserConstants.COMMAND) != null) {
                            if (constants.hasHelpSubCommand() && params.get(CommandParserConstants.COMMAND).equals(CommandParserConstants.HELP)) {
                                params.put(CommandParserConstants.COMMAND, command);
                            } else if (!command.equals(CommandParserConstants.HELP)) {
                                params.put(CommandParserConstants.COMMAND, params.get(CommandParserConstants.COMMAND) + "," + command);
                            }
                            break block52;
                        }
                        params.put(CommandParserConstants.COMMAND, command);
                    }
                    catch (Exception e) {
                        invalidCommands.add(_args[i]);
                    }
                } else if (_args.length > i + 1 && !_args[i + 1].startsWith("-")) {
                    StandardParameter parm;
                    String arg = CommandParser.expandParameter(_args[i], constants.getParameterAliases());
                    value = _args[i + 1].toLowerCase();
                    if (params.get(CommandParserConstants.COMMAND) == null || params.get(CommandParserConstants.COMMAND).equals("")) {
                        throw new InvalidCommandException(ParmResources.getString("UNKNOWN_COMMAND"));
                    }
                    try {
                        parm = constants.getCommandModel().get(params.get(CommandParserConstants.COMMAND)).get(arg);
                    }
                    catch (Exception e) {
                        parm = null;
                    }
                    if (parm == null) {
                        throw new ParameterFailedValidationException(ParmResources.format("UNKNOWN_PARAM", arg));
                    }
                    if (parm.isBoolean()) {
                        if (value.equals("true") || value.equals("false")) {
                            ++i;
                        }
                    } else {
                        ++i;
                    }
                }
            }
            ++i;
        }
        if ((params.get(CommandParserConstants.COMMAND) == null || params.get(CommandParserConstants.COMMAND).equals("")) && invalidCommands.size() == 0) {
            params.put(CommandParserConstants.HELP, "true");
            params.put(CommandParserConstants.COMMAND, CommandParserConstants.HELP);
            return;
        }
        if (constants.hasHelpSubCommand() && params.get(CommandParserConstants.COMMAND) != null && params.get(CommandParserConstants.COMMAND).equals(CommandParserConstants.HELP)) {
            for (int i2 = 1; i2 < _args.length; ++i2) {
                if (!_args[i2].startsWith("-")) continue;
                String parameter = CommandParser.expandParameter(_args[i2], constants.getParameterAliases());
                if (parameter.equals("syntax")) {
                    params.put(parameter, "true");
                    continue;
                }
                if (!parameter.equals("example")) continue;
                params.put(parameter, "true");
            }
            return;
        }
        Map<String, StandardParameter> commandParameters = constants.getCommandModel().get(params.get(CommandParserConstants.COMMAND));
        if (commandParameters == null) {
            throw new InvalidCommandException(ParmResources.getString("UNKNOWN_COMMAND"));
        }
        ArrayList<String> used_parms = new ArrayList<String>();
        for (int i3 = 1; i3 < _args.length; ++i3) {
            if (!_args[i3].startsWith("-")) continue;
            String parameter = CommandParser.expandParameter(_args[i3], constants.getParameterAliases());
            if (parameter.equals("syntax")) {
                params.put(parameter, "true");
                continue;
            }
            if (parameter.equals("example")) {
                params.put(parameter, "true");
                continue;
            }
            if (_args.length > i3 + 1 && !_args[i3 + 1].startsWith("-")) {
                String arg = CommandParser.expandParameter(_args[i3], constants.getParameterAliases());
                String argValue = _args[i3 + 1].toLowerCase();
                StandardParameter parm = constants.getCommandModel().get(params.get(CommandParserConstants.COMMAND)).get(arg);
                if (parm.isBoolean()) {
                    value = argValue.equals("true") || argValue.equals("false") ? argValue : null;
                    ++i3;
                } else {
                    value = _args[i3 + 1].startsWith("-") ? null : _args[++i3];
                }
            } else {
                value = null;
            }
            Pair<String, String> cleanParm = CommandParser.validateCommandParameter(parameter, value, commandParameters, ctx);
            if ((params.get(CommandParserConstants.BASE_COMMAND) == null || !params.get(CommandParserConstants.BASE_COMMAND).equals(CommandParserConstants.SET)) && params.containsKey(cleanParm.getKey())) {
                throw new ParameterFailedValidationException(ParmResources.format("DUP_PARM", parameter));
            }
            params.put(cleanParm.getKey(), cleanParm.getValue());
            used_parms.add(cleanParm.getKey());
        }
        if (commandParameters != null) {
            for (String s : commandParameters.keySet()) {
                Pair<String, String> cleanParm;
                if (commandParameters.get(s).isPositional()) {
                    if (invalidCommands.size() > 0) {
                        if (commandParameters.get(s).singleValue()) {
                            cleanParm = CommandParser.validateCommandParameter(s, (String)invalidCommands.pop(), commandParameters, ctx);
                        } else {
                            String iCommand = String.join((CharSequence)" ", invalidCommands);
                            invalidCommands.clear();
                            cleanParm = CommandParser.validateCommandParameter(s, iCommand, commandParameters, ctx);
                        }
                        params.put(cleanParm.getKey(), cleanParm.getValue());
                        used_parms.add(cleanParm.getKey());
                    }
                } else if (commandParameters.get(s).getDefault() != null && !used_parms.contains(s) && resetParameters) {
                    cleanParm = CommandParser.validateCommandParameter(s, commandParameters.get(s).getDefault(), commandParameters, ctx);
                    params.put(cleanParm.getKey(), cleanParm.getValue());
                    used_parms.add(cleanParm.getKey());
                }
                if (!commandParameters.get(s).isRequired() || used_parms.contains(s) || ctx.getParameterInstance().getParameterAsBoolean(setName, CommandParserConstants.HELP).booleanValue()) continue;
                throw new MissingRequiredParameterException(ParmResources.format("REQUIRED_PARM_MISSING", s));
            }
            if (invalidCommands.size() > 0) {
                throw new ExtraParameterException(ParmResources.format("EXTRA_PARM", invalidCommands.get(0)));
            }
        }
        if (ctx.getParameterInstance().getParameterAsBoolean(setName, CommandParserConstants.DEBUG).booleanValue()) {
            ctx.getParameterInstance().printParametersAsRow(setName);
            try {
                ctx.getOutputStream().flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void loadParams(String setName, String parmString, ScriptRunnerContext ctx, Class<? extends AbstractCommandConstants> constantsClass) throws CommandOptionsClassException, InvalidCommandException, ParameterFailedValidationException, MissingRequiredParameterException, ConnectionNotValidException, ExtraParameterException {
        CommandParser.loadParams(setName, parmString, ctx, constantsClass, true, true, true);
    }

    public static void loadParams(String setName, String parmString, ScriptRunnerContext ctx, Class<? extends AbstractCommandConstants> constantsClass, boolean populateBaseCommand, boolean escapeBackSlashes) throws CommandOptionsClassException, InvalidCommandException, ParameterFailedValidationException, MissingRequiredParameterException, ConnectionNotValidException, ExtraParameterException {
        CommandParser.loadParams(setName, parmString, ctx, constantsClass, populateBaseCommand, escapeBackSlashes, true);
    }

    public static void loadParams(String setName, String parmString, ScriptRunnerContext ctx, Class<? extends AbstractCommandConstants> constantsClass, boolean populateBaseCommand, boolean escapeBackSlashes, boolean resetParameters) throws CommandOptionsClassException, InvalidCommandException, ParameterFailedValidationException, MissingRequiredParameterException, ConnectionNotValidException, ExtraParameterException {
        AbstractCommandConstants constants;
        try {
            constants = constantsClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new CommandOptionsClassException(ParmResources.getString("OPTIONS_ERROR"), e);
        }
        CommandParser.loadParams(setName, parmString, ctx, constants, populateBaseCommand, escapeBackSlashes, resetParameters);
    }

    private static void validateCommand(String baseCommand, String command, ArrayList<String> commands, AbstractCommandConstants constants) throws InvalidCommandException {
        if (commands.contains(command) || constants.hasHelpSubCommand() && command.equals(CommandParserConstants.HELP)) {
            return;
        }
        if (baseCommand != null && baseCommand != "") {
            throw new InvalidCommandException(ParmResources.format("BAD_COMMAND", command, baseCommand));
        }
        throw new InvalidCommandException(ParmResources.format("BAD_COMMAND_SHORT", command));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Pair<String, String> validateCommandParameter(String parameter, String value, Map<String, StandardParameter> parameterList, ScriptRunnerContext ctx) throws ParameterFailedValidationException, ConnectionNotValidException {
        AbstractValidatorService validator;
        if (!parameterList.containsKey(parameter)) {
            throw new ParameterFailedValidationException(ParmResources.format("UNKNOWN_PARAM", parameter));
        }
        StandardParameter ParameterInfo = parameterList.get(parameter);
        Class<?> clazz = ParameterInfo.getValidator();
        try {
            validator = (AbstractValidatorService)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new ParameterFailedValidationException(ParmResources.format("MISSING_VALIDATOR", parameter));
        }
        if (value != null && validator.isListType()) {
            String[] values = ((String)value).split(",", -1);
            value = "";
            for (String theValue : values) {
                if (theValue == null) continue;
                if (CommandParser.adjustCase(theValue)) {
                    if (ParameterInfo.getCase() == StandardParameter.CASE.LOWER) {
                        value = (String)value + "," + theValue.toLowerCase();
                        continue;
                    }
                    if (ParameterInfo.getCase() != StandardParameter.CASE.UPPER) continue;
                    value = (String)value + "," + theValue.toUpperCase();
                    continue;
                }
                value = (String)value + "," + theValue;
            }
            if (((String)value).length() > 0) {
                value = ((String)value).length() > 1 ? ((String)value).substring(1) : "";
            }
        } else if (value != null && CommandParser.adjustCase((String)value)) {
            if (ParameterInfo.getCase() == StandardParameter.CASE.LOWER) {
                value = ((String)value).toLowerCase();
            } else if (ParameterInfo.getCase() == StandardParameter.CASE.UPPER) {
                value = ((String)value).toUpperCase();
            }
        }
        String defVal = ParameterInfo.getDefault();
        if (value == null || ((String)value).equals("")) {
            if (ParameterInfo.isBoolean()) {
                if (defVal == null) {
                    value = "true";
                } else if (defVal.toLowerCase().equals("false")) {
                    value = "true";
                } else {
                    if (!defVal.toLowerCase().equals("true")) throw new ParameterFailedValidationException(ParmResources.format("UNEXPECTED_STATE", parameter));
                    value = "false";
                }
            } else if (defVal != null) {
                value = defVal;
            } else {
                if (!ParameterInfo.isNullable() || defVal != null) throw new ParameterFailedValidationException(ParmResources.format("MISSING_PARAM_VALUE", parameter));
                value = null;
            }
        }
        if (ParameterInfo.isRequired() && (value == null || ((String)value).equals(""))) {
            throw new ParameterFailedValidationException(ParmResources.format("MISSING_PARAM_VALUE", parameter));
        }
        if (validator == null) {
            throw new ParameterFailedValidationException(ParmResources.format("MISSING_VALIDATOR", parameter));
        }
        validator.setupValidator(ParameterInfo.isNullable(), ParameterInfo.getAllowed(), ParameterInfo.getDateFormat(), parameter, ctx);
        validator.validate((String)value);
        return new Pair<String, Object>(parameter, value);
    }
}

