/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.parameterparser.parameter;

import oracle.dbtools.raptor.newscriptrunner.parameterparser.validators.AbstractValidatorService;

public class StandardParameter {
    private final String _defaultValue;
    private String _allowedValues;
    private final boolean _allowNull;
    private final boolean _required;
    private final boolean _positional;
    private final boolean _singleValue;
    private final Class<? extends AbstractValidatorService<?>> _validator;
    private final CASE _parmCase;
    private final String _dateFormat;

    private StandardParameter(StandardParameterBuilder builder) {
        this._allowedValues = builder.allowedValues;
        this._defaultValue = builder.defaultValue;
        this._allowedValues = builder.allowedValues;
        this._allowNull = builder.allowNull;
        this._required = builder.required;
        this._positional = builder.positional;
        this._singleValue = builder.singleValue;
        this._validator = builder.validator;
        this._parmCase = builder.parmCase;
        this._dateFormat = builder.dateFormat;
    }

    public static PositionalStep withValidator(Class<? extends AbstractValidatorService<?>> validator) {
        return new StandardParameterBuilder(validator);
    }

    public String getAllowed() {
        return this._allowedValues;
    }

    public String getDefault() {
        if (this._defaultValue == null) {
            return this._defaultValue;
        }
        if (this.getCase() == CASE.LOWER) {
            return this._defaultValue.toLowerCase();
        }
        if (this.getCase() == CASE.UPPER) {
            return this._defaultValue.toUpperCase();
        }
        return this._defaultValue;
    }

    public boolean singleValue() {
        return this._singleValue;
    }

    public Class<?> getValidator() {
        return this._validator;
    }

    public CASE getCase() {
        if (this._parmCase == null) {
            return CASE.LOWER;
        }
        return this._parmCase;
    }

    public String getDateFormat() {
        if (this._dateFormat == null) {
            return "yyyy-mm-dd hh:mm:ss";
        }
        return this._dateFormat;
    }

    public boolean isBoolean() {
        return this.getValidator().toString().substring(this.getValidator().toString().lastIndexOf(".") + 1).equals("BooleanValidator");
    }

    public boolean isNullable() {
        return this._allowNull;
    }

    public boolean isPositional() {
        return this._positional;
    }

    public boolean isRequired() {
        return this._required;
    }

    public String isRequiredString() {
        return String.valueOf(this._required) == null ? "false" : String.valueOf(this._required);
    }

    public static interface PositionalStep {
        public PositionalDetails isPositional();

        public Build isStandard();
    }

    public static interface PositionalDetails {
        public Build singleValue(boolean var1);
    }

    public static interface Build {
        public Build allowedValues(String var1);

        public Build dateFormat(String var1);

        public Build allowNull(boolean var1);

        public StandardParameter build();

        public Build defaultValue(String var1);

        public Build isRequired(boolean var1);

        public Build paramCase(CASE var1);
    }

    private static class StandardParameterBuilder
    implements Build,
    PositionalDetails,
    PositionalStep {
        private String defaultValue;
        private String allowedValues;
        private boolean allowNull;
        private boolean required;
        private boolean positional;
        private boolean singleValue;
        private final Class<? extends AbstractValidatorService<?>> validator;
        private CASE parmCase;
        private String dateFormat;

        public StandardParameterBuilder(Class<? extends AbstractValidatorService<?>> validator) {
            this.validator = validator;
        }

        @Override
        public Build allowedValues(String allowedValues) {
            this.allowedValues = allowedValues;
            return this;
        }

        @Override
        public Build allowNull(boolean allowNull) {
            this.allowNull = allowNull;
            return this;
        }

        @Override
        public StandardParameter build() {
            StandardParameter parm = new StandardParameter(this);
            return parm;
        }

        @Override
        public Build defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        @Override
        public PositionalDetails isPositional() {
            this.positional = true;
            return this;
        }

        @Override
        public Build isRequired(boolean required) {
            this.required = required;
            return this;
        }

        @Override
        public Build isStandard() {
            this.positional = false;
            this.singleValue = true;
            return this;
        }

        @Override
        public Build singleValue(boolean singleValue) {
            this.singleValue = singleValue;
            return this;
        }

        @Override
        public Build paramCase(CASE pCase) {
            this.parmCase = pCase;
            return this;
        }

        @Override
        public Build dateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
            return this;
        }
    }

    public static enum CASE {
        UPPER,
        LOWER,
        PERSIST;

    }
}

