/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.parameterparser.Help;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class StringWrapper {
    private static final short MAX_LENGTH = 75;
    private static final String sep = System.lineSeparator();

    public static int findBreakBefore(String line, int start) {
        for (int i = start; i >= 0; --i) {
            char c = line.charAt(i);
            if (!Character.isWhitespace(c)) continue;
            return i;
        }
        return start;
    }

    public static List<String> splitIntoLines(String str) {
        ArrayList<String> strings = new ArrayList<String>();
        if (str != null) {
            int len = str.length();
            if (len == 0) {
                strings.add("");
                return strings;
            }
            int lineStart = 0;
            for (int i = 0; i < len; ++i) {
                char c = str.charAt(i);
                if (c == '\r') {
                    int newlineLength = 1;
                    if (i + 1 < len && str.charAt(i + 1) == '\n') {
                        newlineLength = 2;
                    }
                    strings.add(str.substring(lineStart, i));
                    lineStart = i + newlineLength;
                    if (newlineLength != 2) continue;
                    ++i;
                    continue;
                }
                if (c != '\n') continue;
                strings.add(str.substring(lineStart, i));
                lineStart = i + 1;
            }
            if (lineStart < len) {
                strings.add(str.substring(lineStart));
            }
        }
        return strings;
    }

    public static List<String> wrap(String str, int maxWidth) {
        List<String> lines = StringWrapper.splitIntoLines(str);
        if (lines.isEmpty()) {
            return lines;
        }
        ArrayList<String> strings = new ArrayList<String>();
        Iterator<String> iter = lines.iterator();
        while (iter.hasNext()) {
            StringWrapper.wrapLineInto(iter.next(), strings, maxWidth);
        }
        return strings;
    }

    public static void wrapLineInto(String line, List<String> list, int maxWidth) {
        int len = line.length();
        while (len > maxWidth) {
            int pos = len > maxWidth ? StringWrapper.findBreakBefore(line, maxWidth) : len;
            if (pos == -1) {
                pos = maxWidth;
            }
            list.add(line.substring(0, pos).trim());
            line = line.substring(pos).trim();
            len = line.length();
        }
        if (len > 0) {
            list.add(line);
        }
    }

    public static String wrapString(String str) {
        return StringWrapper.wrapString(str, 75, "");
    }

    public static String wrapString(String str, int maxWidth, String spacer) {
        return StringWrapper.wrapString(str, maxWidth, spacer, true);
    }

    public static String wrapString(String str, int maxWidth, String spacer, boolean startWithSpacer) {
        List<String> wrap = StringWrapper.wrap(str, maxWidth);
        StringBuilder stringBuilder = new StringBuilder();
        boolean first = true;
        for (String line : wrap) {
            if (first) {
                first = false;
                if (startWithSpacer) {
                    stringBuilder.append(spacer).append(line).append(sep);
                    continue;
                }
                stringBuilder.append(' ').append(line).append(sep);
                continue;
            }
            stringBuilder.append(spacer).append(line).append(sep);
        }
        return stringBuilder.toString();
    }
}

