/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.connector;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.function.Consumer;

public class SocksProxyValue {
    private final URI uri;

    public static SocksProxyValue create(String uriRep, Consumer<String> errorConsumer) {
        SocksProxyValue socksProxy = null;
        try {
            URI uri = new URI(uriRep);
            String scheme = uri.getScheme();
            String host = uri.getHost();
            int port = uri.getPort();
            if (scheme == null || !scheme.equals("socks5") && !scheme.equals("socks5h")) {
                throw new URISyntaxException(uri.toString(), "protocol");
            }
            if (host == null) {
                throw new URISyntaxException(uri.toString(), "host");
            }
            if (port < 0) {
                throw new URISyntaxException(uri.toString(), "port");
            }
            socksProxy = new SocksProxyValue(uri);
        }
        catch (URISyntaxException ex) {
            errorConsumer.accept(ex.getMessage());
        }
        return socksProxy;
    }

    public URI getURI() {
        return this.uri;
    }

    public void setSocksProperties(Properties props) {
        props.put("oracle.net.socksProxyHost", this.uri.getHost());
        props.put("oracle.net.socksProxyPort", Integer.toString(this.uri.getPort()));
        props.put("oracle.net.socksRemoteDNS", this.uri.getScheme().equals("socks5") ? "false" : "true");
    }

    public String toString() {
        return this.uri.toString();
    }

    private SocksProxyValue(URI uri) {
        this.uri = uri;
    }
}

