/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.connector;

import java.sql.SQLException;
import java.util.Properties;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorArgs;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.Krb5CCNameProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.Krb5ConfigProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.OracleConnector;
import oracle.jdbc.datasource.OracleDataSource;

public class KerberosConnector
extends OracleConnector {
    public KerberosConnector(ConnectorArgs args) {
        super(args);
    }

    @Override
    protected void configureDataSource(OracleDataSource datasource, String url, Properties filteredProps) throws SQLException {
        String krb5_config = this.properties.getValueOf(Krb5ConfigProperty.KRB5_CONFIG);
        String krb5ccname = this.properties.getValueOf(Krb5CCNameProperty.KRB5CCNAME);
        String currConf = System.getProperty("java.security.krb5.conf");
        if (currConf == null || currConf.equals("")) {
            if (krb5_config != null && !krb5_config.equals("")) {
                System.setProperty("java.security.krb5.conf", krb5_config);
            } else {
                String confEnv = System.getenv("KRB5_CONFIG");
                if (confEnv != null && !confEnv.equals("")) {
                    System.setProperty("java.security.krb5.conf", confEnv);
                } else {
                    System.clearProperty("java.security.krb5.conf");
                }
            }
        }
        filteredProps.put("oracle.net.authentication_services", "(KERBEROS5)");
        filteredProps.put("oracle.net.kerberos5_mutual_authentication", "true");
        if (krb5ccname != null && !krb5ccname.equals("")) {
            filteredProps.put("oracle.net.kerberos5_cc_name", krb5ccname);
        } else {
            String ccEnv = System.getenv("KRB5CCNAME");
            if (ccEnv != null && !ccEnv.equals("")) {
                filteredProps.put("oracle.net.kerberos5_cc_name", ccEnv);
            }
        }
        super.configureDataSource(datasource, url, filteredProps);
    }
}

