/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.connector;

import java.text.MessageFormat;
import java.util.List;
import oracle.dbtools.jdbc.wallet.OracleWalletArchive;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorArgs;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ParseConnectionSpecArgs;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.Property;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.CloudConfigProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.CloudWalletConnector;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.OracleStandardFormConnectorType;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.ProxyProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.URLProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.WalletValue;

public class CloudWalletConnectorType
extends OracleStandardFormConnectorType {
    @Override
    public String getName() {
        return "WALLET";
    }

    @Override
    public String getShortName() {
        return "W";
    }

    @Override
    public void parseConnectionSpec(ParseConnectionSpecArgs args) {
        super.parseConnectionSpec(args);
        String url = args.getPropertyValue(URLProperty.URL);
        if (url != null && url.startsWith("jdbc:") && !url.startsWith("jdbc:oracle:thin:")) {
            args.addError(MessageFormat.format(Messages.getString(Messages.Key.INVALID_PREFIX), this.getName(), url));
        } else {
            WalletValue walletValue = args.getPropertyValue(CloudConfigProperty.CLOUDCONFIG);
            if (url == null || walletValue == null) {
                args.addError(Messages.getString(Messages.Key.INVALID_WALLET_URL));
            } else {
                OracleWalletArchive walletArchive = walletValue.getArchive();
                if (walletArchive == null || walletArchive.getTNSNames().getTNSEntry(url) == null) {
                    args.addError(Messages.getString(Messages.Key.INVALID_WALLET_URL));
                }
            }
        }
    }

    @Override
    protected void addInheritablePropertiesTo(List<Property<?>> properties) {
        properties.add(CloudConfigProperty.CLOUDCONFIG);
        properties.add(ProxyProperty.PROXY);
        super.addInheritablePropertiesTo(properties);
    }

    @Override
    public CloudWalletConnector createConnector(ConnectorArgs args) {
        return new CloudWalletConnector(args);
    }
}

