/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.connect;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.db.ConnectionDetails;
import oracle.dbtools.db.ConnectionStoreBridge;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.CommonServices;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.SetAppinfo;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.AbstractConnectionProcessor;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectionContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectionProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.Connector;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorArgs;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorType;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorTypeCache;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.DisconnectorArgs;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ParseConnectionSpecArgs;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.Property;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.PropertyValues;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.RawPropertyValues;
import oracle.dbtools.raptor.newscriptrunner.commands.show.ShowLogin;
import oracle.dbtools.raptor.newscriptrunner.util.help.CommandPageAssemblers;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpContainer;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPages;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPagesBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.help.PageAssembler;
import oracle.dbtools.raptor.newscriptrunner.util.parser.OptionBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParameterBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Parser;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;
import oracle.dbtools.raptor.newscriptrunner.util.parser.TypeBuilder;
import oracle.dbtools.raptor.utils.SQLPLUSUtil;

public class ConnectCommand
extends CommandListener
implements IHelp {
    private final ConnectorTypeCache cache = CommonServices.get(ConnectorTypeCache.class);

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        Parser parser = new Parser(this.createConnectParser());
        Optional<ParsedCommand> parsedCommand = parser.parse(SQLPLUSUtil.cleanCommand(cmd).getSql(), errorMessages::add);
        if (parsedCommand.isPresent()) {
            ConnectCommandProcessor processor = new ConnectCommandProcessor(parsedCommand.get(), ctx, cmd, errorMessages);
            processor.connect(conn, cmd);
        }
        for (String errorMessage : errorMessages) {
            ctx.write(errorMessage + "\n");
        }
        return true;
    }

    @Override
    public String getCommand() {
        return "CONNECT";
    }

    @Override
    public Optional<String> getHelp(ScriptRunnerContext ctx, String pagePath) {
        int lineSize = Integer.parseInt(ctx.getProperty("script.runner.setlinesize").toString());
        HelpPagesBuilder helpPagesBuilder = new HelpPagesBuilder().lineSize(lineSize);
        for (HelpContainer helpContainer : this.cache.getHelpContainers()) {
            helpPagesBuilder.addHelpContainer(helpContainer);
        }
        helpPagesBuilder.addPagesFor(this.createConnectParser());
        for (ConnectorType connectorType : this.cache.getConnectorTypes()) {
            helpPagesBuilder.addPages(this.createConnectorPageAssemblers(connectorType));
        }
        HelpPages helpPages = helpPagesBuilder.build();
        return helpPages.get(pagePath);
    }

    @Override
    public boolean isSqlPlus() {
        return true;
    }

    private Type createConnectParser() {
        TypeBuilder typeBuilder = new TypeBuilder("CONNECT").truncations("CONN");
        for (String propertyName : this.cache.getPropertyNames()) {
            Property property = this.cache.getProperty(propertyName);
            Class propertyType = property.isFlag() ? Boolean.class : String.class;
            OptionBuilder optionBuilder = (OptionBuilder)new OptionBuilder(propertyType, propertyName).helpKey(property.getHelpId());
            if (property.getShortName() != null) {
                optionBuilder.abbreviations(property.getShortName());
            }
            typeBuilder.add(optionBuilder.build());
        }
        typeBuilder.add(new OptionBuilder(Boolean.class, "VERBOSE").abbreviations("V").build());
        typeBuilder.add(((ParameterBuilder)new ParameterBuilder(String.class, "CONNECTIONSPEC").remainder().defaultValue("")).build());
        return typeBuilder.build();
    }

    private Iterable<PageAssembler> createConnectorPageAssemblers(ConnectorType connectorType) {
        TypeBuilder typeBuilder = (TypeBuilder)new TypeBuilder(connectorType.getName()).base().helpKey(connectorType.getHelpId());
        for (Property<?> property : connectorType.getProperties()) {
            Class propertyType = property.isFlag() ? Boolean.class : String.class;
            OptionBuilder optionBuilder = (OptionBuilder)new OptionBuilder(propertyType, property.getName()).helpKey(property.getHelpId());
            if (property.getShortName() != null) {
                optionBuilder.abbreviations(property.getShortName());
            }
            typeBuilder.add(optionBuilder.build());
        }
        typeBuilder.add(new OptionBuilder(Boolean.class, "VERBOSE").abbreviations("V").build());
        typeBuilder.add(((ParameterBuilder)new ParameterBuilder(String.class, "CONNECTIONSPEC").remainder().defaultValue("")).build());
        Type rootType = new TypeBuilder("CONNECT").truncations("CONN").add(typeBuilder.build()).build();
        return new CommandPageAssemblers(rootType, rootType);
    }

    private class ConnectCommandProcessor
    extends AbstractConnectionProcessor {
        private final List<String> errorMessages;
        private final ParsedCommand parsedCommand;
        private Set<Property<?>> commandProperties;
        private PropertyValues propertyValues;
        private ScriptExecutor scriptExecutor;

        ConnectCommandProcessor(ParsedCommand parsedCommand, ScriptRunnerContext ctx, ISQLCommand cmd, List<String> errorMessages) {
            super(ctx, cmd);
            this.scriptExecutor = null;
            this.parsedCommand = parsedCommand;
            this.errorMessages = errorMessages;
        }

        void connect(Connection currentConnection, ISQLCommand cmd) {
            ConnectorInfo connectorInfo;
            this.commandProperties = this.getCommandProperties();
            this.propertyValues = this.getPropertyValues();
            if (this.propertyValues != null && (connectorInfo = this.findMatchedConnector()) != null) {
                String connectionSpec = (String)this.parsedCommand.getParameterValue("CONNECTIONSPEC");
                ConnectionContext connectionContext = CommonServices.get(ConnectorTypeCache.class).getConnectionContext(this.ctx);
                Connection newConnection = this.processConnect(currentConnection, connectionContext.getCurrentConnectorType(), (String)this.parsedCommand.getParameterValue("CONNECTIONSPEC"), connectorInfo.connectorPropertyValues, connectorInfo.connectorType);
                this.ctx.setCurrentConnection(newConnection);
                if (newConnection != null) {
                    connectionContext.setCurrentConnectorType(connectorInfo.connectorType);
                    connectionContext.setCurrentConnectionSpec(connectionSpec);
                    connectionContext.setCurrentPropertyValues(connectorInfo.connectorPropertyValues);
                    connectionContext.setCurrentCommand(cmd);
                }
            }
        }

        private Set<Property<?>> getCommandProperties() {
            HashSet result = new HashSet();
            TreeSet<String> validNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            for (Property<?> property : ConnectCommand.this.cache.getProperties()) {
                String name = property.getName();
                if (this.parsedCommand.getOptionValue(name) == null) continue;
                result.add(property);
                validNames.add(name);
            }
            return result;
        }

        private PropertyValues getPropertyValues() {
            PropertyValues result = ConnectCommand.this.cache.getConnectionContext(this.ctx).getContextPropertyValues().createCopy();
            RawPropertyValues rawValues = RawPropertyValues.create(this.parsedCommand);
            for (Property<?> property : this.commandProperties) {
                Object value = property.createValue(this.ctx, rawValues, this.errorMessages::add);
                result.setValueOf(property, value);
            }
            if (!this.errorMessages.isEmpty()) {
                return null;
            }
            return result;
        }

        /*
         * WARNING - void declaration
         */
        private ConnectorInfo findMatchedConnector() {
            void var3_13;
            ArrayList<ConnectorInfo> matchCandidates = new ArrayList<ConnectorInfo>();
            for (ConnectorType connectorType : ConnectCommand.this.cache.getConnectorTypes()) {
                if (!this.validCommandPropertiesFor(connectorType)) continue;
                ConnectorInfo matchInfo = new ConnectorInfo(connectorType);
                matchCandidates.add(matchInfo);
                this.parseConnectionSpecFor(matchInfo);
            }
            for (ConnectorInfo connectorInfo : matchCandidates) {
                if (!this.matchByCommandProperties(connectorInfo)) continue;
                connectorInfo.matches = true;
            }
            if (!this.existMatchesWithoutError(matchCandidates)) {
                HashMap matchSetMap = new HashMap();
                for (ConnectorInfo matchCandidate : matchCandidates) {
                    Set<Property<?>> matchPropertySet = this.matchByPropertyValues(matchCandidate);
                    if (matchPropertySet == null) continue;
                    matchSetMap.put(matchCandidate, matchPropertySet);
                }
                if (matchSetMap.size() == 1) {
                    for (ConnectorInfo matchCandidate : matchSetMap.keySet()) {
                        matchCandidate.matches = true;
                    }
                } else {
                    for (ConnectorInfo matchCandidate : matchSetMap.keySet()) {
                        boolean superset = true;
                        Set matchPropertySet = (Set)matchSetMap.get(matchCandidate);
                        for (Set otherMatchSet : matchSetMap.values()) {
                            if (matchPropertySet == otherMatchSet || matchPropertySet.containsAll(otherMatchSet)) continue;
                            superset = false;
                            break;
                        }
                        if (!superset) continue;
                        matchCandidate.matches = true;
                    }
                    if (!this.existMatchesWithoutError(matchCandidates)) {
                        for (ConnectorInfo matchCandidate : matchSetMap.keySet()) {
                            matchCandidate.matches = true;
                        }
                    }
                }
            }
            List<ConnectorInfo> matches = this.findMatchesWithoutError(matchCandidates);
            Object var3_11 = null;
            if (!matches.isEmpty()) {
                if (matches.size() == 1) {
                    ConnectorInfo connectorInfo = matches.get(0);
                } else {
                    this.errorMessages.add(oracle.dbtools.raptor.newscriptrunner.commands.connect.Messages.getString(Messages.Key.AMBIGUOUS_CONNECT_REQUEST));
                }
            } else {
                List<ConnectorInfo> errorMatches = this.findMatchesWithError(matchCandidates);
                if (errorMatches.size() == 1) {
                    ConnectorInfo matchInfo = errorMatches.get(0);
                    this.errorMessages.addAll(matchInfo.connectorErrorMessages);
                } else {
                    this.errorMessages.add(oracle.dbtools.raptor.newscriptrunner.commands.connect.Messages.getString(Messages.Key.UNRECOGNIZED_CONNECT_REQUEST));
                }
            }
            return var3_13;
        }

        private boolean existMatchesWithoutError(List<ConnectorInfo> matchCandidates) {
            for (ConnectorInfo matchCandidate : matchCandidates) {
                if (!matchCandidate.matches || !matchCandidate.connectorErrorMessages.isEmpty()) continue;
                return true;
            }
            return false;
        }

        private List<ConnectorInfo> findMatchesWithoutError(List<ConnectorInfo> matchCandidates) {
            ArrayList<ConnectorInfo> matches = new ArrayList<ConnectorInfo>();
            for (ConnectorInfo matchCandidate : matchCandidates) {
                if (!matchCandidate.matches || !matchCandidate.connectorErrorMessages.isEmpty()) continue;
                matches.add(matchCandidate);
            }
            return matches;
        }

        private List<ConnectorInfo> findMatchesWithError(List<ConnectorInfo> matchCandidates) {
            ArrayList<ConnectorInfo> matches = new ArrayList<ConnectorInfo>();
            for (ConnectorInfo matchCandidate : matchCandidates) {
                if (!matchCandidate.matches || matchCandidate.connectorErrorMessages.isEmpty()) continue;
                matches.add(matchCandidate);
            }
            return matches;
        }

        private boolean validCommandPropertiesFor(ConnectorType connectorType) {
            List<Property<?>> connectorProperties = connectorType.getProperties();
            for (Property<?> commandProperty : this.commandProperties) {
                if (connectorProperties.contains(commandProperty)) continue;
                return false;
            }
            return true;
        }

        private void parseConnectionSpecFor(final ConnectorInfo connectorInfo) {
            connectorInfo.connectorType.parseConnectionSpec(new ParseConnectionSpecArgs(){

                @Override
                public String getConnectionSpec() {
                    return (String)ConnectCommandProcessor.this.parsedCommand.getParameterValue("CONNECTIONSPEC");
                }

                @Override
                public <T> T getPropertyValue(Property<T> property) {
                    return connectorInfo.connectorPropertyValues.getValueOf(property);
                }

                @Override
                public void setPropertyValue(Property<?> property, Object value) {
                    if (connectorInfo.connectorCommandProperties.contains(property)) {
                        connectorInfo.connectorErrorMessages.add(MessageFormat.format(oracle.dbtools.raptor.newscriptrunner.commands.connect.Messages.getString(Messages.Key.OPTION_OVERRIDE), property.getName()));
                    } else {
                        connectorInfo.connectorPropertyValues.setValueOf(property, value);
                    }
                }

                @Override
                public ScriptRunnerContext getScriptRunnerContext() {
                    return ConnectCommandProcessor.this.ctx;
                }

                @Override
                public ConnectorTypeCache getConnectorTypeCache() {
                    return ConnectCommand.this.cache;
                }

                @Override
                public void addError(String message) {
                    connectorInfo.connectorErrorMessages.add(message);
                }
            });
        }

        private boolean matchByCommandProperties(ConnectorInfo connectorInfo) {
            if (connectorInfo.connectorCommandProperties.isEmpty()) {
                return false;
            }
            List<Property<?>> connectorProperties = connectorInfo.connectorType.getProperties();
            for (Property property : connectorProperties) {
                if (property.matchesNull() || connectorInfo.connectorCommandProperties.contains(property)) continue;
                return false;
            }
            return true;
        }

        private Set<Property<?>> matchByPropertyValues(ConnectorInfo connectorInfo) {
            HashSet result = new HashSet();
            List<Property<?>> connectorProperties = connectorInfo.connectorType.getProperties();
            for (Property property : connectorProperties) {
                if (property.matchesNull()) continue;
                if (connectorInfo.connectorPropertyValues.getValueOf(property) == null) {
                    return null;
                }
                result.add(property);
            }
            return result;
        }

        private Connection processConnect(Connection currentConnection, ConnectorType currentConnectorType, String connectionSpec, PropertyValues connectorProperties, ConnectorType newConnectorType) {
            if (this.parsedCommand.isFlagSet("VERBOSE")) {
                this.ctx.write(connectorProperties.asStringFor(newConnectorType, "\n") + "\n\n");
            }
            EnumMap<ConnectionProperty, String> connectProperties = new EnumMap<ConnectionProperty, String>(ConnectionProperty.class);
            Connector connector = newConnectorType.createConnector(ConnectorArgs.create(connectionSpec, connectorProperties, this.ctx, this.cmd, connectProperties::put));
            Connection newConnection = connector.connect();
            this.initNewConnection(currentConnection, currentConnectorType, newConnection, connectProperties);
            this.postProcessConnection(newConnection);
            this.processLoginScripts(newConnection);
            this.reportConnection(newConnection, connectProperties);
            return newConnection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initNewConnection(Connection currentConnection, ConnectorType currentConnectorType, Connection newConnection, Map<ConnectionProperty, String> connectProperties) {
            if (!this.ctx.getExited()) {
                block27: {
                    if (newConnection != null) {
                        String privilege;
                        if (currentConnection != null && this.ctx.getBaseConnection() != null && currentConnection.equals(this.ctx.getBaseConnection()) && !"".equals(this.ctx.getMap().get(ScriptRunnerContext.SqlplusVariable._CONNECT_IDENTIFIER.toString()))) {
                            this.ctx.putProperty("script.runner.connection.id", this.ctx.doPromptReplaceSqlplusVar(ScriptRunnerContext.SqlplusVariable._CONNECT_IDENTIFIER.toString(), ScriptRunnerContext.SqlplusVariable._CONNECT_IDENTIFIER));
                        }
                        if ((privilege = connectProperties.get((Object)ConnectionProperty.DEF_PRIVILEGE)) != null) {
                            this.ctx.getMap().put(ScriptRunnerContext.SqlplusVariable._PRIVILEGE.toString(), privilege);
                        } else {
                            this.ctx.getMap().put(ScriptRunnerContext.SqlplusVariable._PRIVILEGE.toString(), "NOTSYSDBA");
                        }
                        String connectIdent = connectProperties.get((Object)ConnectionProperty.DEF_CONNECT_IDENTIFIER);
                        if (connectIdent != null && connectIdent.length() > 1 && connectIdent.length() < 81) {
                            this.ctx.getMap().put(ScriptRunnerContext.SqlplusVariable._CONNECT_IDENTIFIER.toString(), connectIdent);
                        } else {
                            this.ctx.getMap().put(ScriptRunnerContext.SqlplusVariable._CONNECT_IDENTIFIER.toString(), "");
                            this.ctx.getMap().put(ScriptRunnerContext.SqlplusVariable._SQL_ID.toString(), "");
                            this.ctx.doPromptReplaceSqlplusVar(newConnection, ScriptRunnerContext.SqlplusVariable._CONNECT_IDENTIFIER.toString(), ScriptRunnerContext.SqlplusVariable._CONNECT_IDENTIFIER);
                        }
                        Boolean getCommit = (Boolean)this.ctx.getProperty("script.runner.autocommit.checkbox");
                        try {
                            if (getCommit == null || getCommit.equals(Boolean.FALSE)) {
                                newConnection.setAutoCommit(false);
                                break block27;
                            }
                            newConnection.setAutoCommit(true);
                        }
                        catch (SQLException e) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                        }
                    } else {
                        Object failed = connectProperties.get((Object)ConnectionProperty.ERROR_MESSAGE);
                        if (failed == null) {
                            failed = "Unable to establish connection";
                        }
                        if (this.ctx.isCommandLine() && (this.ctx.getTopLevel() || this.ctx.isSQLPlusClassic())) {
                            if (!(this.ctx.getSqlError() != 0 || this.ctx.getOsError() != 0 || this.ctx.getProperty("script.runner.sqlplus.nolog") != null && Boolean.valueOf(this.ctx.getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)).booleanValue())) {
                                failed = !((String)failed).equals("") ? (String)failed + "\n" + ScriptRunnerDbArb.getString("NO_LONGER_CONNECTED") : ScriptRunnerDbArb.getString("NO_LONGER_CONNECTED");
                            }
                            SQLPLUSUtil.report(this.ctx, (String)failed);
                        } else {
                            failed = !((String)failed).equals("") ? ScriptRunnerDbArb.getString("CONNECTION_FAILED") + "\n" + (String)failed : ScriptRunnerDbArb.getString("CONNECTION_FAILED");
                            SQLPLUSUtil.report(this.ctx, ScriptRunnerContext.lineErr(SQLPLUSUtil.cleanCommand(this.cmd).getStartLine() + 1, "  connect ...", failed, this.ctx).trim());
                        }
                        SQLPLUSUtil.doWhenever(this.ctx, this.cmd, currentConnection, true);
                        if (currentConnection != null && !SQLPLUSUtil.isConnectionClosed(currentConnection) && LockManager.lock(currentConnection)) {
                            try {
                                if (!(this.ctx.isCommandLine() && this.ctx.getTopLevel() || this.ctx.isSQLPlusClassic())) {
                                    SQLPLUSUtil.report(this.ctx, "Commit");
                                }
                            }
                            finally {
                                LockManager.unlock(currentConnection);
                            }
                        }
                        this.ctx.getMap().put(ScriptRunnerContext.SqlplusVariable._PRIVILEGE.toString(), "");
                        this.ctx.getMap().put(ScriptRunnerContext.SqlplusVariable._CONNECT_IDENTIFIER.toString(), "");
                        this.ctx.getMap().put(ScriptRunnerContext.SqlplusVariable._USER.toString(), "");
                        this.ctx.getMap().put(ScriptRunnerContext.SqlplusVariable._SQL_ID.toString(), "");
                        this.ctx.setCurrentConnection(currentConnection);
                        this.ctx.putProperty("script.runner.sqlplus.nolog", true);
                    }
                }
                this.ctx.putProperty("AUTOTRACE_STATE", false);
                this.ctx.putProperty("AUTOTRACE_TYPE", "NONE");
                if (LockManager.lock(currentConnection)) {
                    try {
                        if (currentConnection != null) {
                            SQLPLUSUtil.commitConnection(currentConnection);
                            this.disposeConnection(currentConnection, currentConnectorType == null ? null : currentConnectorType.createDisconnector(DisconnectorArgs.create(currentConnection, this.ctx, this.cmd)));
                        } else if (this.ctx.getBaseConnection() == null) {
                            this.ctx.setBaseConnection(newConnection);
                        }
                        this.ctx.setCurrentConnection(newConnection);
                    }
                    finally {
                        LockManager.unlock(currentConnection);
                    }
                }
            }
        }

        private void postProcessConnection(Connection newConnection) {
            this.ctx.putProperty("script.runner.PRELIM_AUTH", Boolean.FALSE);
            if (!this.ctx.getExited() && newConnection != null) {
                try {
                    ConnectionDetails cdFinal = new ConnectionDetails(newConnection.getMetaData().getURL());
                    cdFinal.setConn(newConnection);
                    ConnectionStoreBridge connResolver = (ConnectionStoreBridge)this.ctx.getProperty("cli.conn.resolver");
                    connResolver.addConnection(cdFinal);
                    this.ctx.putProperty("cli.conn.name", cdFinal.getUrl());
                    SQLWarning sw = newConnection.getWarnings();
                    if (sw != null) {
                        ScriptUtils.report(this.ctx, oracle.dbtools.raptor.newscriptrunner.commands.connect.Messages.getString(Messages.Key.CONNECTION_WARNINGS));
                    }
                    while (sw != null) {
                        String w = sw.getLocalizedMessage();
                        if (w != null) {
                            ScriptUtils.report(this.ctx, w);
                        }
                        sw = sw.getNextWarning();
                    }
                    newConnection.clearWarnings();
                }
                catch (SQLException e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                }
                this.ctx.putProperty("script.runner.sqlplus.nolog", false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processLoginScripts(Connection newConnection) {
            if (newConnection != null) {
                Boolean oldEcho = this.ctx.isEchoOn();
                try {
                    SQLPLUSUtil.forceEcho(this.ctx, false, false);
                    Boolean resetToDefault = (Boolean)this.ctx.getProperty("script.runner.commandlineconnect");
                    if (resetToDefault != null && resetToDefault.equals(Boolean.TRUE)) {
                        this.ctx.putProperty("script.runner.commandlineconnect", Boolean.FALSE);
                        this.ctx.setSubstitutionOn(true);
                    }
                    this.ctx.putProperty("script.runner.sqlplus.nolog", false);
                    Object glogin = this.ctx.getProperty("DBConfig.GLOGIN");
                    if (glogin != null && ((Boolean)glogin).equals(Boolean.valueOf("true"))) {
                        this.runGLoginSQL(newConnection);
                        this.runUserLoginSQL(newConnection);
                    }
                }
                finally {
                    SQLPLUSUtil.forceEcho(this.ctx, oldEcho, true);
                }
            }
        }

        private void reportConnection(Connection newConnection, Map<ConnectionProperty, String> connectProperties) {
            this.ctx.putProperty("script.runner.PRELIM_AUTH", Boolean.FALSE);
            if (!this.ctx.getExited() && newConnection != null) {
                if (this.ctx.getProperty("script.runner.cmdline.login") != null) {
                    if (this.ctx.getProperty("script.runner.sqlcl.optionx") == null && this.ctx.getProperty("script.runner.sqlplus.silent") == null && (this.ctx.getProperty("script.runner.PRELIM_AUTH") == null || this.ctx.getProperty("script.runner.PRELIM_AUTH").equals(Boolean.FALSE))) {
                        String lastLogin;
                        if (this.ctx.getProperty("sqlcl.last.login.time") == null && (lastLogin = connectProperties.get((Object)ConnectionProperty.LAST_LOGIN_TIME)) != null && !lastLogin.isEmpty()) {
                            ScriptUtils.report(this.ctx, MessageFormat.format("Last Successful login time: {0}\n", lastLogin));
                        }
                        String x = this.ctx.doPromptReplaceSqlplusVar(ScriptRunnerContext.SqlplusVariable._O_VERSION.toString(), ScriptRunnerContext.SqlplusVariable._O_VERSION);
                        ScriptUtils.report(this.ctx, MessageFormat.format(oracle.dbtools.raptor.newscriptrunner.commands.connect.Messages.getString(Messages.Key.CONNECTED_TO), x) + "\n");
                    }
                    this.ctx.getProperties().remove("script.runner.cmdline.login");
                } else if (this.ctx.getProperty("script.runner.PRELIM_AUTH") != null && this.ctx.getProperty("script.runner.PRELIM_AUTH").equals(Boolean.FALSE) && this.ctx.getProperty("script.runner.sqlplus.silent") == null) {
                    ScriptUtils.report(this.ctx, MessageFormat.format("{0}.", ScriptRunnerDbArb.getString("CONNECTED")));
                }
            }
        }

        private void runUserLoginSQL(Connection conn) {
            File f;
            ArrayList<String> logins = ShowLogin.getLocations(this.ctx, "login.sql", true);
            String loginFile = ShowLogin.firstOrNull(logins);
            if (loginFile != null && (f = new File(loginFile)).exists()) {
                this.ctx.putProperty("sqlcli.login.sql", Boolean.TRUE);
                if (FileUtils.isFileOnCWD(f, this.ctx) && !FileUtils.isFileOnSQLPATH(f, this.ctx)) {
                    this.ctx.write(Messages.getString("SQLPLUS.24"));
                    this.ctx.errorLog(this.ctx.getSourceRef(), Messages.getString("SQLPLUS.24"), "");
                }
                this.runLoginSQLFile(f, conn);
                this.ctx.putProperty("sqlcli.login.sql", Boolean.FALSE);
            }
        }

        private void runGLoginSQL(Connection conn) {
            File file;
            String gloginFile = ShowLogin.firstOrNull(ShowLogin.getLocations(this.ctx, "glogin.sql", false));
            if (gloginFile != null && (file = new File(gloginFile)).exists() && file.canRead()) {
                this.ctx.putProperty("sqlcli.glogin.sql", Boolean.TRUE);
                this.runLoginSQLFile(file, conn);
                this.ctx.putProperty("sqlcli.glogin.sql", Boolean.FALSE);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runLoginSQLFile(File file, Connection conn) {
            block23: {
                String directoryRemoved = file.getName();
                String gloginFile = "login.sql";
                try {
                    gloginFile = file.getCanonicalPath();
                }
                catch (IOException ioe) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, ioe.getStackTrace()[0].toString(), ioe);
                }
                if (FileUtils.isFileOnCWD(file, this.ctx) && !FileUtils.isFileOnSQLPATH(file, this.ctx)) {
                    this.ctx.putProperty("LOGIN_FILE_ON_CWD", Boolean.TRUE);
                }
                String prevFile = this.ctx.getSourceRef();
                Integer localDepth = 0;
                try {
                    localDepth = this.ctx.getTopLevel() || this.ctx.getProperty("script.runner.script_depth") == null ? Integer.valueOf(1) : (Integer)this.ctx.getProperty("script.runner.script_depth");
                    int oneOff = 0;
                    String theName = "";
                    String theGLogin = ShowLogin.firstOrNull(ShowLogin.getLocations(this.ctx, "glogin.sql", false));
                    if (theGLogin != null) {
                        int bslash;
                        int slash = theGLogin.lastIndexOf("/");
                        if (slash > (bslash = theGLogin.lastIndexOf("\\"))) {
                            bslash = slash;
                        }
                        theName = bslash != -1 ? theGLogin.substring(bslash + 1) : theGLogin;
                    }
                    if (directoryRemoved != null && directoryRemoved.equals(theName)) {
                        oneOff = 1;
                    }
                    if (localDepth + oneOff < 20) {
                        ArrayList scrArrayList;
                        this.ctx.putProperty("sqlplus.login.file", Boolean.TRUE);
                        this.scriptExecutor = new ScriptExecutor(new FileInputStream(file), conn);
                        this.ctx.putProperty("runner", this.scriptExecutor);
                        this.scriptExecutor.setOut(this.out);
                        boolean localTopLevel = this.ctx.getTopLevel();
                        this.ctx.setTopLevel(false);
                        this.ctx.putProperty("script.runner.script_depth", localDepth + 1);
                        this.scriptExecutor.setScriptRunnerContext(this.ctx);
                        String pathval = file.getCanonicalPath();
                        this.ctx.setSourceRef(pathval);
                        int ii = pathval.lastIndexOf(File.separator);
                        pathval = pathval.substring(0, ii);
                        this.scriptExecutor.setDirectory(pathval);
                        try {
                            scrArrayList = (ArrayList)this.ctx.getProperty("script.runner.appinfo.arraylist");
                            scrArrayList.add(directoryRemoved);
                            this.ctx.putProperty("script.runner.appinfo.arraylist", scrArrayList);
                            if (!scrArrayList.isEmpty()) {
                                SetAppinfo.setAppinfo(this.ctx, this.ctx.getCurrentConnection(), (String)scrArrayList.get(scrArrayList.size() - 1), scrArrayList.size());
                            }
                            this.scriptExecutor.run();
                            break block23;
                        }
                        finally {
                            this.ctx.setTopLevel(localTopLevel);
                            conn = this.scriptExecutor.getScriptRunnerContext().getCurrentConnection();
                            scrArrayList = (ArrayList)this.ctx.getProperty("script.runner.appinfo.arraylist");
                            if (!scrArrayList.isEmpty()) {
                                scrArrayList.remove(scrArrayList.size() - 1);
                            }
                            this.ctx.putProperty("script.runner.appinfo.arraylist", scrArrayList);
                            if (!scrArrayList.isEmpty()) {
                                SetAppinfo.setAppinfo(this.ctx, this.ctx.getCurrentConnection(), (String)scrArrayList.get(scrArrayList.size() - 1), scrArrayList.size());
                            } else {
                                SetAppinfo.setAppinfo(this.ctx, this.ctx.getCurrentConnection(), SQLPLUSUtil.getProductName(), 0);
                            }
                        }
                    }
                    if (this.ctx.getProperty("sqlplus.classic.mode") != null && Boolean.parseBoolean(this.ctx.getProperty("sqlplus.classic.mode").toString())) {
                        SQLPLUSUtil.report(this.ctx, ScriptRunnerDbArb.getString("MAX_NEST_CLASSIC"));
                    } else {
                        SQLPLUSUtil.report(this.ctx, ScriptRunnerContext.lineErr(this.cmd.getStartLine() + 1, this.cmd.getSQLOrig(), ScriptRunnerDbArb.getString("MAX_NEST"), this.ctx));
                    }
                }
                catch (FileNotFoundException e) {
                    SQLPLUSUtil.report(this.ctx, "No " + gloginFile + " found");
                }
                catch (IOException e) {
                    SQLPLUSUtil.report(this.ctx, "No " + gloginFile + " found");
                }
                finally {
                    this.ctx.setSourceRef(prevFile);
                    this.ctx.removeProperty("sqlplus.login.file");
                    this.ctx.putProperty("script.runner.script_depth", localDepth);
                }
            }
        }

        private class ConnectorInfo {
            ConnectorType connectorType;
            PropertyValues connectorPropertyValues;
            Set<Property<?>> connectorCommandProperties;
            List<String> connectorErrorMessages;
            boolean matches;

            ConnectorInfo(ConnectorType connectorType) {
                this.connectorPropertyValues = ConnectCommandProcessor.this.propertyValues.createCopy();
                this.connectorCommandProperties = new HashSet(ConnectCommandProcessor.this.commandProperties);
                this.connectorErrorMessages = new ArrayList<String>();
                this.matches = false;
                this.connectorType = connectorType;
            }
        }
    }
}

