/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import oracle.dbtools.data.loadservice.LoadParmsAPI;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowPrefixNameNewline;

public class SetLoad
extends CommandListener
implements IShowCommand,
IShowPrefixNameNewline {
    public static final Integer METHOD_INSERT = 0;
    public static final Integer METHOD_DBMS_CLOUD = 1;
    private static final String INSERT = "insert";
    private static final String DBMS_CLOUD = "dbms_cloud";
    private static final String DBMSCLOUD = "dbmscloud";
    private static final String BATCH_ROWS = "batch_rows";
    private static final String BATCHROWS = "batchrows";
    private static final String BATCHES_PER_COMMIT = "batches_per_commit";
    private static final String BATCHESPERCOMMIT = "batchespercommit";
    private static final String COMMIT = "commit";
    private static final String DATE_FORMAT = "date_format";
    private static final String DATEFORMAT = "dateformat";
    private static final String DATE = "date";
    private static final String ERRORS = "errors";
    private static final String LOCALE = "locale";
    private static final String MAP_COLUMN_NAMES = "map_column_names";
    private static final String MAPCOLUMNNAMES = "mapcolumnnames";
    private static final String MAPNAMES = "mapnames";
    private static final String RESPONSE_FORMAT = "response_format";
    private static final String RESPONSEFORMAT = "responseformat";
    private static final String RESPONSE_LOCALES = "response_locales";
    private static final String RESPONSELOCALES = "responselocales";
    private static final String UNKNOWN_COLUMNS_FAIL = "unknown_columns_fail";
    private static final String UNKNOWNCOLUMNSFAIL = "unknowncolumnsfail";
    private static final String UNKNOWNFAIL = "unknownfail";
    private static final String BLANK_COLUMNS_NULL = "blank_columns_null";
    private static final String BLANKCOLUMNSNULL = "blankcolumns_null";
    private static final String BLANK_LINES = "blank_lines";
    private static final String BLANKLINES = "blanklines";
    private static final String CHARACTER_SET = "character_set";
    private static final String CHARACTERSET = "characterset";
    private static final String CLEANNAMES = "cleannames";
    private static final String CLEAN_NAMES = "clean_names";
    private static final String COMPRESSION = "compression";
    private static final String CONVERSION_ERRORS = "conversion_errors";
    private static final String CONVERSIONERRORS = "conversionerrors";
    private static final String COPY_BAD = "copy_bad";
    private static final String COPYBAD = "copybad";
    private static final String COPY_LOG = "copy_log";
    private static final String COPYLOG = "copylog";
    private static final String CREDENTIAL = "credential";
    private static final String ESCAPE = "escape";
    private static final String LOCATION = "location";
    private static final String METHOD = "method";
    private static final String MISSING_END_FIELDS = "missing_end_fields";
    private static final String MISSINGENDFIELDS = "missingendfields";
    private static final String NUMERIC_CHARACTERS = "numeric_characters";
    private static final String NUMERICCHARACTERS = "numericcharacters";
    private static final String NUMBER_FORMAT = "number_format";
    private static final String NUMBERFORMAT = "numberformat";
    private static final String TIMESTAMP = "timestamp";
    private static final String TIMESTAMP_FORMAT = "timestamp_format";
    private static final String TIMESTAMPFORMAT = "timestampformat";
    private static final String TIMESTAMPTZ = "timestamptz";
    private static final String TIMESTAMPTZ_FORMAT = "timestamptz_format";
    private static final String TIMESTAMPTZFORMAT = "timestamptzformat";
    private static final String TRIM = "trim";
    private static final String TRIM_SPACES = "trim_spaces";
    private static final String TRIMSPACES = "trimspaces";
    private static final String TRUNCATE = "truncate";
    private static final String TRUNCATE_TABLE = "truncate_table";
    private static final String TRUNCATETABLE = "truncatetable";
    private static final String TRUNCATE_COLUMNS = "truncate_columns";
    private static final String TRUNCATECOLUMNS = "truncatecolumns";
    private static final String COLUMN_SIZE = "column_size";
    private static final String COLUMNSIZE = "columnsize";
    private static final String COLSIZE = "colsize";
    private static final String ACTUAL = "actual";
    private static final String MAX = "max";
    private static final String MAXIMUM = "maximum";
    private static final String SCAN = "scan";
    private static final String SCAN_ROWS = "scan_rows";
    private static final String SCANROWS = "scanrows";
    private static final String ROUND = "round";
    private static final String ROUNDED = "rounded";
    private static final String TRANSFORM = "transform";
    private static final String TRANSFORM128 = "transform128";
    private static final String QUOTE = "quote";
    private static final String QUOTE128 = "quote128";
    private static final String UNIQUE = "unique";
    private static final String CLOSEP = ")";
    private static final String COMMA = ",";
    private static final String DEFAULT = "default";
    private static final String EQ = "=";
    private static final String UDEFAULT = "DEFAULT";
    private static final String DQUOTE = "\"";
    private static final String ON = "on";
    private static final String UON = "ON";
    private static final String OPENP = "(";
    private static final String OFF = "off";
    private static final String UOFF = "OFF";
    private static final String NL = "\n";
    private static final String SPACE = " ";
    private static final String SQUOTE = "'";
    private static final String UNLIMITED = "unlimited";
    private Integer _loadMethod = METHOD_INSERT;
    private LoadParmsAPI.Builder _loadParmsBuilder;
    private boolean _isValid = true;

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getLoweredTrimmedNoWhitespaceSQL().startsWith("setload") && !cmd.getLoweredTrimmedNoWhitespaceSQL().startsWith("setloadformat")) {
            String line;
            String[] parts = cmd.getSQLOrig().split(SPACE);
            if (parts.length < 3) {
                return true;
            }
            if (parts.length == 3 && parts[2].equalsIgnoreCase(DEFAULT)) {
                ctx.write(Messages.getString("LOADCLEARED"));
                ctx.putProperty("load.method.insert", null);
                ctx.putProperty("load.method.dbms_cloud", null);
                ctx.putProperty("load.method", METHOD_INSERT);
                return true;
            }
            if (parts.length == 4 && parts[2].equalsIgnoreCase(INSERT) && parts[3].equalsIgnoreCase(DEFAULT)) {
                ctx.write(Messages.getString("LOADCLEARED"));
                ctx.putProperty("load.method.insert", null);
                ctx.putProperty("load.method", METHOD_INSERT);
                return true;
            }
            this._loadParmsBuilder = (LoadParmsAPI.Builder)ctx.getProperty("load.method.insert");
            if (this._loadParmsBuilder == null) {
                this._loadParmsBuilder = new LoadParmsAPI.Builder(LoadParmsAPI.SERVICE_METHOD.JDBC_BATCH);
                this._loadParmsBuilder.doCommit(true);
                this._loadParmsBuilder.cleanNames(LoadParmsAPI.CLEAN_NAMES.TRANSFORM);
                ctx.putProperty("load.method.insert", this._loadParmsBuilder);
            }
            this._loadMethod = (Integer)ctx.getProperty("load.method");
            if (this._loadMethod == null) {
                this._loadMethod = METHOD_INSERT;
            }
            String[] bits = this.split((line = (String)cmd.getProperty("ORIG_LINE")) != null ? line : cmd.getSQLOrig());
            int skip = 2;
            while (bits != null && bits.length > 0) {
                Object str = "";
                int i = skip;
                String opt = bits[skip].toLowerCase();
                try {
                    switch (bits[skip].toLowerCase()) {
                        case "batch_rows": 
                        case "batchrows": {
                            if (bits.length < skip + 2) {
                                this.writeMethodMissing(ctx, bits[skip]);
                                return true;
                            }
                            if (this.validateOption(ctx, opt)) {
                                try {
                                    this.getBuilder().batchRows(new Integer(bits[skip + 1]));
                                    this.putBuilder(ctx);
                                }
                                catch (Exception e) {
                                    this.writeMethodBad(ctx, bits[skip] + SPACE + bits[skip + 1]);
                                    return true;
                                }
                            }
                            bits = this.nextBits(bits, skip + 2);
                            break;
                        }
                        case "batches_per_commit": 
                        case "batchespercommit": {
                            if (bits.length < skip + 2) {
                                this.writeMethodMissing(ctx, bits[skip]);
                                return true;
                            }
                            if (this.validateOption(ctx, opt)) {
                                try {
                                    int batches = new Integer(bits[skip + 1]);
                                    this.getBuilder().batchesPerCommit(batches);
                                    this.getBuilder().doCommit(batches >= 0);
                                    this.putBuilder(ctx);
                                }
                                catch (Exception e) {
                                    this.writeMethodBad(ctx, bits[skip] + SPACE + bits[skip + 1]);
                                    return true;
                                }
                            }
                            bits = this.nextBits(bits, skip + 2);
                            break;
                        }
                        case "cleannames": 
                        case "clean_names": {
                            if (bits.length < skip + 2) {
                                this.writeMethodMissing(ctx, bits[skip]);
                                return true;
                            }
                            if (this.validateOption(ctx, opt)) {
                                LoadParmsAPI.CLEAN_NAMES cleanNames = null;
                                if (bits[skip + 1].equalsIgnoreCase(TRANSFORM)) {
                                    cleanNames = LoadParmsAPI.CLEAN_NAMES.TRANSFORM;
                                } else if (bits[skip + 1].equalsIgnoreCase(TRANSFORM128)) {
                                    cleanNames = LoadParmsAPI.CLEAN_NAMES.TRANSFORM128;
                                } else if (bits[skip + 1].equalsIgnoreCase(QUOTE)) {
                                    cleanNames = LoadParmsAPI.CLEAN_NAMES.QUOTE;
                                } else if (bits[skip + 1].equalsIgnoreCase(QUOTE128)) {
                                    cleanNames = LoadParmsAPI.CLEAN_NAMES.QUOTE128;
                                } else if (bits[skip + 1].equalsIgnoreCase(UNIQUE)) {
                                    cleanNames = LoadParmsAPI.CLEAN_NAMES.UNIQUE;
                                } else {
                                    this.writeMethodBad(ctx, bits[skip] + SPACE + bits[skip + 1]);
                                    return true;
                                }
                                try {
                                    this.getBuilder().cleanNames(cleanNames);
                                    this.putBuilder(ctx);
                                }
                                catch (Exception e) {
                                    this.writeMethodBad(ctx, bits[skip] + SPACE + bits[skip + 1]);
                                    return true;
                                }
                            }
                            bits = this.nextBits(bits, skip + 2);
                            break;
                        }
                        case "colsize": 
                        case "columnsize": 
                        case "column_size": {
                            if (bits.length < skip + 2) {
                                this.writeMethodMissing(ctx, bits[skip]);
                                return true;
                            }
                            if (this.validateOption(ctx, opt)) {
                                LoadParmsAPI.DDL_COL_SIZE ddlColSize = null;
                                if (bits[skip + 1].equals(ACTUAL)) {
                                    ddlColSize = LoadParmsAPI.DDL_COL_SIZE.ACTUAL;
                                } else if (bits[skip + 1].equals(ROUNDED) || bits[skip + 1].equals(ROUND)) {
                                    ddlColSize = LoadParmsAPI.DDL_COL_SIZE.ROUNDED;
                                } else if (bits[skip + 1].equals(MAX) || bits[skip + 1].equals(MAXIMUM)) {
                                    ddlColSize = LoadParmsAPI.DDL_COL_SIZE.MAX;
                                } else {
                                    this.writeMethodBad(ctx, bits[skip] + SPACE + bits[skip + 1]);
                                    return true;
                                }
                                try {
                                    this.getBuilder().ddlColSize(ddlColSize);
                                    this.putBuilder(ctx);
                                }
                                catch (Exception e) {
                                    this.writeMethodBad(ctx, bits[skip] + SPACE + bits[skip + 1]);
                                    return true;
                                }
                            }
                            bits = this.nextBits(bits, skip + 2);
                            break;
                        }
                        case "commit": {
                            if (bits.length < skip + 2) {
                                this.writeMethodMissing(ctx, bits[skip]);
                                return true;
                            }
                            if (!bits[skip + 1].equalsIgnoreCase(ON) && !bits[skip + 1].equalsIgnoreCase(OFF)) {
                                this.writeMethodBad(ctx, bits[skip] + SPACE + bits[skip + 1]);
                                return true;
                            }
                            if (this.validateOption(ctx, opt)) {
                                this.getBuilder().doCommit(bits[skip + 1].equalsIgnoreCase(ON));
                                this.putBuilder(ctx);
                            }
                            bits = this.nextBits(bits, skip + 2);
                            break;
                        }
                        case "errors": {
                            if (bits.length < skip + 2) {
                                this.writeMethodMissing(ctx, bits[skip]);
                                return true;
                            }
                            if (this.validateOption(ctx, opt)) {
                                try {
                                    if (bits[skip + 1].equalsIgnoreCase(UNLIMITED)) {
                                        this.getBuilder().errors(-1);
                                    } else {
                                        this.getBuilder().errors(new Integer(bits[skip + 1]));
                                    }
                                    this.putBuilder(ctx);
                                }
                                catch (Exception e) {
                                    this.writeMethodBad(ctx, bits[skip] + SPACE + bits[skip + 1]);
                                    return true;
                                }
                            }
                            bits = this.nextBits(bits, skip + 2);
                            break;
                        }
                        case "date_format": 
                        case "dateformat": 
                        case "date": {
                            if (bits.length < skip + 2 || bits[i + 1].equalsIgnoreCase(DEFAULT)) {
                                this.getBuilder().dateFormat("");
                                this.putBuilder(ctx);
                                return true;
                            }
                            ++i;
                            String space = "";
                            while (i < bits.length && !this.isOption(bits[i])) {
                                str = (String)str + space + bits[i];
                                space = SPACE;
                                ++i;
                            }
                            if (((String)str).isEmpty()) {
                                this.writeMethodMissing(ctx, bits[0]);
                                return true;
                            }
                            if (this.validateOption(ctx, opt)) {
                                this.getBuilder().dateFormat(this.unQuote((String)str));
                                this.putBuilder(ctx);
                            }
                            bits = this.nextBits(bits, i);
                            break;
                        }
                        case "locale": {
                            Locale locale = null;
                            if (bits.length < skip + 2) {
                                locale = null;
                                bits = this.nextBits(bits, skip + 2);
                            } else if (bits.length == skip + 3) {
                                locale = new Locale(bits[skip + 1], bits[skip + 2]);
                                bits = this.nextBits(bits, skip + 3);
                            } else if (bits[skip + 1].equals("\"\"") || bits[skip + 1].equals(DEFAULT)) {
                                locale = null;
                                bits = this.nextBits(bits, skip + 2);
                            } else {
                                locale = new Locale(bits[skip + 1]);
                                bits = this.nextBits(bits, skip + 2);
                            }
                            if (this.validateOption(ctx, opt)) {
                                this.getBuilder().locale(locale);
                                this.putBuilder(ctx);
                            }
                            break;
                        }
                        case "map_column_names": 
                        case "mapnames": 
                        case "mapcolumnnames": {
                            HashMap<String, String> aliasMap = null;
                            if (bits.length == skip + 2 && bits[skip + 1].equalsIgnoreCase(OFF)) {
                                skip += 2;
                            } else {
                                if (bits.length < skip + 3) {
                                    ctx.write(Messages.getString("LOAD_MAP_ERR") + NL);
                                    return true;
                                }
                                if (!bits[skip + 1].equalsIgnoreCase(OPENP)) {
                                    ctx.write(Messages.getString("LOAD_MAP_ERR") + NL);
                                    return true;
                                }
                                skip += 2;
                                aliasMap = new HashMap<String, String>();
                                while (bits.length > skip + 1 && !bits[skip].equals(CLOSEP)) {
                                    if (bits.length < skip + 4) {
                                        ctx.write(Messages.getString("LOAD_MAP_ERR") + NL);
                                        return true;
                                    }
                                    if (!bits[skip + 1].equals(EQ)) {
                                        ctx.write(Messages.getString("LOAD_MAP_ERR") + NL);
                                        return true;
                                    }
                                    aliasMap.put(bits[skip], bits[skip + 2]);
                                    if (bits[skip + 3].equals(COMMA)) {
                                        ++skip;
                                    }
                                    skip += 3;
                                }
                                if (!bits[skip].equals(CLOSEP)) {
                                    this.writeMethodBad(ctx, bits[skip] + SPACE + bits[skip + 1]);
                                    return true;
                                }
                                ++skip;
                            }
                            this.getBuilder().mapColumnNames(aliasMap);
                            this.putBuilder(ctx);
                            bits = this.nextBits(bits, skip);
                            break;
                        }
                        case "method": {
                            if (bits.length < skip + 2) {
                                this.writeMethodMissing(ctx, bits[skip]);
                                return true;
                            }
                            if (!bits[skip + 1].equalsIgnoreCase(INSERT)) {
                                this.writeMethodBad(ctx, bits[skip] + SPACE + bits[skip + 1]);
                                return true;
                            }
                            ctx.putProperty("load.method.insert", this._loadParmsBuilder);
                            this._loadMethod = METHOD_INSERT;
                            ctx.putProperty("load.method", METHOD_INSERT);
                            bits = this.nextBits(bits, skip + 2);
                            break;
                        }
                        case "scan": 
                        case "scan_rows": 
                        case "scanrows": {
                            if (bits.length < skip + 2) {
                                this.writeMethodMissing(ctx, bits[skip]);
                                return true;
                            }
                            if (this.validateOption(ctx, opt)) {
                                try {
                                    Integer scanRows = new Integer(bits[skip + 1]);
                                    if (scanRows > 5000) {
                                        ctx.write(MessageFormat.format(Messages.getString("SCAN_ROWS_ERR"), scanRows.toString()) + NL);
                                        scanRows = 5000;
                                    }
                                    this.getBuilder().scanRows(scanRows);
                                    this.putBuilder(ctx);
                                }
                                catch (Exception e) {
                                    this.writeMethodBad(ctx, bits[skip] + SPACE + bits[skip + 1]);
                                    return true;
                                }
                            }
                            bits = this.nextBits(bits, skip + 2);
                            break;
                        }
                        case "response_format": 
                        case "responseformat": {
                            break;
                        }
                        case "response_locales": 
                        case "responselocales": {
                            break;
                        }
                        case "timestamp": 
                        case "timestamp_format": 
                        case "timestampformat": {
                            if (bits.length < skip + 2 || bits[i + 1].equalsIgnoreCase(DEFAULT)) {
                                this.getBuilder().timestampFormat("");
                                this.putBuilder(ctx);
                                return true;
                            }
                            ++i;
                            String space = "";
                            while (i < bits.length && !this.isOption(bits[i])) {
                                str = (String)str + space + bits[i];
                                space = SPACE;
                                ++i;
                            }
                            if (((String)str).isEmpty()) {
                                this.writeMethodMissing(ctx, bits[0]);
                                return true;
                            }
                            if (this.validateOption(ctx, opt)) {
                                this.getBuilder().timestampFormat(this.unQuote((String)str));
                                this.putBuilder(ctx);
                            }
                            bits = this.nextBits(bits, i);
                            break;
                        }
                        case "timestamptz": 
                        case "timestamptz_format": 
                        case "timestamptzformat": {
                            if (bits.length < skip + 2 || bits[i + 1].equalsIgnoreCase(DEFAULT)) {
                                this.getBuilder().timestampTZFormat("");
                                this.putBuilder(ctx);
                                return true;
                            }
                            ++i;
                            String space = "";
                            while (i < bits.length && !this.isOption(bits[i])) {
                                str = (String)str + space + bits[i];
                                space = SPACE;
                                ++i;
                            }
                            if (((String)str).isEmpty()) {
                                this.writeMethodMissing(ctx, bits[0]);
                                return true;
                            }
                            if (this.validateOption(ctx, opt)) {
                                this.getBuilder().timestampTZFormat(this.unQuote((String)str));
                                this.putBuilder(ctx);
                            }
                            bits = this.nextBits(bits, i);
                            break;
                        }
                        case "truncate": 
                        case "truncate_table": 
                        case "truncatetable": {
                            if (bits.length < skip + 2) {
                                this.writeMethodMissing(ctx, bits[skip]);
                                return true;
                            }
                            if (!bits[skip + 1].equalsIgnoreCase(ON) && !bits[skip + 1].equalsIgnoreCase(OFF)) {
                                this.writeMethodBad(ctx, bits[skip] + SPACE + bits[skip + 1]);
                                return true;
                            }
                            this.getBuilder().deleteRows(bits[skip + 1].equalsIgnoreCase(ON) ? LoadParmsAPI.DELETE_ROWS.TRUE : LoadParmsAPI.DELETE_ROWS.FALSE);
                            this.putBuilder(ctx);
                            bits = this.nextBits(bits, skip + 2);
                            break;
                        }
                        case "unknown_columns_fail": 
                        case "unknowncolumnsfail": 
                        case "unknownfail": {
                            if (bits.length < skip + 2) {
                                this.writeMethodMissing(ctx, bits[skip]);
                                return true;
                            }
                            if (!bits[skip + 1].equalsIgnoreCase(ON) && !bits[skip + 1].equalsIgnoreCase(OFF)) {
                                this.writeMethodBad(ctx, bits[skip] + SPACE + bits[skip + 1]);
                                return true;
                            }
                            if (this.validateOption(ctx, opt)) {
                                this.getBuilder().unknownColumnsFail(bits[skip + 1].equalsIgnoreCase(ON));
                                this.putBuilder(ctx);
                            }
                            bits = this.nextBits(bits, skip + 2);
                            break;
                        }
                        default: {
                            ctx.write(MessageFormat.format(Messages.getString("LOADOPTIONINVALID"), bits[skip].toLowerCase()) + NL);
                            return true;
                        }
                    }
                }
                catch (Exception e) {
                    this.writeMethodBad(ctx, bits.length > skip ? bits[skip] : "");
                    return true;
                }
                skip = 0;
            }
            return true;
        }
        return false;
    }

    private LoadParmsAPI.Builder getBuilder() {
        return this._loadParmsBuilder;
    }

    private void putBuilder(ScriptRunnerContext ctx) {
        ctx.putProperty("load.method.insert", this._loadParmsBuilder);
    }

    private String[] split(String cmd) {
        if (!(cmd.contains(SQUOTE) || cmd.contains(DQUOTE) || cmd.contains(OPENP) || cmd.contains(CLOSEP))) {
            return cmd.split("\\s+");
        }
        String c = null;
        Object word = "";
        ArrayList<Object> words = new ArrayList<Object>();
        for (int i = 0; i < cmd.length(); ++i) {
            int end;
            word = "";
            c = cmd.substring(i, i + 1);
            if (c.equals(DQUOTE) && i + 1 < cmd.length()) {
                end = cmd.indexOf(DQUOTE, i + 1);
                if (end != -1) {
                    words.add(cmd.substring(i, end + 1));
                    i = end + 1;
                    continue;
                }
                word = (String)word + c;
                while (++i < cmd.length() && !cmd.substring(i, i + 1).equals(SPACE)) {
                    word = (String)word + cmd.substring(i, i + 1);
                }
                words.add(word);
                continue;
            }
            if (c.equals(SQUOTE) && i + 1 < cmd.length()) {
                end = cmd.indexOf(SQUOTE, i + 1);
                if (end != -1) {
                    words.add(cmd.substring(i, end + 1));
                    i = end + 1;
                    continue;
                }
                word = (String)word + c;
                while (++i < cmd.length() && !cmd.substring(i, i + 1).equals(SPACE)) {
                    word = (String)word + cmd.substring(i, i + 1);
                }
                words.add(word);
                continue;
            }
            if (c.equals(COMMA) | c.equals(OPENP) || c.equals(CLOSEP) || c.equals(EQ)) {
                word = (String)word + c;
                words.add(word);
                continue;
            }
            if (c.equals(SPACE)) continue;
            word = (String)word + c;
            while (++i < cmd.length() && !cmd.substring(i, i + 1).equals(SPACE)) {
                if (cmd.substring(i, i + 1).equals(COMMA) || cmd.substring(i, i + 1).equals(CLOSEP) || cmd.substring(i, i + 1).equals(EQ)) {
                    --i;
                    break;
                }
                word = (String)word + cmd.substring(i, i + 1);
            }
            words.add(word);
        }
        return words.toArray(new String[words.size()]);
    }

    private void writeMethodMissing(ScriptRunnerContext ctx, String option) {
        ctx.write(MessageFormat.format(Messages.getString("LOADMISSINGVALUE"), option) + NL);
    }

    private void writeMethodBad(ScriptRunnerContext ctx, String option) {
        ctx.write(MessageFormat.format(Messages.getString("LOADBADVALUE"), option) + NL);
    }

    private boolean validateOption(ScriptRunnerContext ctx, String word) {
        if (this.isAnyOption(word, true)) {
            return true;
        }
        ctx.write(MessageFormat.format(Messages.getString("LOADBADOPTION"), word, this.getMethodName()) + NL);
        this._isValid = false;
        return false;
    }

    private boolean isOption(String word) {
        return this.isAnyOption(word, false);
    }

    private boolean isAnyOption(String word, boolean isLoadMethodOption) {
        if (!isLoadMethodOption || this._loadMethod == METHOD_INSERT) {
            try {
                switch (word) {
                    case "insert": 
                    case "batch_rows": 
                    case "batchrows": 
                    case "batches_per_commit": 
                    case "batchespercommit": 
                    case "cleannames": 
                    case "clean_names": 
                    case "colsize": 
                    case "columnsize": 
                    case "column_size": 
                    case "commit": 
                    case "errors": 
                    case "locale": 
                    case "map_column_names": 
                    case "mapcolumnnames": 
                    case "mapnames": 
                    case "response_format": 
                    case "responseformat": 
                    case "response_locales": 
                    case "responselocales": 
                    case "date": 
                    case "date_format": 
                    case "dateformat": 
                    case "scan": 
                    case "scan_rows": 
                    case "scanrows": 
                    case "timestamp": 
                    case "timestamp_format": 
                    case "timestampformat": 
                    case "timestamptz": 
                    case "timestamptz_format": 
                    case "timestamptzformat": 
                    case "truncate": 
                    case "unknown_columns_fail": 
                    case "unknowncolumnsfail": 
                    case "unknownfail": {
                        return true;
                    }
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        if (!isLoadMethodOption || this._loadMethod == METHOD_DBMS_CLOUD) {
            try {
                switch (word) {
                    case "blank_columns_null": 
                    case "blankcolumns_null": 
                    case "blank_lines": 
                    case "blanklines": 
                    case "character_set": 
                    case "characterset": 
                    case "colsize": 
                    case "columnsize": 
                    case "column_size": 
                    case "compression": 
                    case "conversion_errors": 
                    case "conversionerrors": 
                    case "copy_bad": 
                    case "copybad": 
                    case "copy_log": 
                    case "copylog": 
                    case "credential": 
                    case "dbms_cloud": 
                    case "dbmscloud": 
                    case "escape": 
                    case "date": 
                    case "date_format": 
                    case "dateformat": 
                    case "timestamp": 
                    case "timestamp_format": 
                    case "timestampformat": 
                    case "timestamptz": 
                    case "timestamptz_format": 
                    case "timestamptzformat": 
                    case "errors": 
                    case "locale": 
                    case "location": 
                    case "map_column_names": 
                    case "mapcolumnnames": 
                    case "mapnames": 
                    case "missing_end_fields": 
                    case "missingendfields": 
                    case "numeric_characters": 
                    case "numericcharacters": 
                    case "number_format": 
                    case "numberformat": 
                    case "response_format": 
                    case "responseformat": 
                    case "response_locales": 
                    case "responselocales": 
                    case "scan": 
                    case "scan_rows": 
                    case "scanrows": 
                    case "trim_spaces": 
                    case "trimspaces": 
                    case "truncate": 
                    case "truncate_columns": 
                    case "truncatecolumns": 
                    case "unknown_columns_fail": 
                    case "unknowncolumnsfail": 
                    case "unknownfail": {
                        return true;
                    }
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    private String getMethodName() {
        return this._loadMethod == METHOD_INSERT ? INSERT : DBMS_CLOUD;
    }

    private boolean isMethodName(String word) {
        return word == INSERT || word == DBMS_CLOUD;
    }

    private String unQuote(String word) {
        if (word.startsWith(SQUOTE) && word.endsWith(SQUOTE)) {
            return word.substring(1, word.length() - 1);
        }
        if (word.startsWith(DQUOTE) && word.endsWith(DQUOTE)) {
            return word.substring(1, word.length() - 1);
        }
        return word;
    }

    private String[] nextBits(String[] bits, int skip) {
        if (bits.length > skip) {
            String[] rtn = new String[bits.length - skip];
            for (int j = 0; rtn.length > j; ++j) {
                rtn[j] = bits[j + skip];
            }
            return rtn;
        }
        return null;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String theLower;
        boolean fired = false;
        if (cmd.getLoweredTrimmedNoWhitespaceSQL().startsWith("show") && (theLower = cmd.getSql().trim().toLowerCase().replaceAll(SPACE, "")).startsWith("showload") && !theLower.startsWith("showloadformat")) {
            fired = true;
        }
        if (fired) {
            this._loadMethod = METHOD_INSERT;
            if (ctx.getProperties().containsKey("load.method") && ctx.getProperties().get("load.method") != null) {
                this._loadMethod = (Integer)ctx.getProperty("load.method");
                if (this._loadMethod == null) {
                    this._loadMethod = METHOD_INSERT;
                }
            }
            LoadParmsAPI.Builder loadParmsBuilder = null;
            if (ctx.getProperties().containsKey("load.method.insert") && ctx.getProperties().get("load.method.insert") != null) {
                loadParmsBuilder = (LoadParmsAPI.Builder)ctx.getProperty("load.method.insert");
            } else {
                loadParmsBuilder = new LoadParmsAPI.Builder(LoadParmsAPI.SERVICE_METHOD.JDBC_BATCH);
                loadParmsBuilder.doCommit(true);
                loadParmsBuilder.cleanNames(LoadParmsAPI.CLEAN_NAMES.TRANSFORM);
                ctx.putProperty("load.method.insert", this._loadParmsBuilder);
            }
            LoadParmsAPI loadParms = loadParmsBuilder.build();
            SetLoad.showParms(ctx, loadParms);
            return true;
        }
        return false;
    }

    public static void showParms(ScriptRunnerContext ctx) {
        SetLoad.showParms(ctx, SetLoad.getParmsAPI(ctx), "");
    }

    public static void showParms(ScriptRunnerContext ctx, LoadParmsAPI loadParms) {
        SetLoad.showParms(ctx, loadParms, "");
    }

    public static void showParms(ScriptRunnerContext ctx, LoadParmsAPI loadParms, String cmdPrefix) {
        ctx.write(SetLoad.getParms(ctx, loadParms, cmdPrefix));
        ctx.write("");
    }

    public static String getParmsAsSet(ScriptRunnerContext ctx) {
        return SetLoad.getParms(ctx, SetLoad.getParmsAPI(ctx), "set load ");
    }

    public static String getParms(ScriptRunnerContext ctx, LoadParmsAPI loadParms, String cmdPrefix) {
        boolean isPretty = cmdPrefix == null && !cmdPrefix.isEmpty();
        Object method = isPretty ? NL : "";
        method = (String)method + cmdPrefix + "batch_rows " + new Integer(loadParms.getBatchRows()).toString() + NL;
        method = (String)method + cmdPrefix + "batches_per_commit " + new Integer(loadParms.getBatchesPerCommit()).toString() + NL;
        method = (String)method + cmdPrefix + "clean_names " + loadParms.getCleanNames().toString().toLowerCase() + NL;
        method = (String)method + cmdPrefix + "column_size " + loadParms.getDdlColSize().toString().toLowerCase() + NL;
        method = (String)method + cmdPrefix + "commit " + (loadParms.isDoCommit() ? ON : OFF) + NL;
        method = (String)method + cmdPrefix + "date_format " + loadParms.getDataFormat() + NL;
        method = (String)method + cmdPrefix + "errors " + (loadParms.getErrorsLimit() == -1 ? UNLIMITED : new Integer(loadParms.getErrorsLimit()).toString()) + NL;
        if (loadParms.getAliasToColumnMap() == null) {
            method = (String)method + cmdPrefix + "map_column_names off\n";
        } else {
            String aliases = loadParms.getAliasToColumnMap().toString();
            method = (String)method + cmdPrefix + "map_column_names (" + aliases.substring(1, aliases.length() - 1) + ")\n";
        }
        method = (String)method + cmdPrefix + "method insert\n";
        method = (String)method + cmdPrefix + "timestamp_format " + loadParms.getTimestampFormat() + NL;
        method = (String)method + cmdPrefix + "timestamptz_format " + loadParms.getTimestampTZFormat() + NL;
        if (loadParms.getLocale() != null) {
            Locale locale = loadParms.getLocale();
            method = (String)method + cmdPrefix + "locale " + locale.getDisplayLanguage() + SPACE + locale.getDisplayCountry() + NL;
        } else {
            method = (String)method + cmdPrefix + "locale\n";
        }
        method = (String)method + cmdPrefix + "scan_rows " + new Integer(loadParms.getScanRows()).toString() + NL;
        method = (String)method + cmdPrefix + "truncate " + (loadParms.getDeleteRows() == LoadParmsAPI.DELETE_ROWS.TRUE ? ON : OFF) + NL;
        method = (String)method + cmdPrefix + "unknown_columns_fail " + (loadParms.isUnknownColumnsFail() ? ON : OFF) + NL;
        return method;
    }

    public static LoadParmsAPI getParmsAPI(ScriptRunnerContext ctx) {
        LoadParmsAPI.Builder loadParmsBuilder = (LoadParmsAPI.Builder)ctx.getProperty("load.method.insert");
        if (loadParmsBuilder == null) {
            loadParmsBuilder = new LoadParmsAPI.Builder(LoadParmsAPI.SERVICE_METHOD.JDBC_BATCH);
            loadParmsBuilder.doCommit(true);
            ctx.putProperty("load.method.insert", loadParmsBuilder);
            loadParmsBuilder.cleanNames(LoadParmsAPI.CLEAN_NAMES.TRANSFORM);
        }
        LoadParmsAPI loadParms = loadParmsBuilder.build();
        return loadParms;
    }

    @Override
    public String[] getShowAliases() {
        return new String[]{"load"};
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }
}

