/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class ResetPasswordHelper {
    public Connection resetAndReconnect(ScriptRunnerContext ctx, String username, String urlOrig, Properties props, String newPassword, Throwable firstError) throws Throwable {
        return this.resetAndReconnect(ctx, username, urlOrig, props, newPassword, firstError, DriverManager::getConnection);
    }

    public Connection resetAndReconnect(ScriptRunnerContext ctx, String username, String urlOrig, Properties props, String newPassword, Throwable firstError, ConnectionCreator creator) throws Throwable {
        Connection conn;
        boolean reset_ok = false;
        Properties localProps = new Properties();
        localProps.putAll((Map<?, ?>)props);
        SQLException toReport = null;
        localProps.setProperty("oracle.jdbc.newPassword", newPassword);
        try {
            conn = creator.createConnection(urlOrig, localProps);
            try {
                reset_ok = true;
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (SQLException e) {
            toReport = e;
        }
        conn = null;
        if (reset_ok) {
            Properties testProps = new Properties();
            testProps.putAll((Map<?, ?>)props);
            testProps.remove("oracle.jdbc.newPassword");
            testProps.setProperty("password", newPassword);
            if (ctx != null) {
                ctx.putProperty("cli.conn.url", urlOrig);
                ctx.putProperty("cli.conn.props", testProps);
            }
            try {
                conn = creator.createConnection(urlOrig, testProps);
            }
            catch (SQLException ex) {
                toReport = ex;
            }
        }
        if (conn != null && !conn.isClosed()) {
            return conn;
        }
        if (toReport != null) {
            throw toReport;
        }
        throw firstError;
    }

    public static interface ConnectionCreator {
        public Connection createConnection(String var1, Properties var2) throws SQLException;
    }
}

