/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.IOException;
import java.sql.Clob;
import oracle.dbtools.raptor.format.Messages;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.utils.DataTypesUtil;

public class TxtFormatter
extends ResultsFormatter {
    public static final String TYPE = "TEXT";
    public static final String EXT = "tsv";
    public static final String DEFAULT_DELIMITER = "\t";
    public static final String KEY_HEADER = "EXPORT_TXT_HEADER";
    public static final String KEY_DELIMITER = "EXPORT_TXT_DELIMITER";
    public static final String KEY_REC_TERM = "EXPORT_TXT_REC_TERM";
    public static final String KEY_ENCLOSURES = "EXPORT_TXT_ENCLOSURES";
    public static final String KEY_ENCL_LEFT = "EXPORT_TXT_ENCL_LEFT";
    public static final String KEY_ENCL_RIGHT = "EXPORT_TXT_ENCL_RIGHT";
    public static final String KEY_ENCL_RIGHT_DOUBLE = "EXPORT_TXT_ENCL_RIGHT_DOUBLE";
    private boolean _isHeader;

    public TxtFormatter() {
        super(TYPE, Messages.getString("TxtFormatter.0"), EXT);
    }

    @Override
    public void start() throws IOException {
        if (this.isHeader()) {
            int size = this.getColumnCount();
            for (int i = 0; i < size; ++i) {
                String name = this.getColumnName(i);
                if (i < size - 1) {
                    this.write(this.getEnclosureLeft() + name + this.getEnclosureRight() + this.getDelimiter());
                    continue;
                }
                this.write(this.getEnclosureLeft() + name + this.getEnclosureRight());
            }
            this.write(this.getLineTerminator());
        }
    }

    @Override
    public void startRow() throws IOException {
    }

    @Override
    public void printColumn(Object col, int viewIndex, int modelIndex) throws IOException {
        Object colm = "";
        String lEncl = null;
        String rEncl = null;
        int type = this.getDataType(viewIndex);
        if (type == 1 || type == -16 || type == -1 || type == -15 || type == -9 || type == 12 || type == 2005) {
            lEncl = this.getEnclosureLeft();
            rEncl = this.getEnclosureRight();
        } else {
            lEncl = "";
            rEncl = "";
        }
        if (col != null && viewIndex == 0) {
            colm = lEncl + this.cleanString(this.getValueClobCheck(col)) + rEncl;
        } else if (col == null && viewIndex == 0) {
            colm = lEncl + rEncl;
        } else if (col != null && viewIndex > 0) {
            colm = this.getDelimiter() + lEncl + this.cleanString(this.getValueClobCheck(col)) + rEncl;
        } else if (col == null && viewIndex > 0) {
            colm = this.getDelimiter() + lEncl + rEncl;
        }
        this.write((String)colm);
    }

    String getValueClobCheck(Object obj) {
        String val = null;
        if (obj instanceof Clob) {
            Integer size = null;
            if (this.getScriptContext() != null) {
                size = (Integer)this.getScriptContext().getProperty("script.runner.setlong");
            }
            val = size != null ? DataTypesUtil.stringValue(obj, this.getConnection(), size) : DataTypesUtil.stringValue(obj, this.getConnection());
        } else {
            val = this.getValue(obj).toString();
        }
        return val;
    }

    @Override
    public void endRow() throws IOException {
        this.write(this.getLineTerminator());
    }

    @Override
    public void end() throws IOException {
    }

    @Override
    public void setTableName(String tName) {
    }

    @Override
    public boolean allowsLobs() {
        return true;
    }

    @Override
    public boolean isHeaderOptionSupported() {
        return true;
    }

    @Override
    public void isHeader(boolean isHeader) {
        this._isHeader = isHeader;
    }

    @Override
    public boolean isHeader() {
        return this._isHeader;
    }

    @Override
    public boolean isLineTerminatorSupported() {
        return true;
    }

    @Override
    public boolean isDelimiterSupported() {
        return true;
    }

    @Override
    public boolean isDelimiterConfigurable() {
        return false;
    }

    @Override
    public String getDefaultDelimiter() {
        return DEFAULT_DELIMITER;
    }

    @Override
    public boolean isEnclosuresSupported() {
        return true;
    }

    @Override
    public String getHeaderConfigKey() {
        return KEY_HEADER;
    }

    @Override
    public String getLineTerminatorConfigKey() {
        return KEY_REC_TERM;
    }

    @Override
    public String getDelimiterConfigKey() {
        return KEY_DELIMITER;
    }

    @Override
    public String getEnclosuresConfigKey() {
        return KEY_ENCLOSURES;
    }

    @Override
    public String getEnclosureLeftConfigKey() {
        return KEY_ENCL_LEFT;
    }

    @Override
    public String getEnclosureRightConfigKey() {
        return KEY_ENCL_RIGHT;
    }

    @Override
    public String getEnclosureRightDoubleConfigKey() {
        return KEY_ENCL_RIGHT_DOUBLE;
    }

    @Override
    public Boolean isCandidateForSpoolMax() {
        return true;
    }
}

