/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.deployment;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.deployment.DbmsCloudQuery;
import oracle.dbtools.raptor.deployment.DbmsCloudResources;
import oracle.dbtools.raptor.utils.ToolLogger;
import oracle.dbtools.util.Logger;

public class DbmsCloudAPI {
    private static final String CLOSEP = ")";
    private static final String COMMA = ",";
    private static final String COPY_DATA = "copy_data";
    private static final String CREDENTIAL_NAME = "credential_name => ";
    private static final String DBMS_CLOUD_OWNER = "C##CLOUD$SERVICE";
    private static final String DBMS_CLOUD = "dbms_cloud";
    private static final String DOT = ".";
    private static final String EXT_TAB = "create_external_table";
    private static final String FILE_URI_LIST = "file_uri_list => ";
    private static final String NL = "\n";
    private static final String OPENP = "(";
    private static final String SINGLEQ = "'";
    private static final String SPACE = " ";
    private static final String TABLE_NAME = "table_name => ";
    Connection _conn;
    String _connName;
    String _connUser;
    String _schema;
    boolean _isConnLocked = false;
    boolean _isClone = false;
    ExitCode _exitCode;
    ToolLogger _tLogger;
    BigDecimal _operationId;
    String _spacing = "\n";
    public static String COPY_DATA_PREFIX = "C##CLOUD$SERVICE.dbms_cloud.copy_data(\n";
    public static String COPY_DATA_PROC1 = "declare  PROCEDURE copy_data (operation_id OUT NOCOPY NUMBER, err_msg OUT NOCOPY VARCHAR2) IS  BEGIN \n";
    public static String COPY_DATA_PROC2 = "; \nEXCEPTION WHEN OTHERS THEN    FOR err_depth IN 1..UTL_CALL_STACK.ERROR_DEPTH LOOP       err_msg := err_msg || UTL_CALL_STACK.ERROR_MSG (err_depth) || ' ';    END LOOP; end; BEGIN \n   copy_data(OPERATION_ID => ?, ERR_MSG => ?);\nend; \n";
    public static String EXT_TABLE_PREFIX = "C##CLOUD$SERVICE.dbms_cloud.create_external_table(\n";
    public static final String dbms_cloudCreateExternalTablePrefix = "{call ";
    public static final String dbms_cloudCreateExternalTableSuffix = " }";
    private static String VALIDATE_EXTERNAL_TABLE = "declare  PROCEDURE validate_external_table (table_name IN VARCHAR2,operation_id OUT NOCOPY NUMBER,err_msg OUT NOCOPY VARCHAR2, schema_name IN VARCHAR2, row_count IN NUMBER) IS  BEGIN    DBMS_CLOUD.validate_external_table(    table_name      => table_name,    operation_id\t=> operation_id,    schema_name\t    => schema_name,    rowCount\t    => row_count,    STOP_ON_ERROR \t=> false); EXCEPTION WHEN OTHERS THEN    FOR err_depth IN 1..UTL_CALL_STACK.ERROR_DEPTH LOOP       err_msg := err_msg || UTL_CALL_STACK.ERROR_MSG (err_depth) || ' ';    END LOOP; end; BEGIN    validate_external_table(TABLE_NAME => ?, OPERATION_ID => ?, ERR_MSG => ?, SCHEMA_NAME => ?, ROW_COUNT => ?); end; ";
    public static final String dbms_cloudGetValidateLog = "select record from ";
    public static final String dbms_cloudGetValidateBadCount = "select count(*) from ";
    public static final String dbms_cloudGetValidateBad = "select record from ";
    public static final String dbms_cloudGetCloudTabCount1 = "select count(*) from ";
    public static final String dbms_cloudGetCloudTabCount2 = " where rownum = ";
    public static final String dbms_cloudGetXTabRows1 = "select count(*) from ";
    public static final String dbms_cloudGetXTabRows2 = " where rownum = 1";
    private static String temp = "sqldev_temp";
    public static final String dbms_cloudPutObjectBlob = "{call C##CLOUD$SERVICE.DBMS_CLOUD.PUT_OBJECT(CREDENTIAL_NAME => ?, OBJECT_URI => ?,CONTENTS => ?,COMPRESSION => ?)}";
    public static final String dbms_cloudPutObject = "{call C##CLOUD$SERVICE.DBMS_CLOUD.PUT_OBJECT(CREDENTIAL_NAME => ?, OBJECT_URI => ?, DIRECTORY_NAME => ?, FILE_NAME => ?)}";
    public static final String dbms_cloudDeleteSingleObject = "{call C##CLOUD$SERVICE.DBMS_CLOUD.DELETE_OBJECT(CREDENTIAL_NAME => ?, OBJECT_URI => ?)}";
    public static final String dbms_cloudDeleteOperation = "{call C##CLOUD$SERVICE.DBMS_CLOUD.DELETE_OPERATION(ID => ?)}";
    public static final String dropTable = "drop table ";

    public DbmsCloudAPI() {
        this(null);
    }

    public DbmsCloudAPI(ToolLogger tLogger) {
        this._tLogger = tLogger;
    }

    public void isConnLocked(boolean isConnLocked) {
        this._isConnLocked = isConnLocked;
    }

    public void setTLogger(ToolLogger tLogger) {
        this._tLogger = tLogger;
    }

    public ExitCode startService(String connName, boolean isClone) {
        this._connName = connName;
        this._isClone = isClone;
        this.setExitCode(ExitCode.EXIT_SUCCESS);
        String msg = this.cloneAndValidateConnection();
        if (!msg.isEmpty()) {
            ExitCode exitCode = ExitCode.EXIT_SEVERE;
            exitCode.setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_START_ERR") + SPACE);
            exitCode.setMessage(this.getExitCode().getShortMessage() + msg);
            this.setExitCode(exitCode);
        }
        return this.getExitCode();
    }

    public ExitCode startService(String connName, Connection conn) {
        this._connName = connName;
        this._conn = conn;
        this.setExitCode(ExitCode.EXIT_SUCCESS);
        return this.getExitCode();
    }

    public ExitCode restartService(boolean isClone) {
        this._isClone = isClone;
        this.setExitCode(ExitCode.EXIT_SUCCESS);
        try {
            this._conn = this._isClone ? ConnectionResolver.getUniqueConnection(this._connName) : ConnectionResolver.getConnection(this._connName);
        }
        catch (Exception e1) {
            ExitCode exitCode = ExitCode.EXIT_SEVERE;
            exitCode.setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_START_ERR") + SPACE);
            exitCode.setMessage(this.getExitCode().getShortMessage() + e1.getLocalizedMessage());
            this.setExitCode(exitCode);
            Logger.warn(DbmsCloudAPI.class, e1);
        }
        return this.getExitCode();
    }

    public void finishService() {
    }

    public ExitCode getExitCode() {
        return this._exitCode;
    }

    public void setExitCode(ExitCode exitCode) {
        this._exitCode = exitCode;
    }

    public Connection getConnection() {
        return this._conn;
    }

    public String getConnectionUser() {
        return this._connUser;
    }

    public void setSchema(String schema) {
        this._schema = schema;
    }

    public void setSqlSpacing(String spacing) {
        this._spacing = spacing;
    }

    public String getCopyDataStatement(String tableName, String credentials, String fileUri, String schemaName, String fields, String format) {
        StringBuffer sql = new StringBuffer();
        sql.append(COPY_DATA_PREFIX);
        sql.append(this.getCopyDataParms(tableName, credentials, fileUri, schemaName, fields, format));
        return sql.toString();
    }

    public String getCopyDataProcedure(String tableName, String credentials, String fileUri, String schemaName, String fields, String format) {
        StringBuffer sql = new StringBuffer();
        sql.append(COPY_DATA_PROC1);
        sql.append(COPY_DATA_PREFIX);
        sql.append(this.getCopyDataParms(tableName, credentials, fileUri, schemaName, fields, format));
        sql.append(COPY_DATA_PROC2);
        return sql.toString();
    }

    public String getCopyDataParms(String tableName, String credentials, String fileUri, String schemaName, String fields, String format) {
        StringBuffer sql = new StringBuffer();
        sql.append(TABLE_NAME);
        sql.append(SINGLEQ + tableName + SINGLEQ);
        sql.append(COMMA + this._spacing);
        this.appendCredential(sql, credentials);
        this.appendFileUri(sql, fileUri);
        this.appendOperationId(sql);
        this.appendSchemaName(sql, schemaName);
        this.appendFields(sql, fields);
        this.appendFormat(sql, format);
        sql.append(CLOSEP);
        return sql.toString();
    }

    public BigDecimal getLastOperationId() {
        return this._operationId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal doCopy(String sql) throws SQLException {
        ExitCode exitCode = ExitCode.EXIT_SUCCESS;
        Object msg = DbmsCloudResources.getString("DBMS_CLOUD_SUCCESS");
        this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_START", DbmsCloudResources.getString("DBMS_CLOUD_STEP_COPY_DATA")));
        this.tLog(sql);
        this._operationId = null;
        String errMsg = null;
        Statement stmt = null;
        if (this.lock()) {
            try {
                stmt = this._conn.prepareCall(sql.toString());
                stmt.registerOutParameter(1, 2);
                stmt.registerOutParameter(2, 12);
                stmt.execute();
                this._operationId = stmt.getBigDecimal(1);
                this.tLog("Returned: OPERATION_ID => " + this._operationId);
                errMsg = stmt.getString(2);
                if (errMsg != null) {
                    exitCode = ExitCode.EXIT_ERROR;
                    exitCode.setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_STATEMENT_FAILED") + SPACE);
                    msg = this.getExitCode().getShortMessage() + errMsg;
                    exitCode.setMessage((String)msg);
                    this.setExitCode(exitCode);
                    this.tLog((String)msg);
                    this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_COPY_DATA")) + NL);
                    throw new SQLException((String)msg);
                }
            }
            finally {
                stmt.close();
                this.unlock();
            }
        }
        this.tLog((String)msg);
        this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_COPY_DATA")) + NL);
        return this._operationId;
    }

    public String getExtCreateTableStatement(String tableName, String credentials, String fileUri, String schemaName, String columns, String format) {
        StringBuffer sql = new StringBuffer();
        sql.append(EXT_TABLE_PREFIX);
        sql.append(this.getExtCreateTableParms(tableName, credentials, fileUri, schemaName, columns, format));
        return sql.toString();
    }

    public String getExtCreateTableParms(String tableName, String credentials, String fileUri, String schemaName, String columns, String format) {
        StringBuffer sql = new StringBuffer();
        this.appendQSchemaTableName(sql, tableName);
        this.appendCredential(sql, credentials);
        this.appendFileUri(sql, fileUri);
        this.appendColumns(sql, columns);
        this.appendFormat(sql, format);
        sql.append(CLOSEP);
        return sql.toString();
    }

    public void createExternalTable(String sql) throws SQLException {
        Object msg = DbmsCloudResources.getString("DBMS_CLOUD_SUCCESS");
        this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_START", DbmsCloudResources.getString("DBMS_CLOUD_STEP_CREATE_XTAB")));
        Statement stmt = null;
        if (this.lock()) {
            try {
                stmt = this._conn.prepareCall(dbms_cloudCreateExternalTablePrefix + sql + dbms_cloudCreateExternalTableSuffix);
                this.tLog(dbms_cloudCreateExternalTablePrefix + sql + dbms_cloudCreateExternalTableSuffix);
                stmt.execute();
            }
            catch (SQLException e) {
                ExitCode exitCode = ExitCode.EXIT_ERROR;
                exitCode.setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_STATEMENT_FAILED") + SPACE);
                msg = this.getExitCode().getShortMessage() + e.getLocalizedMessage();
                this.setExitCode(exitCode);
                this.tLogException(e);
                this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_CREATE_XTAB")) + NL);
                throw new SQLException(e.getLocalizedMessage(), e.getSQLState(), e.getErrorCode());
            }
            finally {
                stmt.close();
                this.unlock();
            }
        }
        this.tLog((String)msg);
        this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_CREATE_XTAB")) + NL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal validateExternalTable(String tableName, String schemaName, BigDecimal rowCount) throws SQLException {
        Object msg = DbmsCloudResources.getString("DBMS_CLOUD_SUCCESS");
        this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_START", DbmsCloudResources.getString("DBMS_CLOUD_STEP_VALIDATE")));
        BigDecimal operationId = null;
        String errMsg = null;
        Statement stmt = null;
        if (this.lock()) {
            try {
                stmt = this._conn.prepareCall(VALIDATE_EXTERNAL_TABLE);
                this.tLog(VALIDATE_EXTERNAL_TABLE);
                if (rowCount == null || rowCount.equals(new BigDecimal(-1))) {
                    stmt.setBigDecimal(5, new BigDecimal(0));
                    this.tLog("ROWCOUNT => 0");
                } else {
                    stmt.setBigDecimal(5, rowCount);
                    this.tLog("ROWCOUNT => " + rowCount);
                }
                stmt.setString(1, tableName);
                stmt.registerOutParameter(2, 2);
                stmt.registerOutParameter(3, 12);
                stmt.setString(4, schemaName);
                this.tLog("\nTABLE_NAME => " + tableName);
                this.tLog("SCHEMA_NAME => " + schemaName);
                stmt.execute();
                operationId = stmt.getBigDecimal(2);
                this.tLog("\nReturned: OPERATION_ID => " + operationId);
                errMsg = stmt.getString(3);
                if (errMsg != null) {
                    ExitCode exitCode = ExitCode.EXIT_ERROR;
                    exitCode.setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_STATEMENT_FAILED") + SPACE);
                    msg = this.getExitCode().getShortMessage() + errMsg;
                    this.setExitCode(exitCode);
                    this.tLog((String)msg);
                    this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_VALIDATE")) + NL);
                    BigDecimal bigDecimal = operationId;
                    return bigDecimal;
                }
            }
            finally {
                stmt.close();
                this.unlock();
            }
        }
        this.tLog((String)msg);
        this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_VALIDATE")) + NL);
        return operationId;
    }

    public boolean logXTabLog(String xTabLogName, ArrayList<String> badFileNames, ArrayList<String> logFileNames) {
        return this.logXTabLog(null, xTabLogName, badFileNames, logFileNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean logXTabLog(String schema, String xTabLogName, ArrayList<String> badFileNames, ArrayList<String> logFileNames) {
        Object msg = DbmsCloudResources.getString("DBMS_CLOUD_SUCCESS");
        this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_START", DbmsCloudResources.getString("DBMS_CLOUD_STEP_GET_LOG")));
        boolean isLogRows = false;
        ResultSet rs = null;
        if (this.lock()) {
            block16: {
                try {
                    String name = xTabLogName;
                    String record = null;
                    DBUtil dbUtil = DBUtil.getInstance(this._conn);
                    String sql = "select record from " + name;
                    this.tLog(sql);
                    rs = dbUtil.executeQuery(sql, Collections.EMPTY_MAP);
                    int fileIndex = -1;
                    if (rs == null) break block16;
                    while (rs.next()) {
                        isLogRows = true;
                        record = rs.getString(1);
                        if (record == null) {
                            record = SPACE;
                        } else {
                            String searchString = record;
                            while (searchString.length() > 4) {
                                fileIndex = searchString.indexOf(".bad");
                                if (fileIndex != -1) {
                                    String badFileName = this.getFileNameFromLog(searchString.substring(0, fileIndex + 4));
                                    if (!badFileName.isEmpty()) {
                                        badFileNames.add(badFileName);
                                    }
                                    searchString = searchString.substring(fileIndex + 4, searchString.length());
                                    continue;
                                }
                                searchString = "";
                            }
                            searchString = record;
                            while (searchString.length() > 4) {
                                fileIndex = searchString.indexOf(".log");
                                if (fileIndex != -1) {
                                    String logFileName = this.getFileNameFromLog(searchString.substring(0, fileIndex + 4));
                                    if (!logFileName.isEmpty()) {
                                        logFileNames.add(logFileName);
                                    }
                                    searchString = searchString.substring(fileIndex + 4, searchString.length());
                                    continue;
                                }
                                searchString = "";
                            }
                        }
                        this.tLog(record);
                    }
                }
                catch (SQLException e) {
                    boolean bl;
                    try {
                        ExitCode exitCode = ExitCode.EXIT_WARNING;
                        exitCode.setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_STATEMENT_FAILED") + SPACE);
                        msg = this.getExitCode().getShortMessage() + e.getLocalizedMessage();
                        this.setExitCode(exitCode);
                        this.tLogException(e);
                        if (!isLogRows) {
                            this.tLog(DbmsCloudResources.getString("DBMS_CLOUD_LOG_NO_ROWS"));
                        }
                        this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_GET_LOG")) + NL);
                        bl = isLogRows;
                    }
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(rs);
                        this.unlock();
                        throw throwable;
                    }
                    DBUtil.closeResultSet(rs);
                    this.unlock();
                    return bl;
                }
            }
            DBUtil.closeResultSet(rs);
            this.unlock();
        }
        if (!isLogRows) {
            this.tLog(DbmsCloudResources.getString("DBMS_CLOUD_LOG_NO_ROWS"));
        }
        this.tLog((String)msg);
        this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_GET_LOG")) + NL);
        return isLogRows;
    }

    public boolean logXTabBad(String xTabBadName) {
        return this.logXTabBad(null, xTabBadName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean logXTabBad(String schema, String xTabBadName) {
        String msg = DbmsCloudResources.getString("DBMS_CLOUD_SUCCESS");
        this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_START", DbmsCloudResources.getString("DBMS_CLOUD_STEP_LOG_BAD")));
        String name = xTabBadName;
        String count = null;
        if (this.lock()) {
            try {
                count = DBUtil.getInstance(this._conn).executeReturnOneCol("select count(*) from " + name, Collections.EMPTY_MAP);
                this.tLog(DbmsCloudResources.format("DBMS_CLOUD_VAL_XTAB_BAD_COUNT", name, count));
            }
            finally {
                this.unlock();
            }
        }
        this.tLog(msg);
        this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_LOG_BAD")) + NL);
        return Float.valueOf(count).floatValue() > 0.0f;
    }

    public String getCountCloudTab(String xTabName) {
        return this.getCountCloudTab(xTabName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCountCloudTab(String xTabName, String rowLimit) {
        Object limit;
        String count = null;
        Object object = limit = rowLimit == null ? "" : dbms_cloudGetCloudTabCount2 + rowLimit;
        if (this.lock()) {
            try {
                count = DBUtil.getInstance(this._conn).executeReturnOneCol("select count(*) from " + xTabName + (String)limit, Collections.EMPTY_MAP);
            }
            finally {
                this.unlock();
            }
        }
        return count;
    }

    public boolean isDataRows(String tabName) {
        String count = "0";
        if (this.lock()) {
            try {
                count = DBUtil.getInstance(this._conn).executeReturnOneCol("select count(*) from " + this.addUser(tabName) + dbms_cloudGetXTabRows2, Collections.EMPTY_MAP);
            }
            finally {
                this.unlock();
            }
        }
        return count != null ? count.equals("1") : false;
    }

    public void testBucketUrl(String credentialName, String dest) throws SQLException {
        Object msg = DbmsCloudResources.getString("DBMS_CLOUD_SUCCESS");
        String step = DbmsCloudResources.getString("DBMS_CLOUD_STEP_TEST_BUCKET");
        this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_START", step));
        try {
            String tempName = (String)(dest.endsWith("/") ? dest : dest + "/") + DbmsCloudAPI.getTempName(temp);
            try (ByteArrayInputStream fis = new ByteArrayInputStream(temp.getBytes());){
                this.putObject(credentialName, tempName, fis);
                fis.close();
            }
            catch (Throwable t) {
                ExitCode exitCode = ExitCode.EXIT_ERROR;
                exitCode.setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_STATEMENT_FAILED") + SPACE + step);
                msg = this.getExitCode().getShortMessage() + t.getLocalizedMessage();
                this.setExitCode(exitCode);
                this.tLogException(t);
                this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", step) + NL);
                throw DbmsCloudAPI.asSQLException(t);
            }
            try {
                this.deleteObject(credentialName, tempName);
            }
            catch (Throwable t) {
                ExitCode exitCode = ExitCode.EXIT_ERROR;
                exitCode.setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_STATEMENT_FAILED") + SPACE + step);
                msg = this.getExitCode().getShortMessage() + t.getLocalizedMessage();
                this.setExitCode(exitCode);
                this.tLogException(t);
                this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", step) + NL);
                throw DbmsCloudAPI.asSQLException(t);
            }
        }
        catch (Throwable t) {
            ExitCode exitCode = ExitCode.EXIT_ERROR;
            exitCode.setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_STATEMENT_FAILED") + SPACE + step);
            msg = this.getExitCode().getShortMessage() + t.getLocalizedMessage();
            this.setExitCode(exitCode);
            this.tLogException(t);
            this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", step) + NL);
            throw DbmsCloudAPI.asSQLException(t);
        }
    }

    public static String getTempName(String prefix) {
        SimpleDateFormat df = new SimpleDateFormat("yymmdd_HHmmssssss");
        StringBuilder dt = new StringBuilder(df.format(new Date()));
        return prefix + "_" + dt;
    }

    public void putObject(String credentialName, String dest, InputStream contents) throws SQLException {
        Object msg = DbmsCloudResources.getString("DBMS_CLOUD_SUCCESS");
        this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_START", DbmsCloudResources.getString("DBMS_CLOUD_STEP_PUT_DATA")));
        LinkedHashMap<String, Object> binds = new LinkedHashMap<String, Object>();
        binds.put("CREDENTIAL_NAME", credentialName);
        binds.put("OBJECT_URI", dest);
        binds.put("CONTENTS", contents);
        binds.put("COMPRESSION", null);
        String query = DbmsCloudQuery.getQuery("dbms_cloudPutObjectBlob", this._conn);
        if (query == null) {
            throw new SQLException(DbmsCloudResources.getString("DBMS_CLOUD_PKG_ERR"));
        }
        if (this.lock()) {
            try {
                DBUtil dbUtil = DBUtil.getInstance(this._conn);
                dbUtil.execute(query, binds);
                SQLException e = dbUtil.getLastException();
                if (e != null) {
                    throw e;
                }
            }
            catch (SQLException e) {
                ExitCode exitCode = ExitCode.EXIT_WARNING;
                exitCode.setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_STATEMENT_FAILED") + SPACE);
                msg = this.getExitCode().getShortMessage() + e.getLocalizedMessage();
                this.setExitCode(exitCode);
                this.tLogException(e);
                this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_CREATE_CREDENTIAL")) + NL);
                throw new SQLException(e.getLocalizedMessage(), e.getSQLState(), e.getErrorCode());
            }
            finally {
                this.unlock();
            }
        }
        this.tLog((String)msg);
        this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_PUT_DATA")) + NL);
    }

    public String putObject(String credentialName, String bucket, ArrayList<String> putFileNames, boolean logAdvice) throws SQLException {
        Object results = "";
        String separator = "";
        Object msg = DbmsCloudResources.getString("DBMS_CLOUD_SUCCESS");
        this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_START", DbmsCloudResources.getString("DBMS_CLOUD_STEP_PUT_OBJECT")));
        if (putFileNames == null || putFileNames.isEmpty()) {
            return results;
        }
        int i = bucket.lastIndexOf("/");
        String root = i < 0 ? bucket : bucket.substring(0, i);
        Statement stmt = null;
        for (String badFile : putFileNames) {
            int idx = badFile.indexOf("_");
            if (idx == -1) continue;
            if (this.lock()) {
                try {
                    if (this._tLogger != null) {
                        this.tLog(dbms_cloudPutObject);
                        this.tLog("CREDENTIAL_NAME => " + credentialName);
                        this.tLog("OBJECT_URI => " + root + "/" + badFile);
                        this.tLog("DIRECTORY_NAME => DATA_PUMP_DIR");
                        this.tLog("FILE_NAME => " + badFile);
                    }
                    stmt = this._conn.prepareCall(dbms_cloudPutObject);
                    stmt.setString(1, credentialName);
                    stmt.setString(2, root + "/" + badFile);
                    stmt.setString(3, "DATA_PUMP_DIR");
                    stmt.setString(4, badFile);
                    stmt.execute();
                    results = (String)results + separator + root + "/" + badFile;
                }
                catch (SQLException e) {
                    ExitCode exitCode = ExitCode.EXIT_WARNING;
                    exitCode.setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_STATEMENT_FAILED") + SPACE);
                    msg = this.getExitCode().getShortMessage() + e.getLocalizedMessage();
                    this.setExitCode(exitCode);
                    this.tLogException(e);
                    this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_PUT_OBJECT")) + NL);
                    throw new SQLException(e.getLocalizedMessage(), e.getSQLState(), e.getErrorCode());
                }
                finally {
                    stmt.close();
                    this.unlock();
                }
            }
            if (!logAdvice) continue;
            this.tLog(DbmsCloudResources.format("DBMS_CLOUD_COPY_BAD_ADVICE", root + "/" + putFileNames.get(0)));
        }
        this.tLog((String)msg);
        this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_PUT_OBJECT")) + NL);
        return results;
    }

    public void deleteObject(String credentialName, String source, ArrayList<String> putFileNames) throws SQLException {
        if (putFileNames == null || putFileNames.isEmpty()) {
            return;
        }
        int i = source.lastIndexOf("/");
        String root = source.substring(0, i);
        for (String badFile : putFileNames) {
            int idx = badFile.indexOf("_");
            if (idx == -1) continue;
            this.deleteObject(credentialName, root + "/" + badFile);
        }
    }

    public void deleteObject(String credentialName, String object) throws SQLException {
        Object msg = DbmsCloudResources.getString("DBMS_CLOUD_SUCCESS");
        this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_START", DbmsCloudResources.getString("DBMS_CLOUD_STEP_DELETE_OBJECT")));
        LinkedHashMap<String, String> binds = new LinkedHashMap<String, String>();
        binds.put("CREDENTIAL_NAME", credentialName);
        binds.put("OBJECT_URI", object);
        String query = DbmsCloudQuery.getQuery("dbms_cloudDeleteSingleObject", this._conn);
        if (query == null) {
            throw new SQLException(DbmsCloudResources.getString("DBMS_CLOUD_PKG_ERR"));
        }
        try {
            DBUtil dbUtil = DBUtil.getInstance(this._conn);
            dbUtil.execute(query, binds);
            SQLException e = dbUtil.getLastException();
            if (e != null) {
                throw e;
            }
        }
        catch (SQLException e) {
            ExitCode exitCode = ExitCode.EXIT_WARNING;
            exitCode.setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_STATEMENT_FAILED") + SPACE);
            msg = this.getExitCode().getShortMessage() + e.getLocalizedMessage();
            this.setExitCode(exitCode);
            this.tLogException(e);
            this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_CREATE_CREDENTIAL")) + NL);
            throw new SQLException(e.getLocalizedMessage(), e.getSQLState(), e.getErrorCode());
        }
        this.tLog((String)msg);
        this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_DELETE_OBJECT")) + NL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsCredential(String cred) throws SQLException {
        String msg = DbmsCloudResources.getString("DBMS_CLOUD_SUCCESS");
        this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_START", DbmsCloudResources.getString("DBMS_CLOUD_STEP_EXISTS_CREDENTIAL")));
        String count = "0";
        if (this.lock()) {
            try {
                LinkedHashMap<String, String> binds = new LinkedHashMap<String, String>();
                binds.put("CREDENTIAL_NAME", cred);
                String query = DbmsCloudQuery.getQuery("dbms_cloudExistsCredential", this._conn);
                if (query == null) {
                    throw new SQLException(DbmsCloudResources.getString("DBMS_CLOUD_PKG_ERR"));
                }
                DBUtil dbUtil = DBUtil.getInstance(this._conn);
                count = dbUtil.executeReturnOneCol(query, binds);
                this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_EXISTS_CREDENTIAL", cred, count));
                SQLException e = dbUtil.getLastException();
                if (e != null) {
                    throw e;
                }
            }
            finally {
                this.unlock();
            }
        }
        this.tLog(msg);
        this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_EXISTS_CREDENTIAL")) + NL);
        return Float.valueOf(count).floatValue() > 0.0f;
    }

    public void createCredential(String cred, String user, String pass) throws SQLException {
        Object msg = DbmsCloudResources.getString("DBMS_CLOUD_SUCCESS");
        this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_START", DbmsCloudResources.getString("DBMS_CLOUD_STEP_CREATE_CREDENTIAL")));
        LinkedHashMap<String, String> binds = new LinkedHashMap<String, String>();
        binds.put("CREDENTIAL_NAME", cred);
        binds.put("USERNAME", user);
        binds.put("PASSWORD", pass);
        String query = DbmsCloudQuery.getQuery("dbms_cloudCreateCredential", this._conn);
        if (query == null) {
            throw new SQLException(DbmsCloudResources.getString("DBMS_CLOUD_PKG_ERR"));
        }
        try {
            DBUtil dbUtil = DBUtil.getInstance(this._conn);
            dbUtil.execute(query, binds);
            SQLException e = dbUtil.getLastException();
            if (e != null) {
                throw e;
            }
        }
        catch (SQLException e) {
            ExitCode exitCode = ExitCode.EXIT_WARNING;
            exitCode.setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_STATEMENT_FAILED") + SPACE);
            msg = this.getExitCode().getShortMessage() + e.getLocalizedMessage();
            this.setExitCode(exitCode);
            this.tLogException(e);
            this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_CREATE_CREDENTIAL")) + NL);
            throw new SQLException(e.getLocalizedMessage(), e.getSQLState(), e.getErrorCode());
        }
        this.tLog((String)msg);
        this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_CREATE_CREDENTIAL")) + NL);
    }

    public void createPrivateKeyCredential(String cred, String authUserId, String tenancyId, String privateKey, String keyFingerprint) throws SQLException {
        Object msg = DbmsCloudResources.getString("DBMS_CLOUD_SUCCESS");
        this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_START", DbmsCloudResources.getString("DBMS_CLOUD_STEP_CREATE_CREDENTIAL")));
        LinkedHashMap<String, String> binds = new LinkedHashMap<String, String>();
        binds.put("CREDENTIAL_NAME", cred);
        binds.put("USER_OCID", authUserId);
        binds.put("TENANCY_OCID", tenancyId);
        binds.put("PRIVATE_KEY", privateKey);
        binds.put("FINGERPRINT", keyFingerprint);
        String query = DbmsCloudQuery.getQuery("dbms_cloudCreateCredentialPrivateKey", this._conn);
        if (query == null) {
            throw new SQLException(DbmsCloudResources.getString("DBMS_CLOUD_PKG_ERR"));
        }
        try {
            DBUtil dbUtil = DBUtil.getInstance(this._conn);
            dbUtil.execute(query, binds);
            SQLException e = dbUtil.getLastException();
            if (e != null) {
                throw e;
            }
        }
        catch (SQLException e) {
            ExitCode exitCode = ExitCode.EXIT_WARNING;
            exitCode.setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_STATEMENT_FAILED") + SPACE);
            msg = this.getExitCode().getShortMessage() + e.getLocalizedMessage();
            this.setExitCode(exitCode);
            this.tLogException(e);
            this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_CREATE_CREDENTIAL")) + NL);
            throw new SQLException(e.getLocalizedMessage(), e.getSQLState(), e.getErrorCode());
        }
        this.tLog((String)msg);
        this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_CREATE_CREDENTIAL")) + NL);
    }

    public void dropCredential(String cred) throws SQLException {
        Object msg = DbmsCloudResources.getString("DBMS_CLOUD_SUCCESS");
        this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_START", DbmsCloudResources.getString("DBMS_CLOUD_STEP_DROP_CREDENTIAL")));
        LinkedHashMap<String, String> binds = new LinkedHashMap<String, String>();
        binds.put("CREDENTIAL_NAME", cred);
        String query = DbmsCloudQuery.getQuery("dbms_cloudDropCredential", this._conn);
        if (query == null) {
            throw new SQLException(DbmsCloudResources.getString("DBMS_CLOUD_PKG_ERR"));
        }
        try {
            DBUtil dbUtil = DBUtil.getInstance(this._conn);
            dbUtil.execute(query, binds);
            SQLException e = dbUtil.getLastException();
            if (e != null) {
                throw e;
            }
        }
        catch (SQLException e) {
            ExitCode exitCode = ExitCode.EXIT_WARNING;
            exitCode.setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_STATEMENT_FAILED") + SPACE);
            msg = this.getExitCode().getShortMessage() + e.getLocalizedMessage();
            this.setExitCode(exitCode);
            this.tLogException(e);
            this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_CREATE_CREDENTIAL")) + NL);
            throw new SQLException(e.getLocalizedMessage(), e.getSQLState(), e.getErrorCode());
        }
        this.tLog((String)msg);
        this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_DROP_CREDENTIAL")) + NL);
    }

    public void disableCredential(String cred) throws SQLException {
        Object msg = DbmsCloudResources.getString("DBMS_CLOUD_SUCCESS");
        this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_START", DbmsCloudResources.getString("DBMS_CLOUD_STEP_DISABLE_CREDENTIAL")));
        LinkedHashMap<String, String> binds = new LinkedHashMap<String, String>();
        binds.put("CREDENTIAL_NAME", cred);
        String query = DbmsCloudQuery.getQuery("dbms_cloudDisableCredential", this._conn);
        if (query == null) {
            throw new SQLException(DbmsCloudResources.getString("DBMS_CLOUD_PKG_ERR"));
        }
        try {
            DBUtil dbUtil = DBUtil.getInstance(this._conn);
            dbUtil.execute(query, binds);
            SQLException e = dbUtil.getLastException();
            if (e != null) {
                throw e;
            }
        }
        catch (SQLException e) {
            ExitCode exitCode = ExitCode.EXIT_WARNING;
            exitCode.setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_STATEMENT_FAILED") + SPACE);
            msg = this.getExitCode().getShortMessage() + e.getLocalizedMessage();
            this.setExitCode(exitCode);
            this.tLogException(e);
            this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_CREATE_CREDENTIAL")) + NL);
            throw new SQLException(e.getLocalizedMessage(), e.getSQLState(), e.getErrorCode());
        }
        this.tLog((String)msg);
        this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_DISABLE_CREDENTIAL")) + NL);
    }

    public void enableCredential(String cred) throws SQLException {
        Object msg = DbmsCloudResources.getString("DBMS_CLOUD_SUCCESS");
        this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_START", DbmsCloudResources.getString("DBMS_CLOUD_STEP_ENABLE_CREDENTIAL")));
        LinkedHashMap<String, String> binds = new LinkedHashMap<String, String>();
        binds.put("CREDENTIAL_NAME", cred);
        String query = DbmsCloudQuery.getQuery("dbms_cloudEnableCredential", this._conn);
        if (query == null) {
            throw new SQLException(DbmsCloudResources.getString("DBMS_CLOUD_PKG_ERR"));
        }
        try {
            DBUtil dbUtil = DBUtil.getInstance(this._conn);
            dbUtil.execute(query, binds);
            SQLException e = dbUtil.getLastException();
            if (e != null) {
                throw e;
            }
        }
        catch (SQLException e) {
            ExitCode exitCode = ExitCode.EXIT_WARNING;
            exitCode.setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_STATEMENT_FAILED") + SPACE);
            msg = this.getExitCode().getShortMessage() + e.getLocalizedMessage();
            this.setExitCode(exitCode);
            this.tLogException(e);
            this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_CREATE_CREDENTIAL")) + NL);
            throw new SQLException(e.getLocalizedMessage(), e.getSQLState(), e.getErrorCode());
        }
        this.tLog((String)msg);
        this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_ENABLE_CREDENTIAL")) + NL);
    }

    public void updateCredential(String cred, String attribute, String value) throws SQLException {
        Object msg = DbmsCloudResources.getString("DBMS_CLOUD_SUCCESS");
        this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_START", DbmsCloudResources.getString("DBMS_CLOUD_STEP_UPDATE_CREDENTIAL")));
        LinkedHashMap<String, String> binds = new LinkedHashMap<String, String>();
        binds.put("CREDENTIAL_NAME", cred);
        binds.put("ATTRIBUTE", attribute);
        binds.put("VALUE", value);
        String query = DbmsCloudQuery.getQuery("dbms_cloudUpdateCredential", this._conn);
        if (query == null) {
            throw new SQLException(DbmsCloudResources.getString("DBMS_CLOUD_PKG_ERR"));
        }
        try {
            DBUtil dbUtil = DBUtil.getInstance(this._conn);
            dbUtil.execute(query, binds);
            SQLException e = dbUtil.getLastException();
            if (e != null) {
                throw e;
            }
        }
        catch (SQLException e) {
            ExitCode exitCode = ExitCode.EXIT_WARNING;
            exitCode.setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_STATEMENT_FAILED") + SPACE);
            msg = this.getExitCode().getShortMessage() + e.getLocalizedMessage();
            this.setExitCode(exitCode);
            this.tLogException(e);
            this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_CREATE_CREDENTIAL")) + NL);
            throw new SQLException(e.getLocalizedMessage(), e.getSQLState(), e.getErrorCode());
        }
        this.tLog((String)msg);
        this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_UPDATE_CREDENTIAL")) + NL);
    }

    public void deleteOperation(BigDecimal operationId) throws SQLException {
        Object msg = DbmsCloudResources.getString("DBMS_CLOUD_SUCCESS");
        this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_START", DbmsCloudResources.getString("DBMS_CLOUD_STEP_DROP_OPERATION")));
        Statement stmt = null;
        if (this.lock()) {
            try {
                stmt = this._conn.prepareCall(dbms_cloudDeleteOperation);
                this.tLog(dbms_cloudDeleteOperation);
                stmt.setBigDecimal(1, operationId);
                this.tLog("OPERATION_ID => " + operationId);
                stmt.execute();
            }
            catch (SQLException e) {
                ExitCode exitCode = ExitCode.EXIT_ERROR;
                exitCode.setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_STATEMENT_FAILED") + SPACE);
                msg = this.getExitCode().getShortMessage() + e.getLocalizedMessage();
                this.setExitCode(exitCode);
                this.tLogException(e);
                this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_DROP_OPERATION")) + NL);
                throw new SQLException(e.getLocalizedMessage(), e.getSQLState(), e.getErrorCode());
            }
            finally {
                stmt.close();
                this.unlock();
            }
        }
        this.tLog((String)msg);
        this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", DbmsCloudResources.getString("DBMS_CLOUD_STEP_DROP_OPERATION")) + NL);
    }

    public boolean dropTable(String tableName, String type) {
        return this.dropTable(tableName, type, true);
    }

    public boolean dropTable(String tableName, String type, boolean log) {
        Object msg = DbmsCloudResources.getString("DBMS_CLOUD_SUCCESS");
        String lmsg = DbmsCloudResources.format("DBMS_CLOUD_STEP_DROP_TABLE", type != null ? type : "");
        this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_START", lmsg));
        String sql = dropTable + this.addUser(tableName);
        this.tLog(sql);
        boolean isSuccess = this.pstmtExec(sql);
        if (!isSuccess) {
            this.getExitCode().setShortMessage(DbmsCloudResources.getString("DBMS_CLOUD_STATEMENT_FAILED") + SPACE);
            msg = this.getExitCode().getShortMessage() + this.getExitCode().getMessage();
            this.tLog((String)msg);
            this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", lmsg + NL));
            return false;
        }
        this.tLog((String)msg);
        this.tLog(DbmsCloudResources.format("DBMS_CLOUD_STEP_END", lmsg + NL));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pstmtExec(String sql) {
        if (this.lock()) {
            try {
                PreparedStatement pstmt = this._conn.prepareStatement(sql);
                pstmt.execute();
            }
            catch (SQLException e) {
                Logger.warn(DbmsCloudAPI.class, e);
                this._exitCode = ExitCode.EXIT_ERROR;
                this._exitCode.setMessage(sql + SPACE + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                this.unlock();
            }
            return true;
        }
        return false;
    }

    public String addUser(String tableName) {
        return tableName.contains(DOT) ? tableName : DBUtil.addDoubleQuote(this._schema) + DOT + tableName;
    }

    private void appendQSchemaTableName(StringBuffer sql, String tableName) {
        sql.append(TABLE_NAME);
        sql.append(this.getQSchemaTableName(tableName));
        sql.append(COMMA + this._spacing);
    }

    private String getQSchemaTableName(String tableName) {
        return SINGLEQ + tableName + SINGLEQ;
    }

    private void appendCredential(StringBuffer sql, String credentials) {
        sql.append(CREDENTIAL_NAME);
        sql.append(SINGLEQ + credentials + SINGLEQ);
        sql.append(COMMA + this._spacing);
    }

    private void appendFileUri(StringBuffer sql, String fileUri) {
        sql.append(FILE_URI_LIST);
        sql.append(SINGLEQ + fileUri + SINGLEQ);
        sql.append(COMMA + this._spacing);
    }

    private void appendOperationId(StringBuffer sql) {
        sql.append("operation_id => operation_id");
        sql.append(COMMA + this._spacing);
    }

    private void appendSchemaName(StringBuffer sql, String schemaName) {
        sql.append("schema_name => ");
        sql.append(SINGLEQ + schemaName + SINGLEQ);
        sql.append(COMMA + this._spacing);
    }

    private void appendFields(StringBuffer sql, String fields) {
        if (fields != null && !fields.isEmpty()) {
            sql.append("field_list => '" + fields);
            sql.append("'," + this._spacing);
        }
    }

    private void appendColumns(StringBuffer sql, String cols) {
        if (cols != null && !cols.isEmpty()) {
            sql.append("column_list => '" + cols);
            sql.append("'," + this._spacing);
        }
    }

    private void appendFormat(StringBuffer sql, String format) {
        sql.append("format => ");
        sql.append(format);
    }

    private String getFileNameFromLog(String searchString) {
        int fileIndex = searchString.lastIndexOf(SPACE);
        if (fileIndex == -1) {
            fileIndex = 0;
        }
        return searchString.substring(fileIndex + 1, searchString.length());
    }

    private String cloneAndValidateConnection() {
        String msg = "";
        if (this._connName != null) {
            try {
                this._conn = this._isClone ? ConnectionResolver.getUniqueConnection(this._connName) : ConnectionResolver.getConnection(this._connName);
            }
            catch (Exception e1) {
                msg = e1.getLocalizedMessage();
                Logger.warn(DbmsCloudAPI.class, e1);
                return msg;
            }
        }
        if (this._connName == null || this._conn == null) {
            msg = DbmsCloudResources.getString("DBMS_CLOUD_DEST_CONN_UNAVAIL");
            return msg;
        }
        if (this._schema == null) {
            try {
                this._schema = this._connUser = this._conn.getMetaData().getUserName();
            }
            catch (SQLException e1) {
                msg = e1.getLocalizedMessage();
                Logger.warn(DbmsCloudAPI.class, e1);
                return msg;
            }
        }
        return msg;
    }

    private void tLog(String msg) {
        if (this._tLogger != null) {
            this._tLogger.log(msg);
        }
    }

    private void tLogException(Throwable t) {
        if (this._tLogger != null) {
            this._tLogger.logException(t);
        }
    }

    protected static SQLException asSQLException(Throwable t) {
        if (t instanceof SQLException) {
            return (SQLException)t;
        }
        Throwable c = t.getCause();
        if (c instanceof SQLException) {
            return (SQLException)c;
        }
        return new SQLException(t);
    }

    private boolean lock() {
        if (!this._isConnLocked) {
            return LockManager.lock(this._conn);
        }
        return true;
    }

    private void unlock() {
        if (!this._isConnLocked) {
            LockManager.unlock(this._conn);
        }
    }
}

