/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.metadata.MetadataUtil;
import oracle.dbtools.raptor.datatypes.xml.DataValueXMLMarshalHandler;
import oracle.dbtools.raptor.datatypes.xml.DataValueXMLUnmarshalHandler;
import oracle.sql.CLOB;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class XMLUtil {
    public static final String XML_IS_NULL_ATTR_TAG = "is_null";
    public static final String XML_NULL = "";
    public static final String XML_CDATA = "CDATA";
    public static final String XML_NAME_ATT = "name";
    public static final String XML_DATAVALUE_ELEMENT = "DataValue";
    public static final String XML_ENCODING = "UTF-8";

    public static boolean isMarkedNull(String is_null) {
        Boolean marked;
        try {
            marked = is_null != null && is_null.length() > 0 ? Boolean.valueOf(Boolean.parseBoolean(is_null)) : null;
        }
        catch (Exception e) {
            marked = null;
        }
        return marked == null ? false : marked;
    }

    public static void setAttribute(AttributesImpl atts, String qualifiedName, String value) {
        atts.addAttribute(XML_NULL, XML_NULL, qualifiedName, XML_CDATA, value);
    }

    public static String getAttribute(Attributes atts, String qualifiedName) {
        return atts.getValue(qualifiedName);
    }

    public static void markNull(AttributesImpl atts) {
        XMLUtil.setAttribute(atts, XML_IS_NULL_ATTR_TAG, Boolean.TRUE.toString());
    }

    public static void markNull(AttributesImpl atts, boolean flag) {
        XMLUtil.setAttribute(atts, XML_IS_NULL_ATTR_TAG, Boolean.valueOf(flag).toString());
    }

    public static void markNotNull(AttributesImpl atts) {
        XMLUtil.setAttribute(atts, XML_IS_NULL_ATTR_TAG, Boolean.FALSE.toString());
    }

    public static boolean isMarkedNull(Attributes atts) {
        String is_null = XMLUtil.getAttribute(atts, XML_IS_NULL_ATTR_TAG);
        return XMLUtil.isMarkedNull(is_null);
    }

    public static void setName(AttributesImpl atts, String value) {
        if (value != null) {
            XMLUtil.setAttribute(atts, XML_NAME_ATT, value);
        }
    }

    public static String getName(Attributes atts) {
        return XMLUtil.getAttribute(atts, XML_NAME_ATT);
    }

    public static void startDataValueElement(TransformerHandler hd, AttributesImpl atts) throws SAXException {
        hd.startElement(XML_NULL, XML_NULL, XML_DATAVALUE_ELEMENT, atts);
    }

    public static void endDataValueElement(TransformerHandler hd) throws SAXException {
        hd.endElement(XML_NULL, XML_NULL, XML_DATAVALUE_ELEMENT);
    }

    public static void marshallDataValue(TransformerHandler th, DataValue value) throws TransformerConfigurationException, SAXException {
        DataValueXMLMarshalHandler hd = new DataValueXMLMarshalHandler(th);
        hd.marshal(value);
    }

    public static void marshallDataValue(TransformerHandler th, DataValue value, String name) {
        DataValueXMLMarshalHandler hd = new DataValueXMLMarshalHandler(th);
        hd.marshal(value, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void marshallDataValue(OutputStream os, DataValue value, String name, boolean useName) throws TransformerConfigurationException, SAXException {
        try {
            StreamResult streamResult = new StreamResult(os);
            SAXTransformerFactory tf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            TransformerHandler th = tf.newTransformerHandler();
            Transformer serializer = th.getTransformer();
            serializer.setOutputProperty("encoding", XML_ENCODING);
            serializer.setOutputProperty("indent", "yes");
            th.setResult(streamResult);
            DataValueXMLMarshalHandler hd = new DataValueXMLMarshalHandler(th);
            th.startDocument();
            try {
                if (useName) {
                    hd.marshal(value, name);
                } else {
                    hd.marshal(value);
                }
            }
            finally {
                try {
                    th.endDocument();
                }
                catch (Exception e) {
                    Logger.getLogger(XMLUtil.class.getName()).log(Level.WARNING, e.getLocalizedMessage(), e);
                }
            }
        }
        finally {
            try {
                os.flush();
            }
            catch (IOException e) {
                Logger.getLogger(XMLUtil.class.getName()).log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }
    }

    public static void marshallDataValue(OutputStream os, DataValue value, String name) throws TransformerConfigurationException, SAXException {
        XMLUtil.marshallDataValue(os, value, name, true);
    }

    public static void marshallDataValue(OutputStream os, DataValue value) throws TransformerConfigurationException, SAXException {
        XMLUtil.marshallDataValue(os, value, null, false);
    }

    public static Clob marshallDataValue(Connection conn, DataValue value, String name) throws TransformerConfigurationException, SAXException, SQLException {
        Clob clob = XMLUtil.getClobLocator(conn);
        XMLUtil.marshallDataValue(clob, value, name);
        return clob;
    }

    public static Clob marshallDataValue(Connection conn, DataValue value) throws TransformerConfigurationException, SAXException, SQLException {
        Clob clob = XMLUtil.getClobLocator(conn);
        XMLUtil.marshallDataValue(clob, value);
        return clob;
    }

    public static void marshallDataValue(Clob clob, DataValue value, String name) throws TransformerConfigurationException, SAXException, SQLException {
        OutputStream os = clob.setAsciiStream(1L);
        XMLUtil.marshallDataValue(os, value, name);
    }

    public static void marshallDataValue(Clob clob, DataValue value) throws TransformerConfigurationException, SAXException, SQLException {
        OutputStream os = clob.setAsciiStream(1L);
        XMLUtil.marshallDataValue(os, value);
    }

    private static DataValue unmarshallDataValue(InputStream is, DataType datatype, String name, boolean useName) throws SAXException, IOException {
        XMLReader xr = XMLReaderFactory.createXMLReader();
        DataValueXMLUnmarshalHandler handler = useName ? new DataValueXMLUnmarshalHandler(datatype, name) : new DataValueXMLUnmarshalHandler(datatype);
        xr.setContentHandler(handler);
        xr.setErrorHandler(handler);
        xr.parse(new InputSource(is));
        return handler.getDataValue();
    }

    public static DataValue unmarshallDataValue(InputStream is, DataType datatype, String name) throws SAXException, IOException {
        return XMLUtil.unmarshallDataValue(is, datatype, name, true);
    }

    public static DataValue unmarshallDataValue(InputStream is, DataType datatype) throws SAXException, IOException {
        return XMLUtil.unmarshallDataValue(is, datatype, null, false);
    }

    public static DataValue unmarshallDataValue(Clob clob, DataType datatype, String name) throws SAXException, IOException, SQLException {
        return XMLUtil.unmarshallDataValue(clob.getAsciiStream(), datatype, name, true);
    }

    public static DataValue unmarshallDataValue(Clob clob, DataType datatype) throws SAXException, IOException, SQLException {
        return XMLUtil.unmarshallDataValue(clob.getAsciiStream(), datatype, null, false);
    }

    private static Clob getClobLocator(Connection conn) throws SQLException {
        return CLOB.createTemporary((Connection)conn, (boolean)false, (int)10);
    }

    public static String getQuery(Connection conn, String id) {
        return MetadataUtil.getQuery(conn, id);
    }
}

