/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.util;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.raptor.datatypes.objects.OraDATE;
import oracle.dbtools.raptor.datatypes.objects.OraINTERVALDS;
import oracle.dbtools.raptor.datatypes.objects.OraINTERVALYM;
import oracle.dbtools.raptor.datatypes.objects.OraTIMESTAMP;
import oracle.dbtools.raptor.datatypes.objects.OraTIMESTAMPTZ;
import oracle.dbtools.raptor.datatypes.objects.OraTemporalDatum;

public abstract class TemporalUtil {
    private static final Pattern YM_PATTERN = Pattern.compile("([-+]?)P(?:([0-9]+)Y)?(?:([0-9]+)M)?", 2);
    private static final Pattern DS_PATTERN = Pattern.compile("([-+]?)P(?:([0-9]+)D)?(T(?:([0-9]+)H)?(?:([0-9]+)M)?(?:([0-9]+)(?:[.,]([0-9]{0,9}))?S)?)?", 2);

    public static boolean isTimestamp(CharSequence text) {
        try {
            ZonedDateTime.parse(text, DateTimeFormatter.ISO_ZONED_DATE_TIME);
            return true;
        }
        catch (DateTimeParseException pe) {
            try {
                ZonedDateTime.parse(text, DateTimeFormatter.ISO_DATE_TIME.withZone(TimeZone.getDefault().toZoneId()));
                return true;
            }
            catch (DateTimeParseException pe2) {
                return false;
            }
        }
    }

    public static boolean isRestTimestamp(CharSequence text) {
        try {
            ZonedDateTime.parse(text, DateTimeFormatter.ISO_ZONED_DATE_TIME);
            return true;
        }
        catch (DateTimeParseException pe) {
            return false;
        }
    }

    public static String toRestString(long date) {
        return TemporalUtil.toRestString(Instant.ofEpochMilli(date));
    }

    public static String toRestString(Timestamp timestamp) {
        return TemporalUtil.toRestString(timestamp.toInstant());
    }

    public static String toRestString(OraTemporalDatum temporalDatum) {
        if (temporalDatum.userTimeZoneSupported()) {
            return TemporalUtil.toRestString(temporalDatum.toSessionZonedDateTime());
        }
        return TemporalUtil.toRestString(temporalDatum.toSessionInstant());
    }

    public static String toRestString(Instant instant) {
        return TemporalUtil.toRestString(instant.atZone(OraTemporalDatum.UTC_ID));
    }

    public static String toRestString(ZonedDateTime zdt) {
        return TemporalUtil.toRestString(zdt.toOffsetDateTime()).replaceAll("Z\\[UTC\\]", "Z");
    }

    public static String toRestString(OffsetDateTime odt) {
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(odt);
    }

    public static String toPaddedString(long date) {
        return TemporalUtil.toPaddedString(Instant.ofEpochMilli(date));
    }

    public static String toPaddedString(Timestamp timestamp) {
        return TemporalUtil.toPaddedString(timestamp.toInstant());
    }

    public static String toPaddedString(OraTemporalDatum temporalDatum) {
        if (temporalDatum.getResolution() == OraTemporalDatum.Resolution.LOCAL) {
            return TemporalUtil.toPaddedString(temporalDatum.toLocalDateTime());
        }
        if (temporalDatum.userTimeZoneSupported()) {
            return TemporalUtil.toPaddedString(temporalDatum.toZonedDateTime());
        }
        return TemporalUtil.toPaddedString(temporalDatum.toInstant());
    }

    public static String toPaddedString(Instant instant) {
        if (instant.getNano() == 0) {
            return instant.plusNanos(777000000L).toString().replaceAll("[.]777", ".000");
        }
        return instant.toString();
    }

    public static String toPaddedString(LocalDateTime ldt) {
        if (ldt.getNano() == 0) {
            return ldt.plusNanos(777000000L).toString().replaceAll("[.]777", ".000");
        }
        return ldt.toString();
    }

    public static String toPaddedString(ZonedDateTime zdt) {
        if (zdt.getNano() == 0) {
            return zdt.plusNanos(777000000L).toString().replaceAll("[.]777", ".000").replaceAll("Z\\[UTC\\]", "Z");
        }
        return zdt.toString().replaceAll("Z\\[UTC\\]", "Z");
    }

    public static String toPaddedString(OffsetDateTime odt) {
        if (odt.getNano() == 0) {
            return odt.plusNanos(777000000L).toString().replaceAll("[.]777", ".000");
        }
        return odt.toString();
    }

    public static String toString(long date) {
        return TemporalUtil.toString(Instant.ofEpochMilli(date));
    }

    public static String toString(Timestamp timestamp) {
        return TemporalUtil.toString(timestamp.toInstant());
    }

    public static String toString(OraTemporalDatum temporalDatum) {
        if (temporalDatum.getResolution() == OraTemporalDatum.Resolution.LOCAL) {
            return TemporalUtil.toString(temporalDatum.toLocalDateTime());
        }
        if (temporalDatum.userTimeZoneSupported()) {
            return TemporalUtil.toString(temporalDatum.toZonedDateTime());
        }
        return TemporalUtil.toString(temporalDatum.toInstant());
    }

    public static String toString(Instant instant) {
        if (instant.getNano() == 0) {
            return instant.plusNanos(777000000L).toString().replaceAll("[.]777", "");
        }
        return instant.toString();
    }

    public static String toString(LocalDateTime ldt) {
        if (ldt.getNano() == 0) {
            return ldt.plusNanos(777000000L).toString().replaceAll("[.]777", "");
        }
        return ldt.toString();
    }

    public static String toString(ZonedDateTime zdt) {
        if (zdt.getNano() == 0) {
            return zdt.plusNanos(777000000L).toString().replaceAll("[.]777", "").replaceAll("Z\\[UTC\\]", "Z");
        }
        return zdt.toString().replaceAll("Z\\[UTC\\]", "Z");
    }

    public static String toString(OffsetDateTime odt) {
        if (odt.getNano() == 0) {
            return odt.plusNanos(777000000L).toString().replaceAll("[.]777", "");
        }
        return odt.toString();
    }

    public static OraTemporalDatum toOraTemporalDatum(Object obj) {
        if (obj instanceof Calendar) {
            return OraTIMESTAMPTZ.getInstance((Calendar)obj);
        }
        if (obj instanceof ZonedDateTime) {
            return OraTIMESTAMPTZ.getInstance((ZonedDateTime)obj);
        }
        if (obj instanceof Timestamp) {
            return OraTIMESTAMP.getInstance((Timestamp)obj);
        }
        if (obj instanceof Instant) {
            return OraTIMESTAMP.getInstance((Instant)obj);
        }
        if (obj instanceof LocalDateTime) {
            return OraTIMESTAMP.getInstance((LocalDateTime)obj);
        }
        if (obj instanceof Date) {
            return OraDATE.getInstance((Date)obj);
        }
        if (obj instanceof CharSequence) {
            String date = obj.toString();
            String errMsg = "Not a correctly formatted timestamp: " + date;
            try {
                try {
                    ZonedDateTime zdt = ZonedDateTime.parse(date, DateTimeFormatter.ISO_ZONED_DATE_TIME);
                    return OraTIMESTAMPTZ.getInstance(zdt);
                }
                catch (DateTimeParseException pe) {
                    LocalDateTime ldt = LocalDateTime.parse(date, DateTimeFormatter.ISO_DATE_TIME);
                    return OraTIMESTAMP.getInstance(ldt);
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException(errMsg);
            }
        }
        throw new IllegalArgumentException("Unsupported temporal type: " + obj.getClass().getCanonicalName());
    }

    public static Timestamp toTimestamp(Object obj) {
        return TemporalUtil.toOraTemporalDatum(obj).toTimestamp();
    }

    @Deprecated
    public static long valueOf(String date) {
        return TemporalUtil.toTimestamp(date).getTime();
    }

    public static String ISO8601format(OraINTERVALYM interval) {
        StringBuilder sb = new StringBuilder();
        if (interval != null) {
            int sign = interval.get(0);
            int years = interval.get(1);
            int months = interval.get(2);
            if (years != 0 || months != 0) {
                if (sign == -1) {
                    sb.append('-');
                }
                sb.append('P');
                if (years != 0) {
                    sb.append(String.format("%d", years));
                    sb.append('Y');
                }
                if (months != 0) {
                    sb.append(String.format("%d", months));
                    sb.append('M');
                }
            } else {
                sb.append("P0Y0M");
            }
            return sb.toString();
        }
        return null;
    }

    public static OraINTERVALYM YM_ISO8601parse(CharSequence text) {
        OraINTERVALYM interval = OraINTERVALYM.getInstance();
        if (text != null) {
            Matcher matcher = YM_PATTERN.matcher(text);
            if (matcher.matches()) {
                boolean negate = "-".equals(matcher.group(1));
                String yearMatch = matcher.group(2);
                String monthMatch = matcher.group(3);
                int sign = negate ? -1 : 1;
                int years = yearMatch != null && yearMatch.length() > 0 ? Integer.valueOf(yearMatch) : 0;
                int months = monthMatch != null && monthMatch.length() > 0 ? Integer.valueOf(monthMatch) : 0;
                interval.set(0, sign);
                interval.set(1, years);
                interval.set(2, months);
            }
        } else {
            return null;
        }
        return interval;
    }

    public static String ISO8601format(OraINTERVALDS interval) {
        StringBuilder sb = new StringBuilder();
        if (interval != null) {
            int sign = interval.get(0);
            int days = interval.get(1);
            int hours = interval.get(2);
            int minutes = interval.get(3);
            int seconds = interval.get(4);
            int nanos = interval.get(5);
            if (days != 0 || hours != 0 || minutes != 0 || seconds != 0 || nanos != 0) {
                if (sign == -1) {
                    sb.append('-');
                }
                sb.append('P');
                if (days != 0) {
                    sb.append(String.format("%d", days));
                    sb.append('D');
                }
                if (hours != 0 || minutes != 0 || seconds != 0 || nanos != 0) {
                    sb.append('T');
                    if (hours != 0) {
                        sb.append(String.format("%d", hours));
                        sb.append('H');
                    }
                    if (minutes != 0) {
                        sb.append(String.format("%d", minutes));
                        sb.append('M');
                    }
                    String frationalNanos = TemporalUtil.formatNanos(nanos);
                    if (seconds != 0 || frationalNanos != null) {
                        sb.append(String.format("%d", seconds));
                        if (frationalNanos != null) {
                            sb.append('.');
                            sb.append(frationalNanos);
                        }
                        sb.append('S');
                    }
                }
            } else {
                sb.append("P0DT0H0M0S");
            }
            return sb.toString();
        }
        return null;
    }

    public static OraINTERVALDS DS_ISO8601parse(CharSequence text) {
        OraINTERVALDS interval = OraINTERVALDS.getInstance();
        if (text != null) {
            Matcher matcher = DS_PATTERN.matcher(text);
            if (matcher.matches()) {
                boolean negate = "-".equals(matcher.group(1));
                String daysMatch = matcher.group(2);
                matcher.group(3);
                String hoursMatch = matcher.group(4);
                String minutesMatch = matcher.group(5);
                String secondsMatch = matcher.group(6);
                String nanosMatch = matcher.group(7);
                int sign = negate ? -1 : 1;
                int days = daysMatch != null && daysMatch.length() > 0 ? Integer.valueOf(daysMatch) : 0;
                int hours = hoursMatch != null && hoursMatch.length() > 0 ? Integer.valueOf(hoursMatch) : 0;
                int minutes = minutesMatch != null && minutesMatch.length() > 0 ? Integer.valueOf(minutesMatch) : 0;
                int seconds = secondsMatch != null && secondsMatch.length() > 0 ? Integer.valueOf(secondsMatch) : 0;
                int nanos = TemporalUtil.formatNanos(nanosMatch);
                interval.set(0, sign);
                interval.set(1, days);
                interval.set(2, hours);
                interval.set(3, minutes);
                interval.set(4, seconds);
                interval.set(5, nanos);
            }
        } else {
            return null;
        }
        return interval;
    }

    private static String formatNanos(int nanos) {
        if (nanos == 0) {
            return null;
        }
        String fractionalNanos = String.format("%09d", nanos);
        return fractionalNanos.replaceAll("0*$", "");
    }

    private static int formatNanos(String fractionalNanos) {
        if (fractionalNanos == null || ((String)fractionalNanos).length() == 0) {
            return 0;
        }
        fractionalNanos = (String)fractionalNanos + "000000000";
        fractionalNanos = ((String)fractionalNanos).substring(0, 9);
        try {
            return Integer.parseInt((String)fractionalNanos);
        }
        catch (ArithmeticException | NumberFormatException ex) {
            return 0;
        }
    }
}

