/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.sql;

import java.sql.SQLException;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeIllegalArgumentException;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.oracle.sql.Datum;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import oracle.dbtools.raptor.utils.NLSUtils;

public abstract class NumericDatum
extends Datum {
    protected NumericDatum(DataTypeContext context, TypeMetadata typeMetadata) {
        super(context, typeMetadata);
    }

    @Override
    protected StringValue customStringValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, StringType stringType, int maxLen) {
        switch (stringType) {
            case NLS: {
                try {
                    return new StringValue((CharSequence)NLSUtils.getValue(connectionProvider.getNLSConnection(), value.getInternalValue()));
                }
                catch (NullPointerException e) {
                    return this.customStringValue(connectionProvider, value, StringType.GENERIC, maxLen);
                }
            }
        }
        return super.customStringValue(connectionProvider, value, stringType, maxLen);
    }

    @Override
    protected Object customInternalValue(DataTypeConnectionProvider connectionProvider, Object value) {
        return this.getScaledInternalValue(connectionProvider, this.customUnscaledInternalValue(connectionProvider, value));
    }

    protected final Object getScaledInternalValue(DataTypeConnectionProvider connectionProvider, Object value) {
        try {
            return value == null ? value : this.customScaleInternalValue(connectionProvider, value);
        }
        catch (SQLException e) {
            throw new DataTypeIllegalArgumentException(this, value);
        }
    }

    protected Object customUnscaledInternalValue(DataTypeConnectionProvider connectionProvider, Object value) {
        return super.customInternalValue(connectionProvider, value);
    }

    protected Object customScaleInternalValue(DataTypeConnectionProvider connectionProvider, Object value) throws SQLException {
        return value;
    }

    protected boolean isPosInf(String str) {
        return str != null && (str.equalsIgnoreCase("Infinity") || str.equalsIgnoreCase("+Infinity") || str.equalsIgnoreCase("INF") || str.equalsIgnoreCase("+INF") || str.equalsIgnoreCase("~") || str.equalsIgnoreCase("+~"));
    }

    protected boolean isNegInf(String str) {
        return str != null && (str.equalsIgnoreCase("-Infinity") || str.equalsIgnoreCase("-INF") || str.equalsIgnoreCase("-~"));
    }

    protected boolean isNaN(String str) {
        return str != null && str.equalsIgnoreCase("NaN");
    }
}

