/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.sql;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Arrays;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeIllegalArgumentException;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.oracle.sql.NumericDatum;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.nls.OracleNLSProvider;

public class BINARY_DOUBLE
extends NumericDatum {
    protected BINARY_DOUBLE(DataTypeContext context, TypeMetadata typeMetadata) {
        super(context, typeMetadata);
    }

    @Override
    protected StringValue customStringValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, StringType stringType, int maxLen) {
        Object internalValue = value.getInternalValue();
        switch (stringType) {
            case REST: 
            case GENERIC: {
                try {
                    return new StringValue(this.getGenericStringValue((oracle.sql.BINARY_DOUBLE)internalValue));
                }
                catch (SQLException e) {
                    throw new DataTypeIllegalArgumentException(this, internalValue);
                }
            }
        }
        return super.customStringValue(connectionProvider, value, stringType, maxLen);
    }

    @Override
    protected Object customTypedValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, ValueType valueType, Object target) {
        switch (valueType) {
            case JAVA: {
                return super.customTypedValue(connectionProvider, value, ValueType.JDBC, target);
            }
            case JDBC: {
                return super.customTypedValue(connectionProvider, value, ValueType.DEFAULT, target);
            }
        }
        return super.customTypedValue(connectionProvider, value, valueType, target);
    }

    @Override
    protected Class customTypedClass(DataTypeConnectionProvider connectionProvider, ValueType valueType) {
        switch (valueType) {
            case JAVA: {
                return Double.class;
            }
            case JDBC: {
                return this.customTypedClass(connectionProvider, ValueType.DEFAULT);
            }
            case DEFAULT: {
                return oracle.sql.BINARY_DOUBLE.class;
            }
        }
        return super.customTypedClass(connectionProvider, valueType);
    }

    @Override
    protected int customSqlDataType(ValueType valueType) {
        switch (valueType) {
            case DATUM: {
                return 101;
            }
        }
        return super.customSqlDataType(valueType);
    }

    @Override
    protected Object customUnscaledInternalValue(DataTypeConnectionProvider connectionProvider, Object value) {
        try {
            if (value instanceof oracle.sql.BINARY_DOUBLE) {
                return value;
            }
            if (value instanceof Double) {
                return new oracle.sql.BINARY_DOUBLE((Double)value);
            }
            if (value instanceof byte[]) {
                return new oracle.sql.BINARY_DOUBLE(Arrays.copyOf((byte[])value, ((byte[])value).length));
            }
            String stringValue = value.toString();
            if (this.isPosInf(stringValue)) {
                return new oracle.sql.BINARY_DOUBLE(Double.POSITIVE_INFINITY);
            }
            if (this.isNegInf(stringValue)) {
                return new oracle.sql.BINARY_DOUBLE(Double.NEGATIVE_INFINITY);
            }
            if (this.isNaN(stringValue)) {
                return new oracle.sql.BINARY_DOUBLE(Double.NaN);
            }
            try {
                return new oracle.sql.BINARY_DOUBLE(Double.valueOf(stringValue));
            }
            catch (Exception e1) {
                return this.typedValueFromNLSString(connectionProvider, stringValue);
            }
        }
        catch (SQLException e) {
            throw new DataTypeIllegalArgumentException(this, value);
        }
    }

    protected oracle.sql.BINARY_DOUBLE typedValueFromNLSString(DataTypeConnectionProvider connectionProvider, String value) throws SQLException {
        return new oracle.sql.BINARY_DOUBLE(((OracleNLSProvider)NLSProvider.getProvider(connectionProvider.getNLSConnection())).parseNumber(value).doubleValue());
    }

    private BigDecimal getBigDecimal(oracle.sql.BINARY_DOUBLE dbl) throws SQLException {
        BigDecimal ret = null;
        if (dbl != null) {
            ret = new BigDecimal(dbl.stringValue());
        }
        return ret;
    }

    private String getGenericStringValue(oracle.sql.BINARY_DOUBLE dbl) throws SQLException {
        String ret = null;
        if (dbl != null) {
            ret = this.getBigDecimal(dbl).toString();
        }
        return ret;
    }
}

