/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.plsql;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeFactory;
import oracle.dbtools.raptor.datatypes.DataTypeFactoryExtension;
import oracle.dbtools.raptor.datatypes.DataTypeProvider;
import oracle.dbtools.raptor.datatypes.NamedValue;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.impl.AbstractDataTypeProviderImpl;
import oracle.dbtools.raptor.datatypes.metadata.ArgMetadata;
import oracle.dbtools.raptor.datatypes.metadata.MetadataLoader;
import oracle.dbtools.raptor.datatypes.oracle.plsql.BINARY_INTEGER;
import oracle.dbtools.raptor.datatypes.oracle.plsql.BOOLEAN;
import oracle.dbtools.raptor.datatypes.oracle.plsql.CURSOR_FOR;
import oracle.dbtools.raptor.datatypes.oracle.plsql.FLOAT;
import oracle.dbtools.raptor.datatypes.oracle.plsql.NATURAL;
import oracle.dbtools.raptor.datatypes.oracle.plsql.NATURALN;
import oracle.dbtools.raptor.datatypes.oracle.plsql.PLSQL_INDEX_TABLE;
import oracle.dbtools.raptor.datatypes.oracle.plsql.POSITIVE;
import oracle.dbtools.raptor.datatypes.oracle.plsql.POSITIVEN;
import oracle.dbtools.raptor.datatypes.oracle.plsql.RECORD;
import oracle.dbtools.raptor.datatypes.oracle.plsql.SIGNTYPE;
import oracle.dbtools.raptor.datatypes.oracle.plsql.SIMPLE_INTEGER;

public final class OraclePLSQLDataTypeFactory
extends AbstractDataTypeProviderImpl {
    private final PLSQLDataTypeProviderAccess providerAccess = new PLSQLDataTypeProviderAccess();
    private static final String PLSQL_RECORD = "PL/SQL RECORD";
    private static final String PLSQL_INDEX_TABLE = "PL/SQL INDEX TABLE";
    private static final String PLSQL_TABLE = "PL/SQL TABLE";
    private static final String TABLE = "TABLE";
    private static final String ARRAY = "ARRAY";
    private static final String VARRAY = "VARRAY";
    private static final String VARYING_ARRAY = "VARYING ARRAY";
    private static final String CURSOR_FOR_NAME = CURSOR_FOR.class.getName();
    private static OraclePLSQLDataTypeFactory instance;
    private static final Map<String, NamedValue<Map<TypeMetadata.Attribute, Object>>> typeMetadataProps;

    @Override
    protected PLSQLDataTypeProviderAccess getDataTypeProviderAccess() {
        return this.providerAccess;
    }

    public static Builder builder(URI dataTypeProviderURI) {
        return new Builder(dataTypeProviderURI);
    }

    public OraclePLSQLDataTypeFactory(DataTypeFactoryExtension.ExtensionAccess extensionAccess, URI dataTypeProviderURI, DataTypeProvider next, Map<String, NamedValue<Map<TypeMetadata.Attribute, Object>>> typeMetadataProps) {
        super(extensionAccess, dataTypeProviderURI, next, typeMetadataProps);
    }

    protected boolean isStructuredType(String typeName) {
        return PLSQL_RECORD.equals(typeName) || PLSQL_TABLE.equals(typeName) || PLSQL_INDEX_TABLE.equals(typeName) || TABLE.equals(typeName) || ARRAY.equals(typeName) || VARRAY.equals(typeName) || VARYING_ARRAY.equals(typeName);
    }

    protected boolean isSupportedType(String typeName) {
        return PLSQL_RECORD.equals(typeName) || PLSQL_TABLE.equals(typeName) || PLSQL_INDEX_TABLE.equals(typeName);
    }

    @Override
    protected boolean customSupportedType(TypeMetadata typeMetadata) {
        return super.customSupportedType(typeMetadata) && (typeMetadata.get_type_name() == null && typeMetadata.get_type_subname() == null || typeMetadata.get_type_name() != null && typeMetadata.get_type_subname() != null && typeMetadata.get_base_type() != null && this.isSupportedType(typeMetadata.get_base_type()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TypeMetadata customRefineTypeMetadata(DataTypeContext context, TypeMetadata typeMetadata) {
        TypeMetadata candidate;
        block40: {
            candidate = typeMetadata;
            boolean triedSynonym = false;
            while (true) {
                HashMap<TypeMetadata.Attribute, Object> attributeMap3;
                DataTypeConnectionProvider provider;
                Object conn;
                String type_owner;
                if ((type_owner = candidate.get_type_owner()) == null) {
                    return candidate;
                }
                String type_subname = candidate.get_type_subname();
                if (type_subname == null) {
                    return candidate;
                }
                String type_name = candidate.get_type_name();
                if (type_name == null || candidate.get_type_link() != null) {
                    return candidate;
                }
                String data_type = candidate.get_data_type();
                if (data_type == null) {
                    HashMap<TypeMetadata.Attribute, Object> attributeMap2 = new HashMap<TypeMetadata.Attribute, Object>();
                    DataTypeConnectionProvider provider2 = context.getDataTypeConnectionProvider();
                    conn = provider2.getDataTypeConnection();
                    if (conn != null) {
                        provider2.lockDataTypeConnection();
                        try {
                            new MetadataLoader((Connection)conn).loadPLSQLType(attributeMap2, type_owner, type_name, type_subname);
                        }
                        catch (Exception exception) {
                        }
                        finally {
                            provider2.unlockDataTypeConnection();
                        }
                    }
                    if (!attributeMap2.isEmpty()) {
                        candidate = DataTypeFactory.getTypeMetadata(candidate, attributeMap2);
                        data_type = candidate.get_data_type();
                    }
                }
                if ("COLLECTION".equals(data_type)) {
                    provider = context.getDataTypeConnectionProvider();
                    attributeMap3 = new HashMap<TypeMetadata.Attribute, Object>();
                    conn = provider.getDataTypeConnection();
                    if (conn != null) {
                        provider.lockDataTypeConnection();
                        try {
                            LinkedList<ArgMetadata> loadStack = new LinkedList<ArgMetadata>();
                            new MetadataLoader((Connection)conn).loadPLSQLCollection(loadStack, type_owner, type_name, type_subname, 0);
                            if (!loadStack.isEmpty()) {
                                ArgMetadata collArgMetadata = (ArgMetadata)loadStack.pop();
                                String collType = (String)((Map)collArgMetadata.getValue()).get((Object)TypeMetadata.Attribute.DATA_TYPE);
                                attributeMap3.put(TypeMetadata.Attribute.DATA_TYPE, collType);
                                List<NamedValue<TypeMetadata>> typeComponents = candidate.get_type_components();
                                if (typeComponents == null) {
                                    LinkedList<NamedValue<TypeMetadata>> components = new LinkedList<NamedValue<TypeMetadata>>();
                                    while (!loadStack.isEmpty() && ((ArgMetadata)loadStack.peek()).getIdentifier().getLevel() == 1) {
                                        ArgMetadata componentArgMetadata = (ArgMetadata)loadStack.pop();
                                        TypeMetadata componentTypeMetadata = context.getDataTypeFactory().getTypeMetadata((Map)componentArgMetadata.getValue());
                                        components.add(new NamedValue<TypeMetadata>(componentArgMetadata.getName(), componentTypeMetadata));
                                    }
                                    if (components.size() > 0) {
                                        attributeMap3.put(TypeMetadata.Attribute.TYPE_COMPONENTS, components);
                                    }
                                }
                            }
                        }
                        catch (Exception exception) {
                        }
                        finally {
                            provider.unlockDataTypeConnection();
                        }
                    }
                    if (!attributeMap3.isEmpty()) {
                        return DataTypeFactory.getTypeMetadata(candidate, attributeMap3);
                    }
                } else if (PLSQL_INDEX_TABLE.equals(data_type) || PLSQL_TABLE.equals(data_type)) {
                    List<NamedValue<TypeMetadata>> attributes = null;
                    try {
                        if (typeMetadata.getAttribute(TypeMetadata.Attribute.TYPE_COMPONENTS) == null) {
                            attributes = oracle.dbtools.raptor.datatypes.oracle.plsql.PLSQL_INDEX_TABLE.loadAttributes(context, typeMetadata);
                        }
                    }
                    catch (Exception attributeMap3) {
                        // empty catch block
                    }
                    if (attributes != null && !attributes.isEmpty()) {
                        attributeMap3 = new HashMap();
                        attributeMap3.put(TypeMetadata.Attribute.TYPE_COMPONENTS, attributes);
                        return DataTypeFactory.getTypeMetadata(candidate, attributeMap3);
                    }
                } else if (data_type != null) break block40;
                if (candidate != typeMetadata) break block40;
                if (triedSynonym) {
                    return candidate;
                }
                triedSynonym = true;
                provider = context.getDataTypeConnectionProvider();
                attributeMap3 = new HashMap();
                conn = provider.getDataTypeConnection();
                if (conn != null) {
                    provider.lockDataTypeConnection();
                    try {
                        new MetadataLoader((Connection)conn).followSQLSynonym(attributeMap3, type_owner, type_name);
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        provider.unlockDataTypeConnection();
                    }
                }
                if (attributeMap3.isEmpty()) break;
                candidate = DataTypeFactory.getTypeMetadata(candidate, attributeMap3);
            }
            return candidate;
        }
        return candidate;
    }

    @Override
    protected TypeMetadata customFilterExpandedTypeMetadata(TypeMetadata expandedTypeMetadata, TypeMetadata typeMetadata) {
        String implDataType;
        String implClassName;
        if (expandedTypeMetadata != null && CURSOR_FOR_NAME.equals(implClassName = expandedTypeMetadata.get_impl_class_name()) && typeMetadata != null && ((implDataType = typeMetadata.get_impl_data_type()) == null || !implDataType.equals("PL/SQL CURSOR_FOR"))) {
            return null;
        }
        return super.customFilterExpandedTypeMetadata(expandedTypeMetadata, typeMetadata);
    }

    @Override
    public void close() throws IOException {
    }

    static {
        typeMetadataProps = new HashMap<String, NamedValue<Map<TypeMetadata.Attribute, Object>>>(){
            {
                this.put("PL/SQL BOOLEAN", new NamedValue<1>(null, new HashMap<TypeMetadata.Attribute, Object>(){
                    {
                        this.put(TypeMetadata.Attribute.TYPE_CODE, 16);
                        this.put(TypeMetadata.Attribute.IMPL_CLASS, BOOLEAN.class);
                    }
                }));
                this.put("BOOLEAN", new NamedValue<Object>("PL/SQL BOOLEAN", null));
                this.put("BINARY_INTEGER", new NamedValue<2>("INTEGER", new HashMap<TypeMetadata.Attribute, Object>(){
                    {
                        this.put(TypeMetadata.Attribute.BASE_TYPE, "BINARY_INTEGER");
                        this.put(TypeMetadata.Attribute.IMPL_CLASS, BINARY_INTEGER.class);
                    }
                }));
                this.put("FLOAT", new NamedValue<3>("NUMBER", new HashMap<TypeMetadata.Attribute, Object>(){
                    {
                        this.put(TypeMetadata.Attribute.TYPE_CODE, 6);
                        this.put(TypeMetadata.Attribute.BASE_TYPE, "FLOAT");
                        this.put(TypeMetadata.Attribute.IMPL_CLASS, FLOAT.class);
                    }
                }));
                this.put("DOUBLE PRECISION", new NamedValue<4>("FLOAT", new HashMap<TypeMetadata.Attribute, Object>(){
                    {
                        this.put(TypeMetadata.Attribute.TYPE_CODE, 8);
                        this.put(TypeMetadata.Attribute.BASE_TYPE, "DOUBLE PRECISION");
                    }
                }));
                this.put("REAL", new NamedValue<5>("FLOAT", new HashMap<TypeMetadata.Attribute, Object>(){
                    {
                        this.put(TypeMetadata.Attribute.TYPE_CODE, 7);
                        this.put(TypeMetadata.Attribute.BASE_TYPE, "REAL");
                    }
                }));
                this.put("PLS_INTEGER", new NamedValue<6>("BINARY_INTEGER", new HashMap<TypeMetadata.Attribute, Object>(){
                    {
                        this.put(TypeMetadata.Attribute.BASE_TYPE, "PLS_INTEGER");
                    }
                }));
                this.put("NATURAL", new NamedValue<7>("BINARY_INTEGER", new HashMap<TypeMetadata.Attribute, Object>(){
                    {
                        this.put(TypeMetadata.Attribute.BASE_TYPE, "NATURAL");
                        this.put(TypeMetadata.Attribute.IMPL_CLASS, NATURAL.class);
                    }
                }));
                this.put("NATURALN", new NamedValue<8>("BINARY_INTEGER", new HashMap<TypeMetadata.Attribute, Object>(){
                    {
                        this.put(TypeMetadata.Attribute.BASE_TYPE, "NATURALN");
                        this.put(TypeMetadata.Attribute.IMPL_CLASS, NATURALN.class);
                    }
                }));
                this.put("POSITIVE", new NamedValue<9>("BINARY_INTEGER", new HashMap<TypeMetadata.Attribute, Object>(){
                    {
                        this.put(TypeMetadata.Attribute.BASE_TYPE, "POSITIVE");
                        this.put(TypeMetadata.Attribute.IMPL_CLASS, POSITIVE.class);
                    }
                }));
                this.put("POSITIVEN", new NamedValue<10>("BINARY_INTEGER", new HashMap<TypeMetadata.Attribute, Object>(){
                    {
                        this.put(TypeMetadata.Attribute.BASE_TYPE, "POSITIVEN");
                        this.put(TypeMetadata.Attribute.IMPL_CLASS, POSITIVEN.class);
                    }
                }));
                this.put("SIMPLE_INTEGER", new NamedValue<11>("BINARY_INTEGER", new HashMap<TypeMetadata.Attribute, Object>(){
                    {
                        this.put(TypeMetadata.Attribute.BASE_TYPE, "SIMPLE_INTEGER");
                        this.put(TypeMetadata.Attribute.IMPL_CLASS, SIMPLE_INTEGER.class);
                    }
                }));
                this.put("SIGNTYPE", new NamedValue<12>("BINARY_INTEGER", new HashMap<TypeMetadata.Attribute, Object>(){
                    {
                        this.put(TypeMetadata.Attribute.BASE_TYPE, "SIGNTYPE");
                        this.put(TypeMetadata.Attribute.IMPL_CLASS, SIGNTYPE.class);
                    }
                }));
                this.put(OraclePLSQLDataTypeFactory.PLSQL_INDEX_TABLE, new NamedValue<13>(null, new HashMap<TypeMetadata.Attribute, Object>(){
                    {
                        this.put(TypeMetadata.Attribute.TYPE_CODE, -14);
                        this.put(TypeMetadata.Attribute.IMPL_CLASS, PLSQL_INDEX_TABLE.class);
                        this.put(TypeMetadata.Attribute.TYPE_COMPONENTS, null);
                    }
                }));
                this.put(OraclePLSQLDataTypeFactory.PLSQL_RECORD, new NamedValue<14>(null, new HashMap<TypeMetadata.Attribute, Object>(){
                    {
                        this.put(TypeMetadata.Attribute.TYPE_CODE, -333);
                        this.put(TypeMetadata.Attribute.IMPL_CLASS, RECORD.class);
                        this.put(TypeMetadata.Attribute.TYPE_COMPONENTS, null);
                    }
                }));
                this.put(OraclePLSQLDataTypeFactory.PLSQL_TABLE, new NamedValue<Object>(OraclePLSQLDataTypeFactory.PLSQL_INDEX_TABLE, null));
                this.put(OraclePLSQLDataTypeFactory.VARYING_ARRAY, new NamedValue<Object>(OraclePLSQLDataTypeFactory.ARRAY, null));
                this.put(OraclePLSQLDataTypeFactory.VARRAY, new NamedValue<Object>(OraclePLSQLDataTypeFactory.VARYING_ARRAY, null));
                this.put(OraclePLSQLDataTypeFactory.TABLE, new NamedValue<15>(OraclePLSQLDataTypeFactory.VARRAY, new HashMap<TypeMetadata.Attribute, Object>(){
                    {
                        this.put(TypeMetadata.Attribute.BASE_TYPE, OraclePLSQLDataTypeFactory.TABLE);
                    }
                }));
                this.put("TIMESTAMP(9)", new NamedValue<16>("TIMESTAMP", new HashMap<TypeMetadata.Attribute, Object>(){
                    {
                        this.put(TypeMetadata.Attribute.DATA_SCALE, 9);
                    }
                }));
                this.put("TIMESTAMP_UNCONSTRAINED", new NamedValue<Object>("TIMESTAMP(9)", null));
                this.put("TIMESTAMP(9) WITH TIME ZONE", new NamedValue<17>("TIMESTAMP WITH TIME ZONE", new HashMap<TypeMetadata.Attribute, Object>(){
                    {
                        this.put(TypeMetadata.Attribute.DATA_SCALE, 9);
                    }
                }));
                this.put("TIMESTAMP_TZ_UNCONSTRAINED", new NamedValue<Object>("TIMESTAMP(9) WITH TIME ZONE", null));
                this.put("TIMESTAMP(9) WITH LOCAL TIME ZONE", new NamedValue<18>("TIMESTAMP WITH LOCAL TIME ZONE", new HashMap<TypeMetadata.Attribute, Object>(){
                    {
                        this.put(TypeMetadata.Attribute.DATA_SCALE, 9);
                    }
                }));
                this.put("TIMESTAMP_LTZ_UNCONSTRAINED", new NamedValue<Object>("TIMESTAMP(9) WITH LOCAL TIME ZONE", null));
                this.put("INTERVAL DAY(9) TO SECOND(9)", new NamedValue<19>("INTERVAL DAY TO SECOND", new HashMap<TypeMetadata.Attribute, Object>(){
                    {
                        this.put(TypeMetadata.Attribute.DATA_PRECISION, 9);
                        this.put(TypeMetadata.Attribute.DATA_SCALE, 9);
                    }
                }));
                this.put("DSINTERVAL_UNCONSTRAINED", new NamedValue<Object>("INTERVAL DAY(9) TO SECOND(9)", null));
                this.put("INTERVAL YEAR(9) TO MONTH", new NamedValue<20>("INTERVAL YEAR TO MONTH", new HashMap<TypeMetadata.Attribute, Object>(){
                    {
                        this.put(TypeMetadata.Attribute.DATA_PRECISION, 9);
                    }
                }));
                this.put("YMINTERVAL_UNCONSTRAINED", new NamedValue<Object>("INTERVAL YEAR(9) TO MONTH", null));
                this.put("PL/SQL CURSOR_FOR", new NamedValue<21>(null, new HashMap<TypeMetadata.Attribute, Object>(){
                    {
                        this.put(TypeMetadata.Attribute.TYPE_CODE, -10);
                        this.put(TypeMetadata.Attribute.IMPL_CLASS, CURSOR_FOR.class);
                    }
                }));
                this.put("CURSOR", new NamedValue<Object>("PL/SQL CURSOR_FOR", null));
                this.put("REF CURSOR", new NamedValue<Object>("CURSOR", null));
            }
        };
    }

    public static final class Builder
    extends AbstractDataTypeProviderImpl.Builder {
        public static final URI ID;

        private Builder(URI dataTypeProviderURI) {
            super(dataTypeProviderURI);
        }

        @Override
        public PLSQLDataTypeProviderAccess build() {
            OraclePLSQLDataTypeFactory datatypeFactory = new OraclePLSQLDataTypeFactory(this.getExtensionAccess(), this.getDataTypeProviderURI(), this.getExtensionAccess().resolveDataTypeProvider(this.getSuperDataTypeProviderURI()), typeMetadataProps);
            return datatypeFactory.getDataTypeProviderAccess();
        }

        @Override
        public Builder setExtensionAccess(DataTypeFactoryExtension.ExtensionAccess extensionAccess) {
            super.setExtensionAccess(extensionAccess);
            return this;
        }

        @Override
        public Builder setSuperDataTypeProviderURI(URI superDataTypeProvider) {
            super.setSuperDataTypeProviderURI(superDataTypeProvider);
            return this;
        }

        static {
            URI tmpURI = null;
            try {
                tmpURI = new URI("http://www.oracle.com/raptor/datatypes/providers/plsql/");
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            ID = tmpURI;
        }
    }

    public class PLSQLDataTypeProviderAccess
    implements DataTypeProvider.DataTypeProviderAccess {
        protected PLSQLDataTypeProviderAccess() {
        }

        @Override
        public DataTypeProvider getDataTypeProvider() {
            return OraclePLSQLDataTypeFactory.this;
        }

        @Override
        public DataTypeFactoryExtension.ExtensionAccess getExtensionAccess() {
            return OraclePLSQLDataTypeFactory.this.getExtensionAccess();
        }

        @Override
        public DataTypeFactory getDataTypeFactory() {
            return this.getExtensionAccess().getDataTypeFactory();
        }
    }
}

