/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.metadata;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import oracle.dbtools.raptor.datatypes.metadata.SigMetadata;
import oracle.dbtools.raptor.utils.DataTypesUtil;

public final class ProgMetadata {
    final TreeMap<Integer, SigMetadata> signatures;
    final ProgIdentifier identifier;
    Integer minSigOverload;
    Integer maxSigOverLoad;

    public ProgMetadata(ProgIdentifier identifier, List<SigMetadata> signatures) {
        this.identifier = identifier;
        this.signatures = new TreeMap(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                if (o1 == null) {
                    if (o2 != null) {
                        return -1;
                    }
                    return 0;
                }
                if (o2 == null) {
                    return 1;
                }
                return o1.compareTo(o2);
            }
        });
        this.minSigOverload = null;
        this.maxSigOverLoad = null;
        if (signatures != null) {
            for (SigMetadata signature : signatures) {
                this.addSignature(signature);
            }
        }
    }

    public ProgMetadata(ProgIdentifier identifier) {
        this(identifier, null);
    }

    public ProgIdentifier getIdentifier() {
        return this.identifier;
    }

    public Integer getMinSigOverload() {
        return this.minSigOverload;
    }

    public Integer getMaxSigOverload() {
        return this.maxSigOverLoad;
    }

    public SigMetadata getSignature(Integer overload) {
        return this.signatures.get(overload);
    }

    boolean addSignature(SigMetadata signature) {
        if (signature != null) {
            Integer overload = signature.identifier.overload;
            SigMetadata oldSignature = this.signatures.put(overload, signature);
            if (oldSignature != null && oldSignature != signature) {
                this.signatures.put(oldSignature.identifier.overload, oldSignature);
                throw new IllegalArgumentException();
            }
            if (this.minSigOverload == null || overload == null || this.minSigOverload > overload) {
                this.minSigOverload = overload;
            }
            if (this.maxSigOverLoad == null || overload != null && this.maxSigOverLoad < overload) {
                this.maxSigOverLoad = overload;
            }
            return true;
        }
        throw new IllegalArgumentException();
    }

    public int countSignatures() {
        return this.signatures.size();
    }

    public Iterator<SigMetadata> signatureIterator() {
        return this.signatures.values().iterator();
    }

    boolean identifiedBy(ProgIdentifier identifier) {
        return this.identifier.matches(identifier);
    }

    public static final class ProgIdentifier
    implements Cloneable {
        final String owner;
        final String objectName;
        final String packageName;
        static final ProgIdentifier NULL_PROG_ID = new ProgIdentifier();

        public ProgIdentifier(String owner, String objectName, String packageName) {
            this.owner = owner;
            this.objectName = objectName;
            this.packageName = packageName;
        }

        public ProgIdentifier() {
            this(null, null, null);
        }

        public Object clone() {
            return new ProgIdentifier(this.owner, this.objectName, this.packageName);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ProgIdentifier) {
                ProgIdentifier other = (ProgIdentifier)obj;
                return DataTypesUtil.areEqual(this.owner, other.owner) && DataTypesUtil.areEqual(this.objectName, other.objectName) && DataTypesUtil.areEqual(this.packageName, other.packageName);
            }
            return false;
        }

        public int hashCode() {
            int hash = 23;
            hash = 31 * hash + (null == this.owner ? 0 : this.owner.hashCode());
            hash = 31 * hash + (null == this.objectName ? 0 : this.objectName.hashCode());
            hash = 31 * hash + (null == this.packageName ? 0 : this.packageName.hashCode());
            return hash;
        }

        public String getOwner() {
            return this.owner;
        }

        public String getObjectName() {
            return this.objectName;
        }

        public String getPackageName() {
            return this.packageName;
        }

        boolean matches(ProgIdentifier identifier) {
            return DataTypesUtil.areEqual(this, identifier != null ? identifier : NULL_PROG_ID);
        }
    }
}

