/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.metadata;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.metadata.ArgMetadata;
import oracle.dbtools.raptor.datatypes.metadata.LoadedArgMetadata;
import oracle.dbtools.raptor.datatypes.metadata.MetadataUtil;
import oracle.dbtools.raptor.datatypes.metadata.ProgMetadata;
import oracle.dbtools.raptor.datatypes.metadata.SigMetadata;
import oracle.dbtools.raptor.utils.DataTypesUtil;

public class MetadataLoader {
    final Connection conn;

    public MetadataLoader(Connection conn) {
        this.conn = conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSignatureArguments(Deque<LoadedArgMetadata> loadStack, String _objName, String _objOwner, String _objCall, Integer _objOverload) throws SQLException {
        HashMap<String, String> binds = new HashMap<String, String>();
        ResultSet rset = null;
        try {
            DBUtil dbUtil = DBUtil.getInstance(this.conn);
            dbUtil.setRaiseError(false);
            String query = MetadataUtil.getQuery(this.conn, "loadArguments");
            binds.put("OBJECT_OWNER", _objOwner);
            binds.put("OBJECT_NAME", _objName);
            binds.put("OBJECT_CALL", _objCall);
            binds.put("OVERLOAD", _objOverload != null ? _objOverload.toString() : null);
            rset = dbUtil.executeOracleQuery(query, binds);
            if (rset != null) {
                while (rset.next()) {
                    LoadedArgMetadata loadedArgMetadata = new LoadedArgMetadata(this.loadArgMetadata(rset), this.loadSigIdentifier(rset), this.loadProgIdentifier(rset));
                    loadStack.push(loadedArgMetadata);
                }
            }
        }
        catch (Throwable throwable) {
            DBUtil.closeResultSet(rset);
            throw throwable;
        }
        DBUtil.closeResultSet(rset);
    }

    private ProgMetadata.ProgIdentifier loadProgIdentifier(ResultSet rset) throws SQLException {
        return new ProgMetadata.ProgIdentifier(rset.getString("OWNER"), rset.getString("OBJECT_NAME"), rset.getString("PACKAGE_NAME"));
    }

    private SigMetadata.SigIdentifier loadSigIdentifier(ResultSet rset) throws SQLException {
        return new SigMetadata.SigIdentifier(MetadataLoader.getIntegerResult(rset, "OVERLOAD"), MetadataLoader.getIntegerResult(rset, "OBJECT_ID"), MetadataLoader.getIntegerResult(rset, "SUBPROGRAM_ID"));
    }

    private ArgMetadata loadArgMetadata(ResultSet rset) throws SQLException {
        ArgMetadata argMetadata;
        String dataType = rset.getString("DATA_TYPE");
        if (dataType != null) {
            Integer charLen;
            boolean isTextual;
            String plsType = rset.getString("PLS_TYPE");
            String argName = rset.getString("ARGUMENT_NAME");
            int position = rset.getInt("POSITION");
            int level = rset.getInt("DATA_LEVEL");
            String inOut = rset.getString("IN_OUT");
            String defaulted = rset.getString("DEFAULTED");
            String defaultValue = rset.getString("DEFAULT_VALUE");
            Integer defaultLen = MetadataLoader.getIntegerResult(rset, "DEFAULT_LENGTH");
            String charSetName = rset.getString("CHARACTER_SET_NAME");
            String charUsed = rset.getString("CHAR_USED");
            boolean isCharUnit = "C".equals(charUsed);
            boolean bl = isTextual = charSetName != null || isCharUnit;
            if (!isTextual) {
                charLen = null;
                charUsed = null;
            } else {
                charLen = MetadataLoader.getIntegerResult(rset, "CHAR_LENGTH");
                if (charLen == null) {
                    charLen = 0;
                }
            }
            HashMap<TypeMetadata.Attribute, Object> attributeMap = new HashMap<TypeMetadata.Attribute, Object>();
            MetadataLoader.addAttribute(attributeMap, TypeMetadata.Attribute.DATA_TYPE, DataTypesUtil.reformatDataTypeString(dataType));
            MetadataLoader.addAttribute(attributeMap, TypeMetadata.Attribute.PLS_TYPE, DataTypesUtil.reformatDataTypeString(plsType));
            MetadataLoader.addAttribute(attributeMap, TypeMetadata.Attribute.DATA_LENGTH, MetadataLoader.getIntegerResult(rset, "DATA_LENGTH"));
            MetadataLoader.addAttribute(attributeMap, TypeMetadata.Attribute.DATA_PRECISION, MetadataLoader.getIntegerResult(rset, "DATA_PRECISION"));
            MetadataLoader.addAttribute(attributeMap, TypeMetadata.Attribute.DATA_SCALE, MetadataLoader.getIntegerResult(rset, "DATA_SCALE"));
            MetadataLoader.addAttribute(attributeMap, TypeMetadata.Attribute.DATA_RADIX, MetadataLoader.getIntegerResult(rset, "RADIX"));
            MetadataLoader.addAttribute(attributeMap, TypeMetadata.Attribute.TYPE_OWNER, rset.getString("TYPE_OWNER"));
            MetadataLoader.addAttribute(attributeMap, TypeMetadata.Attribute.TYPE_NAME, rset.getString("TYPE_NAME"));
            MetadataLoader.addAttribute(attributeMap, TypeMetadata.Attribute.TYPE_SUBNAME, rset.getString("TYPE_SUBNAME"));
            MetadataLoader.addAttribute(attributeMap, TypeMetadata.Attribute.TYPE_LINK, rset.getString("TYPE_LINK"));
            MetadataLoader.addAttribute(attributeMap, TypeMetadata.Attribute.CHAR_SET_NAME, charSetName);
            MetadataLoader.addAttribute(attributeMap, TypeMetadata.Attribute.CHAR_LENGTH, charLen);
            MetadataLoader.addAttribute(attributeMap, TypeMetadata.Attribute.CHAR_USED, charUsed);
            ArgMetadata.ArgIdentifier argIdentifier = new ArgMetadata.ArgIdentifier(position, level);
            argMetadata = new ArgMetadata(argIdentifier, argName, inOut, attributeMap, defaulted, defaultValue, defaultLen);
        } else {
            argMetadata = null;
        }
        return argMetadata;
    }

    public void loadSQLObject(Deque<ArgMetadata> loadStack, String typeOwner, String typeName, int atLevel) throws SQLException {
        this.loadSQLTypeMetadata("loadSQLObject", loadStack, typeOwner, typeName, atLevel);
    }

    public void loadSQLCollection(Deque<ArgMetadata> loadStack, String typeOwner, String typeName, int atLevel) throws SQLException {
        this.loadSQLTypeMetadata("loadSQLCollection", loadStack, typeOwner, typeName, atLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSQLType(Map<TypeMetadata.Attribute, Object> attributes, String typeOwner, String typeName) throws SQLException {
        HashMap<String, String> binds = new HashMap<String, String>();
        ResultSet rset = null;
        try {
            DBUtil dbUtil = DBUtil.getInstance(this.conn);
            dbUtil.setRaiseError(false);
            String query = MetadataUtil.getQuery(this.conn, "loadSQLType");
            if (query != null) {
                binds.put("TYPE_OWNER", typeOwner);
                binds.put("TYPE_NAME", typeName);
                rset = dbUtil.executeOracleQuery(query, binds);
                if (rset != null) {
                    while (rset.next()) {
                        attributes.put(TypeMetadata.Attribute.DATA_TYPE, rset.getString("TYPECODE"));
                    }
                }
            }
        }
        finally {
            DBUtil.closeResultSet(rset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void followSQLSynonym(Map<TypeMetadata.Attribute, Object> attributes, String typeOwner, String typeName) throws SQLException {
        HashMap<String, String> binds = new HashMap<String, String>();
        ResultSet rset = null;
        try {
            DBUtil dbUtil = DBUtil.getInstance(this.conn);
            dbUtil.setRaiseError(false);
            String query = MetadataUtil.getQuery(this.conn, "followSQLSynonym");
            if (query != null) {
                binds.put("TYPE_OWNER", typeOwner);
                binds.put("TYPE_NAME", typeName);
                rset = dbUtil.executeOracleQuery(query, binds);
                if (rset != null) {
                    while (rset.next()) {
                        attributes.put(TypeMetadata.Attribute.TYPE_OWNER, rset.getString("TABLE_OWNER"));
                        attributes.put(TypeMetadata.Attribute.TYPE_NAME, rset.getString("TABLE_NAME"));
                        attributes.put(TypeMetadata.Attribute.TYPE_LINK, rset.getString("DB_LINK"));
                    }
                }
            }
        }
        finally {
            DBUtil.closeResultSet(rset);
        }
    }

    public void loadSQLAttributes(Deque<ArgMetadata> loadStack, String typeOwner, String typeName, int atLevel) throws SQLException {
        this.loadSQLTypeMetadata("loadSQLAttributes", loadStack, typeOwner, typeName, atLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSQLTypeMetadata(String queryKey, Deque<ArgMetadata> loadStack, String typeOwner, String typeName, int atLevel) throws SQLException {
        HashMap<String, String> binds = new HashMap<String, String>();
        ResultSet rset = null;
        try {
            DBUtil dbUtil = DBUtil.getInstance(this.conn);
            dbUtil.setRaiseError(false);
            String query = MetadataUtil.getQuery(this.conn, queryKey);
            if (query != null) {
                binds.put("TYPE_OWNER", typeOwner);
                binds.put("TYPE_NAME", typeName);
                rset = dbUtil.executeOracleQuery(query, binds);
                if (rset != null) {
                    while (rset.next()) {
                        ArgMetadata argMetadata = this.loadAttrArgMetadata(DataTypeDomain.SQL, rset, atLevel);
                        loadStack.push(argMetadata);
                    }
                }
            }
        }
        finally {
            DBUtil.closeResultSet(rset);
        }
    }

    public void loadPLSQLRecord(Deque<ArgMetadata> loadStack, String typeOwner, String typePackage, String typeName, int atLevel) throws SQLException {
        this.loadPLSQLTypeMetadata("loadPLSQLRecord", loadStack, typeOwner, typePackage, typeName, atLevel);
    }

    public void loadPLSQLCollection(Deque<ArgMetadata> loadStack, String typeOwner, String typePackage, String typeName, int atLevel) throws SQLException {
        this.loadPLSQLTypeMetadata("loadPLSQLCollection", loadStack, typeOwner, typePackage, typeName, atLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPLSQLType(Map<TypeMetadata.Attribute, Object> attributes, String typeOwner, String typePackage, String typeName) throws SQLException {
        HashMap<String, String> binds = new HashMap<String, String>();
        ResultSet rset = null;
        try {
            DBUtil dbUtil = DBUtil.getInstance(this.conn);
            dbUtil.setRaiseError(false);
            String query = MetadataUtil.getQuery(this.conn, "loadPLSQLType");
            if (query != null) {
                binds.put("TYPE_OWNER", typeOwner);
                binds.put("TYPE_PACKAGE", typePackage);
                binds.put("TYPE_NAME", typeName);
                rset = dbUtil.executeOracleQuery(query, binds);
                if (rset != null) {
                    while (rset.next()) {
                        attributes.put(TypeMetadata.Attribute.DATA_TYPE, rset.getString("TYPECODE"));
                    }
                }
            }
        }
        finally {
            DBUtil.closeResultSet(rset);
        }
    }

    public void loadPLSQLAttributes(Deque<ArgMetadata> loadStack, String typeOwner, String typePackage, String typeName, int atLevel) throws SQLException {
        this.loadPLSQLTypeMetadata("loadPLSQLAttributes", loadStack, typeOwner, typePackage, typeName, atLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPLSQLTypeMetadata(String queryKey, Deque<ArgMetadata> loadStack, String typeOwner, String typePackage, String typeName, int atLevel) throws SQLException {
        HashMap<String, String> binds = new HashMap<String, String>();
        ResultSet rset = null;
        try {
            DBUtil dbUtil = DBUtil.getInstance(this.conn);
            dbUtil.setRaiseError(false);
            String query = MetadataUtil.getQuery(this.conn, queryKey);
            if (query != null) {
                binds.put("TYPE_OWNER", typeOwner);
                binds.put("TYPE_PACKAGE", typePackage);
                binds.put("TYPE_NAME", typeName);
                rset = dbUtil.executeOracleQuery(query, binds);
                if (rset != null) {
                    while (rset.next()) {
                        ArgMetadata argMetadata = this.loadAttrArgMetadata(DataTypeDomain.PLSQL, rset, atLevel);
                        loadStack.push(argMetadata);
                    }
                }
            }
        }
        finally {
            DBUtil.closeResultSet(rset);
        }
    }

    private ArgMetadata loadAttrArgMetadata(DataTypeDomain attrDomain, ResultSet rset, int atLevel) throws SQLException {
        ArgMetadata argMetadata;
        String dataType;
        String typeSubName;
        String typeCode = rset.getString("TYPECODE");
        String typeOwner = rset.getString("TYPE_OWNER");
        String typePackage = attrDomain == DataTypeDomain.PLSQL ? rset.getString("TYPE_PACKAGE") : null;
        String typeName = typePackage != null ? typePackage : rset.getString("TYPE_NAME");
        String string = typeSubName = typePackage != null ? rset.getString("TYPE_NAME") : null;
        if (typeCode != null) {
            dataType = typeCode;
        } else if (typeOwner == null && typeSubName == null) {
            dataType = typeName;
            typeName = null;
        } else {
            dataType = null;
        }
        if (dataType != null || typeName != null) {
            Integer charLen;
            boolean isTextual;
            String attrName = rset.getString("ATTR_NAME");
            int position = rset.getInt("POSITION");
            int level = rset.getInt("DATA_LEVEL") + atLevel;
            Integer len = MetadataLoader.getIntegerResult(rset, "LENGTH");
            String charSetName = rset.getString("CHARACTER_SET_NAME");
            String charUsed = rset.getString("CHAR_USED");
            boolean isCharUnit = "C".equals(charUsed);
            boolean bl = isTextual = charSetName != null || isCharUnit;
            if (!isTextual) {
                charLen = null;
                charUsed = null;
            } else {
                charLen = len;
            }
            Integer dataLen = null;
            if (!(typeCode != null || len == null || isTextual && isCharUnit)) {
                dataLen = len;
            }
            HashMap<TypeMetadata.Attribute, Object> attributeMap = new HashMap<TypeMetadata.Attribute, Object>();
            MetadataLoader.addAttribute(attributeMap, TypeMetadata.Attribute.DATA_TYPE, DataTypesUtil.reformatDataTypeString(dataType));
            MetadataLoader.addAttribute(attributeMap, TypeMetadata.Attribute.DATA_LENGTH, dataLen);
            MetadataLoader.addAttribute(attributeMap, TypeMetadata.Attribute.DATA_PRECISION, MetadataLoader.getIntegerResult(rset, "PRECISION"));
            MetadataLoader.addAttribute(attributeMap, TypeMetadata.Attribute.DATA_SCALE, MetadataLoader.getIntegerResult(rset, "SCALE"));
            MetadataLoader.addAttribute(attributeMap, TypeMetadata.Attribute.TYPE_OWNER, typeOwner);
            MetadataLoader.addAttribute(attributeMap, TypeMetadata.Attribute.TYPE_NAME, typeName);
            MetadataLoader.addAttribute(attributeMap, TypeMetadata.Attribute.TYPE_SUBNAME, typeSubName);
            MetadataLoader.addAttribute(attributeMap, TypeMetadata.Attribute.CHAR_SET_NAME, charSetName);
            MetadataLoader.addAttribute(attributeMap, TypeMetadata.Attribute.CHAR_LENGTH, charLen);
            MetadataLoader.addAttribute(attributeMap, TypeMetadata.Attribute.CHAR_USED, charUsed);
            ArgMetadata.ArgIdentifier argIdentifier = new ArgMetadata.ArgIdentifier(position, level);
            argMetadata = new ArgMetadata(argIdentifier, attrName, attributeMap);
        } else {
            argMetadata = null;
        }
        return argMetadata;
    }

    private static boolean addAttribute(Map<TypeMetadata.Attribute, Object> attributeMap, TypeMetadata.Attribute attribute, Object value) {
        if (value != null) {
            attributeMap.put(attribute, value);
            return true;
        }
        return false;
    }

    private static Integer getIntegerResult(ResultSet rset, String name) throws SQLException {
        return rset.getObject(name) != null ? Integer.valueOf(rset.getInt(name)) : null;
    }

    public static enum DataTypeDomain {
        SQL,
        PLSQL;

    }
}

