/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeExtensionObject;
import oracle.dbtools.raptor.datatypes.DataTypeFactoryExtension;
import oracle.dbtools.raptor.datatypes.DataTypeProvider;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.impl.UnsupportedDataTypeImpl;

public abstract class DataTypeProviderDelegate
extends DataTypeExtensionObject
implements DataTypeProvider {
    private DataTypeProvider delegate;
    private DataTypeProvider noxt;

    public DataTypeProviderDelegate(DataTypeFactoryExtension.ExtensionAccess extensionAccess, DataTypeProvider delegate, DataTypeProvider next) {
        super(extensionAccess);
        this.delegate = delegate;
        this.noxt = next;
    }

    public DataTypeProviderDelegate(DataTypeFactoryExtension.ExtensionAccess extensionAccess, DataTypeProvider delegate) {
        this(extensionAccess, delegate, null);
    }

    @Override
    public final DataType getDataType(DataTypeContext context, TypeMetadata typeMetadata) {
        DataType datatype = this.delegate.getDataType(context, typeMetadata);
        if (datatype == null && this.noxt != null) {
            datatype = this.noxt.getDataType(context, typeMetadata);
        }
        return datatype == null ? new UnsupportedDataTypeImpl(context, typeMetadata) : datatype;
    }

    @Override
    public final Set<String> getSupportedTypes() {
        TreeSet<String> chainTypes = this.noxt != null ? this.noxt.getSupportedTypes() : new TreeSet();
        Set<String> delegateTypes = this.delegate.getSupportedTypes();
        if (delegateTypes != null) {
            chainTypes.addAll(delegateTypes);
        }
        return chainTypes;
    }

    @Override
    public final Set<Integer> getSupportedSQLTypes() {
        TreeSet<Integer> chainTypes = this.noxt != null ? this.noxt.getSupportedSQLTypes() : new TreeSet();
        Set<Integer> delegateTypes = this.delegate.getSupportedSQLTypes();
        if (delegateTypes != null) {
            chainTypes.addAll(delegateTypes);
        }
        return chainTypes;
    }

    @Override
    public final Map<String, TypeMetadata> getSupportedTypeMetadata() {
        HashMap<String, TypeMetadata> chainTypeMetadata = this.noxt != null ? this.noxt.getSupportedTypeMetadata() : new HashMap();
        Map<String, TypeMetadata> delegateTypeMetadata = this.delegate.getSupportedTypeMetadata();
        if (delegateTypeMetadata != null) {
            chainTypeMetadata.putAll(delegateTypeMetadata);
        }
        return chainTypeMetadata;
    }

    @Override
    public final TypeMetadata getTypeMetadata(String datatype) {
        TypeMetadata typeMetaData = this.delegate.getTypeMetadata(datatype);
        return typeMetaData == null && this.noxt != null ? this.noxt.getTypeMetadata(datatype) : typeMetaData;
    }

    @Override
    public final TypeMetadata getTypeMetadata(Integer oracleType) {
        TypeMetadata typeMetaData = this.delegate.getTypeMetadata(oracleType);
        return typeMetaData == null && this.noxt != null ? this.noxt.getTypeMetadata(oracleType) : typeMetaData;
    }

    protected static abstract class Builder
    extends DataTypeExtensionObject.Builder
    implements DataTypeProvider.Builder {
        private DataTypeProvider superDataTypeProvider = null;
        private DataTypeProvider delegateDataTypeProvider = null;

        protected Builder() {
        }

        @Override
        public Builder setExtensionAccess(DataTypeFactoryExtension.ExtensionAccess extensionAccess) {
            super.setExtensionAccess(extensionAccess);
            return this;
        }

        public Builder setSuperDataTypeProvider(DataTypeProvider superDataTypeProvider) {
            this.superDataTypeProvider = superDataTypeProvider;
            return this;
        }

        public DataTypeProvider getSuperDataTypeProvider() {
            return this.superDataTypeProvider;
        }

        public Builder setDelegateDataTypeProvider(DataTypeProvider delegateDataTypeProvider) {
            this.delegateDataTypeProvider = delegateDataTypeProvider;
            return this;
        }

        public DataTypeProvider getDelegateDataTypeProvider() {
            return this.delegateDataTypeProvider;
        }
    }
}

