/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes;

import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.raptor.datatypes.PLSQLBlockBuilder;
import oracle.dbtools.raptor.datatypes.PLSQLBlockComponent;

public class PLSQLBoundBlockBuilder
extends PLSQLBlockBuilder {
    private final PLSQLBlockBuilder bindBuilder = new PLSQLBlockBuilder();

    public PLSQLBlockBuilder getBindBuilder() {
        return this.bindBuilder;
    }

    public List<String> addComponent(PLSQLBlockComponent component, String value, String ... binds) {
        List<String> target = (List<String>)this.components.get(component.getSequence());
        if (value != null) {
            if (binds != null) {
                String newValue = String.format(value, binds);
                target = this.addComponent(component, newValue);
            } else {
                target = this.addComponent(component, value);
            }
        }
        this.bindBuilder.addComponent(component, binds);
        return target;
    }

    public List<String> addComponent(PLSQLBlockComponent component, StringBuffer value, String ... binds) {
        List<String> target = (List<String>)this.components.get(component.getSequence());
        if (value != null) {
            if (binds != null) {
                String newValue = String.format(value.toString(), binds);
                target = this.addComponent(component, newValue);
            } else {
                target = this.addComponent(component, value);
            }
        }
        this.bindBuilder.addComponent(component, binds);
        return target;
    }

    public PLSQLBoundBlockBuilder addBuilder(PLSQLBoundBlockBuilder source) {
        super.addBuilder(source);
        this.bindBuilder.addBuilder(source.bindBuilder);
        return this;
    }

    public List<String> getBindTokenList() {
        LinkedList<String> bindTokens = new LinkedList<String>();
        for (PLSQLBlockComponent component : PLSQLBlockComponent.values()) {
            List<String> componentValue = this.getBindBuilder().getComponent(component);
            if (componentValue == null) continue;
            bindTokens.addAll(componentValue);
        }
        return bindTokens.isEmpty() ? null : bindTokens;
    }
}

