/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes;

import java.net.URI;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionReference;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionWrapper;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeFactory;
import oracle.dbtools.raptor.datatypes.DataTypeFactoryExtension;
import oracle.dbtools.raptor.datatypes.DataTypeProvider;
import oracle.dbtools.raptor.datatypes.TypeMetadata;

public class DataTypeFactoryExtensionManager {
    private final CopyOnWriteArrayList<DataTypeFactoryExtension.ExtensionAccess> extensions;
    private final ConcurrentHashMap<URI, DataTypeFactoryExtension.ExtensionAccess> extensionMap;
    private final DataTypeFactory.FactoryAccess factoryAccess;
    private final ExtensionManagerAccess extensionManagerAccess = new ExtensionManagerAccess();

    DataTypeFactoryExtensionManager(DataTypeFactory.FactoryAccess dataTypeFactoryAccess, List<DataTypeFactoryExtension.Builder> extensionList) {
        this.factoryAccess = dataTypeFactoryAccess;
        this.extensions = new CopyOnWriteArrayList();
        this.extensionMap = new ConcurrentHashMap();
        for (DataTypeFactoryExtension.Builder extensionBuilder : extensionList) {
            this.addExtension(extensionBuilder);
        }
    }

    final DataTypeFactory getDataTypeFactory() {
        return this.factoryAccess.getDataTypeFactory();
    }

    synchronized void addExtension(DataTypeFactoryExtension.Builder extensionBuilder) {
        DataTypeFactoryExtension.ExtensionAccess extension = extensionBuilder.setExtensionManagerAccess(this.extensionManagerAccess).build();
        this.extensionMap.put(extensionBuilder.getExensionURI(), extension);
        this.extensions.add(0, extension);
    }

    DataTypeFactoryExtension.ExtensionAccess lookupExtension(URI extensionURI) {
        return extensionURI != null ? this.extensionMap.get(extensionURI) : null;
    }

    <C extends Connection> DataTypeFactoryExtension extensionFor(Class<C> connectionClass) {
        for (DataTypeFactoryExtension.ExtensionAccess extensionAccess : this.extensions) {
            DataTypeFactoryExtension extension;
            if (extensionAccess == null || !(extension = extensionAccess.getDataTypeFactoryExtension()).handlesExplicitly(connectionClass)) continue;
            return extension;
        }
        return null;
    }

    DataType getDataType(DataTypeContext context, TypeMetadata typeMetadata) {
        return context.getDataTypeFactoryExtension().getDataTypeProvider().getDataType(context, typeMetadata);
    }

    TypeMetadata getTypeMetadata(DataTypeConnectionProvider connectionProvider, String typeName) {
        return connectionProvider.getDataTypeFactoryExtension().getDataTypeProvider().getTypeMetadata(typeName);
    }

    TypeMetadata getTypeMetadata(DataTypeConnectionProvider connectionProvider, Integer oracleType) {
        return connectionProvider.getDataTypeFactoryExtension().getDataTypeProvider().getTypeMetadata(oracleType);
    }

    Map<String, TypeMetadata> getSupportedTypeMetadata(Class<? extends Connection> connectionClass) {
        DataTypeProvider provider;
        DataTypeFactoryExtension extension = this.extensionFor(connectionClass);
        if (extension != null && (provider = extension.getDataTypeProvider()) != null) {
            return provider.getSupportedTypeMetadata();
        }
        return new HashMap<String, TypeMetadata>();
    }

    Set<Integer> getSupportedSQLTypes(Class<? extends Connection> connectionClass) {
        DataTypeProvider provider;
        DataTypeFactoryExtension extension = this.extensionFor(connectionClass);
        if (extension != null && (provider = extension.getDataTypeProvider()) != null) {
            return provider.getSupportedSQLTypes();
        }
        return new TreeSet<Integer>();
    }

    Set<String> getSupportedTypes(Class<? extends Connection> connectionClass) {
        DataTypeProvider provider;
        DataTypeFactoryExtension extension = this.extensionFor(connectionClass);
        if (extension != null && (provider = extension.getDataTypeProvider()) != null) {
            return provider.getSupportedTypes();
        }
        return new TreeSet<String>();
    }

    <C extends Connection> DataTypeConnectionProvider.ConnectionProviderAccess<C> buildDataTypeConnectionProvider(Class<C> connectionClass, C connection) {
        DataTypeFactoryExtension extension = this.extensionFor(connectionClass);
        return (DataTypeConnectionProvider.ConnectionProviderAccess)extension.builder(DataTypeConnectionProvider.ConnectionProviderAccess.class, connection).build();
    }

    <C extends Connection> DataTypeConnectionProvider.ConnectionProviderAccess<C> buildDataTypeConnectionProvider(DataTypeConnectionReference<C> connectionReference) {
        DataTypeFactoryExtension extension = this.extensionFor(connectionReference.getConnectionClass());
        return (DataTypeConnectionProvider.ConnectionProviderAccess)extension.builder(DataTypeConnectionProvider.ConnectionProviderAccess.class, connectionReference).build();
    }

    <C extends Connection> DataTypeConnectionProvider.ConnectionProviderAccess<C> buildDataTypeConnectionProvider(DataTypeConnectionReference<C> connectionReference, DataTypeConnectionWrapper<C> nlsWrapper) {
        DataTypeFactoryExtension extension = this.extensionFor(connectionReference.getConnectionClass());
        return (DataTypeConnectionProvider.ConnectionProviderAccess)extension.builder(DataTypeConnectionProvider.ConnectionProviderAccess.class, connectionReference, nlsWrapper).build();
    }

    DataTypeContext.ContextAccess buildDataTypeContext(DataTypeConnectionProvider.ConnectionProviderAccess connectionProviderAccess) {
        DataTypeFactoryExtension extension = connectionProviderAccess.getExtensionAccess().getDataTypeFactoryExtension();
        return (DataTypeContext.ContextAccess)extension.builder(DataTypeContext.ContextAccess.class, connectionProviderAccess).build();
    }

    public class ExtensionManagerAccess {
        private ExtensionManagerAccess() {
        }

        public DataTypeFactory.FactoryAccess getFactoryAccess() {
            return DataTypeFactoryExtensionManager.this.factoryAccess;
        }

        public DataTypeFactory getDataTypeFactory() {
            return DataTypeFactoryExtensionManager.this.getDataTypeFactory();
        }

        public final DataTypeFactoryExtensionManager getDataTypeFactoryExtensionManager() {
            return DataTypeFactoryExtensionManager.this;
        }

        public DataTypeFactoryExtension.ExtensionAccess lookupExtension(URI extensionURI) {
            return DataTypeFactoryExtensionManager.this.lookupExtension(extensionURI);
        }

        public DataTypeContext.ContextAccess getContextAccess(DataTypeConnectionProvider.ConnectionProviderAccess connectionProviderAccess) {
            return this.getFactoryAccess().getContextAccess(connectionProviderAccess);
        }

        public DataTypeContext.ContextAccess peekContextAccess(DataTypeConnectionProvider.ConnectionProviderAccess connectionProviderAccess) {
            return this.getFactoryAccess().peekContextAccess(connectionProviderAccess);
        }
    }
}

