/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.backgroundTask;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.util.Logger;

public class RaptorMultiTask<T extends RaptorTask<?>>
extends RaptorTask<Void> {
    private BlockingQueue<T> _queue = new LinkedBlockingQueue<T>();
    private Map<RaptorTaskDescriptor, T> _active = Collections.synchronizedMap(new HashMap());
    private List<T> _cancelled = Collections.synchronizedList(new ArrayList());
    private List<T> _failed = Collections.synchronizedList(new ArrayList());
    private List<T> _finished = Collections.synchronizedList(new ArrayList());
    private AtomicInteger _parallelism = new AtomicInteger(4);
    private AtomicInteger _taskCount = new AtomicInteger(0);
    private IRaptorTaskListener _taskListener = new RaptorMultiTaskAdapter();

    public RaptorMultiTask(String name, IRaptorTaskRunMode mode) {
        super(name, false, mode);
    }

    public RaptorMultiTask(String name, boolean isInDeterminate, IRaptorTaskRunMode mode) {
        super(name, isInDeterminate, mode);
    }

    public void addTasks(Collection<T> tasks) {
        for (RaptorTask task : tasks) {
            task.getDescriptor().addListener(this._taskListener);
            this._queue.add(task);
            this._taskCount.incrementAndGet();
        }
    }

    public void addTask(T task) {
        this.addTasks(Collections.singleton(task));
    }

    public void setParallelism(int parallelism) {
        this._parallelism.set(parallelism);
    }

    public int getParallelism() {
        return this._parallelism.get();
    }

    public List<T> getCancelledTasks() {
        return this._cancelled;
    }

    public List<T> getFailedTasks() {
        return this._failed;
    }

    public List<T> getFinishedTasks() {
        return this._finished;
    }

    @Override
    protected Void doWork() throws TaskException {
        try {
            while (!this.isFinished()) {
                this.checkCanProceed();
                this.processQueue();
                Thread.sleep(250L);
            }
        }
        catch (Throwable t) {
            Logger.severe(this.getClass(), this.getDescriptor().getName(), t);
            throw new TaskException(t);
        }
        if (!this.getFailedTasks().isEmpty()) {
            RaptorTask task = (RaptorTask)this.getFailedTasks().get(0);
            Throwable t = task.getDescriptor().getThrowable();
            String msg = "Child task(s) failed. ";
            if (t != null) {
                throw new TaskException(msg + t.getMessage(), t);
            }
            throw new TaskException(msg);
        }
        return null;
    }

    @Override
    public boolean cancel() {
        boolean cancelled = true;
        for (RaptorTask task : this._active.values()) {
            if (task.requestCancel()) continue;
            cancelled = false;
        }
        return cancelled;
    }

    @Override
    protected void pause() {
        this.pauseActiveTasks();
        super.pause();
        this.resumeActiveTasks();
    }

    private void pauseActiveTasks() {
        for (RaptorTask task : this._active.values()) {
            task.requestPause();
        }
    }

    private void resumeActiveTasks() {
        for (RaptorTask task : this._active.values()) {
            task.resume();
        }
    }

    private boolean isFinished() {
        return this._queue.isEmpty() && this._active.isEmpty() && this._taskCount.get() == this._cancelled.size() + this._failed.size() + this._finished.size();
    }

    private void processQueue() {
        RaptorTask task;
        if (this._active.size() <= this.getParallelism() && (task = (RaptorTask)this._queue.poll()) != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RaptorTaskManager.getInstance().addTask(task);
                }
            });
            this._active.put(task.getDescriptor(), task);
        }
    }

    private void setProgress() {
        double units = 100.0 * (1.0 - (double)(this._active.size() + this._queue.size()) / (double)this._taskCount.get());
        this.getDescriptor().setProgress((int)units);
    }

    class RaptorMultiTaskAdapter
    extends RaptorTaskAdapter {
        RaptorMultiTaskAdapter() {
        }

        @Override
        public void taskCancelled(RaptorTaskEvent event) {
            RaptorTask task = (RaptorTask)RaptorMultiTask.this._active.remove(event.getTaskDescriptor());
            if (task != null) {
                RaptorMultiTask.this._cancelled.add(task);
            }
            RaptorMultiTask.this.setProgress();
        }

        @Override
        public void taskFailed(RaptorTaskEvent event) {
            RaptorTask task = (RaptorTask)RaptorMultiTask.this._active.remove(event.getTaskDescriptor());
            if (task != null) {
                RaptorMultiTask.this._failed.add(task);
            }
            RaptorMultiTask.this.setProgress();
        }

        @Override
        public void taskFinished(RaptorTaskEvent event) {
            RaptorTask task = (RaptorTask)RaptorMultiTask.this._active.remove(event.getTaskDescriptor());
            if (task != null) {
                RaptorMultiTask.this._finished.add(task);
            }
            RaptorMultiTask.this.setProgress();
        }
    }
}

