/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.json;

import java.util.List;

public class NamedValue {
    public String name;
    public String atomic = null;
    public List<NamedValue> composite = null;

    public NamedValue(String n, String a) {
        this.name = n;
        this.atomic = a;
    }

    public NamedValue(String n, List<NamedValue> c) {
        this.name = n;
        this.composite = c;
    }

    public boolean isLiteral() {
        return this.name == null || this.name.equals(this.valueString());
    }

    public NamedValue child(String name) {
        if (this.composite == null) {
            return null;
        }
        for (NamedValue c : this.composite) {
            if (!name.equals(c.name)) continue;
            return c;
        }
        return null;
    }

    public NamedValue firstChild() {
        return this.child(0);
    }

    public NamedValue child(int index) {
        if (this.composite == null) {
            return null;
        }
        return this.composite.get(index);
    }

    public String valueString() {
        if (this.atomic != null) {
            return this.atomic;
        }
        if (this.composite != null) {
            String openBr = "{";
            StringBuilder ret = new StringBuilder();
            int i = 0;
            for (NamedValue v : this.composite) {
                if (0 == i++) {
                    if (v.isLiteral()) {
                        openBr = "[";
                    }
                    ret.append(openBr);
                } else {
                    ret.append(',');
                }
                ret.append(v.toString());
            }
            if (openBr.equals("{")) {
                ret.append("}");
            } else {
                ret.append("]");
            }
            return ret.toString();
        }
        throw new AssertionError((Object)"atomic == map == null");
    }

    public String toString() {
        if (this.name == null) {
            return this.valueString();
        }
        if (this.isLiteral()) {
            return this.name;
        }
        return this.name + "=" + this.valueString();
    }
}

