/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.graphql;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.RuleTransforms;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.util.Service;

public class GQLParser {
    static Earley instance = null;

    public static Earley getInstance() throws IOException {
        if (instance != null) {
            return instance;
        }
        instance = new Earley((Set)GQLParser.getRules(), false){
            public String[] keywords = new String[]{"query", "mutation", "subscription", "fragment", "on", "schema", "type", "scalar", "interface", "implements", "enum", "union", "extend", "input", "directive", "repeatable"};
            int identifier;
            int digits;
            private Set<Integer> _keywords = new TreeSet<Integer>();
            {
                this.initKeywords();
                this.identifier = (Integer)this.symbolIndexes.get("identifier");
                this.digits = (Integer)this.symbolIndexes.get("digits");
            }

            @Override
            protected boolean isIdentifier(int y, List<LexerToken> src, int symbol, Integer suspect) {
                if (suspect != null && this._keywords.contains(suspect)) {
                    return false;
                }
                LexerToken token = src.get(y);
                return symbol == this.identifier && token.type == Token.IDENTIFIER || symbol == this.digits && token.type == Token.DIGITS;
            }

            @Override
            protected boolean isOptimizable(int headSym, int preSym, int mid, int y) {
                if ("LabeledStatement".equals(this.allSymbols[headSym])) {
                    return false;
                }
                return super.isOptimizable(headSym, preSym, mid, y);
            }

            @Override
            protected void diagnose(Matrix m, int x, int y) {
            }

            void initKeywords() {
                for (String k : this.keywords) {
                    this._keywords.add(this.getSymbol(k));
                }
            }
        };
        GQLParser.instance.isCaseSensitive = true;
        return instance;
    }

    public static Set<RuleTuple> getRules() throws IOException {
        TreeSet<RuleTuple> rules = new TreeSet<RuleTuple>();
        String rulesTxt = Service.readFile(GQLParser.class, "gql.grammar");
        rulesTxt = rulesTxt.replace("'{'", "OPEN_CURLY");
        rulesTxt = rulesTxt.replace("'}'", "CLOSE_CURLY");
        rulesTxt = rulesTxt.replace("private ", "");
        rulesTxt = rulesTxt.replace("!(')'", "!('closed_paren");
        rulesTxt = Grammar.removeNestedBlock(rulesTxt, "/*", "*/");
        rulesTxt = Grammar.removeNestedBlock(rulesTxt, "{", "}");
        rulesTxt = Grammar.removeNestedBlock(rulesTxt, "{", "}");
        rulesTxt = Grammar.removeNestedBlock(rulesTxt, "!(", ")");
        rulesTxt = rulesTxt.replace("OPEN_CURLY", "'{'");
        rulesTxt = rulesTxt.replace("CLOSE_CURLY", "'}'");
        rulesTxt = rulesTxt.replace("'...'", "'.' '.' '.'");
        rulesTxt = rulesTxt.replace("'::='", "':' ':' '='");
        List<LexerToken> src = Lexer.parse(rulesTxt, false, 41);
        ParseNode root = Grammar.parseGrammarFile(src, rulesTxt);
        Grammar.grammar(root, src, rules);
        RuleTransforms.eliminateEmptyProductions(rules);
        return rules;
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        String input = Service.readFile("common/src/test/resources/oracle/dbtools/parser/graphql/example.gql");
        Earley earley = GQLParser.getInstance();
        boolean T = true;
        boolean F = false;
        earley.printOrderedRules("Exprssion", T, F);
        List<LexerToken> src = LexerToken.parse(input, "&`", 937);
        if (src.size() < 1200) {
            LexerToken.print(src);
        }
        Matrix matrix = new Matrix(earley);
        Visual visual = null;
        if (src.size() < 1200) {
            visual = new Visual(src, earley);
        }
        earley.parse(src, matrix);
        if (src.size() < 500) {
            visual.draw(matrix);
        }
        ParseNode out = earley.forest(src, matrix);
        SyntaxError err = SyntaxError.checkSyntax(input, new String[]{"document"}, src, earley, matrix);
        if (err != null) {
            System.out.println(err.getDetailedMessage());
            return;
        }
        out.printTree(5);
    }
}

