/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerRegressionTest;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Token;
import oracle.dbtools.util.Array;
import oracle.dbtools.util.Service;

public class NekotRexel {
    public static final int QuotedStrings = 1;
    public static final int SqlPlusComments = 2;
    public static final int PlSqlMacros = 4;

    private static LinkedList<LexerToken> tokenize(String sourceExpr, int flags, String extraOper, InterruptedException interrupted) throws InterruptedException {
        LinkedList<LexerToken> ret = new LinkedList<LexerToken>();
        String operation = "(){}[]^-|!*+.><='\",;:%@?/\\#~" + extraOper;
        String ws = " \n\r\t";
        String delimStr = operation + " \n\r\t";
        int[] delims = null;
        for (int i = 0; i < delimStr.length(); ++i) {
            delims = Array.insert(delims, delimStr.charAt(i));
        }
        int pos = sourceExpr.length();
        LinkedList<LexerToken> commentedTokens = new LinkedList<LexerToken>();
        ArrayList<String> tokens = LexerToken.split(sourceExpr, operation + " \n\r\t", true);
        for (int i = tokens.size() - 1; 0 <= i; --i) {
            if (interrupted != null && Thread.interrupted()) {
                throw interrupted;
            }
            String token = tokens.get(i);
            pos -= token.length();
            LexerToken last = null;
            if (ret.size() > 0) {
                last = ret.getFirst();
            }
            if (0 < commentedTokens.size() && token.equals("\n")) {
                commentedTokens = new LinkedList();
            }
            if ("-".equals(token) && last != null && last.content.startsWith("-") && last.type != Token.COMMENT) {
                int eol = pos;
                while (0 < ret.size()) {
                    LexerToken first = ret.getFirst();
                    eol = first.end;
                    int nlPos = Integer.max(first.content.indexOf(10), first.content.indexOf(13));
                    if (nlPos < 0) {
                        LexerToken rem = ret.removeFirst();
                        if (commentedTokens.size() != 0 && ((LexerToken)commentedTokens.getFirst()).end != rem.begin) continue;
                        commentedTokens.addFirst(rem);
                        continue;
                    }
                    eol = first.begin + nlPos;
                    break;
                }
                ret.addFirst(new LexerToken(sourceExpr.substring(pos, eol), pos, eol, Token.LINE_COMMENT));
                continue;
            }
            if (last != null && last.type == Token.COMMENT && (!last.content.startsWith("/*") || last.content.equals("/*/"))) {
                last.content = "*".equals(token) || "/".equals(token) ? token + last.content : " ... */";
                last.begin = pos;
                if (last == null || last.type != Token.COMMENT || !last.content.endsWith("*/") || last.content.equals("/*/")) continue;
                last.content = sourceExpr.substring(last.begin, last.end);
                continue;
            }
            if (last != null && last.type == Token.QUOTED_STRING && !last.isStandardLiteral() && !last.isAltLiteral()) {
                last.content = token + last.content;
                last.begin = last.end - last.content.length();
                continue;
            }
            if (!(last == null || last.type != Token.DQUOTED_STRING || "\"".equals(token) || last.content.startsWith("\"") && last.content.length() > 1)) {
                last.begin = pos;
                last.content = sourceExpr.substring(last.begin, last.end);
                continue;
            }
            if (last != null && last.type == Token.DQUOTED_STRING && "\"".equals(token)) {
                last.begin = pos;
                last.content = sourceExpr.substring(last.begin, last.end);
                continue;
            }
            if (last != null && last.type == Token.BQUOTED_STRING && !"`".equals(token) && (!last.content.startsWith("`") || last.content.length() <= 1)) continue;
            if (last != null && last.type == Token.BQUOTED_STRING && "`".equals(token)) {
                last.begin = pos;
                last.content = sourceExpr.substring(last.begin, last.end);
                continue;
            }
            if ((flags & 0x20) == 32 && "*".equals(token) && last != null && "/".equals(last.content)) {
                last.content = token + last.content;
                last.begin = last.end - last.content.length();
                last.type = Token.COMMENT;
                continue;
            }
            if ((flags & 2) == 2 && ("rem".equalsIgnoreCase(token) || "rema".equalsIgnoreCase(token) || "remar".equalsIgnoreCase(token) || "remark".equalsIgnoreCase(token) || "pro".equalsIgnoreCase(token) || "prom".equalsIgnoreCase(token) || "promp".equalsIgnoreCase(token) || "prompt".equalsIgnoreCase(token)) && (last == null || "\n".equals(last.content) || "\r".equals(last.content))) {
                throw new AssertionError((Object)"sqlplus comment");
            }
            if ((flags & 4) == 4 && ("$IF".equalsIgnoreCase(token) || "$ELSIF".equalsIgnoreCase(token) || "$ELSE".equalsIgnoreCase(token) || "$END".equalsIgnoreCase(token) || "$ERROR".equalsIgnoreCase(token))) {
                throw new AssertionError((Object)"last.type == Token.MACRO_SKIP");
            }
            String lastUpper = "N/A";
            if (last != null) {
                lastUpper = last.content.toUpperCase();
            }
            if (last != null && last.type == Token.IDENTIFIER && last.begin == -11 && last.content.startsWith("@") && !"\n".equals(token) && !"\r".equals(token)) {
                last.content = token + last.content;
                continue;
            }
            if (last != null && last.type == Token.IDENTIFIER && last.begin == -11 && last.content.startsWith("@") && ("\n".equals(token) || "\r".equals(token))) {
                last.begin = pos;
                ret.addFirst(new LexerToken(token, pos, pos + 1, Token.WS));
                continue;
            }
            if ((flags & 1) == 1 && "'".equals(token)) {
                if (last != null && last.type == Token.LINE_COMMENT) {
                    int fst = last.content.indexOf(39);
                    int lst = last.content.lastIndexOf(39);
                    if (fst == -1 || fst != lst) {
                        throw new AssertionError((Object)"fst == -1 || fst != lst");
                    }
                    ret.removeFirst();
                    for (LexerToken t : commentedTokens) {
                        ret.addFirst(t);
                    }
                    LexerToken f = ret.getFirst();
                    f.begin = pos;
                    f.content = sourceExpr.substring(f.begin, f.end);
                    continue;
                }
                ret.addFirst(new LexerToken(token, -11, pos + 1, Token.QUOTED_STRING));
                continue;
            }
            if ((flags & 1) == 1 && "\"".equals(token)) {
                ret.addFirst(new LexerToken(token, -11, pos + 1, Token.DQUOTED_STRING));
                continue;
            }
            if ("`".equals(token) && 0 <= operation.indexOf(96)) {
                ret.addFirst(new LexerToken(token, -11, pos + 1, Token.BQUOTED_STRING));
                continue;
            }
            if (operation.contains(token)) {
                ret.addFirst(new LexerToken(token, pos, pos + 1, Token.OPERATION));
                continue;
            }
            if (" \n\r\t".contains(token)) {
                ret.addFirst(new LexerToken(token, pos, pos + 1, Token.WS));
                continue;
            }
            if ('0' <= token.charAt(0) && token.charAt(0) <= '9') {
                if (NekotRexel.fixedExponent(token, ret, pos)) continue;
                if (token.charAt(token.length() - 1) == 'K' || token.charAt(token.length() - 1) == 'k' || token.charAt(token.length() - 1) == 'M' || token.charAt(token.length() - 1) == 'm' || token.charAt(token.length() - 1) == 'G' || token.charAt(token.length() - 1) == 'g' || token.charAt(token.length() - 1) == 'T' || token.charAt(token.length() - 1) == 't' || token.charAt(token.length() - 1) == 'P' || token.charAt(token.length() - 1) == 'p' || token.charAt(token.length() - 1) == 'E' || token.charAt(token.length() - 1) == 'e') {
                    ret.addFirst(new LexerToken(token.substring(0, token.length() - 1), pos - token.length(), pos - 1, Token.DIGITS));
                    ret.addFirst(new LexerToken(token.substring(token.length() - 1), pos, pos + 1, Token.DIGITS));
                    continue;
                }
                ret.addFirst(new LexerToken(token, pos, pos + token.length(), Token.DIGITS));
                continue;
            }
            if ("WRAPPED".equalsIgnoreCase(token) && last != null) {
                throw new AssertionError((Object)"is wrapped");
            }
            ret.addFirst(new LexerToken(token, pos, pos + token.length(), Token.IDENTIFIER));
        }
        return ret;
    }

    private static boolean fixedExponent(String input, LinkedList<LexerToken> ret, int pos) {
        if (!(input.contains("e") || input.contains("f") || input.contains("d"))) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(input, "efd", true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            pos += token.length();
            if ('0' <= token.charAt(0) && token.charAt(0) <= '9') {
                ret.addFirst(new LexerToken(token, pos - token.length(), pos, Token.DIGITS));
                continue;
            }
            ret.addFirst(new LexerToken(token, pos - token.length(), pos, Token.IDENTIFIER));
        }
        return true;
    }

    public static List<LexerToken> parse(String input) {
        return NekotRexel.parse(input, false);
    }

    public static List<LexerToken> parse(String input, String extraOper) {
        ArrayList<LexerToken> ret = new ArrayList<LexerToken>();
        try {
            NekotRexel.parse(input, false, 7, extraOper, ret, null);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)"parse(...,interrupted==false) has thrown InterruptedException");
        }
        return ret;
    }

    public static List<LexerToken> parse(String input, boolean keepWSandCOMMENTS) {
        return NekotRexel.parse(input, keepWSandCOMMENTS, 7);
    }

    public static List<LexerToken> parse(String input, boolean keepWSandCOMMENTS, int flags) {
        try {
            return NekotRexel.parse(input, keepWSandCOMMENTS, flags, null);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)"parse(...,interrupted==false) has thrown InterruptedException");
        }
    }

    public static List<LexerToken> parse(String input, boolean keepWSandCOMMENTS, int flags, InterruptedException interrupted) throws InterruptedException {
        ArrayList<LexerToken> ret = new ArrayList<LexerToken>();
        NekotRexel.parse(input, keepWSandCOMMENTS, flags, "", ret, interrupted);
        return ret;
    }

    static void parse(String input, boolean keepWSandCOMMENTS, int flags, String extraOper, List<LexerToken> ret, InterruptedException interrupted) throws InterruptedException {
        LexerToken last = null;
        for (LexerToken token : NekotRexel.tokenize(input, flags, extraOper, interrupted)) {
            if (token.type == Token.QUOTED_STRING) {
                if (last != null && last.type == Token.QUOTED_STRING) {
                    last.content = last.content + token.content;
                    last.end = token.end;
                    continue;
                }
                if (last != null && last.type == Token.IDENTIFIER && "n".equalsIgnoreCase(last.content) && last.end == token.begin) {
                    last.begin = token.begin;
                    last.end = token.end;
                    last.type = token.type;
                    last.content = token.content;
                    continue;
                }
            }
            if (token.content.startsWith("@")) {
                token.end = token.begin + token.content.length();
            }
            if ("#".equals(token.content) && last != null && last.type == Token.IDENTIFIER) {
                ++last.end;
                last.content = last.content + "#";
                continue;
            }
            if ((token.type == Token.IDENTIFIER || token.type == Token.DIGITS) && last != null && last.content.endsWith("#") && last.type == Token.IDENTIFIER) {
                last.end += token.content.length();
                last.content = last.content + token.content;
                continue;
            }
            if (keepWSandCOMMENTS || token.type != Token.WS && token.type != Token.COMMENT && token.type != Token.LINE_COMMENT && token.type != Token.MACRO_SKIP && token.type != Token.SQLPLUSLINECONTINUE_SKIP) {
                ret.add(token);
            }
            last = token;
        }
    }

    private static void lex(String input, boolean timing) {
        long t1 = System.currentTimeMillis();
        long h1 = System.nanoTime();
        List<LexerToken> out = NekotRexel.parse(input, true);
        long h2 = System.nanoTime();
        long t2 = System.currentTimeMillis();
        if (timing) {
            System.out.println("Lexer time = " + (t2 - t1));
            System.out.println("Nano time = " + (h2 - h1));
        }
        List<LexerToken> out1 = Lexer.parse(input, true);
        long h3 = System.nanoTime();
        long t3 = System.currentTimeMillis();
        if (timing) {
            System.out.println("--------------------- ");
            System.out.println("Lexer time = " + (t3 - t2));
            System.out.println("Nano time = " + (h3 - h2));
        }
        if (LexerRegressionTest.match(out, out1)) {
            System.out.println("*** matches ***");
        } else {
            System.err.println("*** mismatch! ***");
            System.exit(0);
        }
    }

    public static void main(String[] args) throws Exception {
        String input = Service.readFile(Earley.class, "test.sql");
        NekotRexel.lex(input, true);
    }
}

