/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.util.Service;

public class LexerRegressionTest {
    static Integer singleTest = null;
    static int testNo = 0;
    private static TreeSet<Integer> failedTests = new TreeSet();
    private static int output = -1;
    private static int token_list = -1;
    private static int token = -1;
    private static int range = -1;
    private static int content = -1;
    private static int type = -1;
    private static int digits = -1;
    private static int assertion = -1;
    public static int query = -1;
    private static int atest = -1;
    private static int sql_fragment = -1;
    private static int comment = -1;
    public static Earley testParser = null;

    public static void main(String[] args) throws Exception {
        if (singleTest != null) {
            System.out.println("**** run single test ****");
        }
        String testFile = "plsql/lexerRegression.test";
        LexerRegressionTest.test(testFile);
    }

    public static void test(String testFile) throws Exception {
        String input = Service.readFile(LexerRegressionTest.class, testFile);
        List<LexerToken> src = Lexer.parse(input, "`");
        Visual visual = null;
        Matrix matrix = new Matrix(testParser);
        testParser.parse(src, matrix);
        SyntaxError s = SyntaxError.checkSyntax(input, new String[]{"atest"}, src, testParser, matrix);
        if (s != null) {
            if (visual != null) {
                visual.draw(matrix);
            }
            System.err.println("Syntax Error");
            System.err.println("at line#" + s.line);
            System.err.println(s.code);
            System.err.println(s.marker);
            System.err.println("Expected:  ");
            for (String tmp : s.getSuggestions()) {
                System.out.print(tmp + ",");
            }
            throw new Exception(">>>> syntactically invalid code fragment <<<<");
        }
        ParseNode root = testParser.forest(src, matrix);
        LexerRegressionTest.atest(root, src, input);
        if (failedTests.size() == 0) {
            System.out.println("*** ALL " + testNo + " TESTS are OK *** ---> ");
        } else {
            System.err.println("*** FAILED " + failedTests.size() + " tests *** ");
        }
        int cnt = -1;
        for (int testNo : failedTests) {
            if (++cnt < 10) {
                System.err.print(testNo + ",");
                continue;
            }
            if (cnt == 10) {
                System.err.print(" ... ");
                continue;
            }
            if (failedTests.size() - 10 >= cnt) continue;
            System.err.print("," + testNo);
        }
        if (0 < failedTests.size()) {
            System.exit(2);
        }
    }

    private static Set<RuleTuple> getRules() throws Exception {
        String input = Service.readFile(LexerRegressionTest.class, "plsql/lexerTest.grammar");
        List<LexerToken> src = Lexer.parse(input, false, 49);
        ParseNode root = Grammar.parseGrammarFile(src, input);
        TreeSet<RuleTuple> ret = new TreeSet<RuleTuple>();
        Grammar.grammar(root, src, ret);
        return ret;
    }

    private static void atest(ParseNode root, List<LexerToken> src, String input) throws Exception {
        if (root.contains(assertion)) {
            if (singleTest != null && singleTest != testNo) {
                return;
            }
            LexerRegressionTest.assertion(root, src, input);
            return;
        }
        if (root.contains(output)) {
            if (singleTest != null && singleTest != testNo) {
                return;
            }
            Iterator iterator = root.children().iterator();
            if (iterator.hasNext()) {
                ParseNode child = (ParseNode)iterator.next();
                List<LexerToken> out = LexerRegressionTest.query(child, src, input);
                System.out.println("TEST#" + testNo + ":  ---> ");
                LexerToken.print(out);
                return;
            }
            return;
        }
        if (root.contains(comment)) {
            LexerRegressionTest.comment(root, src, input);
        }
        for (ParseNode child : root.children()) {
            LexerRegressionTest.atest(child, src, input);
        }
    }

    private static ParseNode comment(ParseNode root, List<LexerToken> src, String input) throws Exception {
        String testNum = input.substring(src.get((int)(root.from + 2)).begin, src.get((int)(root.to - 1)).end - 1);
        testNo = Integer.parseInt(testNum);
        return null;
    }

    private static List<LexerToken> query(ParseNode root, List<LexerToken> src, String input) {
        return LexerRegressionTest.parse(LexerRegressionTest.sql_fragment(root, src, input));
    }

    private static List<LexerToken> parse(String q) {
        return Lexer.parse(q, true);
    }

    private static String sql_fragment(ParseNode root, List<LexerToken> src, String input) {
        String ret = input.substring(src.get((int)root.from).begin, src.get((int)(root.to - 1)).end);
        if (ret.charAt(0) == '\"') {
            ret = ret.substring(1, ret.length() - 1);
        }
        if (ret.charAt(0) == '`') {
            ret = ret.substring(1, ret.length() - 1);
        }
        return ret;
    }

    private static LexerToken assertion(ParseNode root, List<LexerToken> src, String input) throws Exception {
        List<LexerToken> output = null;
        List<LexerToken> cmp = null;
        for (ParseNode child : root.children()) {
            if (child.contains(query)) {
                output = LexerRegressionTest.query(child, src, input);
                continue;
            }
            if (child.from + 1 == child.to && ("-".equals(child.content(src)) || ">".equals(child.content(src)) || ";".equals(child.content(src))) || !child.contains(token_list)) continue;
            cmp = LexerRegressionTest.tokenList(child, src, input);
        }
        boolean test = LexerRegressionTest.match(cmp, output);
        if (!test) {
            failedTests.add(testNo);
            System.out.println("TEST#" + testNo + ":  broken");
        }
        return null;
    }

    public static boolean match(List<LexerToken> list1, List<LexerToken> list2) {
        if (list1.size() != list2.size()) {
            System.err.println("list1.size()=" + list1.size() + " != list2.size()=" + list2.size());
            return false;
        }
        int i = -1;
        for (LexerToken t1 : list1) {
            LexerToken t2 = list2.get(++i);
            if ("\r\n".equals(t1.content) && "\r".equals(t2.content) || "\r\n".equals(t1.content) && "\n".equals(t2.content)) continue;
            String s1 = t1.toString();
            String s2 = t2.toString();
            if (("".equals(t1.content.trim()) || s1.equals(s2)) && t1.begin == t2.begin && t1.end == t2.end && t1.type == t2.type) continue;
            System.err.println("t1=" + s1 + "\n != t2=" + s2);
            return false;
        }
        return true;
    }

    private static List<LexerToken> tokenList(ParseNode root, List<LexerToken> src, String input) {
        LinkedList<LexerToken> ret = new LinkedList<LexerToken>();
        if (root.contains(token)) {
            ret.add(LexerRegressionTest.token(root, src, input));
            return ret;
        }
        for (ParseNode child : root.children()) {
            ret.addAll(LexerRegressionTest.tokenList(child, src, input));
        }
        return ret;
    }

    private static LexerToken token(ParseNode root, List<LexerToken> src, String input) {
        LexerToken ret = new LexerToken(" ", -1, -1, null);
        for (ParseNode child : root.children()) {
            if (child.contains(digits)) {
                String symbol = child.content(src);
                continue;
            }
            if (child.contains(range)) {
                long rng = LexerRegressionTest.range(child, src, input);
                ret.begin = Service.lX(rng);
                ret.end = Service.lY(rng);
                continue;
            }
            if (child.contains(content)) {
                String content = child.content(src);
                if (content.charAt(0) == '`') {
                    content = content.substring(1, content.length() - 1);
                }
                ret.content = content;
                continue;
            }
            if (!child.contains(type)) continue;
            String type = child.content(src);
            ret.type = Token.valueOf(type.substring(1, type.length() - 1));
        }
        return ret;
    }

    private static long range(ParseNode root, List<LexerToken> src, String input) {
        int x = -1;
        int y = -1;
        for (ParseNode child : root.children()) {
            if (!child.contains(digits)) continue;
            if (x == -1) {
                x = Integer.parseInt(src.get((int)child.from).content);
                continue;
            }
            y = Integer.parseInt(src.get((int)child.from).content);
        }
        return Service.lPair(x, y);
    }

    static {
        try {
            testParser = new Earley((Set)LexerRegressionTest.getRules()){

                @Override
                protected boolean isIdentifier(int y, List<LexerToken> src, int symbol, Integer suspect) {
                    LexerToken token = src.get(y);
                    return symbol == this.identifier && token.type == Token.IDENTIFIER || symbol == this.identifier && token.type == Token.DQUOTED_STRING || symbol == this.identifier && token.type == Token.BQUOTED_STRING;
                }
            };
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        output = (Integer)LexerRegressionTest.testParser.symbolIndexes.get("output");
        token_list = (Integer)LexerRegressionTest.testParser.symbolIndexes.get("token_list");
        assertion = (Integer)LexerRegressionTest.testParser.symbolIndexes.get("assertion");
        query = (Integer)LexerRegressionTest.testParser.symbolIndexes.get("query");
        atest = (Integer)LexerRegressionTest.testParser.symbolIndexes.get("atest");
        token = (Integer)LexerRegressionTest.testParser.symbolIndexes.get("token");
        range = (Integer)LexerRegressionTest.testParser.symbolIndexes.get("range");
        content = (Integer)LexerRegressionTest.testParser.symbolIndexes.get("content");
        type = (Integer)LexerRegressionTest.testParser.symbolIndexes.get("type");
        digits = (Integer)LexerRegressionTest.testParser.symbolIndexes.get("digits");
        sql_fragment = (Integer)LexerRegressionTest.testParser.symbolIndexes.get("sql_fragment");
        comment = (Integer)LexerRegressionTest.testParser.symbolIndexes.get("comment");
    }
}

