/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;

public class EBNF {
    private static Earley earley = new Earley((Set)EBNF.getRules()){

        @Override
        protected boolean isIdentifier(int y, List<LexerToken> src, int symbol, Integer suspect) {
            LexerToken token = src.get(y);
            return symbol == this.identifier && token.type == Token.IDENTIFIER || symbol == this.identifier && token.type == Token.DQUOTED_STRING;
        }
    };
    static int expr = (Integer)EBNF.earley.symbolIndexes.get("expr");
    static int identifier = (Integer)EBNF.earley.symbolIndexes.get("identifier");
    static int string_literal = (Integer)EBNF.earley.symbolIndexes.get("string_literal");
    static int rule = (Integer)EBNF.earley.symbolIndexes.get("rule");
    static int grammar = (Integer)EBNF.earley.symbolIndexes.get("grammar");
    static int disjunct = (Integer)EBNF.earley.symbolIndexes.get("disjunct");
    static int concat = (Integer)EBNF.earley.symbolIndexes.get("concat");
    static int or = (Integer)EBNF.earley.symbolIndexes.get("'|'");
    static int sqOpen = (Integer)EBNF.earley.symbolIndexes.get("'['");

    static Earley bnfParser() {
        return earley;
    }

    private static Set<RuleTuple> getRules() {
        TreeSet<RuleTuple> rules = new TreeSet<RuleTuple>();
        rules.add(new RuleTuple("concat", new String[]{"expr"}));
        rules.add(new RuleTuple("concat", new String[]{"concat", "expr"}));
        rules.add(new RuleTuple("disjunct", new String[]{"concat"}));
        rules.add(new RuleTuple("disjunct", new String[]{"disjunct", "'|'", "concat"}));
        rules.add(new RuleTuple("expr", new String[]{"identifier"}));
        rules.add(new RuleTuple("expr", new String[]{"string_literal"}));
        rules.add(new RuleTuple("expr", new String[]{"disjunct"}));
        rules.add(new RuleTuple("expr", new String[]{"'{'", "disjunct", "'}'"}));
        rules.add(new RuleTuple("expr", new String[]{"'['", "disjunct", "']'"}));
        rules.add(new RuleTuple("expr", new String[]{"'{'", "disjunct", "'}'", "'*'"}));
        rules.add(new RuleTuple("expr", new String[]{"'['", "disjunct", "']'", "'*'"}));
        rules.add(new RuleTuple("rule", new String[]{"identifier", "':'", "expr"}));
        rules.add(new RuleTuple("grammar", new String[]{"rule"}));
        rules.add(new RuleTuple("grammar", new String[]{"grammar", "rule"}));
        TreeSet<RuleTuple> nonEmptyRules = rules;
        return nonEmptyRules;
    }

    public static void grammar(ParseNode root, List<LexerToken> src, Set<RuleTuple> grammar) {
        if (root.contains(rule)) {
            EBNF.rule(root, src, grammar);
        } else {
            for (ParseNode child : root.children()) {
                EBNF.grammar(child, src, grammar);
            }
        }
    }

    private static void rule(ParseNode node, List<LexerToken> src, Set<RuleTuple> grammar) {
        String header = null;
        TreeSet<RuleTuple> expr = new TreeSet<RuleTuple>();
        for (ParseNode child : node.children()) {
            if (header == null && child.contains(identifier)) {
                header = child.content(src);
                continue;
            }
            if (!child.contains(EBNF.expr)) continue;
            EBNF.expr(header, child, src, expr);
            grammar.addAll(expr);
        }
    }

    private static void expr(String header, ParseNode node, List<LexerToken> src, Set<RuleTuple> ret) {
        if (node.from + 1 == node.to && (node.contains(identifier) || node.contains(string_literal))) {
            ret.add(new RuleTuple(header, new String[]{node.content(src)}));
        } else if (node.contains(disjunct)) {
            EBNF.disjunct(header, node, src, ret);
        } else {
            Integer first = null;
            ParseNode disjunct = null;
            Integer third = null;
            Integer last = null;
            for (ParseNode child : node.children()) {
                if (first == null) {
                    first = child.content()[0];
                    continue;
                }
                if (disjunct == null) {
                    disjunct = child;
                    continue;
                }
                if (third == null) {
                    third = child.content()[0];
                    continue;
                }
                if (last != null) continue;
                last = child.content()[0];
            }
            String aux = header + "[" + disjunct.from + "," + disjunct.to + ")";
            ret.add(new RuleTuple(header, new String[]{aux}));
            if (first == sqOpen) {
                ret.add(new RuleTuple(header, new String[0]));
            }
            if (last != null) {
                ret.add(new RuleTuple(header, new String[]{header, aux}));
            }
            TreeSet<RuleTuple> expr = new TreeSet<RuleTuple>();
            EBNF.expr(aux, disjunct, src, expr);
            ret.addAll(expr);
        }
    }

    private static void disjunct(String header, ParseNode node, List<LexerToken> src, Set<RuleTuple> ret) {
        if (node.contains(concat)) {
            LinkedList<String> payload = new LinkedList<String>();
            EBNF.concat(header, node, src, ret, payload);
            ret.add(new RuleTuple(header, payload));
        } else {
            for (ParseNode child : node.children()) {
                if (!child.contains(disjunct) && !child.contains(concat)) continue;
                EBNF.disjunct(header, child, src, ret);
            }
        }
    }

    private static void concat(String header, ParseNode node, List<LexerToken> src, Set<RuleTuple> ret, List<String> payload) {
        if (node.contains(identifier) || node.contains(string_literal)) {
            payload.add(node.content(src));
        } else {
            for (ParseNode child : node.children()) {
                if (child.contains(identifier) || node.contains(string_literal)) {
                    payload.add(child.content(src));
                    continue;
                }
                if (child.contains(expr)) {
                    String aux = header + "[" + child.from + "," + child.to + ")";
                    payload.add(aux);
                    TreeSet<RuleTuple> expr = new TreeSet<RuleTuple>();
                    EBNF.expr(aux, child, src, expr);
                    ret.addAll(expr);
                    continue;
                }
                if (!child.contains(concat)) continue;
                EBNF.concat(header, child, src, ret, payload);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        String input = "qon: [namequal] name";
        List<LexerToken> src = Lexer.parse(input);
        ParseNode root = EBNF.parseGrammarFile(src, input);
        root.printTree();
        TreeSet<RuleTuple> rules = new TreeSet<RuleTuple>();
        EBNF.grammar(root, src, rules);
        RuleTuple.printRules(rules);
    }

    public static ParseNode parseGrammarFile(List<LexerToken> src, String input) throws Exception {
        return Grammar.parseGrammarFile(src, input, earley);
    }
}

