/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.dap.DAP;
import oracle.dbtools.lsp.BackgroundParser;
import oracle.dbtools.lsp.LanguageServer;
import oracle.dbtools.lsp.Message;
import oracle.dbtools.lsp.PublishDiagnosticsParams;
import oracle.dbtools.lsp.WebSocket;
import oracle.dbtools.lsp.features.Position;
import oracle.dbtools.lsp.features.Range;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.json.Interpreter;
import oracle.dbtools.parser.json.JsonEarley;
import oracle.dbtools.parser.json.NamedValue;
import oracle.dbtools.parser.json.ResponseError;
import oracle.dbtools.parser.json.Util;

public class LSP {
    public static boolean logMessages = true;
    private static LanguageServer server = null;
    WebSocket webSocket = null;
    static final Charset UTF_8 = StandardCharsets.UTF_8;
    public static final String cancelResponce = "cancelResponce";
    private Map<Integer, Boolean> applied = new HashMap<Integer, Boolean>();
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int INFO = 3;
    public static final int LOG = 4;
    protected ArrayBlockingQueue<Message> pending = new ArrayBlockingQueue(10);
    protected Map<Integer, Object> asyncResponses = new HashMap<Integer, Object>();
    private int maxId = 1000;
    private OutputStream send;
    private boolean readingFromStream;
    public static final Range zeroRange = new Range(new Position(0, 0), new Position(0, 0));
    public static final Range oneRange = new Range(new Position(0, 0), new Position(0, 3));
    public static final Range fullRange = new Range(new Position(0, 0), new Position(999999, 0));
    public static final Logger Log = Logger.getLogger("main");
    static int port = 6011;

    public static LanguageServer getServer() {
        return server;
    }

    protected LanguageServer initServer() {
        server = new LanguageServer(this);
        return server;
    }

    private String readHeader(InputStream client) {
        StringBuilder line = new StringBuilder();
        char next = this.read(client);
        while (true) {
            if (next == '\r') {
                char last = this.read(client);
                assert (last == '\n');
                break;
            }
            line.append(next);
            next = this.read(client);
        }
        return line.toString();
    }

    private int parseHeader(String header) {
        String contentLength = "Content-Length: ";
        if (header.startsWith(contentLength)) {
            String tail = header.substring(contentLength.length());
            return Integer.parseInt(tail);
        }
        return -1;
    }

    private char read(InputStream client) {
        try {
            int c = client.read();
            if (c == -1) {
                Log.warning("Stream from LSP client has been closed, throwing kill exception...");
                throw new EndOfStream();
            }
            return (char)c;
        }
        catch (IOException e) {
            Log.log(Level.SEVERE, e.getMessage(), e);
            throw new EndOfStream();
        }
    }

    private String readLength(InputStream client, int byteLength) {
        char next = this.read(client);
        while (Character.isWhitespace(next)) {
            next = this.read(client);
        }
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (true) {
            result.append(next);
            if (++i == byteLength) break;
            next = this.read(client);
        }
        return result.toString();
    }

    String nextToken(InputStream client) {
        if (this.webSocket != null) {
            return this.webSocket.unframe(client);
        }
        int contentLength = -1;
        String lastLine = null;
        String line;
        while (!"Connection: close".equals(line = this.readHeader(client))) {
            int maybeLength;
            if (line.isEmpty()) {
                if (0 < contentLength) {
                    return this.readLength(client, contentLength);
                }
                this.webSocket = new WebSocket();
                return lastLine;
            }
            if (line.startsWith("Sec-WebSocket-Key")) {
                lastLine = line;
            }
            if ((maybeLength = this.parseHeader(line)) == -1) continue;
            contentLength = maybeLength;
        }
        return line;
    }

    Message parseMessage(String token) throws Exception {
        Object log = token;
        if (1000 < ((String)log).length() && !((String)log).contains("\"method\":\"initialize\"")) {
            log = ((String)log).substring(0, 1000) + "...";
        }
        if (logMessages) {
            System.out.println("lsp >>> " + (String)log);
        }
        Message ret = new Message();
        ret.jsonrpc = token;
        NamedValue tmp = new Interpreter().eval(token);
        List<NamedValue> elements = tmp.composite;
        block0: for (NamedValue el : elements) {
            if ("\"method\"".equals(el.name)) {
                String name = el.atomic;
                if (name.charAt(0) == '\"' && name.charAt(0) == '\"') {
                    name = name.substring(1, name.length() - 1);
                }
                ret.method = name;
            }
            if ("\"params\"".equals(el.name)) {
                ret.params = el;
            }
            if ("\"result\"".equals(el.name)) {
                ret.result = el;
            }
            if ("\"id\"".equals(el.name)) {
                String idStr = el.valueString();
                if (idStr.charAt(0) == '\"') {
                    idStr = idStr.substring(1, idStr.length() - 1);
                }
                ret.id = Integer.parseInt(idStr);
            }
            if (!"\"error\"".equals(el.name)) continue;
            for (NamedValue ell : el.composite) {
                if (!"\"message\"".equals(ell.name)) continue;
                ret.error = ell.atomic;
                continue block0;
            }
        }
        if (ret.params != null && ret.params.composite != null && 0 < ret.params.composite.size()) {
            NamedValue nv = ret.params.composite.get(0);
            if ("\"id\"".equals(nv.name)) {
                ret.id = Integer.parseInt(nv.valueString());
            }
        }
        return ret;
    }

    protected void writeClient(String messageText) {
        OutputStream client = this.getSend();
        if (this.webSocket != null) {
            try {
                this.webSocket.writeClient(client, messageText);
                return;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        byte[] messageBytes = messageText.getBytes(UTF_8);
        String headerText = String.format("Content-Length: %d\r\n\r\n", messageBytes.length);
        byte[] headerBytes = headerText.getBytes(UTF_8);
        try {
            client.write(headerBytes);
            client.write(messageBytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void respond(int requestId, Object params) {
        OutputStream client = this.getSend();
        if (cancelResponce.equals(params)) {
            Log.log(Level.INFO, "requestId = " + requestId + "   canceled");
            return;
        }
        if (params instanceof ResponseError) {
            throw new RuntimeException("Errors should be sent using LSP.error(...)");
        }
        String jsonText = Util.toJson(params);
        String messageText = String.format("{\"jsonrpc\":\"2.0\",\"id\":%d,\"result\":%s}", requestId, jsonText);
        Object log = messageText;
        if (1000 < ((String)log).length()) {
            log = ((String)log).substring(0, 1000) + "...";
        }
        if (logMessages) {
            System.out.println("   lsp <<< " + (String)log);
        }
        this.writeClientSafely(messageText, requestId);
    }

    void error(int requestId, ResponseError error) {
        LSP.windowShowMessage(error.message, 1);
        this.respond(requestId, null);
    }

    protected int request(String method, Object params) {
        String jsonText = Util.toJson(params);
        int requestId = this.nextId();
        String messageText = String.format("{\"jsonrpc\":\"2.0\",\"id\":%d,\"method\":\"%s\",\"params\":%s}", requestId, method, jsonText);
        Object log = messageText;
        if (1000 < ((String)log).length()) {
            log = ((String)log).substring(0, 1000) + "...";
        }
        if (logMessages) {
            System.out.println("   lsp <<< " + (String)log);
        }
        this.writeClientSafely(messageText, requestId);
        return requestId;
    }

    public int request(String method) {
        int requestId = this.nextId();
        String messageText = String.format("{\"jsonrpc\":\"2.0\",\"id\":%d,\"method\":\"%s\"}", requestId, method);
        Object log = messageText;
        if (1000 < ((String)log).length()) {
            log = ((String)log).substring(0, 1000) + "...";
        }
        if (logMessages) {
            System.out.println("   lsp <<< " + (String)log);
        }
        this.writeClientSafely(messageText, requestId);
        return requestId;
    }

    public void notifyClient(String method, Object params) {
        if (params == null) {
            System.out.println(method + " params == null");
        }
        String jsonText = Util.toJson(params);
        String messageText = String.format("{\"jsonrpc\":\"2.0\",\"method\":\"%s\",\"params\":%s}", method, jsonText);
        Object log = messageText;
        if (1000 < ((String)log).length()) {
            log = ((String)log).substring(0, 1000) + "...";
        }
        if (logMessages) {
            System.out.println("   lsp <<< " + (String)log);
        }
        this.writeClientSafely(messageText, this.nextId());
    }

    public static void windowShowMessage(String msg, int type) {
        String params = "{\"message\":\"" + Util.sugarcoatText(msg) + "\",\"type\":" + type + "}";
        LSP.getServer().getLSP().notifyClient("window/showMessage", params);
    }

    private void writeClientSafely(String messageText, int requestId) {
        long t1 = System.currentTimeMillis();
        if (messageText.length() < 100000) {
            try {
                List<LexerToken> src = LexerToken.parse(messageText, false, 161);
                Parsed target = new Parsed(messageText, src, JsonEarley.jsonParser(), "top");
                if (target.getSyntaxError() != null) {
                    System.err.println("Invalid JSON:" + messageText);
                    throw new AssertionError((Object)"Invalid JSON in responce");
                }
                this.writeClient(messageText);
            }
            catch (IOException e) {
                throw new AssertionError((Object)"Failed to read JSON grammar");
            }
        } else {
            this.writeClient(messageText);
        }
        long t2 = System.currentTimeMillis();
        if (t1 + 100L < t2) {
            System.err.println("JSON parse time = " + (t2 - t1));
        }
    }

    public void connect(InputStream receive, OutputStream send) {
        Program.resetCompiledPrograms();
        server = this.initServer();
        new Thread(){

            @Override
            public void run() {
                try {
                    DAP.main(new String[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
        this.connect(receive, send, server);
    }

    private void sendResponses() {
        for (int id : this.asyncResponses.keySet()) {
            this.respond(id, this.asyncResponses.get(id));
        }
        this.asyncResponses.clear();
    }

    boolean hasPendingMethod(String method, int id) {
        for (Message m : this.pending) {
            if (m.id <= id || !method.equals(m.method)) continue;
            return true;
        }
        return false;
    }

    boolean hasCancelMethod(int id) {
        for (Message m : this.pending) {
            if (m.id != id || !"$/cancelRequest".equals(m.method)) continue;
            return true;
        }
        return false;
    }

    int nextId() {
        return this.maxId++;
    }

    public OutputStream getSend() {
        return this.send;
    }

    protected void connect(final InputStream receive, final OutputStream send, LanguageServer server) {
        this.send = send;
        LSP.server = server;
        final Message endOfStream = new Message();
        if (receive != null) {
            this.readingFromStream = true;
            this.pending = new ArrayBlockingQueue(10);
            class MessageReader
            implements Runnable {
                MessageReader() {
                }

                private boolean kill() {
                    Log.info("Read stream has been closed, putting kill message onto queue...");
                    try {
                        LSP.this.pending.put(endOfStream);
                        return true;
                    }
                    catch (Exception e) {
                        Log.log(Level.SEVERE, "Failed to put kill message onto queue, will try again...", e);
                        return false;
                    }
                }

                @Override
                public void run() {
                    Log.info("Placing incoming messages on queue...");
                    block5: while (true) {
                        try {
                            while (true) {
                                String token;
                                if ("Connection: close" == (token = LSP.this.nextToken(receive)) && this.kill()) {
                                    return;
                                }
                                if (token.startsWith("Sec-WebSocket-Key")) {
                                    WebSocket.upgrade(token, send);
                                    continue;
                                }
                                if (token.equals("pong")) {
                                    LSP.this.webSocket.pong(send);
                                    continue;
                                }
                                if (token.equals("ignore")) continue;
                                if (token.equals("ignorignoreAndPause")) {
                                    try {
                                        Thread.sleep(50L);
                                        continue block5;
                                    }
                                    catch (InterruptedException interruptedException) {
                                        continue;
                                    }
                                }
                                if (token.equals("closeFrame") && this.kill()) {
                                    return;
                                }
                                LSP.this.acceptLspRequestImpl(token);
                            }
                        }
                        catch (EndOfStream e) {
                            if (!this.kill()) continue;
                            return;
                        }
                        catch (Throwable e) {
                            Log.log(Level.SEVERE, e.getMessage(), e);
                            continue;
                        }
                        break;
                    }
                }
            }
            final Thread reader = new Thread((Runnable)new MessageReader(), "reader");
            reader.setDaemon(true);
            reader.start();
            Thread asyncResponder = new Thread("asyncResponder"){

                @Override
                public void run() {
                    LSP.this.asyncResponses = new HashMap<Integer, Object>();
                    do {
                        try {
                            Thread.sleep(100L);
                            LSP.this.sendResponses();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            return;
                        }
                    } while (reader.isAlive());
                }
            };
            asyncResponder.start();
        }
        Log.info("Reading messages from queue...");
        while (true) {
            Message r = null;
            try {
                r = this.pending.poll(100L, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                Log.log(Level.SEVERE, e.getMessage(), e);
                continue;
            }
            if (r == null) continue;
            if (r.equals(endOfStream)) {
                Log.warning("Stream from client has been closed, exiting...");
                throw new RuntimeException("VT: exit");
            }
            if (r.error != null) {
                Log.log(Level.SEVERE, r.error);
                continue;
            }
            try {
                PublishDiagnosticsParams diag;
                Object response;
                if (r.method.equals("initialize")) {
                    response = server.initialize(r.params);
                    this.respond(r.id, response);
                    continue;
                }
                if (r.method.equals("initialized")) {
                    server.initialized();
                    continue;
                }
                if (r.method.equals("shutdown")) {
                    Log.warning("Got shutdown message");
                    this.respond(r.id, null);
                    continue;
                }
                if (r.method.equals("exit")) {
                    Log.warning("Got exit message, exiting...");
                    break;
                }
                if (r.method.equals("workspace/didChangeWorkspaceFolders")) {
                    server.didChangeWorkspaceFolders(r.params);
                    continue;
                }
                if (r.method.equals("workspace/didChangeConfiguration")) {
                    server.didChangeConfiguration(r.params);
                    continue;
                }
                if (r.method.equals("workspace/didChangeWatchedFiles")) {
                    server.didChangeWatchedFiles(r.params);
                    continue;
                }
                if (r.method.equals("workspace/symbol")) {
                    response = server.workspaceSymbols(r.params);
                    this.respond(r.id, response);
                    continue;
                }
                if (r.method.equals("textDocument/documentLink")) {
                    response = server.documentLink(r.params);
                    this.respond(r.id, response);
                    continue;
                }
                if (r.method.equals("textDocument/didOpen")) {
                    diag = server.didOpenTextDocument(r.params);
                    this.notifyClient("textDocument/publishDiagnostics", diag);
                    continue;
                }
                if (r.method.equals("textDocument/didChange")) {
                    diag = server.didChangeTextDocument(r.params);
                    this.notifyClient("textDocument/publishDiagnostics", diag);
                    continue;
                }
                if (r.method.equals("textDocument/willSave")) {
                    server.willSaveTextDocument(r.params);
                    continue;
                }
                if (r.method.equals("textDocument/willSaveWaitUntil")) {
                    response = server.willSaveWaitUntilTextDocument(r.params);
                    this.respond(r.id, response);
                    continue;
                }
                if (r.method.equals("textDocument/didSave")) {
                    server.didSaveTextDocument(r.params);
                    continue;
                }
                if (r.method.equals("textDocument/didClose")) {
                    server.didCloseTextDocument(r.params);
                    continue;
                }
                if (r.method.equals("textDocument/completion")) {
                    response = server.completion(r.params);
                    this.respond(r.id, response);
                    continue;
                }
                if (r.method.equals("completionItem/resolve")) {
                    response = server.resolveCompletionItem(r.params);
                    this.respond(r.id, response);
                    continue;
                }
                if (r.method.equals("textDocument/hover")) {
                    response = server.hover(r.id, r.params);
                    this.respond(r.id, response);
                    continue;
                }
                if (r.method.equals("textDocument/signatureHelp")) {
                    response = server.signatureHelp(r.params);
                    this.respond(r.id, response);
                    continue;
                }
                if (r.method.equals("textDocument/definition")) {
                    response = server.gotoDefinition(r.params);
                    if (response instanceof ResponseError) {
                        this.error(r.id, (ResponseError)response);
                        continue;
                    }
                    this.respond(r.id, response);
                    continue;
                }
                if (r.method.equals("textDocument/references")) {
                    response = server.findReferences(r.params);
                    this.respond(r.id, response);
                    continue;
                }
                if (r.method.equals("textDocument/documentSymbol")) {
                    response = server.documentSymbol(r.params);
                    this.respond(r.id, response);
                    continue;
                }
                if (r.method.equals("textDocument/codeAction")) {
                    response = server.codeAction(r.params);
                    this.respond(r.id, response);
                    continue;
                }
                if (r.method.equals("textDocument/codeLens")) {
                    server.codeLens(r.params, r.id);
                    continue;
                }
                if (r.method.equals("codeLens/resolve")) {
                    response = server.resolveCodeLens(r.params);
                    this.respond(r.id, response);
                    continue;
                }
                if (r.method.equals("textDocument/prepareRename")) {
                    response = server.prepareRename(r.params);
                    this.respond(r.id, response);
                    continue;
                }
                if (r.method.equals("textDocument/rename")) {
                    response = server.rename(r.params);
                    this.respond(r.id, response);
                    continue;
                }
                if (r.method.equals("textDocument/formatting")) {
                    response = server.formatting(r.params);
                    this.respond(r.id, response);
                    continue;
                }
                if (r.method.equals("textDocument/foldingRange")) {
                    response = server.foldingRange(r.params);
                    this.respond(r.id, response);
                    continue;
                }
                if (r.method.equals("textDocument/colorPresentation")) {
                    response = server.colorPresentation(r.params);
                    this.respond(r.id, response);
                    continue;
                }
                if (r.method.equals("textDocument/documentColor")) {
                    server.documentColor(r.params, r.id);
                    continue;
                }
                if (r.method.equals("textDocument/semanticTokens/full")) {
                    response = server.semanticTokensFull(r.params);
                    this.respond(r.id, response);
                    continue;
                }
                if (r.method.equals("workspace/executeCommand")) {
                    response = server.executeCommand(r.params);
                    if (response == null) {
                        this.respond(r.id, "OK");
                        continue;
                    }
                    if (response instanceof ResponseError) {
                        this.error(r.id, (ResponseError)response);
                        continue;
                    }
                    if (response instanceof String) {
                        this.respond(r.id, response);
                        continue;
                    }
                    Log.severe(String.format("Unexpected class `%s`", response.getClass()));
                    continue;
                }
                if (r.method.equals("$/setTrace")) {
                    Log.warning("$/setTrace r.id=" + r.id + " value: " + r.params.atomic);
                    this.respond(r.id, "OK");
                    continue;
                }
                if (r.method.equals("$/cancelRequest")) {
                    Log.warning("$/cancelRequest r.id=" + r.id);
                    continue;
                }
                Log.warning(String.format("Unrecognized method `%s`", r.method));
                this.error(r.id, new ResponseError(-32002, "Unrecognized method " + r.method, null));
            }
            catch (Exception e) {
                Log.log(Level.SEVERE, e.getMessage(), e);
                if (r.id == -1) continue;
                this.error(r.id, new ResponseError(-32603, e.getMessage(), null));
            }
        }
    }

    public Message acceptLspRequest(String jsonRpc) throws Exception, InterruptedException {
        if (this.readingFromStream || null == this.pending) {
            throw new IllegalStateException("Programmer Error(usage): Cannot accept a request directly if reading from an inputStream or if the queue is not initialized (created during LSP.connect)");
        }
        return this.acceptLspRequestImpl(jsonRpc);
    }

    private Message acceptLspRequestImpl(String jsonRpc) throws Exception, InterruptedException {
        String appliedValue;
        Message message = this.parseMessage(jsonRpc);
        if (message.result != null && (appliedValue = message.result.valueString()).startsWith("{\"applied\"=")) {
            this.applied.put(message.id, appliedValue.endsWith("true}"));
        }
        this.maybeProcessCancel(message);
        if (message.isProcessable()) {
            this.pending.put(message);
        }
        return message;
    }

    private void maybeProcessCancel(Message message) {
        if ("$/cancelRequest".equals(message.method)) {
            boolean removed;
            if (-1 == message.id) {
                message.id = -1;
            }
            if (removed = this.pending.removeIf(r -> r.id != -1 && r.id == message.id)) {
                Log.info(String.format("Cancelled request %d, which had not yet started", message.id));
            } else {
                Log.info(String.format("Cannot cancel request %d because it has already started", message.id));
            }
        } else if (message.result != null) {
            // empty if block
        }
    }

    public void createDirectory(String url) {
        String tmpFileName = "t-m-p";
        int rid = this.request("workspace/applyEdit", "{\"edit\": {\"documentChanges\":[{\"kind\":\"create\",\"uri\":\"" + url + "/t-m-p\"}]}}");
        try {
            this.messageApplied(rid);
        }
        catch (AssertionError e) {
            Log.severe(((Throwable)((Object)e)).getMessage() + "... Failed to create " + url + "/t-m-p?");
            return;
        }
        rid = this.request("workspace/applyEdit", "{\"edit\": {\"documentChanges\":[{\"kind\":\"delete\",\"uri\":\"" + url + "/t-m-p\"}]}}");
        try {
            this.messageApplied(rid);
        }
        catch (AssertionError e) {
            Log.severe(((Throwable)((Object)e)).getMessage() + "... Failed to delete " + url + "/t-m-p?");
            return;
        }
    }

    public int createFile(String url, String content) {
        return this.createFile(url, content, true);
    }

    public int createFile(String uri, String content, boolean overwrite) {
        boolean applied;
        int rid;
        Range range = fullRange;
        if (overwrite) {
            rid = this.request("workspace/applyEdit", "{\"edit\": {\"documentChanges\":[{\"kind\":\"delete\",\"uri\":\"" + uri + "\"}]}}");
            applied = this.messageApplied(rid);
            range = zeroRange;
        }
        rid = this.request("workspace/applyEdit", "{\"edit\": {\"documentChanges\":[{\"kind\":\"create\",\"uri\":\"" + uri + "\"}]}}");
        try {
            applied = this.messageApplied(rid);
            if (!applied && !overwrite) {
                return -1;
            }
        }
        catch (AssertionError e) {
            Log.severe("rid=" + rid + "   " + ((Throwable)((Object)e)).getMessage() + "... Failed to create " + uri + "?");
            return -1;
        }
        return this.documentInsert(range, uri, content);
    }

    public void showDocument(String uri) {
        this.request("window/showDocument", "{\"uri\":\"" + uri + "\",\"external\":false,\"takeFocus\":true,\"range\":" + oneRange.toJson() + "}");
    }

    public int documentInsert(Range pos, String uri, String content) {
        int rid = this.request("workspace/applyEdit", "{\"edit\": {\"documentChanges\":[{\"textDocument\":{\"uri\":\"" + uri + "\",\"version\":null},\"edits\":[{\"range\":" + pos.toJson() + ",\"newText\":\"" + Util.sugarcoatText(content) + "\"}]}]}}");
        try {
            boolean bl = this.messageApplied(rid);
        }
        catch (AssertionError e) {
            Log.severe("rid=" + rid + "   " + ((Throwable)((Object)e)).getMessage() + "... Failed to insert into " + uri + "?");
            return -1;
        }
        return rid;
    }

    public void documentInsert(Range pos1, Range pos2, String uri, String content1, String content2) {
        int rid = this.request("workspace/applyEdit", "{\"edit\": {\"documentChanges\":[{\"textDocument\":{\"uri\":\"" + uri + "\",\"version\":null},\"edits\":[{\"range\":" + pos1.toJson() + ",\"newText\":\"" + Util.sugarcoatText(content1) + "\"},{\"range\":" + pos2.toJson() + ",\"newText\":\"" + Util.sugarcoatText(content2) + "\"}]}]}}");
        try {
            boolean bl = this.messageApplied(rid);
        }
        catch (AssertionError e) {
            Log.severe("rid=" + rid + "   " + ((Throwable)((Object)e)).getMessage() + "... Failed to insert2 into " + uri + "?");
            return;
        }
    }

    public int documentAppend(String uri, String content) {
        Position pos = new Position(999999, 0);
        return this.documentInsert(new Range(pos, pos), uri, content);
    }

    void documentBump(BackgroundParser parser) {
        String uri = parser.escapedUrl();
        if (logMessages) {
            System.out.println("bumping " + uri);
        }
        int line = parser.charPos2LineNo1(parser.text.length() - 1);
        int lineStart = parser.lineNo2CharPos1(line);
        Position start = new Position(line - 1, parser.text.length() - 1 - lineStart);
        Position end = new Position(line - 1, parser.text.length() - lineStart);
        Range range = null;
        String bump = "\t";
        if (parser.text.endsWith(bump)) {
            range = new Range(start, end);
            bump = "";
        } else {
            range = new Range(new Position(line, 0), new Position(line, 0));
        }
        int rid = this.request("workspace/applyEdit", "{\"edit\": {\"documentChanges\":[{\"textDocument\":{\"uri\":" + uri + ",\"version\": null},\"edits\":[{\"range\":" + range.toJson() + ",\"newText\":\"" + Util.sugarcoatText(bump) + "\"}]}]}}");
        try {
            boolean bl = this.messageApplied(rid);
        }
        catch (AssertionError e) {
            Log.severe("rid=" + rid + "   " + ((Throwable)((Object)e)).getMessage() + "... Failed to bump " + uri + "?");
            return;
        }
    }

    public int documentBump(String uri) {
        if (logMessages) {
            System.out.println("bump2 " + uri);
        }
        Range range = new Range(new Position(999999, 0), new Position(999999, 0));
        String bump = "\t";
        int rid = this.request("workspace/applyEdit", "{\"edit\": {\"documentChanges\":[{\"textDocument\":{\"uri\":" + uri + ",\"version\": null},\"edits\":[{\"range\":" + range.toJson() + ",\"newText\":\"" + Util.sugarcoatText(bump) + "\"}]}]}}");
        try {
            boolean bl = this.messageApplied(rid);
        }
        catch (AssertionError e) {
            Log.severe(((Throwable)((Object)e)).getMessage() + "... Failed to bump2 " + uri + "?");
            return -1;
        }
        return rid;
    }

    public boolean messageApplied(int rid) {
        for (int i = 0; i < 20; ++i) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.applied.containsKey(rid)) continue;
            return this.applied.get(rid);
        }
        throw new AssertionError((Object)"timeout");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        for (String arg : args) {
            if (arg.toLowerCase().startsWith("logmessages")) {
                if (arg.toLowerCase().contains("false")) {
                    logMessages = false;
                    continue;
                }
                logMessages = true;
                continue;
            }
            port = arg.toLowerCase().startsWith("port") ? Integer.parseInt(arg.substring("port".length() + 1)) : Integer.parseInt(arg);
        }
        ServerSocket socket = new ServerSocket(port);
        while (true) {
            try {
                System.out.println("Listening port# " + port);
                Socket connection = socket.accept();
                new LSP().connect(connection.getInputStream(), connection.getOutputStream());
            }
            catch (Throwable tri) {
                System.err.println("Error handling LSP request: " + tri.getMessage());
                tri.printStackTrace();
            }
        }
    }

    static class EndOfStream
    extends RuntimeException {
        EndOfStream() {
        }
    }
}

