/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.data.loadservice;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.DataType;
import oracle.dbtools.data.model.LoadField;
import oracle.dbtools.data.validators.DateValidator;

public class ColumnDefinitionDetective {
    private static Pattern _uriPattern = Pattern.compile("^[a-z0-9-\\.\\+]{2,10}:$");
    private Locale _locale;
    private NumberFormat _fmt;
    private DateValidator _dateValidator = new DateValidator();
    public static final String[] DATE_MASKS = new String[]{"DD-MON-RR", "RRRR-MM-DD", "RR-MM-DD", "RRRR-MON-DD", "RR-MON-DD", "YYYY-MM-DD", "YY-MM-DD", "YYYY-MON-DD", "YY-MON-DD", "YYYY-MM-DD:HH24:MI:SS", "YYYY-MM-DD HH24:MI:SS", "MM/DD/RRRR", "MM/DD/YY", "MM/DD/YYYY", "MONTH DD, YYYY", "DD/MM/YYYY", "Day, Month, RRRR"};
    public static final String[] TIMESTAMP_MASKS = new String[]{"YYYY-MM-DD HH24:MI:SS.FF", "YYYY-MM-DD:HH24:MI:SS.FF", "YYYY-MM-DD HH24:MI:SS", "YYYY-MM-DD:HH24:MI:SS"};
    public static final String[] TIMESTAMPTZ_MASKS = new String[]{"YYYY-MM-DD HH24:MI:SS.FF TZH:TZM", "YYYY-MM-DD HH24:MI:SS.FF TZR"};
    String[] _dateMasks = DATE_MASKS;
    String[] _timestampMasks = TIMESTAMP_MASKS;
    String[] _timestamptzMasks = TIMESTAMPTZ_MASKS;
    String _temporalType;
    int _formatIndex;
    String _format;

    public ColumnDefinitionDetective() {
        this(null, null);
    }

    public ColumnDefinitionDetective(Locale locale, Character nlsDecimalSeparator) {
        this._locale = locale;
        if (this._locale != null) {
            this._fmt = (DecimalFormat)DecimalFormat.getInstance(this._locale);
            this._dateValidator.setLocale(this._locale);
        } else {
            this._fmt = (DecimalFormat)DecimalFormat.getInstance();
        }
        if (nlsDecimalSeparator != null && this._fmt instanceof DecimalFormat) {
            DecimalFormatSymbols symbols = ((DecimalFormat)this._fmt).getDecimalFormatSymbols();
            symbols.setDecimalSeparator(nlsDecimalSeparator.charValue());
            ((DecimalFormat)this._fmt).setDecimalFormatSymbols(symbols);
        }
    }

    public void setMasks(String[] dateMasks, String[] timestampMasks, String[] timestamptzMasks) {
        this._dateMasks = dateMasks;
        this._timestampMasks = timestampMasks;
        this._timestamptzMasks = timestamptzMasks;
    }

    public void detect(List<Object[]> dataList, LoadField field, boolean isHeader) {
        boolean canBeNumber = true;
        boolean canBeTemporal = true;
        Column column = field.getColumn();
        int columnIndex = field.getColumn().getSourceColID();
        Column dColumn = new Column();
        dColumn.setSourceColID(column.getSourceColID());
        int defPrecision = column.getPrecision();
        int intPrecision = 0;
        boolean isDefPrecision = column.getPrecision() != 0;
        boolean _isHeader = isHeader;
        this.temporalInit();
        Iterator<Object[]> it = dataList.iterator();
        column.setPrecision(0);
        while (it.hasNext() && (canBeNumber || canBeTemporal || !isDefPrecision)) {
            dColumn.setPrecision(0);
            dColumn.setScale(0);
            dColumn.setFormat("");
            if (_isHeader) {
                it.next();
                _isHeader = false;
            } else {
                Object[] row = it.next();
                String data = null;
                if (columnIndex < row.length && row[columnIndex] != null) {
                    data = row[columnIndex].toString();
                }
                if (data != null && data.length() > 0) {
                    if (canBeNumber && this.isNumber(data, dColumn, true)) {
                        if (dColumn.getPrecision() - dColumn.getScale() > column.getPrecision() - column.getScale() && intPrecision < dColumn.getPrecision() - dColumn.getScale()) {
                            intPrecision = dColumn.getPrecision() - dColumn.getScale();
                        }
                        if (column.getScale() < dColumn.getScale()) {
                            column.setScale(dColumn.getScale());
                        }
                    } else {
                        canBeNumber = false;
                        if (column.getPrecision() < data.length()) {
                            column.setPrecision(data.length());
                        }
                    }
                    if (canBeNumber || !canBeTemporal || !this.isTemporal(data, dColumn, dataList, isHeader)) {
                        canBeTemporal = false;
                    }
                }
            }
            if (canBeNumber || canBeTemporal || !isDefPrecision) continue;
            column.setPrecision(defPrecision);
        }
        if (canBeNumber) {
            column.setPrecision(intPrecision + column.getScale());
            if (column.getPrecision() == 0 && column.getScale() == 0) {
                canBeNumber = false;
            }
        }
        if (canBeNumber) {
            column.setType(DataType.NUMBER.toString());
        } else if (canBeTemporal && dColumn.getType() != null) {
            column.setType(dColumn.getType());
            column.setFormat(dColumn.getFormat());
        } else {
            column.setType(DataType.VARCHAR2.toString());
            column.setScale(0);
            if (isDefPrecision) {
                column.setPrecision(defPrecision);
            }
        }
        field.setDetectedType(column.getType());
        field.setDetectedPrecision(column.getPrecision());
        field.setDetectedScale(column.getScale());
    }

    public void detectFormat(List<Object[]> dataList, Column column, boolean isHeader) {
        String[] masks;
        int columnIndex = column.getSourceColID();
        if (columnIndex < 0) {
            return;
        }
        boolean _isHeader = isHeader;
        String columnFormat = column.getFormat();
        this.temporalInit();
        Iterator<Object[]> it = dataList.iterator();
        if (column.getType().equals(DataType.DATE.toString())) {
            masks = this._dateMasks;
        } else if (column.getType().equals(DataType.TIMESTAMP.toString())) {
            masks = this._timestampMasks;
        } else if (column.getType().equals(DataType.TIMESTAMPTZ.toString())) {
            masks = this._timestamptzMasks;
        } else if (column.getType().equals(DataType.TIMESTAMPLTZ.toString())) {
            masks = this._timestampMasks;
        } else {
            return;
        }
        int formatIndex = 0;
        while (it.hasNext()) {
            if (formatIndex == -1) {
                return;
            }
            if (_isHeader) {
                it.next();
                _isHeader = false;
                continue;
            }
            Object[] row = it.next();
            if (columnIndex >= row.length || row[columnIndex] == null) continue;
            String data = row[columnIndex].toString();
            while (formatIndex != -1) {
                if ((formatIndex = this.findValidFormat(data, column, masks, formatIndex)) == -1) continue;
                column.setFormat(masks[formatIndex]);
                if (this.isFormatValid(dataList, column, isHeader)) {
                    return;
                }
                if (++formatIndex < masks.length) continue;
                formatIndex = -1;
                column.setFormat(columnFormat);
            }
        }
        column.setFormat(columnFormat);
    }

    public boolean isNumber(String data, Column column, boolean detectCode) {
        Object result = "";
        try {
            ParsePosition pp = new ParsePosition(0);
            Number num = this._fmt.parse(data.toString(), pp);
            if (num == null) {
                return false;
            }
            result = "" + num.doubleValue();
            if (pp.getIndex() < data.length()) {
                return false;
            }
            if (((String)result).endsWith(".0")) {
                result = ((String)result).substring(0, ((String)result).length() - 2);
            }
            BigDecimal number = new BigDecimal((String)result);
            if (detectCode && number.scale() == 0 && number.precision() > 1 && data.startsWith("0")) {
                return false;
            }
            column.setType(DataType.NUMBER.toString());
            column.setPrecision(number.precision());
            column.setScale(number.scale());
        }
        catch (Exception e) {
            return false;
        }
        return ((String)result).length() != 0;
    }

    public void temporalInit() {
        this._formatIndex = 0;
        this._temporalType = null;
        this._format = null;
    }

    public boolean isTemporal(String data, Column column, List<Object[]> dataList, boolean isHeader) {
        try {
            Matcher matcher = _uriPattern.matcher(data);
            if (matcher.find()) {
                return false;
            }
            boolean mayContainTime = true;
            if (this._temporalType == null) {
                if (data.contains(":")) {
                    mayContainTime = true;
                }
                if (data.contains("-") || data.contains("/") || data.contains(",") || mayContainTime) {
                    while (this._formatIndex != -1) {
                        this._temporalType = DataType.DATE.toString();
                        column.setType(this._temporalType);
                        this._formatIndex = this.findValidFormat(data, column, this._dateMasks, this._formatIndex);
                        if (this._formatIndex == -1) continue;
                        column.setType(this._temporalType);
                        this._format = this._dateMasks[this._formatIndex];
                        column.setFormat(this._format);
                        if (this.isFormatValid(dataList, column, isHeader)) {
                            return true;
                        }
                        ++this._formatIndex;
                        if (this._formatIndex < this._dateMasks.length) continue;
                        this._formatIndex = -1;
                    }
                }
                if (mayContainTime) {
                    this._formatIndex = 0;
                    while (this._formatIndex != -1) {
                        this._temporalType = DataType.TIMESTAMP.toString();
                        column.setType(this._temporalType);
                        this._formatIndex = this.findValidFormat(data, column, this._timestampMasks, this._formatIndex);
                        if (this._formatIndex == -1) continue;
                        column.setType(this._temporalType);
                        this._format = this._timestampMasks[this._formatIndex];
                        column.setFormat(this._format);
                        if (this.isFormatValid(dataList, column, isHeader)) {
                            return true;
                        }
                        ++this._formatIndex;
                        if (this._formatIndex < this._timestampMasks.length) continue;
                        this._formatIndex = -1;
                    }
                }
                return false;
            }
            column.setType(this._temporalType);
            column.setFormat(this._format);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isFormatValid(List<Object[]> dataList, Column column, boolean isHeader) {
        boolean rtn = true;
        Iterator<Object[]> it = dataList.iterator();
        int columnIndex = column.getSourceColID();
        int formatIndex = -1;
        while (it.hasNext()) {
            String data;
            if (isHeader) {
                it.next();
                isHeader = false;
                continue;
            }
            Object[] row = it.next();
            if (columnIndex >= row.length || row[columnIndex] == null || this._dateValidator.validateData(column, data = row[columnIndex].toString())) continue;
            rtn = false;
        }
        return rtn;
    }

    public int findValidFormat(String data, Column column, String[] formats) {
        int i = 0;
        for (String format : formats) {
            column.setFormat(format);
            if (this._dateValidator.validateData(column, data)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int findValidFormat(String data, Column column, String[] formats, int i) {
        while (i < formats.length) {
            column.setFormat(formats[i]);
            if (this._dateValidator.validateData(column, data)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int getRoundedPrecision(int precision, String type) {
        if (type.equals(DataType.VARCHAR2.toString()) || type.equals(DataType.NVARCHAR2.toString())) {
            if (ColumnDefinitionDetective.isBetween(precision, 0, 16)) {
                return 26;
            }
            if (ColumnDefinitionDetective.isBetween(precision, 17, 100)) {
                return 128;
            }
            if (ColumnDefinitionDetective.isBetween(precision, 101, 200)) {
                return 256;
            }
            if (ColumnDefinitionDetective.isBetween(precision, 201, 1000)) {
                return 1024;
            }
            if (ColumnDefinitionDetective.isBetween(precision, 1001, 1500)) {
                return 2048;
            }
            return 4000;
        }
        if (type.equals(DataType.CHAR.toString()) || type.equals(DataType.NCHAR.toString())) {
            if (ColumnDefinitionDetective.isBetween(precision, 0, 16)) {
                return 26;
            }
            if (ColumnDefinitionDetective.isBetween(precision, 17, 100)) {
                return 128;
            }
            if (ColumnDefinitionDetective.isBetween(precision, 101, 200)) {
                return 256;
            }
            if (ColumnDefinitionDetective.isBetween(precision, 201, 1000)) {
                return 1024;
            }
            return 2000;
        }
        if (type.equals(DataType.NUMBER.toString())) {
            return precision < 36 ? precision + 2 : 38;
        }
        if (type.equals(DataType.FLOAT.toString())) {
            return precision < 124 ? precision + 2 : 126;
        }
        return precision;
    }

    public static boolean isBetween(int x, int lower, int upper) {
        return lower <= x && x <= upper;
    }

    public static int getDefaultPrecision(int precision, String type) {
        if (precision == 0) {
            if (type.equals(DataType.VARCHAR2.toString()) || type.equals(DataType.NVARCHAR2.toString())) {
                return 4000;
            }
            if (type.equals(DataType.CHAR.toString()) || type.equals(DataType.NCHAR.toString())) {
                return 2000;
            }
        }
        if (type.equals(DataType.NUMBER.toString())) {
            return 38;
        }
        if (type.equals(DataType.FLOAT.toString())) {
            return 126;
        }
        return precision;
    }

    public static int getMaxPrecision(int precision, String type) {
        if (type.equals(DataType.VARCHAR2.toString()) || type.equals(DataType.NCHAR.toString()) || type.equals(DataType.NVARCHAR2.toString())) {
            return 4000;
        }
        if (type.equals(DataType.NUMBER.toString())) {
            return 38;
        }
        if (type.equals(DataType.FLOAT.toString())) {
            return 126;
        }
        if (type.equals(DataType.CHAR.toString())) {
            return 2000;
        }
        return precision;
    }
}

