/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.data.common;

import java.util.Locale;
import oracle.dbtools.data.common.Iterables;
import oracle.dbtools.data.common.Translatable;
import oracle.dbtools.data.common.TranslatableTemplate;
import oracle.dbtools.data.common.Translatables;

public class TranslatableMessage
implements Translatable {
    private Object[] messageArguments;
    private final TranslatableTemplate template;
    public static final Translatable EMPTY_MESSAGE = new TranslatableMessage((Class)TranslatableMessage.class, "", "", new Object[0]){

        @Override
        public String toString() {
            return "";
        }

        @Override
        public String toString(Locale locale) {
            return "";
        }
    };
    private static final Object[] NO_ARGS = new Object[0];
    private static final TranslatableTemplate NOT_TRANSLATABLE = new TranslatableTemplate(null, null, "{0}");

    public TranslatableMessage(Class<?> baseClass, String messageId, String defaultTemplate, Object ... messageArguments) {
        this(new TranslatableTemplate(baseClass, messageId, defaultTemplate), messageArguments);
    }

    private TranslatableMessage(TranslatableTemplate template, Object ... messageArguments) {
        this.template = template;
        this.messageArguments = messageArguments == null ? NO_ARGS : messageArguments;
    }

    public TranslatableMessage(String msg) {
        this(NOT_TRANSLATABLE, msg);
    }

    public String toString() {
        return this.toString(Locale.getDefault());
    }

    @Override
    public String toString(Iterable<Locale> localePreference) {
        return Translatables.format(this.template, localePreference, this.messageArguments);
    }

    public String toString(Locale locale) {
        return this.toString(Iterables.iterable(locale));
    }

    public static String toString(Translatable msg, Iterable<Locale> localePreference) {
        if (msg == null) {
            return null;
        }
        return msg.toString(localePreference);
    }
}

