/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.dap.script;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.Location;
import com.sun.jdi.LongValue;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VoidValue;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.StepRequest;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.dap.DebugAdapter;
import oracle.dbtools.dap.script.ScriptEventRequestManager;
import oracle.dbtools.dap.script.ScriptLocation;
import oracle.dbtools.dap.script.ScriptStackFrame;
import oracle.dbtools.dap.script.ScriptThread;
import oracle.dbtools.lsp.BackgroundParser;
import oracle.dbtools.lsp.LSP;
import oracle.dbtools.lsp.LanguageServer;
import oracle.dbtools.raptor.newscriptrunner.CommandRegistry;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptParser;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunner;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class ScriptVM
implements VirtualMachine {
    Map<String, ISQLCommand[]> file2stmts = new HashMap<String, ISQLCommand[]>();
    String fileUrl;
    int step = 0;
    BreakpointRequest current = null;
    DebugAdapter debugAdapter;
    ScriptRunner runner;
    final ByteArrayOutputStream baos = new ByteArrayOutputStream();
    ScriptEventRequestManager eventMgr = new ScriptEventRequestManager(this);

    public ScriptVM(BackgroundParser parser, DebugAdapter debugAdapter) {
        ISQLCommand[] stmts;
        String text = parser.text;
        ScriptParser sp = new ScriptParser(text);
        sp.parse();
        for (ISQLCommand cmd : stmts = sp.getSqlStatements()) {
            System.out.println("command: [" + cmd.getStartLine() + "," + cmd.getEndLine() + "]");
        }
        this.file2stmts.put(parser.docUrl, stmts);
        this.fileUrl = parser.docUrl;
        this.debugAdapter = debugAdapter;
        this.runner = new ScriptRunner(debugAdapter.conn, new BufferedOutputStream(this.baos), new ScriptRunnerContext()){};
        this.runner.getScriptRunnerContext().putProperty("sqldev.error.any.in", Boolean.FALSE);
        this.runner.getScriptRunnerContext().putProperty("sqldev.error", Boolean.FALSE);
        this.runner.getScriptRunnerContext().putProperty("script.runner.results", null);
        this.runner.getScriptRunnerContext().putProperty("script.runner.using.systemout", Boolean.TRUE);
        Boolean amICommandLineConnect = (Boolean)this.runner.getScriptRunnerContext().getProperty("script.runner.commandlineconnect");
    }

    @Override
    public VirtualMachine virtualMachine() {
        throw new AssertionError((Object)"virtualMachine()?");
    }

    @Override
    public List<ReferenceType> classesByName(String className) {
        return null;
    }

    @Override
    public List<ReferenceType> allClasses() {
        return null;
    }

    @Override
    public void redefineClasses(Map<? extends ReferenceType, byte[]> classToBytes) {
    }

    @Override
    public List<ThreadReference> allThreads() {
        LinkedList<ThreadReference> ret = new LinkedList<ThreadReference>();
        ret.add(new ScriptThread());
        return ret;
    }

    @Override
    public void suspend() {
    }

    @Override
    public void resume() {
        if (0 < this.eventMgr.stepRequests().size()) {
            final StepRequest sr = this.eventMgr.stepRequests().remove(0);
            ISQLCommand[] stmts = this.file2stmts.get(this.fileUrl);
            final ISQLCommand cmd = stmts[this.step];
            this.oneStep(cmd);
            this.logOutput();
            ++this.step;
            this.current = null;
            ScriptStackFrame frame = (ScriptStackFrame)ScriptThread.instance.stack.get(0);
            if (this.step < stmts.length) {
                frame.location.line = stmts[this.step].getStartLine() + 1;
                try {
                    ScriptThread.instance.updateStack(frame.location);
                    this.eventMgr.addEvent(new StepEvent(){

                        @Override
                        public ThreadReference thread() {
                            return ScriptThread.instance;
                        }

                        @Override
                        public Location location() {
                            return new Location(){

                                @Override
                                public VirtualMachine virtualMachine() {
                                    return ScriptVM.this;
                                }

                                @Override
                                public int compareTo(Location o) {
                                    return o.lineNumber() - this.lineNumber();
                                }

                                @Override
                                public ReferenceType declaringType() {
                                    return null;
                                }

                                @Override
                                public Method method() {
                                    return null;
                                }

                                @Override
                                public long codeIndex() {
                                    return -1L;
                                }

                                @Override
                                public String sourceName() throws AbsentInformationException {
                                    return null;
                                }

                                @Override
                                public String sourceName(String stratum) throws AbsentInformationException {
                                    return this.sourceName();
                                }

                                @Override
                                public String sourcePath() throws AbsentInformationException {
                                    return null;
                                }

                                @Override
                                public String sourcePath(String stratum) throws AbsentInformationException {
                                    return this.sourcePath();
                                }

                                @Override
                                public int lineNumber() {
                                    return cmd.getStartLine();
                                }

                                @Override
                                public int lineNumber(String stratum) {
                                    return this.lineNumber();
                                }
                            };
                        }

                        @Override
                        public EventRequest request() {
                            return sr;
                        }

                        @Override
                        public VirtualMachine virtualMachine() {
                            return ScriptVM.this;
                        }
                    });
                }
                catch (AbsentInformationException e) {
                    e.printStackTrace();
                }
            }
            return;
        }
        ISQLCommand[] stmts = this.file2stmts.get(this.fileUrl);
        while (this.step < stmts.length) {
            ISQLCommand cmd = stmts[this.step];
            int startLine = cmd.getStartLine() + 1;
            int endLine = cmd.getEndLine() + 1 + 1;
            for (final BreakpointRequest br : this.eventMgr.breakpointRequests()) {
                try {
                    ScriptLocation loc = (ScriptLocation)br.location();
                    String sourceName = loc.sourceName();
                    String sourcePath = loc.sourcePath();
                    int lineNo = loc.lineNumber();
                    if (startLine > lineNo || lineNo >= endLine || this.current == br) continue;
                    try {
                        ScriptThread.instance.updateStack(loc);
                    }
                    catch (AbsentInformationException e) {
                        e.printStackTrace();
                    }
                    this.eventMgr.addEvent(new BreakpointEvent(){

                        @Override
                        public ThreadReference thread() {
                            return ScriptThread.instance;
                        }

                        @Override
                        public Location location() {
                            return br.location();
                        }

                        @Override
                        public EventRequest request() {
                            return br;
                        }

                        @Override
                        public VirtualMachine virtualMachine() {
                            return ScriptVM.this;
                        }
                    });
                    this.current = br;
                    return;
                }
                catch (AbsentInformationException e) {
                    e.printStackTrace();
                }
            }
            this.oneStep(cmd);
            this.logOutput();
            ++this.step;
            this.current = null;
            if (stmts.length > this.step) continue;
            this.eventMgr.quit = true;
        }
    }

    void logOutput() {
        LanguageServer langServer = LSP.getServer();
        String lastUrl = langServer.getLastUrl();
        String uri = lastUrl.substring(1, lastUrl.length() - 1) + ".log";
        String url = "\"" + uri + "\"";
        langServer.getLSP().createFile(uri, this.baos.toString());
    }

    private void oneStep(ISQLCommand cmd) {
        block18: {
            CommandRegistry.fireBeginScriptListeners(this.runner.getConn(), this.runner.getScriptRunnerContext());
            Boolean commandLineConnect = (Boolean)this.runner.getScriptRunnerContext().getProperty("script.runner.commandlineconnect");
            if ((commandLineConnect == null || commandLineConnect.equals(Boolean.FALSE)) && this.runner.getScriptRunnerContext().getProperty("sqlplus.login.file") == null && this.runner.getScriptRunnerContext().getProperty("SQLCLI_IGNORE_FIRST_LINE") != null && this.runner.getScriptRunnerContext().getProperty("SQLCLI_IGNORE_FIRST_LINE").equals(true)) {
                this.runner.getScriptRunnerContext().putProperty("SQLCLI_IGNORE_FIRST_LINE", false);
                return;
            }
            ISQLCommand[] stmts = this.file2stmts.get(this.fileUrl);
            if (this.runner.getScriptRunnerContext().isCommandLine() && ScriptVM.isFile(this.runner.getScriptRunnerContext()) && !cmd.isComplete() && this.step == stmts.length - 1 && !this.runner.getScriptRunnerContext().getTopLevel()) {
                if (this.runner.getScriptRunnerContext().getProperty("script.runner.isslashstatement") == null || !Boolean.parseBoolean(this.runner.getScriptRunnerContext().getProperty("script.runner.isslashstatement").toString())) {
                    this.runner.getScriptRunnerContext().putProperty("incomplete", cmd);
                    return;
                }
                if (this.runner.getScriptRunnerContext().getProperty("script.runner.isslashstatement") != null && Boolean.parseBoolean(this.runner.getScriptRunnerContext().getProperty("script.runner.isslashstatement").toString())) {
                    cmd.setExecutable(Boolean.TRUE);
                    cmd.setRunnable(Boolean.TRUE);
                }
            }
            try {
                PrintWriter pw;
                Boolean errProperty = (Boolean)this.runner.getScriptRunnerContext().getProperty("sqldev.error");
                if (errProperty != null && errProperty.booleanValue()) {
                    this.runner.getScriptRunnerContext().putProperty("sqldev.error.any.in", Boolean.TRUE);
                }
                this.runner.getScriptRunnerContext().putProperty("sqldev.error", Boolean.FALSE);
                this.runner.getScriptRunnerContext().putProperty("sqldev.last.err.message", null);
                this.runner.getScriptRunnerContext().setOutputStreamWrapper(this.runner.getOut());
                this.runner.getScriptRunnerContext().putProperty("current_cmd_count", this.step);
                if (this.runner.getScriptRunnerContext().getProperty("sqlcli.login.sql") == null || !this.runner.getScriptRunnerContext().getProperty("sqlcli.login.sql").equals(true) || this.runner.getScriptRunnerContext().getProperty("LOGIN_FILE_ON_CWD") == null || !cmd.getStmtType().equals((Object)SQLCommand.StmtType.G_C_PLSQL) && !cmd.getStmtType().equals((Object)SQLCommand.StmtType.G_C_SQL)) {
                    this.runner.run(cmd);
                    if (this.runner.getScriptRunnerContext().isDbmsEnabled()) {
                        int defaultEnable = 20000;
                        Integer ii = (Integer)this.runner.getScriptRunnerContext().getProperty("script.runner.lastsetserveroutput");
                        if (ii != null && ii > defaultEnable) {
                            defaultEnable = ii;
                        }
                        ScriptExecutor.enableDbmsOutput(this.runner.getScriptRunnerContext().getBaseConnection(), defaultEnable);
                        this.runner.getScriptRunnerContext().clearDbmsFlags();
                    }
                }
                if (this.runner.getScriptRunnerContext() != null && errProperty != null && errProperty.booleanValue() && (pw = this.runner.getScriptRunnerContext().getErrWriter()) != null) {
                    pw.println(cmd);
                    pw.println();
                    String err = (String)this.runner.getScriptRunnerContext().getProperty("sqldev.last.err.message");
                    err = err.replaceAll("\n", "\nREM ");
                    pw.println(err);
                    pw.println('\n');
                }
                if (this.runner.getScriptRunnerContext().getExited()) {
                    return;
                }
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getStackTrace()[0].toString(), e);
                Boolean systemOut = (Boolean)this.runner.getScriptRunnerContext().getProperty("script.runner.using.systemout");
                try {
                    this.runner.getOut().flush();
                }
                catch (Exception ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, ex.getStackTrace()[0].toString(), ex);
                }
                if (systemOut != null && !systemOut.equals(Boolean.FALSE)) break block18;
                try {
                    this.runner.getOut().close();
                }
                catch (Exception ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, ex.getStackTrace()[0].toString(), ex);
                }
            }
        }
        CommandRegistry.fireEndScriptListeners(this.runner.getConn(), this.runner.getScriptRunnerContext());
        try {
            this.runner.getOut().flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void saveHistoryItem(ISQLCommand cmd) {
    }

    private static boolean isFile(ScriptRunnerContext scriptRunnerContext) {
        return scriptRunnerContext.getProperty("script.runner.appinfo.arraylist") != null && ((ArrayList)scriptRunnerContext.getProperty("script.runner.appinfo.arraylist")).size() > 0;
    }

    private static ISQLCommand changeToListCmd(ISQLCommand cmd) {
        cmd.setSql("list");
        cmd.setSQLOrig("list");
        cmd.setModifiedSQL("list");
        cmd.setStmtId(SQLCommand.StmtSubType.G_S_LIST);
        cmd.setResultsType(SQLCommand.StmtResultType.G_R_NONE);
        cmd.setStmtClass(SQLCommand.StmtType.G_C_SQLPLUS);
        cmd.setExecutable(false);
        cmd.setRunnable(true);
        return cmd;
    }

    @Override
    public List<ThreadGroupReference> topLevelThreadGroups() {
        return null;
    }

    @Override
    public EventQueue eventQueue() {
        return this.eventMgr.queue;
    }

    @Override
    public EventRequestManager eventRequestManager() {
        return this.eventMgr;
    }

    @Override
    public BooleanValue mirrorOf(boolean value) {
        return null;
    }

    @Override
    public ByteValue mirrorOf(byte value) {
        return null;
    }

    @Override
    public CharValue mirrorOf(char value) {
        return null;
    }

    @Override
    public ShortValue mirrorOf(short value) {
        return null;
    }

    @Override
    public IntegerValue mirrorOf(int value) {
        return null;
    }

    @Override
    public LongValue mirrorOf(long value) {
        return null;
    }

    @Override
    public FloatValue mirrorOf(float value) {
        return null;
    }

    @Override
    public DoubleValue mirrorOf(double value) {
        return null;
    }

    @Override
    public StringReference mirrorOf(String value) {
        return null;
    }

    @Override
    public VoidValue mirrorOfVoid() {
        return null;
    }

    @Override
    public Process process() {
        return null;
    }

    @Override
    public void dispose() {
        this.eventMgr.quit = true;
    }

    @Override
    public void exit(int exitCode) {
        this.eventMgr.quit = true;
    }

    @Override
    public boolean canWatchFieldModification() {
        return false;
    }

    @Override
    public boolean canWatchFieldAccess() {
        return false;
    }

    @Override
    public boolean canGetBytecodes() {
        return false;
    }

    @Override
    public boolean canGetSyntheticAttribute() {
        return false;
    }

    @Override
    public boolean canGetOwnedMonitorInfo() {
        return false;
    }

    @Override
    public boolean canGetCurrentContendedMonitor() {
        return false;
    }

    @Override
    public boolean canGetMonitorInfo() {
        return false;
    }

    @Override
    public boolean canUseInstanceFilters() {
        return false;
    }

    @Override
    public boolean canRedefineClasses() {
        return false;
    }

    @Override
    public boolean canAddMethod() {
        return false;
    }

    @Override
    public boolean canUnrestrictedlyRedefineClasses() {
        return false;
    }

    @Override
    public boolean canPopFrames() {
        return false;
    }

    @Override
    public boolean canGetSourceDebugExtension() {
        return false;
    }

    @Override
    public boolean canRequestVMDeathEvent() {
        return false;
    }

    @Override
    public boolean canGetMethodReturnValues() {
        return false;
    }

    @Override
    public boolean canGetInstanceInfo() {
        return false;
    }

    @Override
    public boolean canUseSourceNameFilters() {
        return false;
    }

    @Override
    public boolean canForceEarlyReturn() {
        return false;
    }

    @Override
    public boolean canBeModified() {
        return false;
    }

    @Override
    public boolean canRequestMonitorEvents() {
        return false;
    }

    @Override
    public boolean canGetMonitorFrameInfo() {
        return false;
    }

    @Override
    public boolean canGetClassFileVersion() {
        return false;
    }

    @Override
    public boolean canGetConstantPool() {
        return false;
    }

    @Override
    public void setDefaultStratum(String stratum) {
    }

    @Override
    public String getDefaultStratum() {
        return null;
    }

    @Override
    public long[] instanceCounts(List<? extends ReferenceType> refTypes) {
        return new long[0];
    }

    @Override
    public String description() {
        return this.name();
    }

    @Override
    public String version() {
        return "1.0";
    }

    @Override
    public String name() {
        return "SQL script runner";
    }

    @Override
    public void setDebugTraceMode(int traceFlags) {
    }
}

