/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.dap;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Bootstrap;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.ListeningConnector;
import com.sun.jdi.connect.VMStartException;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.ClassUnloadRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.ExceptionRequest;
import com.sun.jdi.request.StepRequest;
import com.sun.jdi.request.ThreadDeathRequest;
import com.sun.jdi.request.ThreadStartRequest;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.logging.Level;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.dap.Breakpoint;
import oracle.dbtools.dap.DAP;
import oracle.dbtools.dap.StarterBlock;
import oracle.dbtools.dap.script.ScriptReferenceType;
import oracle.dbtools.dap.script.ScriptThread;
import oracle.dbtools.dap.script.ScriptVM;
import oracle.dbtools.lsp.BackgroundParser;
import oracle.dbtools.lsp.LSP;
import oracle.dbtools.lsp.LanguageServer;
import oracle.dbtools.lsp.dictionary.Item;
import oracle.dbtools.lsp.features.Location;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.json.NamedValue;
import oracle.dbtools.parser.json.Util;
import oracle.dbtools.util.Service;

public class DebugAdapter {
    private DAP dap;
    private OutputStream send;
    private TreeMap<String, List<Breakpoint>> breakpoints = new TreeMap();
    VirtualMachine vm;
    String startDebugUrl = null;
    public Connection conn = null;
    ThreadReference current = null;
    int frameId = 0;
    List<StackFrame> stackFrames = new LinkedList<StackFrame>();
    Map<String, String> dbSources = new HashMap<String, String>();

    public DebugAdapter(DAP dap, OutputStream send) {
        this.dap = dap;
        this.send = send;
    }

    public DAP getDAP() {
        return this.dap;
    }

    public String cancel(NamedValue param) {
        NamedValue requestId = param.child("\"requestId\"");
        return requestId.atomic;
    }

    public String initialize(NamedValue param) {
        return "{\"supportsCancelRequest\": true ,\"supportsCompletionsRequest\": true ,\"completionTriggerCharacters\": [\".\"] ,\"supportsConfigurationDoneRequest\": true ,\"supportsDisassembleRequest\": true ,\"supportsEvaluateForHovers\": true ,\"supportsExceptionFilterOptions\": false ,\"supportsExceptionInfoRequest\": true ,\"supportsRestartFrame\": true ,\"supportsGotoTargetsRequest\": true ,\"supportsStepInTargetsRequest\": true ,\"supportsModulesRequest\": true ,\"supportsRestartRequest\": true ,\"supportsExceptionOptions\": true ,\"supportsValueFormattingOptions\": true ,\"supportsDelayedStackTraceLoading\": true ,\"supportsLogPoints\": true ,\"supportsReadMemoryRequest\": true ,\"supportsSetExpression\": true ,\"supportsSetVariable\": true ,\"supportsSteppingGranularity\": true ,\"supportSuspendDebuggee\": true ,\"supportTerminateDebuggee\": true ,\"supportsWriteMemoryRequest\": true }";
    }

    public String setBreakpoints(NamedValue arguments) {
        StringBuilder ret = new StringBuilder("{ \"breakpoints\": [");
        int cnt = 0;
        for (Breakpoint b : this.breakpoints(arguments)) {
            if (0 < cnt) {
                ret.append(",");
            }
            ret.append(b.toJson());
            ++cnt;
        }
        ret.append("] } ");
        return ret.toString();
    }

    public String setExceptionBreakpoints(NamedValue arguments) {
        return "{ \"breakpoints\": [] } ";
    }

    public List<Breakpoint> getBreakpoints(String filename) {
        return this.breakpoints.get(filename);
    }

    private List<Breakpoint> breakpoints(NamedValue param) {
        NamedValue breakpoints = param.child("\"breakpoints\"");
        NamedValue source = param.child("\"source\"");
        NamedValue path = source.child("\"path\"");
        String filename = Util.cleanText(path.atomic.substring(1, path.atomic.length() - 1));
        List<Breakpoint> ret = this.breakpoints.get(filename = filename.replace('\\', '/'));
        if (ret == null) {
            ret = new LinkedList<Breakpoint>();
            this.breakpoints.put(filename, ret);
        }
        for (NamedValue bp : breakpoints.composite) {
            NamedValue ln = bp.child("\"line\"");
            int line = Integer.parseInt(ln.atomic);
            Breakpoint breakpoint = new Breakpoint(line, true);
            ret.add(breakpoint);
        }
        return ret;
    }

    public Object configurationDone(NamedValue arguments) throws Exception {
        String message;
        String connstr;
        ParseNode child;
        Iterator iterator;
        LanguageServer langServer = LSP.getServer();
        if (langServer == null) {
            throw new Exception("langServer == null");
        }
        this.startDebugUrl = langServer.getLastUrl();
        if (this.startDebugUrl == null) {
            String message2 = "VT: no current editor?";
            LSP.windowShowMessage("VT: no current editor?", 1);
            return new Exception("VT: no current editor?");
        }
        final BackgroundParser parser = langServer.getParser(this.startDebugUrl);
        String plSqlBlock = parser.text;
        boolean isBlock = true;
        if (!parser.root.contains("block_stmt") && (iterator = parser.root.children().iterator()).hasNext() && !(child = (ParseNode)iterator.next()).contains("block_stmt")) {
            isBlock = false;
        }
        if ((connstr = langServer.associatedFullConnStr(this.startDebugUrl)) == null) {
            message = "Not connected";
            LSP.windowShowMessage("Not connected", 1);
            return new Exception("Not connected");
        }
        this.conn = DriverManager.getConnection(connstr);
        if (this.conn == null) {
            message = "Not connected";
            LSP.windowShowMessage("Not connected", 1);
            return new Exception("Not connected");
        }
        if (!isBlock) {
            StarterBlock block = this.generatePLSQLStarter(parser);
            if (block != null) {
                String debuggeeName = block.getFullName();
                debuggeeName = debuggeeName.replace("\"", "");
                String url = langServer.rootUri + "/debug " + debuggeeName + ".sql";
                langServer.getLSP().createFile(url, block.toString(), true);
                String message3 = "Generated starter block: " + url;
                LSP.windowShowMessage(message3, 3);
                return new Exception(message3);
            }
            this.vm = new ScriptVM(parser, this);
            this.createBreakpointRequests(this.vm, new ClassPrepareEvent(){

                @Override
                public EventRequest request() {
                    return null;
                }

                @Override
                public VirtualMachine virtualMachine() {
                    return DebugAdapter.this.vm;
                }

                @Override
                public ThreadReference thread() {
                    return ScriptThread.instance;
                }

                @Override
                public ReferenceType referenceType() {
                    return new ScriptReferenceType(parser);
                }
            });
            this.vm.resume();
        } else {
            this.vm = this.connectAndLaunchVM();
            this.enableClassPrepareRequest(this.vm);
        }
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    EventSet eventSet = null;
                    while ((eventSet = DebugAdapter.this.vm.eventQueue().remove()) != null) {
                        for (Event event : eventSet) {
                            DAP.LOG.log(Level.INFO, event.toString());
                            if (event instanceof VMStartEvent) {
                                DebugAdapter.this.startSession();
                            }
                            if (event instanceof ClassPrepareEvent) {
                                DebugAdapter.this.createBreakpointRequests(DebugAdapter.this.vm, (ClassPrepareEvent)event);
                            }
                            if (event instanceof BreakpointEvent) {
                                BreakpointEvent bkptEvent = (BreakpointEvent)event;
                                event.request().disable();
                                DebugAdapter.this.dap.event("stopped", "{\"reason\":\"entry\",\"threadId\":1}");
                                DebugAdapter.this.dap.event("continued", "{\"threadId\":1}");
                                DebugAdapter.this.dap.event("stopped", "{\"reason\":\"breakpoint\", \"description\":\"my bkpt\"}");
                                DebugAdapter.this.captureStackFrames(bkptEvent);
                                DebugAdapter.this.current = bkptEvent.thread();
                                continue;
                            }
                            if (event instanceof StepEvent) {
                                StepEvent stepEvent = (StepEvent)event;
                                stepEvent.request().disable();
                                DebugAdapter.this.dap.event("stopped", "{\"reason\":\"entry\",\"threadId\":1}");
                                DebugAdapter.this.dap.event("continued", "{\"threadId\":1}");
                                DebugAdapter.this.dap.event("stopped", "{\"reason\":\"step\", \"description\":\"my step\"}");
                                DebugAdapter.this.captureStackFrames(stepEvent);
                                DebugAdapter.this.current = stepEvent.thread();
                                continue;
                            }
                            if (event instanceof VMDeathEvent) {
                                DebugAdapter.this.vm.dispose();
                                break;
                            }
                            if (event instanceof VMDisconnectEvent) break;
                            DebugAdapter.this.vm.resume();
                        }
                        if (eventSet.size() != 0) continue;
                        DAP.LOG.log(Level.INFO, "eventSet.size() == 0");
                    }
                    if (eventSet == null) {
                        DAP.LOG.log(Level.INFO, "eventSet == null");
                    }
                }
                catch (VMDisconnectedException e) {
                    e.printStackTrace();
                    LSP.windowShowMessage("Virtual Machine is disconnected.", 3);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    DebugAdapter.this.endSession();
                }
            }
        }.start();
        return null;
    }

    private StarterBlock generatePLSQLStarter(BackgroundParser parser) {
        if (!parser.root.contains("create_plsql")) {
            return null;
        }
        Parsed target = new Parsed(parser.text, parser.src, parser.root);
        try {
            String prg = Service.readFile(DebugAdapter.class, "module.arbori");
            int pos = parser.getLastCharPos();
            int srcPos = LexerToken.char2lex(parser.src, pos);
            StarterBlock struct = new StarterBlock(srcPos);
            SqlProgram program = new SqlProgram(prg, (Object)struct);
            program.eval(target);
            return struct;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRDBMSdebug() throws Exception {
        Statement cs = null;
        try {
            LanguageServer langServer = LSP.getServer();
            String lastUrl = langServer.getLastUrl();
            BackgroundParser parser = langServer.getParser(lastUrl);
            Object plSqlBlock = parser.text;
            if (!parser.root.contains("block_stmt")) {
                ParseNode firstChild = null;
                Iterator<LexerToken> iterator = parser.root.children().iterator();
                if (iterator.hasNext()) {
                    ParseNode child;
                    firstChild = child = (ParseNode)((Object)iterator.next());
                }
                plSqlBlock = parser.text.substring(parser.src.get((int)firstChild.from).begin, parser.src.get((int)firstChild.to).begin);
            }
            int ins = -1;
            for (LexerToken t : parser.src) {
                if (!"BEGIN".equalsIgnoreCase(t.content)) continue;
                ins = t.end;
                break;
            }
            plSqlBlock = ((String)plSqlBlock).substring(0, ins) + "\n  dbms_debug_jdwp.connect_tcp('127.0.0.1', 4000);\n" + ((String)plSqlBlock).substring(ins);
            cs = this.conn.prepareCall((String)plSqlBlock);
            cs.execute();
        }
        finally {
            if (cs != null) {
                try {
                    cs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String launch(NamedValue param) throws Exception {
        NamedValue startPlsqlBlock = param.child("\"startPlsqlBlock\"");
        return null;
    }

    public String next(NamedValue param) throws Exception {
        this.clearPreviousStep(this.current);
        StepRequest stepRequest = this.vm.eventRequestManager().createStepRequest(this.current, -2, 2);
        stepRequest.addCountFilter(1);
        stepRequest.enable();
        this.vm.resume();
        return null;
    }

    private void clearPreviousStep(ThreadReference thread) {
        EventRequestManager mgr = this.vm.eventRequestManager();
        for (StepRequest request : mgr.stepRequests()) {
            if (!request.thread().equals(thread)) continue;
            mgr.deleteEventRequest(request);
            break;
        }
    }

    public String resume(NamedValue arguments) {
        this.clearPreviousStep(this.current);
        this.vm.resume();
        return null;
    }

    public String scopes(NamedValue param) {
        this.frameId = Integer.parseInt(param.child((String)"\"frameId\"").atomic);
        return "{\"scopes\":[{\"name\":\"Locals\",\"variablesReference\":1000,\"expensive\":false}]}";
    }

    public String stackTrace(NamedValue param) throws Exception {
        StringBuilder ret = new StringBuilder("{\"stackFrames\":[");
        NamedValue levels = param.child("\"levels\"");
        NamedValue startFrame = param.child("\"startFrame\"");
        int from = Integer.parseInt(startFrame.atomic);
        int to = from + Integer.parseInt(levels.atomic);
        if (this.stackFrames.size() < to) {
            to = this.stackFrames.size();
        }
        for (int i = from; i < to; ++i) {
            StackFrame sf = this.stackFrames.get(i);
            if (0 < i) {
                ret.append(",");
            }
            ret.append("{\"id\":" + i);
            String path = this.startDebugUrl;
            if (path.charAt(0) == '\"') {
                path = path.substring(1, path.length() - 1);
            }
            if (i < this.stackFrames.size() - 1) {
                path = this.sourcePath(sf);
            }
            ret.append(",\"source\":{\"name\":\"" + sf.location().sourceName() + "\"");
            ret.append(",\"path\":\"" + path + "\"");
            ret.append(",\"sourceReference\":0,\"adapterData\":\"mock-adapter-data\"");
            ret.append("}");
            ret.append(",\"line\":" + sf.location().lineNumber() + ",\"column\":0,\"name\":\"" + sf.location().sourceName() + "\"}");
        }
        ret.append("],\"totalFrames\":" + (to - from) + "}");
        return ret.toString();
    }

    public String stepIn(NamedValue arguments) {
        this.clearPreviousStep(this.current);
        StepRequest stepRequest = this.vm.eventRequestManager().createStepRequest(this.current, -2, 1);
        stepRequest.addCountFilter(1);
        stepRequest.enable();
        this.vm.resume();
        return null;
    }

    public String threads() {
        StringBuilder ret = new StringBuilder("{ \"threads\": [");
        ret.append("{\"id\": 1, \"name\": \"SQL Debugger single thread\" }");
        ret.append("] } ");
        return ret.toString();
    }

    public String variables() throws SQLException, IOException, AbsentInformationException {
        StringBuilder ret = new StringBuilder("{\"variables\":[");
        int cnt = 0;
        StackFrame currentFrame = this.stackFrames.get(this.frameId);
        Map<LocalVariable, Value> visibleVariables = currentFrame.getValues(currentFrame.visibleVariables());
        for (LocalVariable lv : visibleVariables.keySet()) {
            if (0 < cnt) {
                ret.append(",");
            }
            ++cnt;
            Value val = visibleVariables.get(lv);
            ObjectReference obj = (ObjectReference)val;
            ReferenceType refType = obj.referenceType();
            String value = "\"NULL\"";
            for (Field field : refType.fields()) {
                Value fv;
                if (!field.name().contains("value") || (fv = obj.getValue(field)) == null) continue;
                value = fv.toString();
            }
            ret.append("{\"name\":\"" + lv.name() + "\", \"value\":" + value + ",\"variablesReference\": 0}");
        }
        ret.append("] } ");
        return ret.toString();
    }

    public Object evaluate(NamedValue param) throws Exception {
        String expression = param.child((String)"\"expression\"").atomic;
        expression = expression.substring(1, expression.length() - 1);
        int frame = Integer.parseInt(param.child((String)"\"frameId\"").atomic);
        StackFrame currentFrame = this.stackFrames.get(frame);
        Map<LocalVariable, Value> visibleVariables = currentFrame.getValues(currentFrame.visibleVariables());
        for (LocalVariable lv : visibleVariables.keySet()) {
            if (!expression.toUpperCase().equals(lv.name())) continue;
            Value val = visibleVariables.get(lv);
            ObjectReference obj = (ObjectReference)val;
            ReferenceType refType = obj.referenceType();
            String value = "\"NULL\"";
            for (Field field : refType.fields()) {
                Value fv;
                if (!field.name().contains("value") || (fv = obj.getValue(field)) == null) continue;
                value = fv.toString();
            }
            return "{\"result\":" + value + "}";
        }
        return new Exception("VT: unreferenced " + expression);
    }

    private String sourcePath(StackFrame frame) throws Exception {
        String dbLocation = frame.location().sourcePath();
        String file = this.dbSources.get(dbLocation);
        if (file == null) {
            StringTokenizer st = new StringTokenizer(dbLocation, "\\.");
            st.nextToken();
            Object type = st.nextToken().toUpperCase();
            if (((String)type).startsWith("PACKAGE") && "PACKAGE".length() < ((String)type).length()) {
                type = "PACKAGE " + ((String)type).substring("PACKAGE".length());
            }
            if ("BLOCK".equals(type)) {
                throw new AssertionError((Object)"\"BLOCK\".equals(type)");
            }
            String schema = st.nextToken();
            String object = st.nextToken();
            Item item = new Item(object, (String)type, schema);
            LanguageServer langServer = LSP.getServer();
            BackgroundParser parser = langServer.getParser(this.startDebugUrl);
            Object location = parser.getRegistry().locate(item, true);
            if (location instanceof Exception) {
                throw (Exception)location;
            }
            if (location instanceof Location) {
                file = ((Location)location).url;
                this.dbSources.put(dbLocation, file);
            }
        }
        return file;
    }

    public String disconnect(NamedValue arguments) {
        LSP.windowShowMessage("Debugging Stopped", 3);
        this.endSession();
        return null;
    }

    private VirtualMachine connectAndLaunchVM() throws IOException, IllegalConnectorArgumentsException, VMStartException {
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                    DebugAdapter.this.startRDBMSdebug();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    DAP.LOG.log(Level.INFO, "startRDBMSdebug() completed");
                    DebugAdapter.this.endSession();
                }
            }
        }.start();
        ListeningConnector connector = DebugAdapter.getAttachingConnector();
        Map<String, Connector.Argument> arguments = connector.defaultArguments();
        arguments.get("port").setValue("4000");
        VirtualMachine vm = connector.accept(arguments);
        return vm;
    }

    private static ListeningConnector getAttachingConnector() {
        List<ListeningConnector> connectors = Bootstrap.virtualMachineManager().listeningConnectors();
        for (int i = 0; i < connectors.size(); ++i) {
            ListeningConnector c = connectors.get(i);
            if (!"com.sun.jdi.SocketListen".equals(c.name())) continue;
            return c;
        }
        return null;
    }

    private void enableClassPrepareRequest(VirtualMachine vm) {
        ClassPrepareRequest classPrepareRequest = vm.eventRequestManager().createClassPrepareRequest();
        classPrepareRequest.addClassFilter("$Oracle.Procedure.*");
        classPrepareRequest.addClassFilter("$Oracle.PackageBody.*");
        classPrepareRequest.enable();
    }

    public void createBreakpointRequests(VirtualMachine vm, ClassPrepareEvent event) throws AbsentInformationException {
        ReferenceType classType = event.referenceType();
        for (String source : this.breakpoints.keySet()) {
            String dictionaryUri = LSP.getServer().dictionaryUri;
            String name = classType.name();
            StringTokenizer st = new StringTokenizer(name, "\\.");
            st.nextToken();
            String type = st.nextToken().toUpperCase();
            if ("BLOCK".equals(type)) {
                throw new AssertionError((Object)"\"BLOCK\".equals(type)");
            }
            if ("PACKAGE".equals(type) || "PACKAGE BODY".equals(type) || "PROCEDURE".equals(type) || "FUNCTION".equals(type)) {
                String object;
                String schema = st.nextToken();
                if (!source.toUpperCase().contains(" " + schema + "/") || !source.contains(object = st.nextToken())) {
                    continue;
                }
            } else if ("SCRIPT".equals(type)) {
                // empty if block
            }
            for (Breakpoint breakpoint : this.breakpoints.get(source)) {
                List<com.sun.jdi.Location> locationsOfLine = classType.locationsOfLine(breakpoint.line);
                if (locationsOfLine.size() == 0) continue;
                com.sun.jdi.Location location = locationsOfLine.get(0);
                BreakpointRequest bpReq = vm.eventRequestManager().createBreakpointRequest(location);
                bpReq.enable();
            }
        }
    }

    public void captureStackFrames(LocatableEvent event) throws IncompatibleThreadStateException, AbsentInformationException {
        this.stackFrames = event.thread().frames();
    }

    private void startSession() {
        EventRequestManager em = this.vm.eventRequestManager();
        ClassPrepareRequest classPrepareRequest = em.createClassPrepareRequest();
        classPrepareRequest.setSuspendPolicy(2);
        classPrepareRequest.enable();
        ClassUnloadRequest classUnloadRequest = em.createClassUnloadRequest();
        classUnloadRequest.setSuspendPolicy(0);
        classUnloadRequest.enable();
        ThreadStartRequest threadStartRequest = em.createThreadStartRequest();
        threadStartRequest.setSuspendPolicy(0);
        threadStartRequest.enable();
        ThreadDeathRequest threadDeathRequest = em.createThreadDeathRequest();
        threadDeathRequest.setSuspendPolicy(0);
        threadDeathRequest.enable();
        ExceptionRequest exceptionRequest = em.createExceptionRequest(null, false, true);
        exceptionRequest.setSuspendPolicy(2);
        exceptionRequest.enable();
    }

    private void endSession() {
        this.dap.event("terminated", null);
        this.dap.event("exited", "{\"exitCode\":0}");
        this.endVM();
        if (this.conn != null) {
            try {
                this.conn.close();
                this.conn = null;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private void endVM() {
        if (this.vm != null) {
            try {
                this.vm.exit(0);
                this.vm.dispose();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.vm = null;
            }
        }
    }
}

