/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.connections;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import oracle.dbtools.connections.Location;

final class InternalLocation
implements Location {
    private final ClassLoader loader;
    private final String path;

    static Location createInternalLocation(String path, ClassLoader cl) {
        return new InternalLocation(path, cl);
    }

    private InternalLocation(String path, ClassLoader cl) {
        this.path = path;
        this.loader = cl == null ? Thread.currentThread().getContextClassLoader() : cl;
    }

    private URL findResource() throws IOException {
        return this.loader.getResource(this.path);
    }

    @Override
    public boolean exists() {
        return this.loader.getResource(this.path) != null;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        URL url = this.findResource();
        return url != null ? url.openStream() : null;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new IOException(new UnsupportedOperationException("getOutputStream()"));
    }

    @Override
    public URI getRelativeRoot() {
        URI root = null;
        try {
            URL url = this.findResource();
            URI file = url.toURI();
            String path = file.getPath();
            if (path != null) {
                root = file.resolve(path.endsWith("/") ? ".." : ".");
            }
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
        return root;
    }
}

