/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.connections;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.connections.ReferencePair;
import oracle.dbtools.data.common.Iterators;

public final class ConnectionReference
implements Iterable<ReferencePair> {
    private final String className;
    private final ReferencePair[] values;

    private ConnectionReference(String className, List<ReferencePair> values) {
        this.className = className;
        this.values = values.toArray(new ReferencePair[0]);
    }

    public String getClassName() {
        return this.className;
    }

    public ReferencePair get(String key) {
        ReferencePair value = null;
        for (ReferencePair r : this.values) {
            if (!ModelUtil.areEqual(key, r.getKey())) continue;
            value = r;
            break;
        }
        return value;
    }

    @Override
    public Iterator<ReferencePair> iterator() {
        return Iterators.iterator(this.values);
    }

    public static final class ReferenceBuilder {
        private final String className;
        private final List<ReferencePair> values = new ArrayList<ReferencePair>();

        public ReferenceBuilder(String className) {
            this.className = className;
        }

        public ReferenceBuilder addValue(ReferencePair value) {
            this.values.add(value);
            return this;
        }

        public ConnectionReference build() {
            return new ConnectionReference(this.className, this.values);
        }
    }
}

