/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.utils;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringUtils {
    private static final String DQ = "\"";

    public static void main(String[] args) {
        String s = "           This is a #weird String         ";
        System.out.println(s);
        System.out.println("ltrim >" + StringUtils.ltrim(s) + "<");
        System.out.println("rtrim >" + StringUtils.rtrim(s) + "<");
        System.out.println("nonalpha >" + StringUtils.getFirstNonAlpha(s) + "<");
        System.out.println(StringUtils.initCapSingle("tYPE bODY"));
        System.out.println(StringUtils.initCap("tYPE bODY"));
        System.out.println(StringUtils.initCapSingle("tYPE bODY"));
    }

    public static String ltrim(String s) {
        int i;
        for (i = 0; i < s.length() && Character.isWhitespace(s.charAt(i)); ++i) {
        }
        return s.substring(i);
    }

    public static String rtrim(String s) {
        int i;
        for (i = s.length() - 1; i >= 0 && Character.isWhitespace(s.charAt(i)); --i) {
        }
        return s.substring(0, i + 1);
    }

    public static String getFirstNonAlpha(String str) {
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            char c = str.charAt(i);
            if (Character.isAlphabetic(c) || Character.isDigit(c) || Character.isSpaceChar(c)) continue;
            return Character.toString(c);
        }
        return null;
    }

    public static String initCap(String line) {
        String[] arr = line.split(" ");
        StringBuilder sb = new StringBuilder();
        for (String word : arr) {
            word = word.toUpperCase().replace(word.substring(1), word.substring(1).toLowerCase());
            sb.append(word + " ");
        }
        return sb.toString().trim();
    }

    public static Object initCapSingle(String objectType) {
        if (objectType.length() > 1) {
            return objectType.toUpperCase().substring(0, 1) + objectType.toLowerCase().substring(1);
        }
        return objectType.toUpperCase();
    }

    public static String replaceEnvironmentVariables(String text) {
        Map<String, String> envMap = System.getenv();
        String pattern = "\\$([A-za-z0-9]+)|\\$\\{([A-Za-z0-9_]+)\\}|\\%([A-Za-z0-9_]+)\\%";
        Pattern expr = Pattern.compile(pattern);
        Matcher matcher = expr.matcher(text);
        while (matcher.find()) {
            String checker = null;
            for (int i = 1; i <= matcher.groupCount() && (checker = matcher.group(i)) == null; ++i) {
            }
            String envValue = null;
            if (checker != null) {
                envValue = envMap.get(checker.toUpperCase());
            }
            if (envValue == null) {
                envValue = "";
                continue;
            }
            envValue = envValue.replace("\\", "\\\\");
            Pattern subexpr = Pattern.compile(Pattern.quote(matcher.group(0)));
            text = subexpr.matcher(text).replaceAll(envValue);
        }
        return text;
    }

    public static String unQuote(String s) {
        if (s != null && !s.isEmpty() && s.startsWith(DQ) && s.endsWith(DQ) && s.length() > 1) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }
}

