/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.config;

import java.io.File;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.common.config.IStorage;

public interface IEnvironmentConfig {
    public static final String ENV_ENCODING = "ENV_ENCODING";
    public static final String ENV_GUI = "ENV_GUI";
    public static final String ENV_LINE_TERMINATOR = "ENV_LINE_TERMINATOR";
    public static final String ENV_USER_DIR = "ENV_USER_DIR";
    public static final String ENV_USER_TEMP_DIR = "ENV_USER_TEMP_DIR";

    public static class Storage
    implements IStorage {
        private static IStorage INSTANCE = new Storage();
        private static IStorage storage;

        private Storage() {
        }

        public static IStorage getInstance() {
            return INSTANCE;
        }

        public static void setBackingStorage(IStorage theStorage) {
            storage = theStorage;
        }

        @Override
        public String getString(String key) {
            String retVal = null;
            if (storage != null && storage.contains(key)) {
                retVal = storage.getString(key);
            }
            if (null == retVal) {
                retVal = Defaults.getString(key);
            }
            return retVal;
        }

        @Override
        public void putString(String key, String value) {
            if (storage == null) {
                throw new IllegalAccessError("No IStorage implementation set. Cannot put values");
            }
            storage.putString(key, value);
        }

        @Override
        public int getInt(String key) {
            int retVal = 0;
            if (storage != null && storage.contains(key)) {
                retVal = storage.getInt(key);
            }
            if (0 == retVal) {
                retVal = Defaults.getInteger(key);
            }
            return retVal;
        }

        @Override
        public void putInt(String key, int value) {
            if (storage == null) {
                throw new IllegalAccessError("No IStorage implementation set. Cannot put values");
            }
            storage.putInt(key, value);
        }

        @Override
        public Boolean getBoolean(String key) {
            Boolean retVal = null;
            if (storage != null && storage.contains(key)) {
                retVal = storage.getBoolean(key);
            }
            if (null == retVal) {
                retVal = Defaults.getBoolean(key);
            }
            return retVal;
        }

        @Override
        public void putBoolean(String key, boolean value) {
            if (storage == null) {
                throw new IllegalAccessError("No IStorage implementation set. Cannot put values");
            }
            storage.putBoolean(key, value);
        }
    }

    public static class Defaults {
        private static final HashMap<String, Object> s_defaults = new HashMap();

        public static Map<String, Object> get() {
            return (Map)s_defaults.clone();
        }

        static String getString(String parm) {
            Object obj = s_defaults.get(parm);
            return obj instanceof String ? (String)obj : (obj != null ? obj.toString() : null);
        }

        static Integer getInteger(String parm) {
            Object obj = s_defaults.get(parm);
            return obj instanceof Integer ? (Integer)obj : (obj != null ? Integer.valueOf(Integer.parseInt(obj.toString())) : null);
        }

        static boolean getBoolean(String parm) {
            Object obj = s_defaults.get(parm);
            return obj instanceof Boolean ? (Boolean)obj : (obj != null ? Boolean.parseBoolean(obj.toString()) : false);
        }

        static {
            InputStreamReader isr = new InputStreamReader(System.in);
            s_defaults.put(IEnvironmentConfig.ENV_ENCODING, isr.getEncoding().intern());
            s_defaults.put(IEnvironmentConfig.ENV_GUI, Boolean.FALSE.toString());
            s_defaults.put(IEnvironmentConfig.ENV_LINE_TERMINATOR, System.lineSeparator());
            String userDir = System.getProperty("user.home");
            String userTempDir = userDir + File.separator + "tmp";
            File userTempFile = new File(userTempDir + File.separator + "tmp");
            if (!userTempFile.exists()) {
                userTempFile.mkdir();
            }
            s_defaults.put(IEnvironmentConfig.ENV_USER_DIR, userDir);
            s_defaults.put(IEnvironmentConfig.ENV_USER_TEMP_DIR, userTempDir);
        }
    }
}

