/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.util.Map;
import java.util.Set;
import oracle.dbtools.arbori.Attribute;
import oracle.dbtools.arbori.Tuple;
import oracle.dbtools.parser.ParseNode;

class Parent
extends Attribute {
    String ref;

    public Parent(String name) {
        this.name = name;
        this.ref = Parent.referredTo(name);
    }

    @Override
    Set<Tuple> eval(Map<String, Integer> attributePositions, Set<Tuple> candidates, ParseNode root) {
        int nameCol = attributePositions.get(this.name);
        int refCol = attributePositions.get(this.ref);
        for (Tuple t : candidates) {
            if (t.values[refCol] == null) continue;
            t.values[nameCol] = t.values[refCol].parent();
        }
        return candidates;
    }

    @Override
    Attribute referredTo(Map<String, Attribute> varDefs) {
        return varDefs.get(this.ref);
    }

    @Override
    ParseNode lookup(Map<String, Integer> attributePositions, ParseNode[] tuple, Map<String, Attribute> varDefs) {
        return this.referredTo(varDefs).lookup(attributePositions, tuple, varDefs).parent();
    }
}

