/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.lang.reflect.Field;
import java.util.Map;
import oracle.dbtools.arbori.Attribute;
import oracle.dbtools.arbori.Position;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.scripting.GlobalMap;

class BindVar
extends Position {
    BindVar(String name) {
        super(name);
    }

    @Override
    public int eval(Map<String, Integer> attributePositions, ParseNode[] tuple, Map<String, Attribute> varDefs) {
        GlobalMap globals = this.master.prog.getGlobals();
        if (globals != null) {
            Object object = globals.get(this.name);
            if (object instanceof String) {
                try {
                    return Integer.parseInt((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (object instanceof Integer) {
                try {
                    return (Integer)object;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        try {
            Field f = this.master.prog.getClass().getField(this.name);
            f.setAccessible(true);
            return f.getInt(this.master.prog);
        }
        catch (NoSuchFieldException e) {
            try {
                Field f = this.master.prog.struct.getClass().getField(this.name);
                f.setAccessible(true);
                return f.getInt(this.master.prog.struct);
            }
            catch (Exception e1) {
                throw new AssertionError((Object)("Bind var '" + this.name + "' not found: " + e1.getMessage()));
            }
        }
        catch (Exception e) {
            throw new AssertionError((Object)("Bind var '" + this.name + "' not found: " + e.getMessage()));
        }
    }

    public String toString() {
        return ":" + this.name;
    }
}

