/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app.injection0;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import oracle.dbtools.app.injection0.PlsqlException;
import oracle.dbtools.app.injection0.PlsqlType;
import oracle.dbtools.app.injection0.SqlInjectionGraph;
import oracle.dbtools.app.injection0.SymbolTable;
import oracle.dbtools.app.injection0.TypeConversion;
import oracle.dbtools.app.injection0.Usage;
import oracle.dbtools.parser.ParseNode;

class ValueNode {
    private static final boolean DEBUG = false;
    String nonterm;
    ParseNode pos;

    ParseNode getPos() {
        return this.pos;
    }

    ValueNode(String nonterm, ParseNode pos) {
        this.nonterm = nonterm;
        this.pos = pos;
    }

    ExprNode asExprNode(SymbolTable symbols) {
        if (this instanceof ExprNode) {
            return (ExprNode)this;
        }
        switch (this.nonterm) {
            case "identifier": {
                IdentifierNode idNode = (IdentifierNode)this;
                Usage u = symbols.read(idNode.getName());
                if (u == null) {
                    throw new IllegalArgumentException("Undefined symbol " + idNode.getName() + " at " + this.pos);
                }
                List<Usage> usages = Collections.singletonList(u);
                return new ExprNode("expr", this.pos, u.getType(), usages);
            }
        }
        return (ExprNode)this;
    }

    IdentifierNode asIdentifierNode() {
        return (IdentifierNode)this;
    }

    IdentifierNodeDeclared asIdentiferNodeDeclared() {
        return (IdentifierNodeDeclared)this;
    }

    StringNode asStringNode() {
        return (StringNode)this;
    }

    TypeNode asTypeNode() {
        return (TypeNode)this;
    }

    public String toString() {
        return this.nonterm == null ? "<NULL>" : this.nonterm;
    }

    static class StringNode
    extends ValueNode {
        private String name;

        StringNode(String nonterm, ParseNode pos, String s) {
            super(nonterm, pos);
            this.name = s;
        }

        String getName() {
            return this.name;
        }

        @Override
        public String toString() {
            return super.toString() + " " + this.name;
        }
    }

    static class TypeNode
    extends ValueNode {
        PlsqlType type;

        TypeNode(String nonterm, ParseNode pos, PlsqlType type) {
            super(nonterm, pos);
            this.type = type;
        }

        PlsqlType getType() {
            return this.type;
        }

        @Override
        public String toString() {
            return this.nonterm + (this.nonterm.equals("type") ? "" : " type") + " " + this.type;
        }
    }

    static class ParametersNode
    extends ValueNode {
        private final List<IdentifierNode> parameters;

        ParametersNode(String nonterm, ParseNode pos, List<IdentifierNode> parameters) {
            super(nonterm, pos);
            this.parameters = parameters;
        }

        List<IdentifierNode> getParameters() {
            return this.parameters;
        }
    }

    static class IdentifierNodeDeclared
    extends IdentifierNode {
        SymbolTable symtab;
        Usage declaration;

        IdentifierNodeDeclared(IdentifierNode idNode, SymbolTable symtab, Usage declaration) {
            super(idNode.nonterm, idNode.getPos(), idNode.getName(), idNode.type);
            this.symtab = symtab;
            this.declaration = declaration;
        }
    }

    static class MultiNode<T>
    extends ValueNode {
        private ArrayList<T> values = new ArrayList();

        MultiNode(String nonterm, ParseNode pos) {
            super(nonterm, pos);
        }

        void add(T value) {
            this.values.add(value);
        }

        void addAll(List<T> values) {
            this.values.addAll(values);
        }

        List<T> getValues() {
            return this.values;
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer("{");
            for (T value : this.values) {
                sb.append(value == null ? "null" : value.toString());
            }
            sb.append("}");
            return sb.toString();
        }
    }

    static class IdentifierNode
    extends StringNode {
        private EnumSet<SqlInjectionGraph.ParameterMode> modes = EnumSet.noneOf(SqlInjectionGraph.ParameterMode.class);
        private PlsqlType type;

        IdentifierNode(String nonterm, ParseNode pos, String id, PlsqlType type) {
            super(nonterm, pos, id);
            this.type = type;
        }

        IdentifierNode(ValueNode node, String name, PlsqlType type) {
            super(node.nonterm, node.pos, name);
            this.type = type;
        }

        public EnumSet<SqlInjectionGraph.ParameterMode> getModes() {
            return this.modes;
        }

        public void setModes(EnumSet<SqlInjectionGraph.ParameterMode> modes) {
            this.modes = modes;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public PlsqlType getType() {
            return this.type;
        }

        @Override
        public String toString() {
            return super.toString() + " [" + this.type + "] ";
        }
    }

    static class ExprNode
    extends ValueNode {
        private PlsqlType type;
        private List<Usage> usages;

        ExprNode(String nonterm, ParseNode pos, PlsqlType type, List<Usage> usages) {
            super(nonterm, pos);
            this.type = type;
            this.usages = usages != null ? usages : new ArrayList<Usage>(2);
        }

        PlsqlType getType() {
            return this.type;
        }

        List<Usage> getUsages() {
            return this.usages;
        }

        EnumSet<PlsqlException> merge(ExprNode en) {
            this.usages.addAll(en.usages);
            return TypeConversion.exceptionsFromMerge(this.type, en.getType());
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer("Expr " + super.toString() + " " + this.type);
            if (this.usages.size() > 0) {
                sb.append(" <-");
            }
            for (Usage u : this.usages) {
                sb.append(" " + u);
            }
            return sb.toString();
        }
    }

    static class DeclarationNode
    extends ValueNode {
        Usage usage;

        DeclarationNode(String nonterm, ParseNode pos, Usage usage) {
            super(nonterm, pos);
            this.usage = usage;
        }

        @Override
        public String toString() {
            return "Declaration " + super.toString() + (this.usage == null ? "<null usage>" : this.usage.toString());
        }
    }
}

