/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app.injection;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import oracle.dbtools.app.injection.DependencyLink;
import oracle.dbtools.app.injection.FlowFunc;
import oracle.dbtools.app.injection.SqlInjectionGraph;
import oracle.dbtools.app.injection.Symbol;
import oracle.dbtools.app.injection.SymbolTable;
import oracle.dbtools.app.injection.Tuple;
import oracle.dbtools.app.injection.Usage;

class FlowGraph {
    ArrayList<Usage> sources = new ArrayList();
    ArrayList<Usage> sinks = new ArrayList();
    Deque<Object> nodeLabelStack = new ArrayDeque<Object>();

    FlowGraph(Object label) {
        this.nodeLabelStack.addLast(label);
    }

    void addSource(Usage source) {
        this.sources.add(source);
    }

    void addSink(Usage sink) {
        this.sinks.add(sink);
    }

    /*
     * WARNING - void declaration
     */
    List<List<DependencyLink>> getInjections(Function<Usage, ? extends DependencyLink.LocationTuple> linenum, SymbolTable debugScope, boolean keepDuplicates) {
        HashSet<Usage> debugUsages = new HashSet<Usage>();
        ArrayDeque<Path> todo = new ArrayDeque<Path>();
        HashMap<Usage, Path> paths = new HashMap<Usage, Path>();
        if (SqlInjectionGraph.Debug.DUMP_USAGES.has(obj -> "getInjections".equals(obj))) {
            Usage.dumpSaveAll(null, "getInjections", this.sources, this.sinks);
        }
        for (Usage usage : this.sources) {
            debugUsages.add(usage);
            if (usage.isSafe()) continue;
            Path path = new Path(usage);
            paths.put(usage, path);
            todo.addLast(path);
        }
        while (!todo.isEmpty()) {
            Path cur = (Path)todo.removeFirst();
            for (Usage usage : cur.getFlows()) {
                debugUsages.add(usage);
                Path path = (Path)paths.get(usage);
                if (path != null) continue;
                Path path2 = new Path(usage, cur);
                paths.put(usage, path2);
                todo.addLast(path2);
            }
            for (FlowFunc.FlowFuncLink flowFuncLink : cur.getFuncLinks()) {
                for (Usage u : flowFuncLink.getFlows()) {
                    debugUsages.add(u);
                    Path path = (Path)paths.get(u);
                    if (path != null) continue;
                    Path path3 = new Path(u, cur);
                    paths.put(u, path3);
                    todo.addLast(path3);
                }
            }
            for (Usage usage : cur.getSources()) {
                debugUsages.add(usage);
            }
        }
        ArrayList<List<DependencyLink>> allInjections = new ArrayList<List<DependencyLink>>();
        for (Usage usage : this.sinks) {
            debugUsages.add(usage);
            Path path = (Path)paths.get(usage);
            if (path == null) continue;
            ArrayList<DependencyLink> injection = new ArrayList<DependencyLink>();
            for (Usage u : path.getPath()) {
                DependencyLink.LocationTuple lt = linenum.apply(u);
                DependencyLink link = new DependencyLink(u.getName(), u.getLoc(), lt);
                if (!keepDuplicates && !injection.isEmpty() && link.equals(injection.get(injection.size() - 1))) continue;
                injection.add(new DependencyLink(u.getName(), u.getLoc(), lt));
            }
            allInjections.add(injection);
        }
        ArrayDeque<Usage> arrayDeque = new ArrayDeque<Usage>(debugUsages);
        while (!arrayDeque.isEmpty()) {
            Usage usage = (Usage)arrayDeque.removeFirst();
            for (Usage u2 : usage.getFlows()) {
                if (debugUsages.contains(u2)) continue;
                debugUsages.add(u2);
                arrayDeque.addFirst(u2);
            }
            for (Usage u2 : usage.getSources()) {
                if (debugUsages.contains(u2)) continue;
                debugUsages.add(u2);
                arrayDeque.addFirst(u2);
            }
        }
        if (Debug.DUMP_GRAPH.debug) {
            System.out.println("====================== Dumping traverssed usage graph");
            for (Usage usage : debugUsages) {
                System.out.print(usage.string() + " <-");
                for (Usage usage2 : usage.getSources()) {
                    System.out.print(" " + usage2.string());
                }
                System.out.print(" ->");
                for (Usage usage3 : usage.getFlows()) {
                    System.out.print(" " + usage3.string());
                }
                System.out.println();
            }
        }
        if (Debug.DUMP_PATHS.debug) {
            Debug.DUMP_PATHS.outln("====================== Dumping paths");
            HashMap<Path, Usage> hashMap = new HashMap<Path, Usage>();
            HashSet<Path> hashSet = new HashSet<Path>();
            for (Map.Entry entry : paths.entrySet()) {
                Path p4 = (Path)entry.getValue();
                hashMap.put(p4, (Usage)entry.getKey());
                if (p4.prev == null) continue;
                hashSet.add(p4.prev);
            }
            for (Path path : paths.values()) {
                void var12_53;
                if (hashSet.contains(path)) continue;
                while (var12_53 != null) {
                    Usage u;
                    u = (Usage)hashMap.get(var12_53);
                    System.out.print(u.string() + "<=");
                    Path path4 = var12_53.prev;
                }
                System.out.println();
            }
        }
        return allInjections;
    }

    void collectUsages(SymbolTable debugScope, Set<Usage> debugUsages) {
        for (Map.Entry<String, Symbol> e : debugScope.getSymbols().entrySet()) {
            String name = e.getKey();
            Symbol sym = e.getValue();
            if (sym instanceof SymbolTable) {
                this.collectUsages((SymbolTable)sym, debugUsages);
                continue;
            }
            if (sym.getAssigned() == null) continue;
            debugUsages.add(sym.getAssigned());
        }
    }

    public Object getNodeLabel() {
        return this.nodeLabelStack.getLast();
    }

    public void pushNodeLabel(Object nodeLabel) {
        this.nodeLabelStack.addLast(nodeLabel);
    }

    public void popNodeLabel() {
        if (this.nodeLabelStack.isEmpty()) {
            throw new NullPointerException();
        }
        this.nodeLabelStack.pollLast();
    }

    private static class Path {
        Usage usage;
        Tuple<Path, FlowFunc> funcChain;
        Path prev;

        private Path(Usage usage, Path reachedFrom) {
            this.funcChain = reachedFrom == null ? null : reachedFrom.funcChain;
            this.usage = usage;
            this.prev = reachedFrom;
        }

        private Path(Usage usage, Path reachedFrom, FlowFunc flowFunc) {
            this.funcChain = new Tuple<Path, FlowFunc>(reachedFrom, flowFunc);
            this.usage = usage;
            this.prev = reachedFrom;
        }

        private Path(Usage usage) {
            this(usage, null);
        }

        private List<Usage> getFlows() {
            return this.usage.getFlows();
        }

        private List<Usage> getSources() {
            return this.usage.getSources();
        }

        private List<FlowFunc.FlowFuncLink> getFuncLinks() {
            return this.usage.getFuncLinks();
        }

        private List<Usage> getPath() {
            List<Object> ret = this.prev == null ? new ArrayList() : this.prev.getPath();
            ret.add(this.usage);
            return ret;
        }

        private String toString(Function<Usage, ? extends DependencyLink.LocationTuple> linenum) {
            StringBuffer sb = new StringBuffer(this.usage.toString() + ":" + linenum.apply(this.usage) + " |");
            for (Usage u : this.getPath()) {
                sb.append(" " + u + ":" + linenum.apply(u));
            }
            return sb.toString();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(this.usage.toString() + " |");
            for (Usage u : this.getPath()) {
                sb.append(" " + u);
            }
            return sb.toString();
        }
    }

    static enum Debug {
        DUMP_PATHS(true),
        DUMP_GRAPH(true);

        boolean debug = false;
        Object[] parms;

        private Debug(boolean debug) {
        }

        private Debug(boolean debug, Object ... parms) {
            this.parms = parms;
        }

        void out(String string) {
            if (this.debug) {
                System.out.print(string);
            }
        }

        void outln(String line) {
            if (this.debug) {
                System.out.println(line);
            }
        }

        void outln() {
            this.outln("");
        }
    }
}

