/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import oracle.dbtools.app.Rewrite;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.plsql.LazyNode;

public class SqlId
extends Rewrite {
    private String prefix = " ";
    private int sqlCnt = 0;
    private int changeCnt = 0;

    public SqlId(String prefix, Set<String> fileExtensions) {
        super(fileExtensions);
        this.prefix = prefix;
    }

    private static List<Integer> getInsertionsPoints(LazyNode node, List<LexerToken> src) {
        LinkedList<Integer> ret = new LinkedList<Integer>();
        if ("insert".equalsIgnoreCase(node.startToken) || "update".equalsIgnoreCase(node.startToken) || "delete".equalsIgnoreCase(node.startToken) || "select".equalsIgnoreCase(node.startToken) || "with".equalsIgnoreCase(node.startToken) || "merge".equalsIgnoreCase(node.startToken)) {
            ret.add(node.from);
        } else if ("cursor".equalsIgnoreCase(node.startToken) || "for".equalsIgnoreCase(node.startToken)) {
            int pos = -1;
            int start = node.from;
            int end = node.to;
            if ("for".equalsIgnoreCase(node.startToken)) {
                int i = -1;
                for (LazyNode child : node.shallowChildren()) {
                    if (++i == 0) {
                        start = child.from;
                        end = child.to;
                        continue;
                    }
                    ret.addAll(SqlId.getInsertionsPoints(child, src));
                }
            }
            for (LexerToken t : src) {
                if (++pos >= end) break;
                if (pos < start || !"select".equalsIgnoreCase(t.content)) continue;
                ret.add(pos);
                break;
            }
        } else {
            for (LazyNode child : node.shallowChildren()) {
                ret.addAll(SqlId.getInsertionsPoints(child, src));
            }
        }
        return ret;
    }

    @Override
    public String transform(String input, List<LexerToken> src, LazyNode root) {
        String fullPrefix = " /* " + this.prefix;
        List<Integer> insertionPoints = SqlId.getInsertionsPoints(root, src);
        int pos = -1;
        int priorLexPos = 0;
        StringBuilder output = new StringBuilder();
        for (LexerToken t : src) {
            if (!insertionPoints.contains(++pos)) continue;
            ++this.sqlCnt;
            if (fullPrefix.equals(input.substring(t.end, t.end + fullPrefix.length()))) continue;
            output.append(input.substring(priorLexPos, t.end));
            priorLexPos = t.end;
            output.append(fullPrefix + UUID.randomUUID().toString().substring(0, 6) + " */ ");
            ++this.changeCnt;
        }
        output.append(input.substring(priorLexPos));
        return output.toString();
    }

    @Override
    protected String found() {
        return "found " + this.sqlCnt + " statements, ";
    }

    @Override
    protected String changed() {
        return "stamped " + this.changeCnt + " of them";
    }
}

