/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.importer.writers;

import java.net.URL;
import java.sql.PreparedStatement;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.importer.ImportResources;
import oracle.dbtools.importer.core.ImportKeys;
import oracle.dbtools.importer.core.ImportProperties;
import oracle.dbtools.importer.writers.ImportGenModel;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.utils.MessageHandler;
import oracle.dbtools.util.Logger;

public class ImportGenTask {
    private ImportProperties _iProps;
    private ImportGenModel _iGenModel;
    private RaptorTask<Void> _task;

    public ImportGenTask(ImportGenModel iGenModel) {
        this._iGenModel = iGenModel;
        this._iProps = this._iGenModel.getIProps();
    }

    public RaptorTask<Void> getTask(String name, boolean isInDeterminate, IRaptorTaskRunMode mode) {
        this._task = new RaptorTask<Void>(name, true, IRaptorTaskRunMode.MODAL_OPTIONAL){

            public Void doWork() {
                Logger.info(((Object)((Object)this)).getClass(), (String)ImportResources.getString("GEN_TO_WORKSHEET"));
                try {
                    if (ImportGenTask.this._iGenModel.getService().isLockNeeded() && !ImportGenTask.this._iGenModel.lockConnectionForImport()) {
                        this.getDescriptor().setMessage(ImportGenTask.this._iGenModel.getExitCode().getShortMessage() + " " + ImportGenTask.this._iGenModel.getExitCode().getMessage());
                        ImportGenTask.this._iGenModel.isCancel(true);
                    }
                    if (!ImportGenTask.this._iGenModel.isCancel()) {
                        ImportGenTask.this._iGenModel.getService().process();
                        if (ImportGenTask.this._iGenModel.getExitCode() == ExitCode.EXIT_SUCCESS && !ImportGenTask.this._iGenModel.isCancel()) {
                            ImportGenTask.this.commitTask();
                        } else {
                            ImportGenTask.this.rollbackTask();
                        }
                    }
                }
                finally {
                    if (ImportGenTask.this._iGenModel.getService().isLockNeeded()) {
                        ImportGenTask.this._iGenModel.unlockConnectionForImport();
                    }
                    ImportGenTask.this._iGenModel.getService().finish();
                }
                return null;
            }

            public boolean cancel() {
                ImportGenTask.this._iGenModel.isCancel(true);
                return true;
            }
        };
        this._task.getDescriptor().addListener((IRaptorTaskListener)new DBTaskListener(name));
        return this._task;
    }

    public boolean cancelTask() {
        this.rollbackTask();
        if (this._task != null) {
            boolean rtn = this._task.requestCancel();
            return rtn;
        }
        return true;
    }

    public final void rollbackTask() {
        try {
            if (!this._iGenModel.getConn().isClosed() && this._iGenModel.isConnLocked()) {
                this._iGenModel.getConn().rollback();
                if (this._iGenModel.isTableCreated() && !this._iGenModel.isIgnoreAllErrors()) {
                    String dropTableSql = this._iGenModel.getDropTableStatementForPrepare();
                    PreparedStatement pstmt = this._iGenModel.getConn().prepareStatement(dropTableSql);
                    pstmt.execute();
                    this._iGenModel.getConn().commit();
                }
            }
        }
        catch (Exception e) {
            Logger.warn(this.getClass(), (Throwable)e);
        }
    }

    public void commitTask() {
        try {
            if (this._iGenModel.isConnLocked()) {
                this._iGenModel.getConn().commit();
            }
        }
        catch (Exception e) {
            Logger.warn(this.getClass(), (Throwable)e);
        }
    }

    private void outBad(String msg) {
        try {
            this._iGenModel.getStream().printlnBad(msg);
        }
        catch (Exception e) {
            Logger.warn(this.getClass(), (Throwable)e);
        }
    }

    public void closeFiles() {
        if (this._iGenModel.getStream() != null) {
            this._iGenModel.getStream().finished();
            this._iGenModel.getStream().deleteEmptyFile();
            try {
                this._iGenModel.getStream().finishedBad();
            }
            catch (Exception e) {
                Logger.warn(this.getClass(), (Throwable)e);
            }
        }
    }

    final class DBTaskListener
    extends RaptorTaskAdapter {
        private String _taskFullName;
        private String _msg = "";

        DBTaskListener(String taskFullName) {
            this._taskFullName = taskFullName;
        }

        public void taskFailed(RaptorTaskEvent event) {
            RaptorTaskEvent _event = event;
            if (_event.getTaskDescriptor().isCancelled()) {
                this._msg = this._taskFullName + ". ";
                this._msg = this._msg + ImportResources.getString("TASK_CANCELLED_ROLLBACK");
                Logger.warn(((Object)((Object)this)).getClass(), (String)this._msg);
            } else {
                this._msg = this._taskFullName + ". ";
                this._msg = this._msg + ImportResources.getString("TASK_FAILED_ROLLBACK");
                Logger.warn(((Object)((Object)this)).getClass(), (String)this._msg);
            }
            ImportGenTask.this.rollbackTask();
        }

        public void taskCancelled(RaptorTaskEvent event) {
            this._msg = this._taskFullName + ". ";
            this._msg = this._msg + ImportResources.getString("TASK_CANCELLED_ROLLBACK");
            this._msg = this._msg + " " + event.getTaskDescriptor().getMessage();
            Logger.warn(((Object)((Object)this)).getClass(), (String)this._msg);
            ImportGenTask.this.rollbackTask();
            this.finish(this._msg);
        }

        public void taskFinished(RaptorTaskEvent event) {
            RaptorTaskEvent _event = event;
            if (_event.getTaskDescriptor().isCancelled() || ImportGenTask.this._iGenModel.isCancel()) {
                this._msg = this._taskFullName + ". ";
                this._msg = this._msg + ImportResources.getString("TASK_CANCELLED_ROLLBACK");
                this._msg = this._msg + " " + event.getTaskDescriptor().getMessage();
                ImportGenTask.this.outBad("-- " + this._msg);
            } else {
                try {
                    if (ImportGenTask.this._iGenModel.isConnLocked()) {
                        ImportGenTask.this._iGenModel.getConn().commit();
                    }
                }
                catch (Exception e) {
                    Logger.warn(((Object)((Object)this)).getClass(), (Throwable)e);
                }
            }
            if (this._msg.length() == 0) {
                this._msg = ImportGenTask.this._iProps.getValueBoolean(ImportKeys.IS_SOURCE_OSS) != false ? ImportGenTask.this._iGenModel.getService().getStatusMsg() : this._taskFullName + ". " + ImportResources.getString("TASK_SUCCEEDED_AND_COMMITTED");
            }
            this.finish(this._msg);
            ImportGenTask.this._iGenModel.eLogToolEnd();
        }

        private void finish(String msg) {
            URL openUrl = (URL)ImportGenTask.this._iProps.get(ImportKeys.URL_FOR_AUTO_OPEN);
            if (openUrl != null && ImportGenTask.this._iProps.getValueInteger(ImportKeys.LOAD_METHOD) != 0) {
                try {
                    ImportGenTask.this._iGenModel.eLogHref(openUrl);
                }
                catch (Exception e) {
                    Logger.warn(((Object)((Object)this)).getClass(), (Throwable)e);
                    ImportGenTask.this._iGenModel.eLogException(e);
                }
            }
            if (ImportGenTask.this._iGenModel.getStream().isBadFileUsed()) {
                try {
                    ImportGenTask.this._iGenModel.eLogHref(ImportGenTask.this._iGenModel.getStream().geturlBad());
                }
                catch (Exception e) {
                    Logger.warn(((Object)((Object)this)).getClass(), (Throwable)e);
                    ImportGenTask.this._iGenModel.eLogException(e);
                }
                try {
                    ImportGenTask.this._iGenModel.getStream().finishedBad();
                }
                catch (Exception e) {
                    Logger.warn(((Object)((Object)this)).getClass(), (Throwable)e);
                }
            }
            ImportGenTask.this.closeFiles();
            Logger.warn(((Object)((Object)this)).getClass(), (String)ImportResources.getString("GEN_TO_WORKSHEET"));
            this.showFinalMsg(this._msg);
        }

        private void showFinalMsg(String msg) {
            if (!ImportGenTask.this._iGenModel.isBatch()) {
                String eMsg = msg == null || msg.length() == 0 ? "" : msg;
                MessageHandler.information(null, (String)eMsg, (String)ImportResources.getString("TASK_SHORT_NAME"), null);
            }
        }
    }
}

