/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.importer.formattors;

import java.math.BigDecimal;
import java.sql.Connection;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParsePosition;
import oracle.dbtools.data.formattors.NumberFormattor;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.nls.OracleNLSProvider;

public class NumberFormattorImport
extends NumberFormattor {
    Character _nlsDecimalSeparator;

    public void setNlsDecimalSeparator(Character nlsDecimalSeparator) {
        this._nlsDecimalSeparator = nlsDecimalSeparator;
    }

    public String formatData(Object data, Column c) {
        Object result = "NULL";
        if (data != null) {
            String dataStr = data.toString();
            NumberFormat fmt = null;
            ParsePosition pp = new ParsePosition(0);
            fmt = this._l != null ? NumberFormat.getInstance(this._l) : NumberFormat.getInstance();
            if (this._nlsDecimalSeparator != null && fmt instanceof DecimalFormat) {
                DecimalFormatSymbols symbols = ((DecimalFormat)fmt).getDecimalFormatSymbols();
                symbols.setDecimalSeparator(this._nlsDecimalSeparator.charValue());
                ((DecimalFormat)fmt).setDecimalFormatSymbols(symbols);
            }
            try {
                if (fmt instanceof DecimalFormat) {
                    ((DecimalFormat)fmt).setParseBigDecimal(true);
                    result = ((BigDecimal)fmt.parse(dataStr, pp)).toPlainString();
                } else {
                    result = c.getPrecision() > 0 && c.getScale() > 0 || c.getPrecision() == 0 && c.getScale() == 0 || this.isScaleImported() ? "" + ((BigDecimal)fmt.parse(dataStr, pp)).doubleValue() : "" + ((BigDecimal)fmt.parse(dataStr, pp)).longValue();
                }
            }
            catch (Exception e) {
                result = dataStr;
            }
            if (pp.getIndex() < dataStr.length()) {
                return dataStr;
            }
        }
        if (((String)result).length() == 0) {
            return "NULL";
        }
        return result;
    }

    public Object formatDataForJava(Object data, Column c) throws Exception {
        String num = this.formatData(data, c);
        if (this.getConnection() != null && num != null) {
            String decChar = "" + ((OracleNLSProvider)NLSProvider.getProvider((Connection)this.getConnection())).getDecimalSeparator();
            num = num.replace(".", decChar);
        }
        return num;
    }
}

