/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.reports;

import com.oracle.premigration.reports.json.CpatJsonPropertyDescription;
import lombok.NonNull;

public final class CheckFiltrationMetadata {
    @CpatJsonPropertyDescription(value="Indicates which 'column' in relevantObjectsData represents the owner of the object. E.g., it could be the 'OWNER', 'TABLE_OWNER', 'USERNAME', or some other value.")
    @NonNull
    private final String schemaOwnerColumn;
    @CpatJsonPropertyDescription(value="Indicates which 'column' in relevantObjectsData represents the name of the object. E.g. it could be 'TABLE_NAME', 'SYNONYM_NAME', 'DIRECTORY_NAME', or 'OBJECT_NAME', or some other value.")
    @NonNull
    private final String objectNameColumn;
    @CpatJsonPropertyDescription(value="When possible, indicates which 'column' in relevantObjectsData represents the type of the object. E.g. it could be 'OBJECT_TYPE', some other value, or the empty string which indicates that all the rows in relevantObjectData are the same type and that type is specified by the 'objectTypeFixed' value.")
    @NonNull
    private final String objectTypeColumn;
    @CpatJsonPropertyDescription(value="When objectTypeColumn is empty this Indicates which 'column' in relevantObjectsData represents the type of the object.  If the value for 'objectTypeColumn' is not empty then the value for this property will be empty.")
    private final String objectTypeFixed;

    public String getObjectTypeFixed() {
        return this.objectTypeFixed == null ? "" : this.objectTypeFixed;
    }

    private static String $default$objectTypeColumn() {
        return "";
    }

    CheckFiltrationMetadata(@NonNull String schemaOwnerColumn, @NonNull String objectNameColumn, @NonNull String objectTypeColumn, String objectTypeFixed) {
        if (schemaOwnerColumn == null) {
            throw new NullPointerException("schemaOwnerColumn is marked non-null but is null");
        }
        if (objectNameColumn == null) {
            throw new NullPointerException("objectNameColumn is marked non-null but is null");
        }
        if (objectTypeColumn == null) {
            throw new NullPointerException("objectTypeColumn is marked non-null but is null");
        }
        this.schemaOwnerColumn = schemaOwnerColumn;
        this.objectNameColumn = objectNameColumn;
        this.objectTypeColumn = objectTypeColumn;
        this.objectTypeFixed = objectTypeFixed;
    }

    public static CheckFiltrationMetadataBuilder builder() {
        return new CheckFiltrationMetadataBuilder();
    }

    @NonNull
    public String getSchemaOwnerColumn() {
        return this.schemaOwnerColumn;
    }

    @NonNull
    public String getObjectNameColumn() {
        return this.objectNameColumn;
    }

    @NonNull
    public String getObjectTypeColumn() {
        return this.objectTypeColumn;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CheckFiltrationMetadata)) {
            return false;
        }
        CheckFiltrationMetadata other = (CheckFiltrationMetadata)o;
        String this$schemaOwnerColumn = this.getSchemaOwnerColumn();
        String other$schemaOwnerColumn = other.getSchemaOwnerColumn();
        if (this$schemaOwnerColumn == null ? other$schemaOwnerColumn != null : !this$schemaOwnerColumn.equals(other$schemaOwnerColumn)) {
            return false;
        }
        String this$objectNameColumn = this.getObjectNameColumn();
        String other$objectNameColumn = other.getObjectNameColumn();
        if (this$objectNameColumn == null ? other$objectNameColumn != null : !this$objectNameColumn.equals(other$objectNameColumn)) {
            return false;
        }
        String this$objectTypeColumn = this.getObjectTypeColumn();
        String other$objectTypeColumn = other.getObjectTypeColumn();
        if (this$objectTypeColumn == null ? other$objectTypeColumn != null : !this$objectTypeColumn.equals(other$objectTypeColumn)) {
            return false;
        }
        String this$objectTypeFixed = this.getObjectTypeFixed();
        String other$objectTypeFixed = other.getObjectTypeFixed();
        return !(this$objectTypeFixed == null ? other$objectTypeFixed != null : !this$objectTypeFixed.equals(other$objectTypeFixed));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $schemaOwnerColumn = this.getSchemaOwnerColumn();
        result = result * 59 + ($schemaOwnerColumn == null ? 43 : $schemaOwnerColumn.hashCode());
        String $objectNameColumn = this.getObjectNameColumn();
        result = result * 59 + ($objectNameColumn == null ? 43 : $objectNameColumn.hashCode());
        String $objectTypeColumn = this.getObjectTypeColumn();
        result = result * 59 + ($objectTypeColumn == null ? 43 : $objectTypeColumn.hashCode());
        String $objectTypeFixed = this.getObjectTypeFixed();
        result = result * 59 + ($objectTypeFixed == null ? 43 : $objectTypeFixed.hashCode());
        return result;
    }

    public String toString() {
        return "CheckFiltrationMetadata(schemaOwnerColumn=" + this.getSchemaOwnerColumn() + ", objectNameColumn=" + this.getObjectNameColumn() + ", objectTypeColumn=" + this.getObjectTypeColumn() + ", objectTypeFixed=" + this.getObjectTypeFixed() + ")";
    }

    public static class CheckFiltrationMetadataBuilder {
        private String schemaOwnerColumn;
        private String objectNameColumn;
        private boolean objectTypeColumn$set;
        private String objectTypeColumn$value;
        private String objectTypeFixed;

        CheckFiltrationMetadataBuilder() {
        }

        public CheckFiltrationMetadataBuilder schemaOwnerColumn(@NonNull String schemaOwnerColumn) {
            if (schemaOwnerColumn == null) {
                throw new NullPointerException("schemaOwnerColumn is marked non-null but is null");
            }
            this.schemaOwnerColumn = schemaOwnerColumn;
            return this;
        }

        public CheckFiltrationMetadataBuilder objectNameColumn(@NonNull String objectNameColumn) {
            if (objectNameColumn == null) {
                throw new NullPointerException("objectNameColumn is marked non-null but is null");
            }
            this.objectNameColumn = objectNameColumn;
            return this;
        }

        public CheckFiltrationMetadataBuilder objectTypeColumn(@NonNull String objectTypeColumn) {
            if (objectTypeColumn == null) {
                throw new NullPointerException("objectTypeColumn is marked non-null but is null");
            }
            this.objectTypeColumn$value = objectTypeColumn;
            this.objectTypeColumn$set = true;
            return this;
        }

        public CheckFiltrationMetadataBuilder objectTypeFixed(String objectTypeFixed) {
            this.objectTypeFixed = objectTypeFixed;
            return this;
        }

        public CheckFiltrationMetadata build() {
            String objectTypeColumn$value = this.objectTypeColumn$value;
            if (!this.objectTypeColumn$set) {
                objectTypeColumn$value = CheckFiltrationMetadata.$default$objectTypeColumn();
            }
            return new CheckFiltrationMetadata(this.schemaOwnerColumn, this.objectNameColumn, objectTypeColumn$value, this.objectTypeFixed);
        }

        public String toString() {
            return "CheckFiltrationMetadata.CheckFiltrationMetadataBuilder(schemaOwnerColumn=" + this.schemaOwnerColumn + ", objectNameColumn=" + this.objectNameColumn + ", objectTypeColumn$value=" + this.objectTypeColumn$value + ", objectTypeFixed=" + this.objectTypeFixed + ")";
        }
    }
}

